/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bcm.business.invest.service.InvValidator;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.serviceHelper.ScenePeriodServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.LongUtil;

public class InvShareholdingValidator<T>
implements InvValidator<T> {
    private long modelId;
    private T entity;
    private final Map<Long, Set<String>> org2children;
    private final Map<String, IDNumberTreeNode> treeNodeMap;
    private final Set<String> stockRadioKeys;
    private final Map<Object, DynamicObject> entityMapFromLoad;

    public InvShareholdingValidator(long modelId) {
        this.modelId = modelId;
        this.org2children = new HashMap<Long, Set<String>>(16);
        this.treeNodeMap = new HashMap<String, IDNumberTreeNode>(16);
        this.stockRadioKeys = new HashSet<String>(16);
        this.entityMapFromLoad = new HashMap<Object, DynamicObject>(16);
    }

    @Override
    public void setEntity(Object data) {
        this.entity = data;
    }

    public ChildrenIncludeValidator prepareChildren(Long selectedOrgId) {
        return new ChildrenIncludeValidator(this.org2children.computeIfAbsent(selectedOrgId, k -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.modelId, (Long)selectedOrgId);
            if (node.isShare()) {
                Long copyFromId = node.getCopyfromId();
                node = MemberReader.findEntityMemberById((Long)this.modelId, (Long)copyFromId);
            }
            return TreeStructureServiceHelper.getNumbers(node.getAllChildren(0));
        }));
    }

    public String notNull(String key, String propName) {
        Object o = this.getKey(this.entity, key);
        if (Objects.isNull(o)) {
            String msg = ResManager.loadKDString((String)"%1$s\u4e3a\u7a7a\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvShareholdingValidator_17", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }
        return null;
    }

    public String nonEmptyAndUndeletedDependentSource(String entityName, String idKey, String inputKey, String loadKey, String propName) {
        Object id = this.getKey(this.entity, idKey);
        Object input = this.getKey(this.entity, inputKey);
        if (Objects.nonNull(id) && (Long)id != 0L && Objects.isNull(input)) {
            DynamicObject dynamicObject = this.entityMapFromLoad.computeIfAbsent(id, pk -> {
                QFilter pkQf = new QFilter("id", "=", pk);
                QFilter qf = new QFilter("isdelete", "=", (Object)"0");
                QFilter[] qfs = new QFilter[]{pkQf, qf};
                Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName), (QFilter[])qfs);
                return (DynamicObject)objectDynamicObjectMap.get(pk);
            });
            Object o = Optional.ofNullable(dynamicObject).map(dy -> dy.get(loadKey)).orElseGet(() -> null);
            if (Objects.isNull(o)) {
                String msg = ResManager.loadKDString((String)"%1$s\u4f9d\u8d56\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u5220\u9664,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvShareholdingValidator_18", (String)"fi-bcm-business", (Object[])new Object[0]);
                return String.format(msg, propName);
            }
            String msg = ResManager.loadKDString((String)"%1$s\u4e3a\u7a7a\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvShareholdingValidator_17", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }
        if (Objects.isNull(input)) {
            String msg = ResManager.loadKDString((String)"%1$s\u4e3a\u7a7a\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"InvShareholdingValidator_17", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }
        return null;
    }

    public String baseDataNotNull(String key, String propName) {
        Object id = this.getKey(this.entity, key);
        if (Objects.isNull(id) || (Long)id == 0L || (Long)id == -1L) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6838\u5bf9%1$s\u662f\u5426\u6b63\u786e\u3002", (String)"InvShareholdingValidator_19", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }
        return null;
    }

    public String independentOrg(String numberKey, String propName) {
        boolean isDep = Optional.of(this.entity).map(map -> this.getKey(map, numberKey)).map(String.class::cast).map(number -> this.treeNodeMap.computeIfAbsent(this.modelId + number, k -> MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.modelId), (String)number))).map(node -> node.getProperty("isindependentorg")).map(Boolean.class::cast).orElseGet(() -> true);
        if (!isDep) {
            String msg = ResManager.loadKDString((String)"%1$s\u9700\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareholdingValidator_20", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }
        return null;
    }

    public String uniqueCombo(String relationType, String ... keys) {
        LinkedList<String> list = new LinkedList<String>();
        for (String key : keys) {
            Object obj = this.getKey(this.entity, key);
            if (!Objects.nonNull(obj)) continue;
            list.add((String)obj);
        }
        list.add(relationType);
        if (list.size() == keys.length + 1 && !this.stockRadioKeys.add(String.join((CharSequence)"&", list))) {
            String msg = ResManager.loadKDString((String)"%1$s+%2$s+%3$s\u7ec4\u5408\u4e0d\u552f\u4e00\u3002", (String)"InvShareholdingValidator_21", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, list.toArray());
        }
        return null;
    }

    public String uniqueComboByKey(String relationTypeKey, String ... keys) {
        return Optional.ofNullable(this.entity).map(e -> this.getKey(e, relationTypeKey)).map(String.class::cast).map(relationType -> this.uniqueCombo((String)relationType, keys)).orElseGet(() -> null);
    }

    public String stockRadioSumLessThen100(String propNames, String ... keys) {
        long sum = 0L;
        for (String key : keys) {
            sum += Optional.ofNullable(this.entity).map(e -> this.getKey(e, key)).map(radio -> {
                if (radio instanceof BigDecimal) {
                    return ((BigDecimal)radio).longValue();
                }
                return LongUtil.toLong((Object)radio);
            }).orElseGet(() -> 0L).longValue();
        }
        if (sum > 100L || sum < 0L) {
            String msg = ResManager.loadKDString((String)"%1$s\u6301\u80a1\u6bd4\u4f8b\u6570\u503c\u8d85\u51fa\u8303\u56f4\u30100,100\u3011\u3002", (String)"InvShareholdingValidator_22", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propNames);
        }
        return null;
    }

    public String notEquals(String shareholderKey, String investedCompanyKey) {
        Object shareholder = this.getKey(this.entity, shareholderKey);
        Object investedCompany = this.getKey(this.entity, investedCompanyKey);
        if (Objects.nonNull(shareholder) && shareholder.equals(investedCompany)) {
            return ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u548c\u88ab\u6295\u8d44\u5355\u4f4d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"InvShareholdingValidator_23", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return null;
    }

    public String ratioBetween0To100(String numberKey, String propName) {
        boolean isBetween0To100 = Optional.of(this.entity).map(map -> this.getKey(map, numberKey)).map(obj -> {
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            try {
                return new BigDecimal(obj.toString());
            }
            catch (Exception e) {
                return null;
            }
        }).map(ratio -> ratio.compareTo(BigDecimal.ZERO) >= 0 && ratio.compareTo(new BigDecimal(100)) <= 0).orElseGet(() -> false);
        if (!isBetween0To100) {
            String msg = ResManager.loadKDString((String)"%1$s\u6301\u80a1\u6bd4\u4f8b\u6570\u503c\u8d85\u51fa\u8303\u56f4\u30100,100\u3011\u3002", (String)"InvShareholdingValidator_22", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }
        return null;
    }

    public String entHaveReadwritePerm(String idKey, PermissionService permissionService, Long dimensionId, String propName) {
        return Optional.of(this.entity).map(map -> this.getKey(map, idKey)).map(LongUtil::toLong).filter(id -> !permissionService.hasWritePerm(dimensionId, (Long)id)).map(id -> {
            String msg = ResManager.loadKDString((String)"\u60a8\u65e0[%1$s]\u5199\u6743\u9650\u3002", (String)"InvShareholdingValidator_24", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }).orElseGet(() -> null);
    }

    public String entHavePerm(String idKey, PermissionService permissionService, Long dimensionId, String propName) {
        return Optional.of(this.entity).map(map -> this.getKey(map, idKey)).map(LongUtil::toLong).filter(id -> permissionService.hasNoPerm(dimensionId, (Long)id)).map(id -> {
            String msg = ResManager.loadKDString((String)"\u60a8\u65e0[%1$s]\u8bfb\u6743\u9650\u3002", (String)"InvShareholdingValidator_25", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }).orElseGet(() -> null);
    }

    private Object getKey(T entity, String key) {
        if (entity instanceof DynamicObject) {
            return ((DynamicObject)entity).get(key);
        }
        if (entity instanceof JSONObject) {
            String[] split = key.split("\\.");
            JSONObject jsonObject = (JSONObject)entity;
            for (String s : split) {
                Object step = jsonObject.get((Object)s);
                if (!(step instanceof JSONObject)) {
                    return step;
                }
                jsonObject = (JSONObject)step;
            }
        }
        return null;
    }

    public String independentOrgIC(String shareholder, String propName) {
        return this.doCheckIndependent(shareholder, propName, "bcm_icmembertree");
    }

    public String independentOrgEnt(String investedCompany, String propName) {
        return this.doCheckIndependent(investedCompany, propName, "bcm_entitymembertree");
    }

    private String doCheckIndependent(String shareholder, String propName, String entityNumber) {
        boolean isIndependent = Optional.of(this.entity).map(map -> this.getKey(map, shareholder)).map(LongUtil::toLong).filter(id -> id != 0L).map(id -> {
            if (entityNumber.equals("bcm_entitymembertree")) {
                return MemberReader.findMemberById((long)this.modelId, (String)entityNumber, (Long)id);
            }
            String number = MemberReader.findMemberById((long)this.modelId, (String)entityNumber, (Long)id).getNumber();
            return MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.modelId), (String)number);
        }).filter(node -> node != IDNumberTreeNode.NotFoundTreeNode).map(node -> node.getProperty("isindependentorg")).map(Boolean.class::cast).orElseGet(() -> true);
        if (!isIndependent) {
            String msg = ResManager.loadKDString((String)"%1$s\u9700\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareholdingValidator_20", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, propName);
        }
        return null;
    }

    public String notEqualsOrg(String investedCompany, String shareholder) {
        String investedCompanyNumber = Optional.of(this.entity).map(map -> this.getKey(map, investedCompany)).map(LongUtil::toLong).filter(id -> id != 0L).map(id -> MemberReader.findMemberById((long)this.modelId, (String)"bcm_entitymembertree", (Long)id)).map(IDNumberTreeNode::getNumber).orElseGet(() -> null);
        String shareholderNumber = Optional.of(this.entity).map(map -> this.getKey(map, shareholder)).map(LongUtil::toLong).filter(id -> id != 0L).map(id -> MemberReader.findMemberById((long)this.modelId, (String)"bcm_icmembertree", (Long)id)).map(IDNumberTreeNode::getNumber).orElseGet(() -> null);
        if (Objects.nonNull(investedCompanyNumber) && !investedCompanyNumber.equals(IDNumberTreeNode.NotFoundTreeNode.getNumber()) && investedCompanyNumber.equals(shareholderNumber)) {
            return ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u548c\u88ab\u6295\u8d44\u5355\u4f4d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"InvShareholdingValidator_23", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return null;
    }

    public String sceneHavePeriod(String model, String scenario, String period, String msg) {
        Long modelId = (Long)this.getKey(this.entity, model);
        Long scenarioId = (Long)this.getKey(this.entity, scenario);
        Long periodId = (Long)this.getKey(this.entity, period);
        if (Objects.isNull(modelId) || modelId == 0L || Objects.isNull(scenarioId) || scenarioId == 0L || Objects.isNull(periodId) || periodId == 0L) {
            return null;
        }
        IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId);
        String sceneNumber = sceneMember.getNumber();
        List periodIds = ScenePeriodServiceHelper.getScenePeriodByModel(modelId, Collections.singletonList(sceneNumber)).getOrDefault(sceneNumber, Collections.emptyList());
        if (!periodIds.contains(periodId)) {
            return String.format(msg, MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber(), sceneMember.getNumber());
        }
        return null;
    }

    public String staticStockInvestedCompanyNotNull(String relationTypeKey, String investedCompanyKey) {
        Object id = this.getKey(this.entity, investedCompanyKey);
        if (Objects.isNull(id) || (Long)id == 0L || (Long)id == -1L) {
            Object relationType = this.getKey(this.entity, relationTypeKey);
            InvRelaTypeEnum relaTypeEnum = InvRelaTypeEnum.findEnumByType((String)((String)relationType));
            if (Objects.isNull(relaTypeEnum)) {
                return null;
            }
            if (InvRelaTypeEnum.DirectRelaType == relaTypeEnum) {
                return ResManager.loadKDString((String)"\u76f4\u63a5\u6301\u80a1\u7684\u88ab\u6295\u8d44\u5355\u4f4d\u9700\u5728\u5f53\u524d\u89c6\u56fe\u4e2d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u88ab\u6295\u8d44\u5355\u4f4d\u662f\u5426\u6b63\u786e\u3002", (String)"InvShareholdingValidator_27", (String)"fi-bcm-business", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5408\u5e76\u8282\u70b9\u4e0b\u672a\u627e\u5230\u5f55\u5165\u7684\u88ab\u6295\u8d44\u5355\u4f4d\uff0c\u8bf7\u6838\u5bf9\u88ab\u6295\u8d44\u5355\u4f4d\u662f\u5426\u6b63\u786e\u3002", (String)"InvShareholdingValidator_28", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return null;
    }

    public String staticStockRadioRelation(String relationTypeKey, String equScaleKey, String confirmScaleKey, String minConfirmScaleKey) {
        Object minConfirmScale;
        BigDecimal sum;
        Object relationType = this.getKey(this.entity, relationTypeKey);
        InvRelaTypeEnum relaTypeEnum = InvRelaTypeEnum.findEnumByType((String)((String)relationType));
        if (Objects.isNull(relaTypeEnum)) {
            return null;
        }
        Object confirmScale = this.getKey(this.entity, confirmScaleKey);
        if (Objects.isNull(confirmScale)) {
            return null;
        }
        if (LongUtil.toLong((Object)relationType) > 5L) {
            Object equScale = this.getKey(this.entity, equScaleKey);
            if (!confirmScale.equals(equScale)) {
                String msg = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b\u65f6\uff0c\u8981\u6c42\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b\u3010%1$s\u3011\u548c\u8ba1\u7b97\u6301\u80a1\u6bd4\u4f8b\u3010%2$s\u3011\u4e00\u81f4\u3002", (String)"InvShareholdingValidator_29", (String)"fi-bcm-business", (Object[])new Object[0]);
                return String.format(msg, confirmScaleKey, equScaleKey);
            }
        } else if (InvRelaTypeEnum.MinRelaType == relaTypeEnum || InvRelaTypeEnum.SameLevelRelaType == relaTypeEnum) {
            Object minConfirmScale2 = this.getKey(this.entity, minConfirmScaleKey);
            if (!confirmScale.equals(minConfirmScale2)) {
                String msg = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b\u65f6\uff0c\u8981\u6c42\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b\u3010%1$s\u3011\u548c\u5c11\u6570\u80a1\u4e1c\u6301\u80a1\u6bd4\u4f8b\u3010%2$s\u3011\u4e00\u81f4\u3002", (String)"InvShareholdingValidator_30", (String)"fi-bcm-business", (Object[])new Object[0]);
                return String.format(msg, confirmScaleKey, minConfirmScaleKey);
            }
            return null;
        }
        if ((sum = (minConfirmScale = this.getKey(this.entity, minConfirmScaleKey)) instanceof BigDecimal && confirmScale instanceof BigDecimal ? ((BigDecimal)minConfirmScale).add((BigDecimal)confirmScale) : new BigDecimal(String.valueOf(minConfirmScale)).add(new BigDecimal(String.valueOf(confirmScale)))).compareTo(new BigDecimal(100)) != 0) {
            String msg = ResManager.loadKDString((String)"\u975e\u3010%1$s\u6216%2$s\u3011\u7c7b\u578b\uff0c\u8981\u6c42\u786e\u8ba4\u6301\u80a1\u6bd4\u4f8b\u3010%3$s\u3011\u548c\u5c11\u6570\u80a1\u4e1c\u6301\u80a1\u6bd4\u4f8b\u3010%4$s\u3011\u4e4b\u548c\u4e3a100%%\u3002", (String)"InvShareholdingValidator_31", (String)"fi-bcm-business", (Object[])new Object[0]);
            return String.format(msg, InvRelaTypeEnum.MinRelaType.getDesc(), InvRelaTypeEnum.SameLevelRelaType.getDesc(), confirmScaleKey, minConfirmScaleKey);
        }
        return null;
    }

    public class ChildrenIncludeValidator {
        private final Set<String> childrenNums;

        private ChildrenIncludeValidator(Set<String> childrenNums) {
            this.childrenNums = childrenNums;
        }

        public String childCheck(String numberKey, String propName) {
            boolean isChildren = Optional.of(InvShareholdingValidator.this.entity).map(map -> InvShareholdingValidator.this.getKey(map, numberKey)).map(this.childrenNums::contains).orElseGet(() -> true);
            if (!isChildren) {
                String msg = ResManager.loadKDString((String)"%1$s\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u5f53\u524d\u5408\u5e76\u8282\u70b9\u7684\u4e0b\u7ea7\u5355\u4f4d\u3002", (String)"InvShareholdingValidator_32", (String)"fi-bcm-business", (Object[])new Object[0]);
                return String.format(msg, propName);
            }
            return null;
        }

        public String childCheckBy(IDNumberTreeNode investedCompany, String propName) {
            String number = investedCompany == IDNumberTreeNode.NotFoundTreeNode ? null : investedCompany.getNumber();
            boolean isChildren = Optional.ofNullable(number).map(this.childrenNums::contains).orElseGet(() -> true);
            if (!isChildren) {
                String msg = ResManager.loadKDString((String)"%1$s\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u5f53\u524d\u5408\u5e76\u8282\u70b9\u7684\u4e0b\u7ea7\u5355\u4f4d\u3002", (String)"InvShareholdingValidator_32", (String)"fi-bcm-business", (Object[])new Object[0]);
                return String.format(msg, propName);
            }
            return null;
        }
    }
}

