/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.shareholder;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseSetHelper;
import kd.fi.bcm.business.invest.invratio.InvRelationExcRuleService;
import kd.fi.bcm.business.invest.invratio.model.InvRelationRuleContext;
import kd.fi.bcm.business.invest.invstructuretable.InvDynamicStockService;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.invest.model.InvDynamicStockParam;
import kd.fi.bcm.business.invest.shareholder.ShareHoldingCalcService;
import kd.fi.bcm.business.invest.shareholder.model.InvRelationSearchConfig;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvCalculateShareRelaService {
    private static Log log = LogFactory.getLog(InvCalculateShareRelaService.class);
    private final boolean supportRuleExc;
    private final String accuracy;
    private final InvRelationSearchConfig f7;
    private final boolean isCalcStaticStock;
    private final boolean isCalcDynamicStock;
    private final int calcType;
    private final int calcRange;
    private final Set<Long> orgSet;
    private final Map<Long, Long> orgToCaseMap;

    public InvCalculateShareRelaService(InvRelationSearchConfig f7, boolean isCalcStaticStock, boolean isCalcDynamicStock, int calcType, int calcRange, Set<Long> orgSet) {
        this.f7 = f7;
        this.isCalcStaticStock = isCalcStaticStock;
        this.isCalcDynamicStock = isCalcDynamicStock;
        this.calcType = calcType;
        this.calcRange = calcRange;
        this.orgSet = orgSet.stream().map(orgId -> MemberReader.findEntityMemberById((Long)f7.getModelId(), (Long)orgId)).map(IDNumberTreeNode::getBaseTreeNode).map(IDNumberTreeNode::getId).collect(Collectors.toSet());
        this.orgToCaseMap = InvShareCaseSetHelper.findShareCaseByOrg(f7.getModelId(), f7.getScenarioId(), this.orgSet);
        DynamicObject config = InvRelationSetHelper.queryRelationSet(f7.getModelId());
        if (Objects.nonNull(config)) {
            this.accuracy = !StringUtils.isBlank((String)config.getString("accuracy")) ? config.getString("accuracy").trim() : "2";
            this.supportRuleExc = config.getBoolean("supportruleexc");
        } else {
            this.accuracy = "2";
            this.supportRuleExc = false;
        }
    }

    public boolean isSupportRuleExc() {
        return this.supportRuleExc;
    }

    public List<String> doCheck() {
        ArrayList<String> checkRsList = new ArrayList<String>();
        checkRsList.addAll(this.checkF7());
        checkRsList.addAll(this.checkMergeOrg());
        checkRsList.addAll(this.checkOrgSet());
        return checkRsList;
    }

    public List<String> doCalculate() {
        if (!this.checkF7().isEmpty() || this.orgSet.isEmpty()) {
            return Collections.emptyList();
        }
        long mergeOrgId = this.f7.getMergeOrgId();
        String modelNumber = MemberReader.findModelNumberById((Object)this.f7.getModelId());
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNumber, (Long)mergeOrgId);
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
            return Collections.emptyList();
        }
        ArrayList calcTask = new ArrayList(2);
        Set<Long> invShareCases = this.orgToCaseMap.values().stream().collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(invShareCases)) {
            return Collections.emptyList();
        }
        DynamicObjectCollection dynamicObjects = InvShareCaseHelper.queryBy(invShareCases);
        Map<Long, DynamicObject> id2Dy = dynamicObjects.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        invShareCases.forEach(caseId -> {
            DynamicObject caseDy = id2Dy.getOrDefault(caseId, new DynamicObject());
            calcTask.add(() -> this.doCalcStaticStock(orgNode, caseDy));
            calcTask.add(() -> this.doCalcDynamicStock(caseDy));
        });
        List calcMsg = ThreadPoolService.runInUpdateTemplateLinkInfoThreadForCallable(calcTask.toArray(new Callable[0]));
        Set error = calcMsg.stream().filter(ResultBox::isError).map(ResultBox::getErrorList).filter(CollectionUtils::isNotEmpty).map(list -> (MessageInfo)list.get(0)).map(MessageInfo::getMessage).collect(Collectors.toSet());
        if (!error.isEmpty()) {
            throw new KDBizException(String.join((CharSequence)"\n", error));
        }
        Set rs = calcMsg.stream().map(ResultBox::getMessageList).filter(CollectionUtils::isNotEmpty).map(list -> (MessageInfo)list.get(0)).map(MessageInfo::getMessage).collect(Collectors.toSet());
        if (this.supportRuleExc) {
            List<Callable> tasks = this.orgSet.stream().map(orgId -> MemberReader.findEntityMemberById((Long)this.f7.getModelId(), (Long)orgId)).map(IDNumberTreeNode::getNumber).map(number -> () -> this.excRule((String)number)).collect(Collectors.toList());
            List resultList = ThreadPoolService.runInUpdateTemplateLinkInfoThreadForCallable(tasks.toArray(new Callable[0]));
            List msg = resultList.stream().map(ResultBox::getMessageList).filter(CollectionUtils::isNotEmpty).map(result -> (MessageInfo)result.get(0)).filter(Objects::nonNull).map(MessageInfo::getMessage).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (msg.isEmpty()) {
                rs.add(ResManager.loadKDString((String)"\u6267\u884c\u89c4\u5219\u6210\u529f\u3002", (String)"InvCalculateShareRelaService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            } else {
                rs.addAll(msg);
            }
        }
        return Lists.newArrayList(rs);
    }

    private ResultBox doCalcDynamicStock(DynamicObject caseDy) {
        ResultBox resultBox = ResultBox.of();
        try {
            if (this.isCalcDynamicStock) {
                InvStructureContext ctx = new InvStructureContext(this.f7.getModelId(), this.f7.getScenarioId(), this.f7.getFyId(), this.f7.getPeriodId());
                InvDynamicStockParam calParam = new InvDynamicStockParam();
                calParam.setMergeId(this.f7.getMergeOrgId());
                calParam.setCalType(this.calcType);
                calParam.setOrgUnitNumLists(this.orgSet.stream().map(org -> MemberReader.findEntityMemberById((Long)this.f7.getModelId(), (Long)org).getNumber()).collect(Collectors.toSet()));
                calParam.setShareCaseId(caseDy.getLong("id"));
                calParam.setOrgToCaseMap(this.orgToCaseMap);
                new InvDynamicStockService(ctx, calParam).calcShareHolding();
                String msg = ResManager.loadKDString((String)"\u65b9\u6848%1$s,\u52a8\u6001\u80a1\u6bd4\u91cd\u7b97\u6210\u529f\u3002", (String)"CalculateShareRelaService_0", (String)"fi-bcm-business", (Object[])new Object[0]);
                resultBox.addSuccess(String.format(msg, caseDy.getString("number")));
            } else {
                resultBox.addSuccess(ResManager.loadKDString((String)"\u4e0d\u6267\u884c\u52a8\u6001\u80a1\u6bd4\u91cd\u7b97\u3002", (String)"CalculateShareRelaService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String message = e.getMessage() == null ? e.fillInStackTrace() + "\n" + e.getStackTrace()[0].toString() : e.getMessage();
            String format = ResManager.loadKDString((String)"\u65b9\u6848%1$s\u52a8\u6001\u80a1\u6bd4\u91cd\u7b97\u5931\u8d25\uff1a%2$s", (String)"CalculateShareRelaService_5", (String)"fi-bcm-business", (Object[])new Object[0]);
            resultBox.addError(String.format(format, caseDy.getString("number"), message));
        }
        return resultBox;
    }

    private ResultBox doCalcStaticStock(IDNumberTreeNode orgNode, DynamicObject caseDy) {
        ResultBox resultBox = ResultBox.of();
        try {
            if (this.isCalcStaticStock) {
                long caseId = caseDy.getLong("id");
                ShareHoldingCalcService service = new ShareHoldingCalcService(this.f7.getModelId(), this.f7.getScenarioId(), this.f7.getFyId(), this.f7.getPeriodId(), orgNode.getNumber()).setCalcType(this.calcType).setCalcRange(this.calcRange).setOrgUnitIdLists(this.orgSet.stream().map(Object::toString).collect(Collectors.toList())).setAccuracy(Integer.parseInt(this.accuracy)).setCaseId(caseId).setOrgToCaseMap(this.orgToCaseMap);
                service.calcShareHolding(null);
                StringJoiner key = new StringJoiner("_");
                key.add("invCalcStaticWalkPaths");
                key.add(this.f7.getModelNum());
                key.add(this.f7.getScenariodNum());
                key.add(this.f7.getFyNum());
                key.add(this.f7.getPeriodNum());
                key.add(String.valueOf(caseId));
                Table<String, String, Object> holderWalkPaths = service.getHolderWalkPaths();
                CacheGenFactory.getCommonCache().put(key.toString(), holderWalkPaths);
                String msg = ResManager.loadKDString((String)"\u65b9\u6848%1$s,\u9759\u6001\u80a1\u6bd4\u91cd\u7b97\u6210\u529f\u3002", (String)"CalculateShareRelaService_2", (String)"fi-bcm-business", (Object[])new Object[0]);
                resultBox.addSuccess(String.format(msg, caseDy.getString("number")));
            } else {
                resultBox.addSuccess(ResManager.loadKDString((String)"\u4e0d\u6267\u884c\u9759\u6001\u80a1\u6bd4\u91cd\u7b97\u3002", (String)"CalculateShareRelaService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String message = e.getMessage() == null ? e.fillInStackTrace() + "\n" + e.getStackTrace()[0].toString() : e.getMessage();
            String format = ResManager.loadKDString((String)"\u65b9\u6848%1$s\u9759\u6001\u80a1\u6bd4\u91cd\u7b97\u5931\u8d25\uff1a%2$s", (String)"CalculateShareRelaService_4", (String)"fi-bcm-business", (Object[])new Object[0]);
            resultBox.addError(String.format(format, caseDy.getString("number"), message));
        }
        return resultBox;
    }

    private ResultBox excRule(String parentNumber) {
        InvRelationRuleContext ctx = new InvRelationRuleContext(this.f7.getModelId(), this.f7.getScenarioId(), this.f7.getFyId(), this.f7.getPeriodId());
        ctx.setCalcdynamicStock(this.isCalcDynamicStock);
        ctx.setCalcStaticstock(this.isCalcStaticStock);
        ctx.setOrgUnitNumber(parentNumber);
        Object[] results = new InvRelationExcRuleService(ctx).excBizRule();
        ResultBox resultBox = ResultBox.of();
        StringJoiner msg = new StringJoiner(",");
        if (results.length > 0) {
            List failedIds = Arrays.stream(results).filter(record -> BRExecStatusEnum.FAILED.getIndex().equals(((DynamicObject)record).get("execstatus"))).map(record -> ((DynamicObject)record).getLong("bizrule")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(failedIds)) {
                DynamicObjectCollection bizrules = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", failedIds)});
                bizrules.stream().forEach(rule -> msg.add(rule.getString("number")));
                String msgStr = msg.toString();
                msgStr = String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u201c%1$s\u201d\uff0c\u89c4\u5219\u201c%2$s\u201d\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u4e1a\u52a1\u89c4\u5219\u5217\u8868\u67e5\u770b\u201c\u6267\u884c\u60c5\u51b5\u201d\u3002", (String)"InvRelationSearchPlugin_111", (String)"fi-bcm-formplugin", (Object[])new Object[0]), parentNumber, msgStr);
                resultBox.add(msgStr);
            } else {
                resultBox.setData((Object)results);
            }
        }
        return resultBox;
    }

    private List<String> checkOrgSet() {
        if (Objects.nonNull(this.orgSet) && !this.orgSet.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u671f\u95f4\u662f\u5426\u5f00\u542f\u6216\u8005\u6743\u9650\u662f\u5426\u5206\u914d\u3002", (String)"InvCalculateShareRelaService_1", (String)"fi-bcm-business", (Object[])new Object[0])});
    }

    private List<String> checkMergeOrg() {
        IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.f7.getModelId(), (Long)this.f7.getMergeOrgId());
        if (node != IDNumberTreeNode.NotFoundTreeNode) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u4e0d\u5b58\u5728", (String)"IntelligentSchedulePlan_6", (String)"fi-bcm-business", (Object[])new Object[0])});
    }

    private List<String> checkF7() {
        if (this.f7.getModelId() != 0L && this.f7.getScenarioId() != 0L && this.f7.getFyId() != 0L && this.f7.getPeriodId() != 0L && this.f7.getMergeOrgId() != 0L) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u4f53\u7cfb\uff0c\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvRelationSearchPlugin_11", (String)"fi-bcm-business", (Object[])new Object[0])});
    }
}

