/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.shareholder;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.QFBuilder;

public class InvShareRelaService {
    public static final String PATTERN_DATE = "yyyy-MM-dd";

    public static DynamicObject[] loadInvShareRela(String selectProperties, QFBuilder qfBuilder) {
        return BusinessDataServiceHelper.load((String)"bcm_invsharerela", (String)selectProperties, (QFilter[])qfBuilder.toArray());
    }

    public static void groupCollectBeforeCheckControlAndSumShareScale(List<DynamicObject> allRelation, BiConsumer<Map<String, DynamicObject>, Pair<String, Set<DynamicObject>>> actionCheck) {
        boolean[] allControlIsNull = new boolean[]{true};
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE);
        Map<String, List<DynamicObject>> investedDateGroup = allRelation.stream().map(dy -> {
            boolean controlIsNull = Objects.isNull(dy.get("iscontrol"));
            boolean bl = allControlIsNull[0] = allControlIsNull[0] && controlIsNull;
            if (controlIsNull) {
                dy.set("iscontrol", (Object)"0");
            }
            return dy;
        }).collect(Collectors.groupingBy(dy -> sdf.format(dy.getDate("investdate"))));
        HashMap shareholderConfigMap = Maps.newHashMap();
        HashSet change2ControlSet = Sets.newHashSet();
        investedDateGroup.keySet().stream().sorted().forEach(date -> {
            List dynamicObjects = (List)investedDateGroup.get(date);
            for (DynamicObject dynamicObject : dynamicObjects) {
                shareholderConfigMap.put(InvShareRelaService.getShareholderNumber(dynamicObject), dynamicObject);
            }
            actionCheck.accept(shareholderConfigMap, new Pair(date, (Object)change2ControlSet));
        });
        if (allControlIsNull[0]) {
            change2ControlSet.forEach(dy -> dy.set("iscontrol", (Object)"1"));
        }
    }

    public static String getCheckingDate(Map<String, DynamicObject> shareholderConfigMap) {
        return shareholderConfigMap.entrySet().stream().map(Map.Entry::getValue).map(dy -> dy.getDate("investdate")).max(Date::compareTo).map(date -> new SimpleDateFormat(PATTERN_DATE).format((Date)date)).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u53d6\u5f53\u524d\u6821\u9a8c\u7684\u671f\u672b\u65f6\u95f4\u5931\u8d25\u3002", (String)"InvShareRelaService_1", (String)"fi-bcm-business", (Object[])new Object[0])));
    }

    public static void buildControlSumAndShareScaleSumThenCheck(Map<String, DynamicObject> shareholderConfigMap, Pair<String, Set<DynamicObject>> calculateUtil, IntConsumer doCheckControlSum, Consumer<BigDecimal> doCheckShareScaleSum) {
        BigDecimal sum = BigDecimal.ZERO;
        int controlSum = 0;
        int hisControlSum = 0;
        DynamicObject maxShareObj = null;
        BigDecimal maxShareScale = BigDecimal.ZERO;
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_DATE);
        for (Map.Entry<String, DynamicObject> entry : shareholderConfigMap.entrySet()) {
            BigDecimal shareScale;
            DynamicObject dynamicObject = entry.getValue();
            Date date = dynamicObject.getDate("investdate");
            String investedDate = sdf.format(date);
            if (dynamicObject.getBoolean("iscontrol")) {
                ++hisControlSum;
                if (((String)calculateUtil.p1).equals(investedDate)) {
                    ++controlSum;
                }
            }
            if ((shareScale = dynamicObject.getBigDecimal("sharescale")).compareTo(maxShareScale) > 0) {
                maxShareObj = dynamicObject;
                maxShareScale = shareScale;
            }
            sum = sum.add(shareScale);
        }
        doCheckControlSum.accept(controlSum);
        doCheckShareScaleSum.accept(sum);
        if (hisControlSum == 0 && Objects.nonNull(maxShareObj)) {
            ((Set)calculateUtil.p2).add(maxShareObj);
        }
    }

    public static String getShareholderNumber(DynamicObject dy) {
        if ("orgentryentity".equals(dy.getDataEntityType().getName())) {
            return dy.getDynamicObject("shareholderid").getString("number");
        }
        return dy.getDynamicObject("shareholder").getString("number");
    }

    public static void calculateChangeScale(List<DynamicObject> doc) {
        Map<String, List<DynamicObject>> date2dysMap = doc.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("investdate"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("shareholder.id")));
        for (Map.Entry<String, List<DynamicObject>> date : date2dysMap.entrySet()) {
            List<DynamicObject> dys = date.getValue();
            BigDecimal nowScale = new BigDecimal(0);
            for (int i = 0; i < dys.size(); ++i) {
                BigDecimal curShareScale = dys.get(i).getBigDecimal("sharescale");
                dys.get(i).set("changescale", (Object)curShareScale.subtract(nowScale));
                nowScale = curShareScale;
            }
        }
    }

    public static Map<String, DynamicObject> getAllRelaByDate(long modelId, Date date, Long shareCaseId) {
        HashMap<String, DynamicObject> currPerRelaMap = new HashMap<String, DynamicObject>(16);
        QFBuilder qfBuilder = InvShareRelaService.getIsolationQFilter(modelId, shareCaseId);
        qfBuilder.and("investdate", "<=", (Object)date);
        DynamicObjectCollection invShareRelaDys = QueryServiceHelper.query((String)"bcm_invsharerela", (String)"shareholder.id,shareholder.number,investeecompany.id,investeecompany.number,sharescale,investdate,isout,iscontrol", (QFilter[])qfBuilder.toArray(), (String)"investdate asc");
        invShareRelaDys.forEach(dy -> {
            String investedNumber = dy.getString("investeecompany.number");
            String shareholderNumber = dy.getString("shareholder.number");
            currPerRelaMap.put(shareholderNumber + "_" + investedNumber, (DynamicObject)dy);
        });
        return currPerRelaMap;
    }

    private InvShareRelaService() {
        throw new IllegalStateException(ResManager.loadKDString((String)"%1$s\u7c7b\u4e3a\u5e38\u91cf\u7c7b\uff0c\u65e0\u6cd5\u7ee7\u627f\u548c\u5b9e\u4f8b\u5316\u3002", (String)"FormPluginConstant_0", (String)"fi-bcm-business", (Object[])new Object[]{this.getClass().getName()}));
    }

    public static QFBuilder getIsolationQFilter(long modelId, long shareCaseId) {
        return new QFBuilder("model", "=", (Object)modelId).and("sharecase", "=", (Object)shareCaseId);
    }

    public static QFBuilder getQFilter(long modelId, Set<Long> shareCaseIds) {
        return new QFBuilder("model", "=", (Object)modelId).and("sharecase", "in", shareCaseIds);
    }
}

