/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.shareholder;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.shareholder.model.HoldingCalcContext;
import kd.fi.bcm.business.invest.shareholder.model.ShareNode;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ShareHoldingCalcService {
    private WatchLogger log = BcmLogFactory.getWatchLogInstance(ShareHoldingCalcService.class);
    private HoldingCalcContext ctx;
    private DynamicObjectCollection coll = new DynamicObjectCollection();
    private int reCalcType = 3;
    private static final BigDecimal Zero = new BigDecimal("0.0");
    private static final BigDecimal FiveTy = new BigDecimal("50.0");
    private List<String> orgUnitIdLists;
    private HashMap<String, String> dynmic2Key;
    private static int accuracy;
    private Long caseId;
    private Map<Long, Long> orgToCaseMap;

    public Long getCaseId() {
        return this.caseId;
    }

    public ShareHoldingCalcService setCaseId(Long caseId) {
        this.caseId = caseId;
        this.ctx.addTag(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6295\u8d44\u65b9\u6848", (String)"ShareHoldingCalcService_11", (String)"fi-bcm-business", (Object[])new Object[0]), () -> caseId);
        return this;
    }

    public ShareHoldingCalcService(long modelId, long scenarioId, long fyId, long periodId) {
        this.ctx = new HoldingCalcContext(modelId, scenarioId, fyId, periodId);
    }

    public ShareHoldingCalcService(HoldingCalcContext ctx) {
        this.ctx = ctx;
    }

    public ShareHoldingCalcService(long modelId, long scenarioId, long fyId, long periodId, String orgUnitNumber) {
        this.ctx = new HoldingCalcContext(modelId, scenarioId, fyId, periodId);
        this.ctx.setOrgUnitNumber(orgUnitNumber);
    }

    public ShareHoldingCalcService setCalcRange(int range) {
        return this;
    }

    public ShareHoldingCalcService setAccuracy(int accuracy) {
        ShareHoldingCalcService.accuracy = accuracy;
        this.ctx.addTag(ResManager.loadKDString((String)"\u8bbe\u7f6e\u80a1\u6743\u91cd\u7b97\u7cbe\u5ea6", (String)"ShareHoldingCalcService_3", (String)"fi-bcm-business", (Object[])new Object[0]), () -> accuracy);
        return this;
    }

    public ShareHoldingCalcService setOrgUnitIdLists(List<String> orgUnitIdLists) {
        this.orgUnitIdLists = orgUnitIdLists;
        return this;
    }

    public ShareHoldingCalcService setCalcType(int type) {
        this.reCalcType = type;
        this.ctx.addTag(ResManager.loadKDString((String)"\u8bbe\u7f6e\u91cd\u7b97\u7c7b\u578b", (String)"ShareHoldingCalcService_5", (String)"fi-bcm-business", (Object[])new Object[0]), () -> type);
        return this;
    }

    public void calcShareHolding(AbstractFormPlugin plugin) {
        this.ctx.addTag("start", () -> ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4\u8ba1\u7b97", (String)"ShareHoldingCalcService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.initShareHoldingRelation();
        this.initHolderNode(plugin);
        this.doCalcHolding();
        this.outputRelaHolding();
        this.ctx.addTag("end", () -> ResManager.loadKDString((String)"\u9759\u6001\u80a1\u6bd4\u8ba1\u7b97", (String)"ShareHoldingCalcService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private void outputRelaHolding() {
        this.dynmic2Key = new HashMap();
        Set<HoldingCalcContext.WalkPath> allWalkPath = this.ctx.getAllWalkPath();
        if (null == this.orgUnitIdLists) {
            this.ctx.getHolderList().forEach(holder -> this.mergerRelaHolding((HoldingCalcContext.UnitHolderRelaInfo)holder, allWalkPath));
        } else {
            this.ctx.getHolderList().forEach(holder -> {
                Optional<String> hasHold = this.orgUnitIdLists.stream().filter(f -> f.equals(String.valueOf(holder.getUnitId())) && this.caseId.equals(this.orgToCaseMap.get(LongUtil.toLong((Object)f)))).findFirst();
                if (hasHold.isPresent()) {
                    this.mergerRelaHolding((HoldingCalcContext.UnitHolderRelaInfo)holder, allWalkPath);
                }
            });
        }
        this.saveRecord();
    }

    private void saveRecord() {
        ArrayList<Long> reserveDatas = new ArrayList<Long>(2);
        Map<String, DynamicObject> kvMap = this.queryInvRelation();
        HashMap dbDySort = new HashMap(16);
        if (!this.coll.isEmpty()) {
            kvMap.forEach((k, v) -> {
                if (!v.getBoolean("isdelete")) {
                    String key = v.getString("invrelatype") + "->" + v.getString("orgunit.number");
                    if (dbDySort.containsKey(key)) {
                        List dys = (List)dbDySort.get(key);
                        Integer relaseq = (Integer)v.get("relaseq");
                        if (relaseq == 0) {
                            v.set("relaseq", (Object)(dys.size() + 1));
                        }
                        dys.add(v);
                        dbDySort.put(key, dys);
                    } else {
                        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(16);
                        Integer relaseq = (Integer)v.get("relaseq");
                        if (relaseq == 0) {
                            v.set("relaseq", (Object)1);
                        }
                        dys.add((DynamicObject)v);
                        dbDySort.put(key, dys);
                    }
                }
            });
            HashMap maxseqMap = new HashMap(16);
            this.coll.forEach(c -> {
                String type = c.getString("invrelatype");
                String key = this.packKey((DynamicObject)c);
                DynamicObject v = (DynamicObject)kvMap.remove(this.dynmic2Key.get(key));
                if (c.getLong("investeecompany") == 0L) {
                    OperationLogUtil.writeOperationLog(ResManager.loadKDString((String)"\u80a1\u6743\u91cd\u7b97", (String)"ShareHoldingCalcService_1", (String)"fi-bcm-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff1a%1$s\u3002", (String)"ShareHoldingCalcService_2", (String)"fi-bcm-business", (Object[])new Object[0]), c.getLong("model")), c.getLong("model"), "bcm_recalculateform");
                }
                if (v != null) {
                    String vkey;
                    List vlist;
                    if (this.reCalcType != 1) {
                        c.set("isdelete", v.get("isdelete"));
                        if (v.getBoolean("isdelete")) {
                            if (v.getBoolean("ismodified")) {
                                c.set("isdelete", (Object)"0");
                            } else {
                                c.set("isdelete", (Object)"1");
                            }
                        } else {
                            BigDecimal minconfirmscale = v.getBigDecimal("minconfirmscale");
                            BigDecimal confirmScale = v.getBigDecimal("confirmscale");
                            BigDecimal equvscale = v.getBigDecimal("equvscale");
                            if (ShareHoldingCalcService.checkModify(v)) {
                                c.set("confirmscale", (Object)confirmScale);
                                c.set("minconfirmscale", (Object)minconfirmscale);
                                c.set("ismodified", v.get("ismodified"));
                            }
                            switch (InvRelaTypeEnum.valueof((String)type)) {
                                case DirectRelaType: {
                                    c.set("isusedinvrule", v.get("isusedinvrule"));
                                    c.set("isconfirmed", v.get("isconfirmed"));
                                    break;
                                }
                                case INDirectRelaType: 
                                case MultiRelaType: 
                                case MinRelaType: 
                                case SameLevelRelaType: {
                                    break;
                                }
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(vlist = (List)dbDySort.get(vkey = v.getString("invrelatype") + "->" + v.getString("orgunit.number"))))) {
                        vlist.stream().forEach(dy -> {
                            if (this.dynmic2Key.get(this.packKey((DynamicObject)c)).equals(this.packKeyByNum((DynamicObject)dy))) {
                                int relaseq = dy.getInt("relaseq");
                                c.set("relaseq", (Object)relaseq);
                                if (maxseqMap.containsKey(vkey)) {
                                    if ((Integer)maxseqMap.get(vkey) < relaseq) {
                                        maxseqMap.put(vkey, relaseq);
                                    }
                                } else {
                                    maxseqMap.put(vkey, relaseq);
                                }
                                return;
                            }
                        });
                    }
                    DynamicObjectCollection tmpls = v.getDynamicObjectCollection("effecttemp");
                    if (!v.getBoolean("isdelete") && tmpls != null && tmpls.size() > 0) {
                        DynamicObjectCollection copnyEntries = c.getDynamicObjectCollection("effecttemp");
                        copnyEntries.clear();
                        for (DynamicObject tmpl : tmpls) {
                            DynamicObject d = (DynamicObject)OrmUtils.clone((IDataEntityBase)tmpl, (boolean)false, (boolean)true);
                            copnyEntries.add((Object)d);
                        }
                        c.set("effecttemp", (Object)copnyEntries);
                    }
                }
            });
            this.coll.forEach(e -> {
                int relaseq = e.getInt("relaseq");
                if (relaseq == 0 && !e.getBoolean("isdelete")) {
                    int index1;
                    String key = this.dynmic2Key.get(this.packKey((DynamicObject)e));
                    String seqkey = key.substring(0, key.indexOf("->", (index1 = key.indexOf("->")) + 1));
                    Integer maxSeq = maxseqMap.get(seqkey) == null ? Integer.valueOf(0) : (Integer)maxseqMap.get(seqkey);
                    e.set("relaseq", (Object)(maxSeq + 1));
                    maxseqMap.put(seqkey, maxSeq + 1);
                }
            });
        }
        if (this.reCalcType != 1 && !kvMap.isEmpty()) {
            for (DynamicObject v2 : kvMap.values()) {
                if (!v2.getBoolean("isdelete") && !ShareHoldingCalcService.checkModify(v2)) continue;
                reserveDatas.add(v2.getLong("id"));
            }
        }
        try (TXHandle x = TX.required();){
            try {
                QFBuilder qf = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
                qf.add("scenario", "=", (Object)this.ctx.getScenarioId());
                qf.add("year", "=", (Object)this.ctx.getFyId());
                qf.add("period", "=", (Object)this.ctx.getPeriodId());
                qf.add("invrelatype", "in", (Object)new String[]{"1", "2", "3", "4", "5"});
                if (reserveDatas.size() > 0) {
                    qf.add("id", "not in", reserveDatas);
                }
                if (null != this.orgUnitIdLists) {
                    qf.add("orgunit", "in", (Object)LongUtil.toLongList(this.orgUnitIdLists));
                }
                DeleteServiceHelper.delete((String)"bcm_invrelation", (QFilter[])qf.toArray());
                if (this.coll.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])((DynamicObject[])this.coll.toArray((Object[])new DynamicObject[0])));
                }
            }
            catch (Exception e2) {
                x.markRollback();
                throw e2;
            }
        }
    }

    public static boolean checkModify(DynamicObject v) {
        BigDecimal equvscale = v.getBigDecimal("equvscale");
        BigDecimal confirmScale = v.getInt("invrelatype") > 3 ? v.getBigDecimal("minconfirmscale") : v.getBigDecimal("confirmscale");
        return v.getBoolean("ismodified") || equvscale.compareTo(confirmScale) != 0;
    }

    private String packKey(DynamicObject dyna) {
        return dyna.getString("invrelatype") + "->" + dyna.getString("orgunit") + "->" + dyna.getString("shareholder") + "->" + dyna.getString("investeecompany");
    }

    private String packKeyByNum(DynamicObject dyna) {
        return dyna.getString("invrelatype") + "->" + dyna.getString("orgunit.number") + "->" + dyna.getString("shareholder.number") + "->" + dyna.getString("investeecompany.number");
    }

    private void saveChangeStatus() {
        StringBuilder sql = new StringBuilder("delete  from T_BCM_InvChangeStatus ");
        sql.append("WHERE FModelId =? and fscenarioid = ? and ffyid = ? and fperiodid = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FModelId", -5, (Object)this.ctx.getModelId()), new SqlParameter(":fscenarioid", -5, (Object)this.ctx.getScenarioId()), new SqlParameter(":ffyid", -5, (Object)this.ctx.getFyId()), new SqlParameter(":fperiodid", -5, (Object)this.ctx.getPeriodId())};
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql.toString(), (Object[])params);
        ORM orm = ORM.create();
        DynamicObject dyna = orm.newDynamicObject("bcm_invchangestatus");
        java.util.Date[] from2End = PeriodUtils.calcStartAndEndDate((long)this.ctx.getModelId(), (long)this.ctx.getFyId(), (long)this.ctx.getPeriodId());
        dyna.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyna.set("modelid", (Object)this.ctx.getModelId());
        dyna.set("scenarioid", (Object)this.ctx.getScenarioId());
        dyna.set("fyid", (Object)this.ctx.getFyId());
        dyna.set("periodid", (Object)this.ctx.getPeriodId());
        dyna.set("starttime", (Object)from2End[0]);
        dyna.set("endtime", (Object)from2End[1]);
        dyna.set("status", (Object)"1");
        BusinessDataWriter.save((IDataEntityType)dyna.getDataEntityType(), (Object[])new Object[]{dyna});
    }

    private Map<String, DynamicObject> queryInvRelation() {
        HashMap<String, DynamicObject> kvMap = new HashMap<String, DynamicObject>();
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.ctx.getModelId());
        qf.add("scenario", "=", (Object)this.ctx.getScenarioId());
        qf.add("year", "=", (Object)this.ctx.getFyId());
        qf.add("period", "=", (Object)this.ctx.getPeriodId());
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_invrelation", (QFilter[])qf.toArray());
        for (DynamicObject dyna : objectDynamicObjectMap.values()) {
            if (dyna.getInt("invrelatype") > 5) continue;
            kvMap.put(this.packKeyByNum(dyna), dyna);
        }
        return kvMap;
    }

    private void mergerRelaHolding(HoldingCalcContext.UnitHolderRelaInfo holder, Set<HoldingCalcContext.WalkPath> allWalkPath) {
        this.ctx.addTag(String.format(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u6392\u5e8f\u540e\u7684\u67b6\u6784\u96c6\u5408_%s", (String)"ShareHoldingCalcService_7", (String)"fi-bcm-business", (Object[])new Object[0]), holder.getUnitNum()), holder::getAllCompanyNum2LongMap);
        this.ctx.addTag(String.format(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7_%s", (String)"ShareHoldingCalcService_8", (String)"fi-bcm-business", (Object[])new Object[0]), holder.getUnitNum()), holder::getDirectChildren);
        this.ctx.addTag(String.format(ResManager.loadKDString((String)"\u771f\u5b9e\u7684\u76f4\u63a5\u4e0b\u7ea7_%s", (String)"ShareHoldingCalcService_9", (String)"fi-bcm-business", (Object[])new Object[0]), holder.getUnitNum()), holder::getRealDirectChildren);
        ArrayList<AbstractRelaSort> sortChain = new ArrayList<AbstractRelaSort>(2);
        DirecteRelaSort directRelaSort = new DirecteRelaSort(this.ctx);
        CrossingOrgMinShareHolderRelaSort crossingOrgMinShareHolderRelaSort = new CrossingOrgMinShareHolderRelaSort(this.ctx);
        sortChain.add(directRelaSort);
        sortChain.add(new InDirectionRelaSort(this.ctx));
        sortChain.add(new MultiRelaSort(this.ctx));
        sortChain.add(crossingOrgMinShareHolderRelaSort);
        sortChain.add(new SameLevelRelaSort(this.ctx));
        allWalkPath.forEach(walk -> sortChain.forEach(sort -> sort.sortFilter(holder, (HoldingCalcContext.WalkPath)walk)));
        crossingOrgMinShareHolderRelaSort.handelSprecialInvPath(holder, directRelaSort);
        sortChain.forEach(sort -> this.buildRecord((AbstractRelaSort)sort, holder));
    }

    private void buildRecord(AbstractRelaSort sort, HoldingCalcContext.UnitHolderRelaInfo holder) {
        ORM orm = ORM.create();
        sort.relaHoldScacleMap.forEach((key, value) -> {
            DynamicObject dyna = orm.newDynamicObject("bcm_invrelation");
            this.buildCommonPart(dyna, holder);
            String[] splits = key.split("->");
            dyna.set("invrelatype", (Object)sort.getSortType().getType());
            dyna.set("shareholder", (Object)this.ctx.getHoldCompNum2IdMap().get(splits[0]));
            Long invteeCompId = 0L;
            invteeCompId = InvRelaTypeEnum.DirectRelaType.getType().equals(sort.getSortType().getType()) ? this.ctx.getInvteeCompNum2IdMap().get(splits[1]) : holder.getAllCompanyNum2IdMap().get(splits[1]);
            if (!LongUtil.isvalidLong((Object)invteeCompId)) {
                return;
            }
            dyna.set("investeecompany", (Object)invteeCompId);
            dyna.set("equvscale", (Object)ShareHoldingCalcService.handleScale(value));
            dyna.set("sharecase", (Object)this.caseId);
            switch (sort.getSortType()) {
                case INDirectRelaType: 
                case MultiRelaType: {
                    dyna.set("confirmscale", dyna.get("equvscale"));
                    dyna.set("minconfirmscale", (Object)ShareHoldingCalcService.handleScale(BigDecimal.ZERO.equals(value) ? BigDecimal.ZERO : BigDecimal.ONE.subtract((BigDecimal)value)));
                    break;
                }
                case DirectRelaType: {
                    dyna.set("confirmscale", dyna.get("equvscale"));
                    dyna.set("minconfirmscale", (Object)ShareHoldingCalcService.handleScale(BigDecimal.ONE.subtract((BigDecimal)value)));
                    BigDecimal tmp = dyna.getBigDecimal("equvscale");
                    if (ShareHoldingCalcService.isBetween00And50(tmp)) {
                        dyna.set("isusedinvrule", (Object)"1");
                        dyna.set("isconfirmed", (Object)"0");
                        break;
                    }
                    dyna.set("isusedinvrule", (Object)"0");
                    break;
                }
                case MinRelaType: 
                case SameLevelRelaType: {
                    dyna.set("minconfirmscale", dyna.get("equvscale"));
                    break;
                }
            }
            if (this.ctx.getHoldCompNum2IdMap().get(splits[0]) != null) {
                this.coll.add((Object)dyna);
                this.dynmic2Key.put(this.packKey(dyna), sort.getSortType().getType() + "->" + holder.getUnitNum() + "->" + splits[0] + "->" + splits[1]);
            }
        });
    }

    private static boolean isBetween00And50(BigDecimal tmp) {
        return tmp != null && tmp.compareTo(Zero) >= 0 && tmp.compareTo(FiveTy) <= 0;
    }

    private static BigDecimal handleScale(BigDecimal scale) {
        scale = scale.multiply(BCMConstant.Hundred);
        return scale.setScale(accuracy, RoundingMode.HALF_UP);
    }

    private void buildCommonPart(DynamicObject dyna, HoldingCalcContext.UnitHolderRelaInfo holder) {
        dyna.set("model", (Object)this.ctx.getModelId());
        dyna.set("scenario", (Object)this.ctx.getScenarioId());
        dyna.set("year", (Object)this.ctx.getFyId());
        dyna.set("period", (Object)this.ctx.getPeriodId());
        dyna.set("orgunit", (Object)holder.getUnitId());
        dyna.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dyna.set("createtime", (Object)TimeServiceHelper.now());
        dyna.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dyna.set("modifytime", (Object)TimeServiceHelper.now());
    }

    private void doCalcHolding() {
        this.ctx.getHolderList().parallelStream().forEach(holder -> {
            ShareNode calcNode = this.ctx.getShareNodes().get(holder.getHolderNumber());
            if (calcNode != null) {
                this.calcEquvScale((HoldingCalcContext.UnitHolderRelaInfo)holder, calcNode);
            }
        });
    }

    private void calcEquvScale(HoldingCalcContext.UnitHolderRelaInfo holder, ShareNode calcNode) {
        this.walkShareNode(holder, calcNode, calcNode.packNode(), BCMConstant.One, true, false);
    }

    public Table<String, String, Object> getHolderWalkPaths() {
        HashBasedTable walkPathTable = HashBasedTable.create();
        this.ctx.getHolderList().stream().forEach(arg_0 -> ShareHoldingCalcService.lambda$getHolderWalkPaths$18((Table)walkPathTable, arg_0));
        return walkPathTable;
    }

    private void walkShareNode(HoldingCalcContext.UnitHolderRelaInfo holder, ShareNode parentNode, String preWalkPath, BigDecimal preScale, boolean isRoot, boolean isCyclePath) {
        if (!isRoot) {
            holder.addWalkPath(preWalkPath, preScale, isCyclePath);
            if (isCyclePath) {
                return;
            }
        }
        parentNode.getInvChildren().forEach(c -> {
            boolean isCycle = this.isContains(preWalkPath, c.packNode());
            BigDecimal currScale = preScale.multiply(this.ctx.getRelaMap().get(parentNode.getNumber() + "->" + c.getNumber()));
            if (!isRoot && (holder.getDirectChildren().contains(c.getNumber()) || holder.getDirectChildren().contains(parentNode.getNumber())) && holder.getCachePath().add(this.showLinkPath(parentNode.packNode(), (ShareNode)c))) {
                holder.addWalkPath(this.showLinkPath(parentNode.packNode(), (ShareNode)c), this.ctx.getRelaMap().get(parentNode.getNumber() + "->" + c.getNumber()), false);
            }
            this.walkShareNode(holder, (ShareNode)c, this.showLinkPath(preWalkPath, (ShareNode)c), currScale, false, isCycle);
        });
    }

    private boolean isContains(String preWalkPath, String path) {
        String[] paths = preWalkPath.split("->");
        return Arrays.asList(paths).contains(path);
    }

    private String showLinkPath(String preWalkPath, ShareNode currNode) {
        return preWalkPath + "->" + currNode.packNode();
    }

    private void initHolderNode(AbstractFormPlugin plugin) {
        if (this.ctx.getShareNodes().isEmpty()) {
            return;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ShareHoldingCalcService.class.getName(), (String)"bcm_entitymembertree", (String)"number,id,longnumber,ctrlorg.number hnumber,cslscheme.id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.ctx.getModelId()), new QFilter("ctrlorg", "!=", (Object)0L), new QFilter("ctrlorg", "is not null", null), new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex())}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HoldingCalcContext.UnitHolderRelaInfo info = this.ctx.addUnitAndHolderRela(row.getLong("id"), row.getString("number"), row.getString("hnumber"));
                info.setUnitLongNum(row.getString("longnumber"));
                info.setCslscheme(row.getLong("cslscheme.id"));
                this.ctx.getShareNodes().computeIfPresent(row.getString("hnumber"), (k, oldval) -> {
                    oldval.setHolder(true);
                    return oldval;
                });
                this.ctx.getHoldMapInvestee().put(row.getString("number"), row.getString("hnumber"));
            }
        }
        catch (Exception e) {
            this.log.error("initHolderNode error -->" + ThrowableHelper.toString((Exception)e));
            throw new KDBizException(e.toString());
        }
        if (this.ctx.getHolderList().isEmpty()) {
            if (plugin == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u63a7\u80a1\u516c\u53f8\u3002", (String)"ShareHoldingCalcService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u63a7\u80a1\u516c\u53f8\u3002", (String)"ShareHoldingCalcService_0", (String)"fi-bcm-business", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        this.ctx.getHolderList().forEach(h -> {
            IDNumberTreeNode unitHolderNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)h.getUnitId());
            FilterOrgStructParam orgParam = new FilterOrgStructParam(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId()).setOpenSortedDictionary(true);
            Map<Long, String> effectiveOrgMap = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(orgParam, unitHolderNode.getAllChildrenIds());
            Map<String, Set<Long>> priorOrgMap = EntityVersioningUtil.sortOrgByChangeType(this.ctx.getModelNum(), null, effectiveOrgMap.keySet(), orgParam.getSortedDictionary());
            boolean isCurCalOrgNode = this.orgUnitIdLists == null || this.orgUnitIdLists.contains(Long.toString(h.getUnitId()));
            for (IDNumberTreeNode childNode : isCurCalOrgNode ? unitHolderNode.getAllChildren() : unitHolderNode.getChildren()) {
                String childNum = childNode.getNumber();
                Set<Long> priorList = priorOrgMap.get(childNum);
                if (CollectionUtil.isEmpty(priorList) || !priorList.contains(childNode.getId())) continue;
                if (childNode.getParent() == unitHolderNode && priorList.iterator().next().longValue() == childNode.getId().longValue()) {
                    if (this.ctx.getHoldMapInvestee().containsKey(childNum)) {
                        h.getDirectChildren().add(this.ctx.getHoldMapInvestee().get(childNum));
                    } else {
                        h.getRealDirectChildren().add(childNum);
                        h.getDirectChildren().add(childNum);
                    }
                }
                if (!isCurCalOrgNode) continue;
                h.getAllChildren().add(childNum);
            }
            if (isCurCalOrgNode) {
                h.getAllChildren().add(h.getHolderNumber());
            }
            h.getAllChildren().add(h.getHolderNumber());
            h.getRealDirectChildren().add(h.getHolderNumber());
            h.getDirectChildren().add(h.getHolderNumber());
            priorOrgMap.forEach((orgNum, idList) -> {
                if (!CollectionUtil.isEmpty((Collection)idList)) {
                    long id = (Long)idList.iterator().next();
                    h.getAllCompanyNum2IdMap().put((String)orgNum, (Long)idList.iterator().next());
                    h.getAllCompanyNum2LongMap().put((String)orgNum, BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)id).getLongNumber());
                }
            });
        });
        this.sortOrgByCsScheme();
    }

    private void sortOrgByCsScheme() {
        HashSet<String> numbers = new HashSet<String>();
        numbers.addAll(this.ctx.getHoldCompNum2IdMap().keySet());
        numbers.addAll(this.ctx.getInvteeCompNum2IdMap().keySet());
        QFBuilder qf = new QFBuilder();
        qf.add(new QFilter("number", "in", numbers));
        qf.add(new QFilter("model", "=", (Object)this.ctx.getModelId()));
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"cslscheme.id,number", (QFilter[])qf.toArray()).forEach(dyna -> this.ctx.getScheme2OrgNums().put((Object)dyna.getLong("cslscheme.id"), (Object)dyna.getString("number")));
    }

    private void initShareHoldingRelation() {
        StringBuilder sql = new StringBuilder("select h.fnumber hnumber,h.fid hid,inv.fnumber invnumber,inv.fid invid,r.FShareScale scale,r.fisout isout from T_BCM_INVSHARERELA r ");
        sql.append("JOIN t_bcm_structofICEntity h ON h.FId = r.FShareHolderId ").append("JOIN t_bcm_structofEnt inv ON inv.FId = r.FInvesteeCompanyId ").append("JOIN (SELECT FShareHolderId,FInvesteeCompanyId,max(FInvestDate) FInvestDate from T_BCM_INVSHARERELA where FModelId =?  and FInvestDate <= ? and fsharecaseid = ? ").append("Group By FShareHolderId,FInvesteeCompanyId) t ON r.FShareHolderId = t.FShareHolderId and r.FInvesteeCompanyId = t.FInvesteeCompanyId and r.FInvestDate = t.FInvestDate ");
        java.util.Date[] dates = PeriodUtils.calcStartAndEndDate((long)this.ctx.getModelId(), (long)this.ctx.getFyId(), (long)this.ctx.getPeriodId());
        Object[] params = new SqlParameter[]{new SqlParameter(":FModelId", -5, (Object)this.ctx.getModelId()), new SqlParameter(":FInvestDate", 91, (Object)new Date(dates[1].getTime())), new SqlParameter(":fsharecaseid", -5, (Object)this.caseId)};
        VersionParam param = AdjustOperationHelper.createVersionParam(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
        boolean isRealTimeJudgOutRela = ConfigServiceHelper.getBoolParam(this.ctx.getModelId(), "isRealTimeJudgOutRela");
        DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql.toString(), (Object[])params, rs -> {
            boolean isOut = false;
            while (rs.next()) {
                BigDecimal scale = rs.getBigDecimal("scale");
                if (scale.compareTo(BigDecimal.ZERO) == 0) continue;
                String hnumber = rs.getString("hnumber");
                String invnumber = rs.getString("invnumber");
                long hid = rs.getLong("hid");
                long invId = rs.getLong("invid");
                boolean bl = isOut = !rs.getBoolean("isout");
                if (isRealTimeJudgOutRela) {
                    boolean bl2 = isOut = !AdjustOperationHelper.isMatchIcItem(param, "ICEntity", hnumber);
                }
                if (isOut) {
                    this.ctx.getOutSideCompSet().add(hnumber);
                }
                this.ctx.addShareRela(hnumber, hid, invnumber, invId, rs.getBigDecimal("scale").divide(BCMConstant.Hundred), isOut);
            }
            return this.ctx;
        });
    }

    public ShareHoldingCalcService setOrgToCaseMap(Map<Long, Long> orgToCaseMap) {
        this.orgToCaseMap = orgToCaseMap;
        return this;
    }

    private static /* synthetic */ void lambda$getHolderWalkPaths$18(Table walkPathTable, HoldingCalcContext.UnitHolderRelaInfo holder) {
        holder.getWalkPath().stream().forEach(walkPath -> {
            String[] orgNodes = walkPath.getPath().split("->");
            String holdCompany = orgNodes[0];
            String investeeCompany = orgNodes[orgNodes.length - 1];
            String investTar = holdCompany + "->" + investeeCompany;
            ArrayList<HoldingCalcContext.WalkPath> walkPathList = (ArrayList<HoldingCalcContext.WalkPath>)walkPathTable.get((Object)holder.getUnitNum(), (Object)investTar);
            if (Objects.isNull(walkPathList)) {
                walkPathList = new ArrayList<HoldingCalcContext.WalkPath>(16);
            }
            walkPathList.add((HoldingCalcContext.WalkPath)walkPath);
            walkPathTable.put((Object)holder.getUnitNum(), (Object)investTar, walkPathList);
        });
    }

    static class SameLevelRelaSort
    extends AbstractRelaSort {
        protected SameLevelRelaSort(HoldingCalcContext ctx) {
            super(ctx);
        }

        @Override
        protected void sortFilter(HoldingCalcContext.UnitHolderRelaInfo holder, HoldingCalcContext.WalkPath walkPath) {
            boolean isNoSameLevelRelaUseDirect = ConfigServiceHelper.getBoolParam(this._ctx.getModelId(), "isNoSameLevelRelaUseDirect");
            String[] orgNodes = this.splitPath(walkPath);
            int lenth = orgNodes.length;
            String holdCompany = orgNodes[0];
            String investeeCompany = orgNodes[orgNodes.length - 1];
            if (lenth > 2 && holder.getHolderNumber().equals(holdCompany)) {
                List<String> toCheckList;
                List<String> list = toCheckList = isNoSameLevelRelaUseDirect ? Arrays.asList(orgNodes) : Arrays.asList(investeeCompany, orgNodes[orgNodes.length - 2]);
                if (!holder.getDirectChildren().containsAll(toCheckList)) {
                    return;
                }
                BigDecimal scale = this._ctx.getRelaMap().getOrDefault(this.packKey(orgNodes[lenth - 2], investeeCompany), BCMConstant.Zero).multiply(BCMConstant.Hundred);
                if (ConfigServiceHelper.getBoolParam(this._ctx.getModelId(), "isUseSameLevelRelaLastLevelScaleNew")) {
                    if (ShareHoldingCalcService.isBetween00And50(scale)) {
                        this.relaHoldScacleMap.put(this.packKey(orgNodes[lenth - 2], investeeCompany), this._ctx.getRelaMap().getOrDefault(this.packKey(orgNodes[lenth - 2], investeeCompany), BCMConstant.Zero));
                    } else {
                        this.relaHoldScacleMap.compute(this.packKey(orgNodes[lenth - 2], investeeCompany), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale()));
                    }
                } else {
                    this.relaHoldScacleMap.put(this.packKey(orgNodes[lenth - 2], investeeCompany), this._ctx.getRelaMap().getOrDefault(this.packKey(orgNodes[lenth - 2], investeeCompany), BCMConstant.Zero));
                }
            }
        }

        @Override
        InvRelaTypeEnum getSortType() {
            return InvRelaTypeEnum.SameLevelRelaType;
        }
    }

    static class DirecteRelaSort
    extends AbstractRelaSort {
        protected DirecteRelaSort(HoldingCalcContext ctx) {
            super(ctx);
        }

        @Override
        protected void sortFilter(HoldingCalcContext.UnitHolderRelaInfo holder, HoldingCalcContext.WalkPath walkPath) {
            String[] orgNodes = this.splitPath(walkPath);
            int lenth = orgNodes.length;
            String holdCompany = orgNodes[0];
            String investeeCompany = orgNodes[orgNodes.length - 1];
            if (lenth == 2 && (holder.getRealDirectChildren().contains(holdCompany) || holder.getHolderNumber().equals(holdCompany))) {
                this.relaHoldScacleMap.put(this.packKey(holdCompany, investeeCompany), walkPath.getScale());
                if (this.isOutsideCompany(holdCompany)) {
                    this._ctx.getAllWalkPath().stream().forEach(path -> {
                        String[] orgNodes2 = this.splitPath((HoldingCalcContext.WalkPath)path);
                        int lenth2 = orgNodes2.length;
                        String holdCompany2 = orgNodes2[0];
                        String investeeCompany2 = orgNodes2[orgNodes2.length - 1];
                        if (lenth2 == 2 && investeeCompany2.equals(holdCompany)) {
                            this.relaHoldScacleMap.put(this.packKey(holdCompany2, investeeCompany2), path.getScale());
                        }
                    });
                }
            }
        }

        @Override
        InvRelaTypeEnum getSortType() {
            return InvRelaTypeEnum.DirectRelaType;
        }
    }

    static class CrossingOrgMinShareHolderRelaSort
    extends AbstractRelaSort {
        private Set<HoldingCalcContext.WalkPath> specialPathSet = new HashSet<HoldingCalcContext.WalkPath>(4);

        protected CrossingOrgMinShareHolderRelaSort(HoldingCalcContext ctx) {
            super(ctx);
        }

        @Override
        protected void sortFilter(HoldingCalcContext.UnitHolderRelaInfo holder, HoldingCalcContext.WalkPath walkPath) {
            String[] orgNodes = this.splitPath(walkPath);
            int lenth = orgNodes.length;
            String holdCompany = orgNodes[0];
            String investeeCompany = orgNodes[orgNodes.length - 1];
            if (!holder.getAllCompanyNum2IdMap().containsKey(holdCompany) || !holder.getAllCompanyNum2IdMap().containsKey(investeeCompany)) {
                return;
            }
            if (lenth == 2) {
                if (holder.getHolderNumber().equals(holdCompany) && !holder.getDirectChildren().contains(investeeCompany) && this.isCommonUnitAndSame2CurrentHolderUnit(holder, holdCompany, investeeCompany)) {
                    this.relaHoldScacleMap.compute(this.packKey(holdCompany, investeeCompany), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale()));
                } else if (this.isCommonUnitAndSame2CurrentHolderUnit(holder, holdCompany, investeeCompany) && this.isCrossingOrgInvMinRelaType(holder, holdCompany, investeeCompany)) {
                    this.relaHoldScacleMap.compute(this.packKey(holdCompany, investeeCompany), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale()));
                }
            }
        }

        protected void handelSprecialInvPath(HoldingCalcContext.UnitHolderRelaInfo holder, AbstractRelaSort other) {
            if (!this.specialPathSet.isEmpty()) {
                block0: for (HoldingCalcContext.WalkPath path : this.specialPathSet) {
                    String invCompany;
                    String[] h2inv = this.splitPath(path);
                    String holdCompany = h2inv[h2inv.length - 2];
                    if (!this.isCrossingOrgInv(holdCompany, invCompany = h2inv[h2inv.length - 1])) continue;
                    for (String rela : other.relaHoldScacleMap.keySet()) {
                        String invCompany2;
                        String[] a2b = this.splitKey(rela);
                        String holdCompany2 = a2b[a2b.length - 2];
                        if (!this.isCrossingOrgInv(holdCompany2, invCompany2 = a2b[a2b.length - 1]) || holdCompany.equals(holdCompany2) || invCompany.equals(invCompany2)) continue;
                        Optional<HoldingCalcContext.UnitHolderRelaInfo> holdParent = this._ctx.getHolderList().stream().filter(f -> f.getDirectChildren().contains(holdCompany2)).findFirst();
                        Optional<HoldingCalcContext.UnitHolderRelaInfo> investeeParent = this._ctx.getHolderList().stream().filter(f -> f.getDirectChildren().contains(invCompany2)).findFirst();
                        if (!holdParent.isPresent() || !investeeParent.isPresent() || !holder.getDirectChildren().contains(holdParent.get().getHolderNumber()) || !holder.getDirectChildren().contains(investeeParent.get().getHolderNumber()) || !holdParent.get().getDirectChildren().contains(invCompany) || !investeeParent.get().getDirectChildren().contains(holdCompany)) continue;
                        this.relaHoldScacleMap.compute(this.packKey(holdCompany, invCompany), (k, v) -> v == null ? this._ctx.getRelaMap().get(this.packKey(holdCompany, invCompany)).subtract(path.getScale()) : v.add(path.getScale()));
                        continue block0;
                    }
                }
            }
        }

        @Override
        InvRelaTypeEnum getSortType() {
            return InvRelaTypeEnum.MinRelaType;
        }
    }

    static class InDirectionRelaSort
    extends AbstractRelaSort {
        protected InDirectionRelaSort(HoldingCalcContext ctx) {
            super(ctx);
        }

        @Override
        protected void sortFilter(HoldingCalcContext.UnitHolderRelaInfo holder, HoldingCalcContext.WalkPath walkPath) {
            boolean isTheSameHolder;
            ShareNode node;
            String[] orgNodes = this.splitPath(walkPath);
            int lenth = orgNodes.length;
            String holdCompany = orgNodes[0];
            String investeeCompany = orgNodes[orgNodes.length - 1];
            if (holder.getHolderNumber().equals(investeeCompany)) {
                return;
            }
            if (lenth == 2 && holder.getHolderNumber().equals(holdCompany) && holder.getDirectChildren().contains(investeeCompany) && !this.isOutsideCompany(holdCompany)) {
                this.relaHoldScacleMap.compute(this.packKey(holder.getHolderNumber(), investeeCompany), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale()));
            } else if (lenth == 2 && holder.getDirectChildren().contains(investeeCompany) && this.isCommonUnitAndSame2CurrentHolderUnit(holder, holdCompany, investeeCompany)) {
                if (ShareHoldingCalcService.handleScale(walkPath.getScale()).compareTo(Zero) >= 0) {
                    this.relaHoldScacleMap.compute(this.packKey(holder.getHolderNumber(), investeeCompany), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale()));
                }
            } else if (lenth > 2 && holder.getHolderNumber().equals(holdCompany) && holder.getDirectChildren().contains(investeeCompany)) {
                String holdCompany2 = orgNodes[orgNodes.length - 2];
                if (ShareHoldingCalcService.handleScale(this._ctx.getRelaMap().get(this.packKey(holdCompany2, investeeCompany))).compareTo(Zero) < 0) {
                    this.relaHoldScacleMap.compute(this.packKey(holder.getHolderNumber(), investeeCompany), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale()));
                }
            } else if (lenth == 2 && this.isOutsideCompany(holdCompany) && holder.getDirectChildren().contains(investeeCompany) && (node = this._ctx.getShareNodes().get(investeeCompany)) != null && (isTheSameHolder = node.getHolders().stream().anyMatch(p -> p.getNumber().equals(holder.getHolderNumber())))) {
                this._ctx.getAllWalkPath().stream().forEach(path -> {
                    String[] orgNodes2 = this.splitPath((HoldingCalcContext.WalkPath)path);
                    int lenth2 = orgNodes2.length;
                    String investeeCompany2 = orgNodes2[orgNodes2.length - 1];
                    if (lenth2 == 2 && investeeCompany2.equals(holdCompany)) {
                        this.relaHoldScacleMap.compute(this.packKey(holder.getHolderNumber(), investeeCompany), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale().multiply(path.getScale())));
                    }
                });
            }
        }

        @Override
        InvRelaTypeEnum getSortType() {
            return InvRelaTypeEnum.INDirectRelaType;
        }
    }

    static class MultiRelaSort
    extends AbstractRelaSort {
        protected MultiRelaSort(HoldingCalcContext ctx) {
            super(ctx);
        }

        @Override
        protected void sortFilter(HoldingCalcContext.UnitHolderRelaInfo holder, HoldingCalcContext.WalkPath walkPath) {
            String[] orgNodes = this.splitPath(walkPath);
            String headNode = orgNodes[0];
            String tailNode = orgNodes[orgNodes.length - 1];
            if (holder.getHolderNumber().equals(headNode) && !this.isIncludeOutsideCompany(orgNodes) && !walkPath.isCyclePath()) {
                boolean isMultiRelaSortAllInChildrens;
                boolean bl = isMultiRelaSortAllInChildrens = ConfigServiceHelper.getBoolParam(this._ctx.getModelId(), "isNoCheckMultiRelaSortAllInChildrens") || holder.getAllChildren().containsAll(Arrays.asList(orgNodes));
                if (isMultiRelaSortAllInChildrens && holder.getDirectChildren().contains(tailNode)) {
                    this.relaHoldScacleMap.compute(this.packKey(headNode, tailNode), (k, v) -> v == null ? walkPath.getScale() : v.add(walkPath.getScale()));
                }
            }
        }

        private boolean isIncludeOutsideCompany(String[] orgNodes) {
            for (String orgNode : orgNodes) {
                if (!this._ctx.getOutSideCompSet().contains(orgNode)) continue;
                return true;
            }
            return false;
        }

        @Override
        InvRelaTypeEnum getSortType() {
            return InvRelaTypeEnum.MultiRelaType;
        }
    }

    protected static abstract class AbstractRelaSort {
        protected Map<String, BigDecimal> relaHoldScacleMap = new HashMap<String, BigDecimal>();
        protected HoldingCalcContext _ctx;

        protected AbstractRelaSort(HoldingCalcContext ctx) {
            this._ctx = ctx;
        }

        protected String[] splitPath(HoldingCalcContext.WalkPath path) {
            return path.getPath().split("->");
        }

        protected String packKey(String k1, String k2) {
            return k1 + "->" + k2;
        }

        protected String[] splitKey(String key) {
            return key.split("->");
        }

        protected boolean isOutsideCompany(String company) {
            return this._ctx.getOutSideCompSet().contains(company);
        }

        public String toString() {
            return String.format("sort type:%s,value:%s", this.getSortType(), JSONObject.toJSON(this.relaHoldScacleMap));
        }

        protected int isExistCrossingOrgPath(String[] orgNodes, HoldingCalcContext.UnitHolderRelaInfo holder) {
            int lenth = orgNodes.length;
            int crossingType = -1;
            for (String org : orgNodes) {
                if (this._ctx.getScheme2OrgNums().get((Object)holder.getCslscheme()).contains(org)) continue;
                return -1;
            }
            crossingType = 0;
            for (int i = 1; i < lenth - 1; ++i) {
                if (!this.isCrossingOrgInv(orgNodes[i], orgNodes[i + 1]) || !this.isDetailChildren(holder, orgNodes[i]) || !this.isDetailChildren(holder, orgNodes[i + 1])) continue;
                crossingType = 1;
                break;
            }
            return crossingType;
        }

        public boolean isDetailChildren(HoldingCalcContext.UnitHolderRelaInfo holder, String child) {
            return new MembRangeItem("bcm_entitymembertree", (Long)holder.getUnitId(), holder.getUnitNum(), RangeEnum.VALUE_90, false, (Object)this._ctx.getModelId()).isMatched(holder.getAllCompanyNum2IdMap().get(child));
        }

        public boolean isCommonUnitAndSame2CurrentHolderUnit(HoldingCalcContext.UnitHolderRelaInfo holder, String holdCompany, String investeeCompany) {
            String hLongNum = holder.getAllCompanyNum2LongMap().get(holdCompany);
            String invLongNum = holder.getAllCompanyNum2LongMap().get(investeeCompany);
            if (StringUtils.isBlank((String)hLongNum) || StringUtils.isBlank((String)invLongNum)) {
                return false;
            }
            String parentLongNum = this.getTheSameParentLongNum(hLongNum, invLongNum);
            return !kd.bos.util.StringUtils.isEmpty((String)parentLongNum) && parentLongNum.endsWith("!" + holder.getUnitNum());
        }

        private String getTheSameParentLongNum(String longNum1, String longNum2) {
            String split = String.valueOf('!');
            String[] split1 = longNum1.split(split);
            String[] split2 = longNum2.split(split);
            int min = Math.min(split1.length, split2.length);
            int index = 0;
            int i = 0;
            while (i < min && split1[i].equals(split2[i])) {
                index = i++;
            }
            return String.join((CharSequence)split, Arrays.copyOf(split1, index + 1));
        }

        public boolean isCrossingOrgInv(String holdCompany, String investeeCompany) {
            Optional<HoldingCalcContext.UnitHolderRelaInfo> holdParent = this._ctx.getHolderList().stream().filter(f -> f.getDirectChildren().contains(holdCompany)).findFirst();
            Optional<HoldingCalcContext.UnitHolderRelaInfo> investeeParent = this._ctx.getHolderList().stream().filter(f -> f.getDirectChildren().contains(investeeCompany)).findFirst();
            return !holdParent.isPresent() || !investeeParent.isPresent() || !holdParent.get().getHolderNumber().equals(investeeParent.get().getHolderNumber()) && !holdParent.get().getHolderNumber().equals(investeeCompany) && !investeeParent.get().getHolderNumber().equals(holdCompany);
        }

        public boolean isCrossingOrgInvMinRelaType(HoldingCalcContext.UnitHolderRelaInfo holder, String holdCompany, String investeeCompany) {
            String hLongNum = holder.getAllCompanyNum2LongMap().get(holdCompany);
            String invLongNum = holder.getAllCompanyNum2LongMap().get(investeeCompany);
            if (StringUtils.isBlank((String)hLongNum) || StringUtils.isBlank((String)invLongNum)) {
                return false;
            }
            String commonholdnum = this.getTheSameParentLongNum(hLongNum, invLongNum);
            if (commonholdnum.equals("Entity!")) {
                return true;
            }
            Optional<HoldingCalcContext.UnitHolderRelaInfo> commonHoldParent = this._ctx.getHolderList().stream().filter(f -> f.getUnitLongNum().equals(commonholdnum)).findFirst();
            return !commonHoldParent.get().getDirectChildren().contains(holdCompany) || !commonHoldParent.get().getDirectChildren().contains(investeeCompany);
        }

        protected abstract void sortFilter(HoldingCalcContext.UnitHolderRelaInfo var1, HoldingCalcContext.WalkPath var2);

        abstract InvRelaTypeEnum getSortType();
    }
}

