/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.shareholder.model;

import com.google.common.collect.HashMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.adjust.trace.TraceLog;
import kd.fi.bcm.business.adjust.trace.TraceLogUtil;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.invest.shareholder.model.ShareNode;
import kd.fi.bcm.common.util.ToStringHelper;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HoldingCalcContext
extends AbstractContext {
    public static final String Arrow_Flag = "->";
    private Map<String, BigDecimal> relaMap = new HashMap<String, BigDecimal>();
    private Map<String, ShareNode> shareNodes = new HashMap<String, ShareNode>();
    private List<UnitHolderRelaInfo> holderList = new ArrayList<UnitHolderRelaInfo>();
    private Map<String, UnitHolderRelaInfo> holdingNumMapRelaInfos = new HashMap<String, UnitHolderRelaInfo>();
    private Set<String> outSideCompSet = new HashSet<String>();
    private Set<WalkPath> allWalkPath;
    private Map<String, String> holdMapInvestee = new HashMap<String, String>();
    private Map<String, Long> holdCompNum2IdMap = new HashMap<String, Long>();
    private Map<String, Long> invteeCompNum2IdMap = new HashMap<String, Long>();
    private HashMultimap<Long, String> scheme2OrgNums = HashMultimap.create();
    private String orgUnitNumber;
    private final TraceLog traceLog = TraceLogUtil.getLogInstance("redis");

    public HoldingCalcContext(long modelId, long scenarioId, long fyId, long periodId) {
        super(modelId, scenarioId, fyId, periodId);
    }

    public <T> void addTag(String key, CacheLoader<T> loader) {
        this.traceLog.addTag(key, loader);
    }

    public Map<String, BigDecimal> getRelaMap() {
        return this.relaMap;
    }

    public ShareNode getOrCreateShareNode(long id, String number) {
        return this.shareNodes.computeIfAbsent(number, key -> new ShareNode(id, number));
    }

    public Map<String, ShareNode> getShareNodes() {
        return this.shareNodes;
    }

    public void addShareRela(String holdNumber, long hId, String invNumber, long invId, BigDecimal scale, boolean isOut) {
        this.relaMap.put(this.sugerKey(holdNumber, invNumber), scale);
        this.holdCompNum2IdMap.put(holdNumber, hId);
        this.invteeCompNum2IdMap.put(invNumber, invId);
        ShareNode holdNode = this.getOrCreateShareNode(hId, holdNumber);
        holdNode.setOut(isOut);
        ShareNode InvteeNode = this.getOrCreateShareNode(invId, invNumber);
        holdNode.addInvestee(InvteeNode);
    }

    public UnitHolderRelaInfo addUnitAndHolderRela(long id, String unitNum, String holderNumber) {
        DynamicObject dyna;
        UnitHolderRelaInfo relaInfo = new UnitHolderRelaInfo(id, unitNum, holderNumber);
        if (!this.holdCompNum2IdMap.containsKey(holderNumber) && (dyna = MemberServiceHelper.getBaseMember("bcm_icmembertree", "id", new QFilter("number", "=", (Object)holderNumber).and("model", "=", (Object)this.getModelId()))) != null) {
            this.holdCompNum2IdMap.put(holderNumber, dyna.getLong("id"));
        }
        this.holderList.add(relaInfo);
        this.holdingNumMapRelaInfos.put(holderNumber, relaInfo);
        return relaInfo;
    }

    public List<UnitHolderRelaInfo> getHolderList() {
        return this.holderList;
    }

    public Set<String> getOutSideCompSet() {
        return this.outSideCompSet;
    }

    public void setOutSideCompSet(Set<String> outSideCompSet) {
        this.outSideCompSet = outSideCompSet;
    }

    public Map<String, String> getHoldMapInvestee() {
        return this.holdMapInvestee;
    }

    public Map<String, Long> getHoldCompNum2IdMap() {
        return this.holdCompNum2IdMap;
    }

    public Map<String, Long> getInvteeCompNum2IdMap() {
        return this.invteeCompNum2IdMap;
    }

    public Set<WalkPath> getAllWalkPath() {
        if (this.allWalkPath == null) {
            this.allWalkPath = new HashSet<WalkPath>();
            this.getHolderList().forEach(e -> this.allWalkPath.addAll(((UnitHolderRelaInfo)e).walkPath));
        }
        return this.allWalkPath;
    }

    public String sugerKey(String k1, String k2) {
        return k1 + Arrow_Flag + k2;
    }

    public Map<String, UnitHolderRelaInfo> getHoldingNumMapRelaInfos() {
        return this.holdingNumMapRelaInfos;
    }

    public HashMultimap<Long, String> getScheme2OrgNums() {
        return this.scheme2OrgNums;
    }

    public void setScheme2OrgNums(HashMultimap<Long, String> scheme2OrgNums) {
        this.scheme2OrgNums = scheme2OrgNums;
    }

    public String getOrgUnitNumber() {
        return this.orgUnitNumber;
    }

    public void setOrgUnitNumber(String orgUnitNumber) {
        this.orgUnitNumber = orgUnitNumber;
    }

    public static class WalkPath {
        private String path;
        private BigDecimal scale;
        private boolean isCyclePath = false;

        public String getPath() {
            return this.path;
        }

        public BigDecimal getScale() {
            return this.scale;
        }

        public boolean isCyclePath() {
            return this.isCyclePath;
        }

        WalkPath(String path, BigDecimal scale, boolean isCyclePath) {
            this.path = path;
            this.scale = scale;
            this.isCyclePath = isCyclePath;
        }

        public String toString() {
            return ToStringHelper.deepToString((Object)this);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.path).toHashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WalkPath) {
                WalkPath o = (WalkPath)other;
                return this.path.equals(o.path);
            }
            return false;
        }
    }

    public static class UnitHolderRelaInfo {
        private long unitId;
        private String unitNum;
        private String unitLongNum;
        private String holderNumber;
        private Set<WalkPath> walkPath = new LinkedHashSet<WalkPath>();
        private Set<String> directChildren = new HashSet<String>();
        private Set<String> realDirectChildren = new HashSet<String>();
        private Set<String> allChildren = new HashSet<String>();
        private Set<String> cachePath = new HashSet<String>();
        private Map<String, Long> allCompanyNum2IdMap = new HashMap<String, Long>();
        private Map<String, String> allCompanyNum2LongMap = new HashMap<String, String>();
        private long cslscheme = 0L;

        public long getCslscheme() {
            return this.cslscheme;
        }

        public void setCslscheme(long cslscheme) {
            this.cslscheme = cslscheme;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public void setUnitNum(String unitNum) {
            this.unitNum = unitNum;
        }

        public String getUnitNum() {
            return this.unitNum;
        }

        public String getUnitLongNum() {
            return this.unitLongNum;
        }

        public void setUnitLongNum(String unitLongNum) {
            this.unitLongNum = unitLongNum;
        }

        public String getHolderNumber() {
            return this.holderNumber;
        }

        public Set<WalkPath> getWalkPath() {
            return this.walkPath;
        }

        public Set<String> getDirectChildren() {
            return this.directChildren;
        }

        public Set<String> getAllChildren() {
            return this.allChildren;
        }

        public Set<String> getRealDirectChildren() {
            return this.realDirectChildren;
        }

        public Set<String> getCachePath() {
            return this.cachePath;
        }

        public UnitHolderRelaInfo(long unitId, String unitNum, String holderNumber) {
            this.holderNumber = holderNumber;
            this.unitNum = unitNum;
            this.unitId = unitId;
        }

        public void addWalkPath(String path, BigDecimal scale, boolean isCyclePath) {
            this.walkPath.add(new WalkPath(path, scale, isCyclePath));
        }

        public String toString() {
            return ToStringHelper.deepToString((Object)this);
        }

        public Map<String, Long> getAllCompanyNum2IdMap() {
            return this.allCompanyNum2IdMap;
        }

        public Map<String, String> getAllCompanyNum2LongMap() {
            return this.allCompanyNum2LongMap;
        }
    }
}

