/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class GlobalIdDistributer {
    private Queue<Long> idPool = new LinkedList<Long>();
    private Queue<String> idStringPool = new LinkedList<String>();
    private static float DEFAULT_LOAD_FACTOR = 0.75f;
    private static int defaultBatchCount = 500;

    public GlobalIdDistributer() {
    }

    public GlobalIdDistributer(int rowCount, int colCount, float factor) {
        defaultBatchCount = (int)((float)(rowCount * colCount) * factor);
    }

    public GlobalIdDistributer(int rowCount, int colCount) {
        defaultBatchCount = (int)((float)(rowCount * colCount) * DEFAULT_LOAD_FACTOR);
    }

    public long getLongId() {
        if (this.idPool.size() == 0) {
            long[] longIds = GlobalIdUtil.genGlobalLongIds((int)defaultBatchCount);
            this.idPool.addAll(Arrays.stream(longIds).boxed().collect(Collectors.toList()));
        }
        return this.idPool.poll();
    }

    public String getStringId() {
        if (this.idStringPool.size() == 0) {
            Object[] StringIds = GlobalIdUtil.genStringIds((int)defaultBatchCount);
            this.idStringPool.addAll(Lists.newArrayList((Object[])StringIds));
        }
        return this.idStringPool.poll();
    }
}

