/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.elimination.model.GenerateContext;
import kd.fi.bcm.business.invest.extdim.InvExtDataServiceHelper;
import kd.fi.bcm.business.invest.extdim.InvExtDataSpreadServiceHelper;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKeyTable;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultCellTable;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.invest.model.InvestFormulaLog;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.invest.sheet.InvLimSheetHeadInfo;
import kd.fi.bcm.business.invest.sheet.InvPaperSheetIteratorService;
import kd.fi.bcm.business.invest.sheet.InvShareRelationInfo;
import kd.fi.bcm.business.invest.sheet.InvSheetDeleteInfo;
import kd.fi.bcm.business.invest.sheet.InvTemplateDistributionService;
import kd.fi.bcm.business.invest.sheet.formula.InvFormulaParam;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestSpreadFormulaHandler;
import kd.fi.bcm.business.invest.sheet.log.IInvLimSheetLogServer;
import kd.fi.bcm.business.invest.sheet.log.InvLimSheetLogServer;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invlimsheet.InvExtDataConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.enums.invest.SheetStatusEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import org.apache.commons.collections.CollectionUtils;

public class InvElimPaperGenerateService {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvElimPaperGenerateService.class);
    public static final String NUMBER = "number";
    private final IInvLimSheetLogServer logServer;
    private Set<String> errMsg = new HashSet<String>();
    protected GenerateContext ctx;
    private final Set<Long> delSheetPks = new HashSet<Long>(16);
    private final Set<Long> delEntryPks = new HashSet<Long>(16);
    private final Set<Long> delExtendDataPKs = new HashSet<Long>(16);
    List<DynamicObject> needCreateTemps;
    DynamicObjectCollection invLimSheets;
    private List<String> specifiedProcess = null;
    private Map<Long, List<DynamicObject>> templateRuleWhenOpenGroup;
    private Map<Long, List<DynamicObject>> templateRuleByManualGroup;
    private Map<String, List<DynamicObject>> templateGroupByProcess;
    private Map<Long, List<DynamicObject>> temp2RelationType;
    private Map<Long, List<DynamicObject>> temp2CslMap;
    private Map<String, Set<String>> temp2MergeMap = new HashMap<String, Set<String>>(16);
    private Collection<Long> paper2DeleteIds;
    private Set<String> templateList;
    private Boolean isInvestGenWay = true;
    private int elimTemplateType = 1;
    public static final String NEWDATA_2_0 = "NEWDATA_2.0";
    public static final String NEWDATA = "NEWDATA";

    public Set<String> getTemplateList() {
        return this.templateList;
    }

    public void setTemplateList(Set<String> templateList) {
        this.templateList = templateList;
    }

    public void setInvestGenWay(Boolean investGenWay) {
        this.isInvestGenWay = investGenWay;
    }

    public void setElimTemplateType(int elimTemplateType) {
        this.elimTemplateType = elimTemplateType;
    }

    public static String getSpreadType(Sheet sheet, long templateId) {
        return InvExtDataSpreadServiceHelper.getSpreadType(sheet, templateId);
    }

    public int delSheetCount() {
        return this.delSheetPks.size();
    }

    public int delEntryCount() {
        return this.delEntryPks.size();
    }

    public InvElimPaperGenerateService(Long modelId, Long scenarioId, Long fyId, Long periodId, Long unitId, InvLimSheetLogConstant.Operation operationType) {
        this.ctx = new GenerateContext(modelId, scenarioId, fyId, periodId, unitId);
        this.logServer = InvLimSheetLogServer.buildInvLimSheetLogServer(modelId, scenarioId, fyId, periodId, unitId, operationType);
    }

    public InvElimPaperGenerateService(Long modelId, Long scenarioId, Long fyId, Long periodId, Long unitId, IInvLimSheetLogServer logServer) {
        this.ctx = new GenerateContext(modelId, scenarioId, fyId, periodId, unitId);
        this.logServer = logServer;
    }

    public void setSpecifiedProcess(List<String> process) {
        this.specifiedProcess = process;
    }

    private List<String> getProcesses() {
        ArrayList<String> processList = new ArrayList<String>();
        if (this.elimTemplateType == 2) {
            processList.add("ERAdj");
            processList.add("RAdj");
        } else {
            MergeControlHelper.getUnitElimProcesses(this.ctx.getModelId()).forEach(processList::addAll);
        }
        if (this.specifiedProcess != null) {
            processList.retainAll(this.specifiedProcess);
        }
        return processList;
    }

    /*
     * Exception decompiling
     */
    public Pair<Integer, String> generatePaper() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clear() {
        if (CollectionUtils.isNotEmpty(this.delEntryPks)) {
            this.delEntryPks.clear();
        }
        if (CollectionUtils.isNotEmpty(this.delExtendDataPKs)) {
            this.delExtendDataPKs.clear();
        }
        if (CollectionUtils.isNotEmpty(this.delSheetPks)) {
            this.delSheetPks.clear();
        }
    }

    private Pair<Integer, String> buildPaper(Set<String> units) {
        List<String> processes = this.getProcesses();
        if (CollectionUtils.isEmpty(processes)) {
            return Pair.onePair((Object)0, null);
        }
        Table<String, String, List<InvLimSheetHeadInfo>> relaTable = this.getRelaysMap(units);
        Table<String, String, List<InvLimSheetHeadInfo>> changeRelaTable = this.getChangeRelaysMap(units);
        relaTable.putAll(changeRelaTable);
        int countSheet = 0;
        InvestFormulaContext context = new InvestFormulaContext(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
        context.setCslschemeId(OrgServiceHelper.getCslSchemeId(this.ctx.getOrgUnitId()));
        context.setMergeOrgId(this.ctx.getOrgUnitId());
        context.setExecuteOrgId(this.ctx.getOrgUnitId());
        InvestSpreadFormulaHandler formulaHandler = new InvestSpreadFormulaHandler(context);
        for (String process : processes) {
            List<DynamicObject> templates = this.templateGroupByProcess.get(process);
            if (CollectionUtils.isEmpty(templates)) continue;
            Comparator<DynamicObject> comparator = Comparator.comparing(a -> 0);
            templates.sort(comparator.thenComparing((r1, r2) -> {
                if (r1.getBigDecimal("executeorder").compareTo(BigDecimal.ZERO) == 0) {
                    return 1;
                }
                if (r2.getBigDecimal("executeorder").compareTo(BigDecimal.ZERO) == 0) {
                    return -1;
                }
                return r1.getBigDecimal("executeorder").compareTo(r2.getBigDecimal("executeorder"));
            }).thenComparing(value -> value.getBigDecimal("executeorder"), Comparator.nullsLast(BigDecimal::compareTo)));
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)"Entity");
            Map<Long, IDNumberTreeNode> csl2RootNodeMap = entityNode.getChildren().stream().collect(Collectors.toMap(child -> LongUtil.toLong((Object)child.getProperty("cslscheme.id")), child -> child, (v1, v2) -> v1));
            ArrayList<InvLimSheetHeadInfo> relas = new ArrayList<InvLimSheetHeadInfo>(16);
            for (DynamicObject tmp : templates) {
                relas.clear();
                List<DynamicObject> relationTypes = this.temp2RelationType.getOrDefault(tmp.getLong("id"), Collections.emptyList());
                if (this.elimTemplateType == 2) {
                    Set<String> mergeScope = this.temp2MergeMap.get(tmp.getString(NUMBER));
                    for (DynamicObject cslDy : this.temp2CslMap.getOrDefault(tmp.getLong("id"), Collections.emptyList())) {
                        IDNumberTreeNode cslRoot = csl2RootNodeMap.get(cslDy.getLong("fbasedataid.id"));
                        if (cslRoot == null) continue;
                        Set unitIdList = InvestServiceHelper.queryEffectiveOrgMapCacheNoMerge(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), cslRoot.getId()).getOrDefault(this.ctx.getOrgUnitNumber(), Collections.emptySet());
                        for (Long unitId : unitIdList) {
                            Map unitRelaMap;
                            IDNumberTreeNode unitParNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)unitId).getParent();
                            if (unitParNode == null || "Entity".equals(unitParNode.getNumber()) || !mergeScope.remove(unitParNode.getNumber()) || (unitRelaMap = relaTable.row((Object)unitParNode.getNumber())).isEmpty()) continue;
                            InvRelationTypeHelper.foreachRelationType(relationTypes, (Consumer<String>)((Consumer)number -> relas.addAll(unitRelaMap.getOrDefault(number, Collections.emptyList()))));
                        }
                    }
                } else {
                    Map unitRelaMap = relaTable.row((Object)this.ctx.getOrgUnitNumber());
                    if (!unitRelaMap.isEmpty()) {
                        InvRelationTypeHelper.foreachRelationType(relationTypes, (Consumer<String>)((Consumer)number -> relas.addAll(unitRelaMap.getOrDefault(number, Collections.emptyList()))));
                    }
                }
                SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)((String)tmp.get("data")));
                if (!relas.isEmpty()) {
                    String floatOrder = (String)tmp.get("floatfieldorder");
                    if (!StringUtils.isBlank((CharSequence)floatOrder)) {
                        this.floatOrderResort(relationTypes, relas, floatOrder);
                    }
                    spreadManager.getBook().getSheet(0).getUserObject().put("tempId", tmp.getLong("id"));
                    spreadManager.getBook().getSheet(0).getUserObject().put("spreadtype", tmp.get("spreadtype"));
                    formulaHandler.autoFloatFormula(spreadManager, this.ctx.getOrgUnitId(), relas, (String)tmp.get("spreadtype"));
                    this.execBizRule(tmp, InvSheetTemplateConstant.EexcRuleTypeEnum.EXECWHENOPEN.getCode());
                    this.fillRuleResult2Sheet(tmp, spreadManager.getBook().getSheet(0));
                    InvestFormulaLog.createLogPoint(InvFormulaLogTypeEnum.InvSheetFormulaLog.getLogType(), this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), this.ctx.getOrgUnitId(), tmp.getLong("id"));
                    formulaHandler.calculateSpreadManagerFormulas(this.ctx.getOrgUnitId(), spreadManager, new InvFormulaParam(process));
                    InvestFormulaLog.removeLogPoint();
                    this.saveExtData(tmp, spreadManager);
                    this.execBizRule(tmp, InvSheetTemplateConstant.EexcRuleTypeEnum.MANUAL.getCode());
                } else {
                    if (this.isInvestGenWay.booleanValue()) continue;
                    spreadManager.getBook().getSheet(0).getUserObject().put("spreadtype", tmp.get("spreadtype"));
                    spreadManager.getBook().getSheet(0).putUserObject("inv_relation_count", (Object)0);
                    spreadManager.getBook().getSheet(0).putUserObject(NEWDATA, null);
                    spreadManager.getBook().getSheet(0).putUserObject(NEWDATA_2_0, null);
                }
                DynamicObject mulEntryObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invlimsheetentity");
                mulEntryObj.set(NUMBER, (Object)(tmp.getString(NUMBER) + "_V" + tmp.getBigDecimal("versionnumber").setScale(1)));
                mulEntryObj.set("name", (Object)tmp.getString("name"));
                mulEntryObj.set("template", (Object)tmp.getString("id"));
                mulEntryObj.set("model", (Object)this.ctx.getModelId());
                mulEntryObj.set("scenario", (Object)this.ctx.getScenarioId());
                mulEntryObj.set("year", (Object)this.ctx.getFyId());
                mulEntryObj.set("period", (Object)this.ctx.getPeriodId());
                mulEntryObj.set("entity", (Object)this.ctx.getOrgUnitId());
                mulEntryObj.set("creator", (Object)this.ctx.getUser());
                mulEntryObj.set("createtime", (Object)new Date());
                mulEntryObj.set("data", (Object)ObjectSerialUtil.toByteSerialized((Object)spreadManager));
                mulEntryObj.set("spreadjson", (Object)tmp.getString("spreadjson"));
                mulEntryObj.set("cslscheme", (Object)this.ctx.getCslId());
                mulEntryObj.set("catalog", (Object)tmp.getString("templatecatalog"));
                mulEntryObj.set("from", (Object)SheetStatusEnum.AUTO.status());
                SaveServiceHelper.save((IDataEntityType)mulEntryObj.getDynamicObjectType(), (Object[])new Object[]{mulEntryObj});
                ++countSheet;
            }
        }
        return Pair.onePair((Object)countSheet, this.errMsg.isEmpty() ? null : this.errMsg.toString());
    }

    private void fillRuleResult2Sheet(DynamicObject template, Sheet sheet) {
        InvEDResultCellTable calValueTable = this.queryRuleResult(template);
        if (calValueTable.isEmpty()) {
            return;
        }
        String defaultRelationTypeNumber = PaperTemplateService.getDefaultRelationTypeNumber(template.getLong("id"));
        String spreadType = InvElimPaperGenerateService.getSpreadType(sheet, template.getLong("id"));
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(sheet, spreadType);
        invPaperSheetIteratorService.iterationValueCellAxis((rltCell, orgCell, shareholderCell, investedCell, accCell, valueCell) -> {
            ExtendExtUniqueKey uniqueKey;
            Pair<Long, Object> valuePair;
            String shareholder = (String)shareholderCell.getUserObject(NUMBER, (Object)"");
            String investOrg = (String)investedCell.getUserObject(NUMBER, (Object)"");
            String unitOrg = (String)orgCell.getUserObject(NUMBER, (Object)"");
            String relationType = InvElimPaperGenerateService.getRelationType(defaultRelationTypeNumber, rltCell, shareholder, investOrg);
            String categorized = InvElimSpreadGenerateService.getCategorized(rltCell);
            String accountNumber = (String)accCell.getUserObject(NUMBER, (Object)"");
            if (Objects.nonNull(shareholder) && Objects.nonNull(investOrg) && Objects.nonNull(accountNumber) && Objects.nonNull(relationType) && Objects.nonNull(categorized) && Objects.nonNull(unitOrg) && Objects.isNull(valueCell.getUserObject("ff")) && (valuePair = calValueTable.getValuePair(uniqueKey = new ExtendExtUniqueKey(accountNumber, this.ctx.getOrgUnitNumber(), unitOrg, shareholder, investOrg, relationType, categorized))) != null && Objects.nonNull(valuePair.p2) && Objects.isNull(valueCell.getUserObject("ff"))) {
                valueCell.setValue(valuePair.p2);
            }
        });
    }

    public static String getRelationType(String relationTypeFromPaper, Cell rltCell, Object shareholder, Object investOrg) {
        String relationType = (String)rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName(), (Object)"");
        if (Objects.nonNull(shareholder) && Objects.nonNull(investOrg) && Objects.isNull(relationType)) {
            relationType = relationTypeFromPaper;
            rltCell.setUserObject(InvRelaTypeEnum.class.getSimpleName(), (Object)relationType);
        }
        return relationType;
    }

    private InvEDResultCellTable queryRuleResult(DynamicObject template) {
        long extModelId = template.getLong("extdimid");
        DynamicObject extModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,extendsgroup.id,extendsgroup.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)extModelId)});
        if (Objects.isNull(extModel)) {
            return new InvEDResultCellTable();
        }
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(this.ctx.getModelShowNum(), extModel.getString("extendsgroup.number"), extModel.getString(NUMBER));
        edQueryComInfo.setExtselects(InvExtDataConstant.getSelectField());
        edQueryComInfo.addDimFilter("Scenario", this.ctx.getScenariodNum());
        edQueryComInfo.addDimFilter("Year", this.ctx.getFyNum());
        edQueryComInfo.addDimFilter("Period", this.ctx.getPeriodNum());
        edQueryComInfo.addFilter("templatenumber", template.getString(NUMBER));
        edQueryComInfo.addFilter("org", this.ctx.getOrgUnitNumber());
        return InvExtDataServiceHelper.getCalValueTable(edQueryComInfo);
    }

    private void floatOrderResort(List<DynamicObject> relationTypes, List<InvLimSheetHeadInfo> relas, String floatOrder) {
        final ArrayList orderList = new ArrayList(3);
        JSONObjectUtil.parseObjectOrder((String)floatOrder).forEach((k, v) -> {
            if (((Boolean)v).booleanValue()) {
                if (InvSheetTemplateConstant.FloatFeildEnum.INVRELATIONTYPE.getCode().equals(k)) {
                    HashMap indexMap = new HashMap();
                    IntStream.rangeClosed(0, relationTypes.size() - 1).forEach(i -> indexMap.put(((DynamicObject)relationTypes.get(i)).getString("fbasedataid.number"), i));
                    orderList.add(Comparator.comparing(p -> indexMap.getOrDefault(p.getRelationType(), 0)));
                } else if (InvSheetTemplateConstant.FloatFeildEnum.HOLDER.getCode().equals(k)) {
                    orderList.add(Comparator.comparing(InvLimSheetHeadInfo::getShareholderNumber));
                } else {
                    orderList.add(Comparator.comparing(InvLimSheetHeadInfo::getInvestedCompanyNumber));
                }
            }
        });
        relas.sort(new Comparator<InvLimSheetHeadInfo>(){

            @Override
            public int compare(InvLimSheetHeadInfo o1, InvLimSheetHeadInfo o2) {
                int index = 0;
                for (Comparator order : orderList) {
                    index = order.compare(o1, o2);
                    if (index == 0) continue;
                    return index;
                }
                return index;
            }
        });
    }

    private void execBizRule(DynamicObject template, String execType) {
        String processNumber = template.getString("process.number");
        long groupId = template.getLong("group");
        ArrayList<DynamicObject> templateRule = new ArrayList(16);
        if (InvSheetTemplateConstant.EexcRuleTypeEnum.MANUAL.getCode().equals(execType)) {
            templateRule = this.templateRuleByManualGroup.get(groupId);
        } else if (InvSheetTemplateConstant.EexcRuleTypeEnum.EXECWHENOPEN.getCode().equals(execType)) {
            templateRule = this.templateRuleWhenOpenGroup.get(groupId);
        }
        if (CollectionUtils.isEmpty(templateRule)) {
            return;
        }
        this.excBizRule(template, processNumber, templateRule);
    }

    public Object[] excBizRule(DynamicObject template, String processNumber, List<DynamicObject> templateRule) {
        BizRuleExecParam param = this.getBizRuleExecParam(processNumber);
        Set dispenseRuleIds = templateRule.stream().map(record -> record.getLong("bizrule.id")).collect(Collectors.toSet());
        Collection allocateRecords = BizRuleServiceHelper.getBizRule((String)this.ctx.getModelNum(), f -> f.add("bizrule.id", "in", (Object)dispenseRuleIds), (String[])new String[]{processNumber});
        ArrayList bizRuleList = new ArrayList();
        allocateRecords.forEach(e -> {
            String content = e.getString("bizrule.content");
            if (kd.bos.util.StringUtils.isNotEmpty((String)content)) {
                bizRuleList.add(Pair.onePair((Object)e.getLong("bizrule.id"), (Object)content));
            }
        });
        if (CollectionUtils.isEmpty((Collection)allocateRecords)) {
            return Collections.emptyList().toArray();
        }
        Object[] records = BizRuleExecStarter.createExecRecord(allocateRecords.toArray(new DynamicObject[0]), param, this.ctx.getModelId());
        param.setBizRuleList(bizRuleList);
        param.setExecuteType(BizRuleExecuteTypeEnum.EQUITY_ONLY);
        param.setPaperTemplateNumber(template.getString(NUMBER));
        ArrayList<BizRuleExecParam> excuteParams = new ArrayList<BizRuleExecParam>();
        excuteParams.add(param);
        InvestServiceHelper.excRule(param, (DynamicObject[])records, excuteParams);
        return records;
    }

    private BizRuleExecParam getBizRuleExecParam(String process) {
        BizRuleExecParam p = new BizRuleExecParam(this.ctx.getModelNum());
        IDNumberTreeNode orgnode = MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)this.ctx.getOrgUnitNumber());
        IDNumberTreeNode curnode = MemberReader.findCurrencyMemberByNum((String)this.ctx.getModelNum(), (String)orgnode.getCurrency());
        p.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, Long.valueOf(OrgRelaProcessMembPool.isRelaProcess((String)process) ? orgnode.getId().longValue() : this.ctx.getOrgUnitId()), this.ctx.getOrgUnitNumber());
        p.getCommonParam().addCommonParamPair(PresetConstant.FY_DIM, Long.valueOf(this.ctx.getFyId()), this.ctx.getFyNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.PERIOD_DIM, Long.valueOf(this.ctx.getPeriodId()), this.ctx.getPeriodNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.SCENE_DIM, Long.valueOf(this.ctx.getScenarioId()), this.ctx.getScenariodNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.CURRENCY_DIM, curnode.getId(), curnode.getNumber());
        p.getCommonParam().addCommonParamPair(PresetConstant.PROCESS_DIM, MemberReader.findMemberByNumber((String)this.ctx.getModelNum(), (String)PresetConstant.PROCESS_DIM, (String)process).getId(), process);
        return p;
    }

    private Table<String, String, List<InvLimSheetHeadInfo>> getRelaysMap(Set<String> units) {
        HashBasedTable relaTable = HashBasedTable.create();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
        qfBuilder.add("scenario", "=", (Object)this.ctx.getScenarioId());
        qfBuilder.add("year", "=", (Object)this.ctx.getFyId());
        qfBuilder.add("period", "=", (Object)this.ctx.getPeriodId());
        qfBuilder.add("isdelete", "=", (Object)"0");
        qfBuilder.add("orgunit.number", "in", units);
        if (this.elimTemplateType == 2) {
            qfBuilder.add("shareholder.number", "=", (Object)this.ctx.getOrgUnitNumber());
            qfBuilder.add("invrelatype", "=", (Object)InvRelaTypeEnum.DirectRelaType.getType());
            qfBuilder.add("isusedinvrule", "=", (Object)"1");
            qfBuilder.add("isconfirmed", "=", (Object)"0");
        }
        DynamicObjectCollection relas = QueryServiceHelper.query((String)"bcm_invrelation", (String)"orgunit,orgunit.number,orgunit.name,invrelatype,shareholder,shareholder.number,shareholder.name,investeecompany,investeecompany.number,investeecompany.name", (QFilter[])qfBuilder.toArray(), (String)"orgunit,invrelatype,relaseq");
        HashMap relationTypeNumber2Name = new HashMap(16);
        InvRelationTypeHelper.consumeStaticRelationsType(this.ctx.getModelId(), (number, name, isUse) -> relationTypeNumber2Name.put(number, name.getLocaleValue()));
        Map code2InvRelaTypeEnum = InvRelationTypeConstant.getCode2InvRelaTypeEnum();
        for (DynamicObject rela : relas) {
            String invRelaType = rela.getString("invrelatype");
            String orgunit = rela.getString("orgunit.number");
            InvLimSheetHeadInfo headInfo = new InvLimSheetHeadInfo(invRelaType, InvRelationTypeConstant.CatalogEnum.relation.getCode());
            headInfo.setShareholder(rela.getLong("shareholder"), rela.getString("shareholder.number"), rela.getString("shareholder.name"));
            headInfo.setInvestedCompany(rela.getLong("investeecompany"), rela.getString("investeecompany.number"), rela.getString("investeecompany.name"));
            headInfo.setRelationTypeName((String)relationTypeNumber2Name.get(invRelaType));
            headInfo.setUnitOrg(rela.getLong("orgunit"), rela.getString("orgunit.number"), rela.getString("orgunit.name"));
            if (StringUtils.isEmpty((CharSequence)headInfo.getInvestedCompanyNumber()) || StringUtils.isEmpty((CharSequence)headInfo.getShareholderNumber())) continue;
            String relaTypeNum = InvRelationTypeHelper.findUnitNumber(invRelaType, code2InvRelaTypeEnum);
            List headInfos = (List)relaTable.get((Object)orgunit, (Object)relaTypeNum);
            if (headInfos == null) {
                headInfos = Lists.newArrayList();
                relaTable.put((Object)orgunit, (Object)relaTypeNum, (Object)headInfos);
            }
            headInfos.add(headInfo);
        }
        return relaTable;
    }

    private Table<String, String, List<InvLimSheetHeadInfo>> getChangeRelaysMap(Set<String> units) {
        ArrayList selectFields = Lists.newArrayList((Object[])new String[]{"merge.number", "merge.id", "merge.name", "invchangetype", "shareholder", "investeecompany", "invchangetype.name"});
        DynamicObjectCollection changeRelas = InvDynamicStockRatioHelper.loadGroupChangeTypeRelation(this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), (Collection<String>)Lists.newArrayList((Object[])new String[]{InvDynamicStockRatioConstant.StatusEnum.ENABLE.getCode()}), units.stream().map(unitNum -> MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)unitNum).getId()).collect(Collectors.toSet()), String.join((CharSequence)",", selectFields));
        HashBasedTable changeRelaTable = HashBasedTable.create();
        for (DynamicObject rela : changeRelas) {
            String mergeNum = rela.getString("merge.number");
            String invRelaType = rela.getString("invchangetype.number");
            InvLimSheetHeadInfo headInfo = new InvLimSheetHeadInfo(invRelaType, InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            headInfo.setShareholder(rela.getLong("shareholder.id"), rela.getString("shareholder.number"), rela.getString("shareholder.name"));
            headInfo.setInvestedCompany(rela.getLong("investeecompany.id"), rela.getString("investeecompany.number"), rela.getString("investeecompany.name"));
            headInfo.setRelationTypeName(rela.getString("invchangetype.name"));
            headInfo.setUnitOrg(rela.getLong("merge.id"), rela.getString("merge.number"), rela.getString("merge.name"));
            List headInfos = (List)changeRelaTable.get((Object)mergeNum, (Object)invRelaType);
            if (headInfos == null) {
                headInfos = Lists.newArrayList();
                changeRelaTable.put((Object)mergeNum, (Object)invRelaType, (Object)headInfos);
            }
            headInfos.add(headInfo);
        }
        return changeRelaTable;
    }

    public void saveExtData(DynamicObject tmp, SpreadManager spreadManager) {
        ArrayList<ExtendExtUniqueKey> existExtDatas = new ArrayList<ExtendExtUniqueKey>();
        ExtendExtUniqueKeyTable uniqueKeyTable = InvExtDataSpreadServiceHelper.collectExtDataUniqueKey(tmp.getLong("id"), this.ctx.getOrgUnitNumber(), spreadManager, valueCell -> Objects.nonNull(valueCell.getUserObject("formula_fail")));
        uniqueKeyTable.forEach(existExtDatas::add);
        InvSheetDeleteInfo deleteInfo = new InvSheetDeleteInfo();
        if (!CollectionUtil.isEmpty(existExtDatas)) {
            deleteInfo.setDeleteCells(existExtDatas);
            deleteInfo.setClearExtData(true);
        }
        InvExtDataSpreadServiceHelper.saveSpreadManagerExtData(this.ctx.getModelId(), this.ctx.getScenariodNum(), this.ctx.getFyNum(), this.ctx.getPeriodNum(), this.ctx.getOrgUnitNumber(), tmp, spreadManager, deleteInfo, this.logServer);
    }

    private List<DynamicObject> fliterTemplate(List<DynamicObject> tempList) {
        ArrayList<DynamicObject> usedTemplates = new ArrayList<DynamicObject>(16);
        HashMap sheets = new HashMap(16);
        HashSet<Long> tempest = new HashSet<Long>(tempList.size());
        for (DynamicObject template : tempList) {
            if (tempest.contains(template.getLong("id")) || !this.isInvestGenWay.booleanValue() && CollectionUtils.isNotEmpty(this.templateList) && !this.templateList.contains(template.getString(NUMBER))) continue;
            if (template.getString("status").equals(InvSheetTemplateConstant.BillStatusEnum.ENABLE.getCode())) {
                usedTemplates.add(template);
            }
            tempest.add(template.getLong("id"));
        }
        QFilter sheetFilter = new QFilter("template", "in", tempest);
        sheetFilter.and(new QFilter("entity", "=", (Object)TreeStructureServiceHelper.getEntityBaseMemberId(this.ctx.getOrgUnitId())));
        sheetFilter.and(new QFilter("model", "=", (Object)this.ctx.getModelId()));
        sheetFilter.and(new QFilter("scenario", "=", (Object)this.ctx.getScenarioId()));
        sheetFilter.and(new QFilter("year", "=", (Object)this.ctx.getFyId()));
        sheetFilter.and(new QFilter("period", "=", (Object)this.ctx.getPeriodId()));
        QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)"id,from,template", (QFilter[])new QFilter[]{sheetFilter}).forEach(sheet -> sheets.put(sheet.getLong("template"), sheet));
        Set<Long> effectiveTmpls = PaperTemplateHelper.queryEffectiveTmpls(this.ctx.getModelId(), this.ctx.getFyId(), this.ctx.getPeriodId(), usedTemplates.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        ArrayList<DynamicObject> needCreateTemps = new ArrayList<DynamicObject>(16);
        for (DynamicObject template : usedTemplates) {
            if (!effectiveTmpls.contains(template.getLong("id")) || sheets.containsKey(template.getLong("id")) && !((DynamicObject)sheets.get(template.getLong("id"))).getString("from").equals(SheetStatusEnum.AUTO.status()) && !this.idCheck(template.getLong("id"))) continue;
            needCreateTemps.add(template);
        }
        return needCreateTemps;
    }

    public boolean idCheck(long templateId) {
        return false;
    }

    public void collectDelExtendDataByModelAcc2Relation(Map<String, Map<String, Set<InvShareRelationInfo>>> modelAcc2Relations) {
        QFilter filter4Extend = new QFilter("modelnumber", "=", (Object)this.ctx.getModelShowNum());
        filter4Extend.and("scenario", "=", (Object)this.ctx.getScenariodNum());
        filter4Extend.and("year", "=", (Object)this.ctx.getFyNum());
        filter4Extend.and("period", "=", (Object)this.ctx.getPeriodNum());
        filter4Extend.and("org", "=", (Object)this.ctx.getOrgUnitNumber());
        filter4Extend.and("datamodel", "in", modelAcc2Relations.keySet());
        HashSet allAcc = new HashSet(16);
        modelAcc2Relations.forEach((k, v) -> allAcc.addAll(v.keySet()));
        filter4Extend.and("account", "in", allAcc);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_extenddata_inv", (String)"id,account,relationtype,entity,org,merge,internalcompany,datamodel,categorized,templatenumber", (QFilter[])filter4Extend.toArray(), null);){
            ds.forEachRemaining(p -> {
                InvShareRelationInfo relationInfo;
                long id = p.getLong("id");
                String account = p.getString("account");
                String relationType = p.getString("relationtype");
                String belong_org = p.getString("org");
                String merge = p.getString("merge");
                String shareholder = p.getString("internalcompany");
                String invested = p.getString("entity");
                String dataModel = p.getString("datamodel");
                String categorized = p.getString("categorized");
                Map acc2Relations = modelAcc2Relations.getOrDefault(dataModel, Collections.emptyMap());
                Set relations = acc2Relations.getOrDefault(account, Collections.emptySet());
                if (relations.contains(relationInfo = new InvShareRelationInfo(belong_org, merge, shareholder, invested, relationType, categorized))) {
                    this.delExtendDataPKs.add(id);
                    this.logServer.logSheetDataRemove(p.getString("templatenumber"), dataModel, new ExtendExtUniqueKey(account, relationInfo));
                }
            });
        }
    }

    public void collectDelEntryByTempPks(List<Long> tempPks) {
        List<String> orgUnitNumbers = this.getOrgUnitNumbers();
        QFBuilder tempQF = new QFBuilder("extend", "in", tempPks);
        tempQF.add("scenario", "=", (Object)this.ctx.getScenarioId());
        tempQF.add("year", "=", (Object)this.ctx.getFyId());
        tempQF.add("period", "=", (Object)this.ctx.getPeriodId());
        tempQF.add("entity.number", "in", orgUnitNumbers);
        tempQF.add("sourcetype", "=", (Object)(ElimRptAdjSourceTypeEnum.SHEETINV.getValue() + ""));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_rptadjust", (String)"id,extend,sourcetype", (QFilter[])tempQF.toArray(), null);){
            ds.forEachRemaining(p -> this.delEntryPks.add(p.getLong("id")));
        }
    }

    private List<String> getOrgUnitNumbers() {
        String orgUnitNumber = this.ctx.getOrgUnitNumber();
        if (IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(orgUnitNumber)) {
            return QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)"entity.number", (QFilter[])new QFBuilder("id", "in", this.paper2DeleteIds).toArray()).stream().map(dy -> dy.getString("entity.number")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new String[]{orgUnitNumber});
    }

    public void deletePaperNormal(Collection<Long> paperIds) {
        this.paper2DeleteIds = paperIds;
        ArrayList<Long> tempPks = new ArrayList<Long>(16);
        HashMap<String, Map<String, Set<InvShareRelationInfo>>> modelAcc2Relations = new HashMap<String, Map<String, Set<InvShareRelationInfo>>>(16);
        this.collectDelSheet(tempPks, this.paper2DeleteIds);
        this.collectDelEntryByTempPks(tempPks);
        this.deletePaperAndEntryFilter();
        this.collectTempModelAccRelation(modelAcc2Relations);
        this.collectDelExtendDataByModelAcc2Relation(modelAcc2Relations);
        this.deletePaperAndEntry();
    }

    public void collectDelSheet(List<Long> tempPks, Collection<Long> delLimSheetPks) {
        QFBuilder qfBuilder = new QFBuilder();
        if (delLimSheetPks == null || delLimSheetPks.isEmpty()) {
            qfBuilder.add("model", "=", (Object)this.ctx.getModelId());
            qfBuilder.and("scenario", "=", (Object)this.ctx.getScenarioId());
            qfBuilder.and("year", "=", (Object)this.ctx.getFyId());
            qfBuilder.and("period", "=", (Object)this.ctx.getPeriodId());
            qfBuilder.and("entity.number", "=", (Object)this.ctx.getOrgUnitNumber());
            qfBuilder.and("from", "=", (Object)SheetStatusEnum.AUTO.status());
            qfBuilder.and("template.process.number", "in", this.getProcesses());
        } else {
            qfBuilder.add("id", "in", delLimSheetPks);
        }
        this.invLimSheets = QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)"id,from,template,template.number,template.extdimid.number,template.invrelationtype,data", (QFilter[])qfBuilder.toArray());
        this.invLimSheets.forEach(invLimSheet -> {
            if (!this.isInvestGenWay.booleanValue() && CollectionUtils.isNotEmpty(this.templateList) && !this.templateList.contains(invLimSheet.getString("template.number"))) {
                return;
            }
            long sheetId = invLimSheet.getLong("id");
            this.delSheetPks.add(sheetId);
            long templateId = invLimSheet.getLong("template");
            tempPks.add(templateId);
        });
    }

    public void deletePaperAndEntryFilter() {
        if (!this.delEntryPks.isEmpty()) {
            Map<Long, HashBasedTable<Long, Long, List<String>>> backLockScope = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds(ResManager.loadKDString((String)"\u5e95\u7a3f\u751f\u6210\u63a5\u53e3(\u5220\u9664\u5e95\u7a3f\u5173\u8054\u5206\u5f55)", (String)"InvElimPaperGenerateService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx, new ArrayList<Long>(this.delEntryPks), null);
            HashSet lockDims = new HashSet();
            HashSet lockAdjusts = new HashSet();
            QFBuilder qfBuilder = new QFBuilder("id", "in", backLockScope.keySet());
            try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(new HashSet<String>(Arrays.asList("status", "extendfrom", "id")), qfBuilder, null, -1);){
                ds.forEachRemaining(row -> {
                    if (RptAdjustStatusEnum.AUDIT.status().equals(row.getString("status"))) {
                        Long adjustId = row.getLong("id");
                        lockAdjusts.add(adjustId);
                        String extendfrom = row.getString("extendfrom");
                        HashBasedTable detailTable = (HashBasedTable)backLockScope.get(adjustId);
                        if (detailTable.containsRow((Object)adjustId)) {
                            lockDims.add(String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s[%2$s]", (String)"InvElimPaperGenerateService_3", (String)"fi-bcm-business", (Object[])new Object[0]), extendfrom, detailTable.row((Object)adjustId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                        } else {
                            lockDims.add(String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u8054\u52a8/\u5171\u4eab)%1$s[%2$s]", (String)"InvElimPaperGenerateService_4", (String)"fi-bcm-business", (Object[])new Object[0]), extendfrom, detailTable.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                        }
                    }
                });
            }
            if (!lockDims.isEmpty()) {
                this.errMsg.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5e95\u7a3f\u5206\u5f55\u8bbe\u7f6e%s\u5bf9\u5e94\u7684\u5386\u53f2\u5206\u5f55\u5df2\u7ecf\u5206\u9636\u6bb5\u6570\u636e\u9501\u5b9a\uff0c\u65e0\u6cd5\u6253\u56de", (String)"InvElimPaperGenerateService_5", (String)"fi-bcm-business", (Object[])new Object[0]), lockDims));
            }
            this.delEntryPks.removeAll(lockAdjusts);
        }
    }

    public void collectTempModelAccRelation(Map<String, Map<String, Set<InvShareRelationInfo>>> modelAcc2Relations) {
        this.invLimSheets.forEach(invLimSheet -> {
            if (!this.isInvestGenWay.booleanValue() && CollectionUtils.isNotEmpty(this.templateList) && !this.templateList.contains(invLimSheet.getString("template.number"))) {
                return;
            }
            long templateId = invLimSheet.getLong("template");
            String data = invLimSheet.getString("data");
            if (data != null) {
                String dataModel = invLimSheet.getString("template.extdimid.number");
                Map acc2Relations = modelAcc2Relations.computeIfAbsent(dataModel, k -> new HashMap(16));
                SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)data);
                Sheet sheet = spreadManager.getBook().getSheet(0);
                InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(sheet, InvElimPaperGenerateService.getSpreadType(sheet, templateId));
                HashSet extAccNumbers = new HashSet(sheet.getMaxRowCount());
                iteratorService.iterationAccCell(accCell -> {
                    String number = (String)accCell.getUserObject(NUMBER);
                    if (number != null) {
                        extAccNumbers.add(number);
                    }
                });
                if (sheet.getUserObject("inv_relation_count") == null) {
                    return;
                }
                int floatCount = (Integer)sheet.getUserObject("inv_relation_count");
                HashSet relations = new HashSet(floatCount);
                iteratorService.iterationRelationCell((rltCell, orgCell, shareholderCell, investedCell) -> {
                    String relationType = (String)rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName());
                    relationType = relationType == null ? PaperTemplateService.getDefaultRelationTypeNumber(templateId) : relationType;
                    String categorized = InvElimSpreadGenerateService.getCategorized(rltCell);
                    String unitOrg = (String)orgCell.getUserObject(NUMBER);
                    String shareholder = (String)shareholderCell.getUserObject(NUMBER);
                    String investedOrg = (String)investedCell.getUserObject(NUMBER);
                    InvShareRelationInfo invLimSheetRelation = new InvShareRelationInfo(this.ctx.getOrgUnitNumber(), unitOrg, shareholder, investedOrg, relationType, categorized);
                    relations.add(invLimSheetRelation);
                });
                extAccNumbers.forEach(acc -> {
                    Set invLimSheetRelations = acc2Relations.computeIfAbsent(acc, k -> new HashSet(relations.size()));
                    invLimSheetRelations.addAll(relations);
                });
            }
        });
    }

    public void deletePaperAndEntry() {
        PlatUtil.executeWithTXNew(tx -> {
            if (this.delSheetPks != null && !this.delSheetPks.isEmpty()) {
                BusinessDataWriter.delete((String)"bcm_invlimsheetentity", (QFilter[])new QFilter[]{new QFilter("id", "in", this.delSheetPks)});
            }
            if (this.delExtendDataPKs != null && !this.delExtendDataPKs.isEmpty()) {
                BusinessDataWriter.delete((String)"bcm_extenddata_inv", (QFilter[])new QFilter[]{new QFilter("id", "in", this.delExtendDataPKs)});
            }
            if (this.delEntryPks != null && !this.delEntryPks.isEmpty()) {
                AdjustClearServiceHelper.batchDeleteAutoAdjust("InvElimPaperGenerateService.deletePaperAndEntry", this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), new ArrayList<Long>(this.delEntryPks));
            }
        });
    }

    public void saveLog() {
        this.logServer.successLogAsync();
    }

    public DynamicObjectCollection getTemplateAssignRule(List<Long> templateGroupIds, String property) {
        QFilter filter = new QFilter("papertemplate.group", "in", templateGroupIds);
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            if (InvSheetTemplateConstant.EexcRuleTypeEnum.MANUAL.getCode().equals(property)) {
                filter.and("execwhenopen", "=", (Object)false);
                filter.and("execwhensave", "=", (Object)false);
            } else {
                filter.and(property, "=", (Object)true);
            }
        }
        DynamicObjectCollection allocateRecords = QueryServiceHelper.query((String)"bcm_brallocateentity", (String)"bizrule.id,execwhenopen,execwhensave,papertemplate,papertemplate.group", (QFilter[])new QFilter[]{filter});
        return allocateRecords;
    }

    private Map<String, List<DynamicObject>> getTemplateGroup(List<DynamicObject> templates) {
        Map<String, List<DynamicObject>> templateGroup = templates.stream().filter(tpl -> Objects.nonNull(tpl.getString("process.number"))).collect(Collectors.groupingBy(tpl -> tpl.getString("process.number")));
        return templateGroup;
    }

    private Map<Long, List<DynamicObject>> buildTemp2Relation(List<DynamicObject> needCreateTemps) {
        Set tempIds = needCreateTemps.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)String.join((CharSequence)",", "id", "invrelationtype"), (QFilter[])new QFBuilder("id", "in", tempIds).toArray());
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject tmp : query) {
            tmp.getDynamicObjectCollection("invrelationtype").forEach(rela -> result.computeIfAbsent(tmp.getLong("id"), a -> Lists.newArrayList()).add(rela));
        }
        return result;
    }

    public Set<String> getErrMsg() {
        return this.errMsg;
    }

    private static /* synthetic */ Long lambda$generatePaper$10(DynamicObject rule) {
        return rule.getLong("papertemplate.group");
    }

    private static /* synthetic */ Long lambda$generatePaper$9(DynamicObject rule) {
        return rule.getLong("papertemplate.group");
    }

    private static /* synthetic */ Long lambda$generatePaper$8(DynamicObject temp) {
        return temp.getLong("group");
    }

    private /* synthetic */ void lambda$generatePaper$7(DynamicObject tmp, DynamicObject csl) {
        this.temp2CslMap.computeIfAbsent(tmp.getLong("id"), a -> Lists.newArrayList()).add(csl);
    }

    private /* synthetic */ void lambda$generatePaper$5(DynamicObject tmp, DynamicObject rela) {
        this.temp2RelationType.computeIfAbsent(tmp.getLong("id"), a -> Lists.newArrayList()).add(rela);
    }

    private static /* synthetic */ Long lambda$generatePaper$3(DynamicObject dynamicObject) {
        return dynamicObject.getLong("id");
    }

    private static /* synthetic */ Set lambda$generatePaper$2(String a) {
        return Sets.newHashSet();
    }

    private /* synthetic */ boolean lambda$generatePaper$1(Set units, List tempList, IDNumberTreeNode orgNode) {
        IDNumberTreeNode smallParentNode = orgNode.getParent();
        if (smallParentNode != null && !"Entity".equals(smallParentNode.getNumber()) && units.add(smallParentNode.getNumber())) {
            DynamicObjectCollection templates = InvTemplateDistributionService.queryTemplateByEntityId(this.ctx.getModelId(), smallParentNode.getId(), this.ctx.getFyId(), this.ctx.getPeriodId(), this.ctx.getScenarioId());
            for (DynamicObject template : templates) {
                this.temp2MergeMap.computeIfAbsent(template.getString(NUMBER), a -> Sets.newHashSet()).add(smallParentNode.getNumber());
                tempList.add(template);
            }
        }
        return false;
    }

    static class CurrentInvEDSaveComInfo {
        private InvEDSaveComInfo invEDSaveComInfo;
        private List<EDColumn> edColumnList;

        CurrentInvEDSaveComInfo() {
        }

        public void setInvEDSaveComInfo(InvEDSaveComInfo invEDSaveComInfo) {
            this.invEDSaveComInfo = invEDSaveComInfo;
        }

        public void setEdColumnList(List<EDColumn> edColumnList) {
            this.edColumnList = edColumnList;
        }

        public InvEDSaveComInfo getInvEDSaveComInfo() {
            return this.invEDSaveComInfo;
        }

        public List<EDColumn> getEdColumnList() {
            return this.edColumnList;
        }
    }
}

