/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.invest.elimination.InvElimRecorderGenHelper;
import kd.fi.bcm.business.invest.elimination.model.GenerateContext;
import kd.fi.bcm.business.invest.elimination.model.InvElimTemplateEntry;
import kd.fi.bcm.business.invest.elimination.model.InvElimTemplateModel;
import kd.fi.bcm.business.invest.elimination.model.RelaModel;
import kd.fi.bcm.business.invest.extdim.InvExtDataServiceHelper;
import kd.fi.bcm.business.invest.extdim.InvExtDataSpreadServiceHelper;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKeyTable;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultCellTable;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.sheet.InvShareRelationInfo;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.constant.invest.invlimsheet.InvExtDataConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetEntryConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.domain.Cell;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InvElimSpreadGenerateService {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvElimSpreadGenerateService.class);
    protected AdjRecordLog adjLog = new AdjRecordLog();
    protected GenerateContext ctx;
    protected List<InvElimTemplateModel> templates;
    private int progress;
    private ObjIntConsumer<String> observer;
    private final Set<String> errMsg = new HashSet<String>();
    protected List<String> specifiedProcess = null;
    protected Set<RelaModel> relaModels = new HashSet<RelaModel>(16);
    private final HashMap<InvShareRelationInfo, RelaModel> relaTypeAndModelMap = new HashMap(16);
    protected LinkedHashMultimap<Long, InvCalcLine> calcPool;
    protected CalculateService calcService;
    protected List<DynamicObject> elims = new ArrayList<DynamicObject>();
    protected List<DynamicObject> elimEntries = new ArrayList<DynamicObject>();
    private int generatCount = 0;
    private Set<Long> sucessesIds = new HashSet<Long>();
    private final Set<Long> noBlElimIds = new HashSet<Long>(16);
    protected List<DynamicObject> elimEntriesLinkMapping = new ArrayList<DynamicObject>();
    Map<Long, String> tempPk2NumMap = new HashMap<Long, String>(16);

    public InvElimSpreadGenerateService(long modelId, long scenarioId, long fyId, long periodId, long unitId) {
        this.ctx = new GenerateContext(modelId, scenarioId, fyId, periodId, unitId);
        this.templates = new ArrayList<InvElimTemplateModel>();
    }

    public InvElimSpreadGenerateService(long modelId, long scenarioId, long fyId, long periodId, long unitId, List<DynamicObject> sheets) {
        this.ctx = new GenerateContext(modelId, scenarioId, fyId, periodId, unitId, sheets);
        this.templates = new ArrayList<InvElimTemplateModel>();
    }

    public void setSpecifiedProcess(List<String> process) {
        this.specifiedProcess = process;
    }

    public Tuple<Integer, Set<Long>, String> generate() {
        this.setProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2\u5e95\u7a3f\u5bf9\u5e94\u6a21\u677f\u5206\u5f55\u914d\u7f6e\u3002", (String)"InvElimSpreadGenerateService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.buildInvElimTemplateModel();
        this.setProgress(20, ResManager.loadKDString((String)"\u6b63\u5728\u6839\u636e\u5206\u5f55\u660e\u7ec6\u914d\u7f6e\u4ece\u5e95\u7a3f\u4e2d\u53d6\u503c\u3002", (String)"InvElimSpreadGenerateService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.initCalService();
        Map<Long, Set<InvShareRelationInfo>> temp2RelaInfos = this.buildRelatModel();
        this.calculateExpression(temp2RelaInfos);
        this.setProgress(60, ResManager.loadKDString((String)"\u6b63\u5728\u6784\u9020\u5206\u5f55\u660e\u7ec6\u548c\u5206\u5f55\u5934\u3002", (String)"InvElimSpreadGenerateService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.buildElimRecord();
        this.setProgress(80, ResManager.loadKDString((String)"\u6b63\u5728\u5220\u9664\u5386\u53f2\u5206\u5f55\u3002", (String)"InvElimSpreadGenerateService_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        PlatUtil.executeWithTXNew(tx -> {
            Map<String, String> noNeedCreateSet = this.deleteOldData();
            this.setProgress(90, ResManager.loadKDString((String)"\u6b63\u5728\u4fdd\u5b58\u65b0\u5206\u5f55\u3002", (String)"InvElimSpreadGenerateService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            this.saveData(noNeedCreateSet);
        });
        return Tuple.create((Object)this.generatCount, this.sucessesIds, this.errMsg.isEmpty() ? null : Joiner.on((String)"\n").join(this.errMsg));
    }

    private void initCalService() {
        CalContext calContext = new CalContext(this.ctx.getModelNum(), null, this.ctx.getFyNum(), this.ctx.getPeriodNum(), this.ctx.getScenariodNum(), this.ctx.getUnitCurrency());
        calContext.setProperty("orgUnitId", this.ctx.getOrgUnitId());
        calContext.setProperty("orgUnitNumber", this.ctx.getOrgUnitNumber());
        this.calcService = new CalculateService(calContext);
    }

    private void buildInvElimTemplateModel() {
        HashMap tmp2spread = new HashMap(16);
        QFBuilder tempQF = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
        tempQF.add("scenario", "=", (Object)this.ctx.getScenarioId());
        tempQF.add("year", "=", (Object)this.ctx.getFyId());
        tempQF.add("period", "=", (Object)this.ctx.getPeriodId());
        tempQF.add("entity.number", "=", (Object)this.ctx.getOrgUnitNumber());
        List<String> processes = this.getProcesses();
        tempQF.add("template.process.number", "in", processes);
        if (null != this.ctx.getSheets() && !this.ctx.getSheets().isEmpty()) {
            this.ctx.getSheets().forEach(p -> tmp2spread.put(p.getLong("template.id"), p.getString("data")));
        } else {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"buildInvElimTemplateModel", (String)"bcm_invlimsheetentity", (String)"data,template", (QFilter[])tempQF.toArray(), null);){
                ds.forEachRemaining(p -> tmp2spread.put(p.getLong("template"), p.getString("data")));
            }
        }
        Map tempDyMap = BusinessDataServiceHelper.loadFromCache((Object[])tmp2spread.keySet().toArray(), (String)"bcm_papertemplate");
        Map<String, List<DynamicObject>> tempGroupByProcess = tempDyMap.values().stream().collect(Collectors.groupingBy(k -> k.getString("process.number")));
        HashBasedTable accountPos = HashBasedTable.create();
        QFBuilder tempLayoutQF = new QFBuilder("template", "in", tempDyMap.keySet());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_invsheetacclayout", (String)"template,position,extdimid", (QFilter[])tempLayoutQF.toArray(), null);){
            ds.forEachRemaining(arg_0 -> this.lambda$buildInvElimTemplateModel$4(tempDyMap, (Table)accountPos, arg_0));
        }
        for (String process : processes) {
            List<DynamicObject> tempByProcess = tempGroupByProcess.get(process);
            if (CollectionUtils.isEmpty(tempByProcess)) continue;
            Set tempIds = tempByProcess.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
            QFBuilder tempEntrysQF = new QFBuilder("sheettemplate", "in", tempIds);
            DynamicObjectCollection entrys = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)"id,number,name", (QFilter[])tempEntrysQF.toArray());
            Object[] idList = entrys.stream().map(id -> id.getLong("id")).toArray();
            DynamicObject[] sheetSet = BusinessDataServiceHelper.load((Object[])idList, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsheetttplentrys").getDynamicObjectType());
            Arrays.stream(sheetSet).forEach(arg_0 -> this.lambda$buildInvElimTemplateModel$7(tempDyMap, tmp2spread, (Table)accountPos, arg_0));
        }
        this.adjLog.update();
    }

    public void setObserver(ObjIntConsumer<String> observer) {
        this.observer = observer;
    }

    public Set<String> getErrMsg() {
        return this.errMsg;
    }

    public GenerateContext getCtx() {
        return this.ctx;
    }

    private boolean isFlowRow(String spreadtype) {
        return "2".equalsIgnoreCase(spreadtype);
    }

    private void calculateExpression(Map<Long, Set<InvShareRelationInfo>> temp2RelaInfos) {
        Map<String, Integer> accountScale = CurrencyScaleHandler.getAccountScale(this.ctx.getModelId());
        this.calcPool = LinkedHashMultimap.create();
        int precision = this.getCurrencyPrecision();
        HashSet<String> relaStrs = new HashSet<String>(16);
        Map<String, List<InvElimTemplateModel>> dataModelGroup = this.templates.stream().collect(Collectors.groupingBy(model -> (String)model.getProperty("dataModel")));
        Map<String, DynamicObject> extendsModelByNum = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number,extendsgroup.number,extendsgroup.id", (QFilter[])new QFBuilder("model", "=", (Object)this.ctx.getModelId()).and("number", "in", dataModelGroup.keySet()).toArray()).stream().collect(Collectors.toMap(p -> p.getString("number"), p -> p, (v1, v2) -> v1));
        for (String dataModel : dataModelGroup.keySet()) {
            DynamicObject dataModelDy = extendsModelByNum.get(dataModel);
            if (dataModelDy == null) continue;
            Map<Long, DynamicObject> extMems = InvExtDataServiceHelper.getSheetExtMemberByExtModel(this.ctx.getModelId(), dataModelDy.getLong("id"));
            List templateList = dataModelGroup.getOrDefault(dataModel, new ArrayList());
            EdQueryComInfo edQueryComInfo = new EdQueryComInfo(this.ctx.getModelShowNum(), dataModelDy.getString("extendsgroup.number"), dataModelDy.getString("number"));
            edQueryComInfo.setExtselects(InvExtDataConstant.getSelectField());
            edQueryComInfo.addDimFilter("Scenario", this.ctx.getScenariodNum());
            edQueryComInfo.addDimFilter("Year", this.ctx.getFyNum());
            edQueryComInfo.addDimFilter("Period", this.ctx.getPeriodNum());
            edQueryComInfo.addFilter("org", this.ctx.getOrgUnitNumber());
            InvEDResultCellTable calValueTable = InvExtDataServiceHelper.getCalValueTable(edQueryComInfo);
            for (InvElimTemplateModel template : templateList) {
                relaStrs.clear();
                Set<InvShareRelationInfo> relationInfos = temp2RelaInfos.get(template.getTemplateId());
                for (InvShareRelationInfo relationInfo : relationInfos) {
                    if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)String.valueOf(template.getRelaType().p1), (CharSequence)String.valueOf(relationInfo.getCategorized())) || !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)String.valueOf(template.getRelaType().p2), (CharSequence)String.valueOf(relationInfo.getRelationType())) || !relaStrs.add(relationInfo.getCategorized() + "#" + relationInfo.getRelationType() + "#" + relationInfo.getShareholderNumber() + "#" + relationInfo.getInvestedCompanyNumber())) continue;
                    RelaModel relaModel = this.relaTypeAndModelMap.computeIfAbsent(relationInfo, a -> {
                        RelaModel model = new RelaModel();
                        IDNumberTreeNode holderNode = BcmThreadCache.findMemberByNum((String)this.ctx.getModelNum(), (String)"InternalCompany", (String)relationInfo.getShareholderNumber());
                        model.holdCompanyId = holderNode.getId();
                        model.holdCompanyNum = relationInfo.getShareholderNumber();
                        model.holdCompanyName = holderNode.getName();
                        IDNumberTreeNode investNode = BcmThreadCache.findMemberByNum((String)this.ctx.getModelNum(), (String)"Entity", (String)relationInfo.getInvestedCompanyNumber());
                        model.invCompanyId = investNode.getId();
                        model.invCompanyNum = relationInfo.getInvestedCompanyNumber();
                        model.invCompanyName = investNode.getName();
                        model.mergeNum = relationInfo.getUnitOrgNumber();
                        model.mergeId = BcmThreadCache.findMemberByNum((String)this.ctx.getModelNum(), (String)"Entity", (String)relationInfo.getUnitOrgNumber()).getId();
                        model.setRelationType(relationInfo.getRelationType());
                        model.setCategorized(relationInfo.getCategorized());
                        return model;
                    });
                    this.relaModels.add(relaModel);
                    if (!this.checkBindTemplate(template, relaModel)) continue;
                    for (InvElimTemplateEntry entry : template.getEntries()) {
                        Object value;
                        Long elimEntryId;
                        InvCalcLine line = new InvCalcLine();
                        line.entryId = entry.getEntryId();
                        line.relaModel = relaModel;
                        line.relaType = template.getRelaType();
                        line.entry = entry;
                        line.seq = entry.getSeq();
                        line.process = template.getProcess();
                        String relationType = relaModel.getRelationType();
                        String categorized = relaModel.getCategorized();
                        if (entry.isBalanceLine()) {
                            this.calcPool.put((Object)template.getTemplateId(), (Object)line);
                            continue;
                        }
                        DynamicObject extMemDy = extMems.get(LongUtil.toLong((Object)entry.getRuleExpression()));
                        if (extMemDy == null) continue;
                        Pair<Long, Object> valuePair = calValueTable.getValuePair(new ExtendExtUniqueKey(extMemDy.getString("number"), this.ctx.getOrgUnitNumber(), relaModel.getMergeNum(), relaModel.holdCompanyNum, relaModel.invCompanyNum, relationType, categorized));
                        if (valuePair == null) {
                            elimEntryId = null;
                            value = BigDecimal.ZERO;
                        } else {
                            value = valuePair.p2;
                            elimEntryId = (Long)valuePair.p1;
                            if (value instanceof Exception) {
                                value = BigDecimal.ZERO;
                            }
                        }
                        line.value = InvestUtils.convertToBigDecimal((Object)value);
                        String accountNumber = line.getEntry().getAcct();
                        if (accountScale.get(accountNumber) != null) {
                            precision = accountScale.get(accountNumber);
                        }
                        line.value = line.value != null ? line.value.setScale(precision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                        line.elimEntryId = elimEntryId;
                        this.calcPool.put((Object)template.getTemplateId(), (Object)line);
                    }
                }
                template.clearProperty("data");
                template.clearProperty("isFlowRow");
                template.clearProperty("accountPos");
                this.incrementProgress(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u3010%1$s %2$s\u3011\u660e\u7ec6\u884c\u5b8c\u6210\u53d6\u6570\u3002", (String)"InvElimSpreadGenerateService_6", (String)"fi-bcm-business", (Object[])new Object[0]), template.getNumber(), template.getName()));
            }
        }
    }

    private Map<Long, Set<InvShareRelationInfo>> buildRelatModel() {
        HashMap<Long, Set<InvShareRelationInfo>> temp2RelaInfo = new HashMap<Long, Set<InvShareRelationInfo>>(16);
        HashSet<String> mergeSet = new HashSet<String>();
        HashSet<String> holderSet = new HashSet<String>();
        HashSet<String> investSet = new HashSet<String>();
        for (InvElimTemplateModel template : this.templates) {
            ExtendExtUniqueKeyTable uniqueKeyTable = InvExtDataSpreadServiceHelper.collectExtDataUniqueKey(template.getTemplateId(), this.ctx.getOrgUnitNumber(), template.getSpreadManger(), null);
            temp2RelaInfo.put(template.getTemplateId(), uniqueKeyTable.getRelaInfoSet());
            for (InvShareRelationInfo relationInfo : uniqueKeyTable.getRelaInfoSet()) {
                mergeSet.add(relationInfo.getUnitOrgNumber());
                holderSet.add(relationInfo.getShareholderNumber());
                investSet.add(relationInfo.getInvestedCompanyNumber());
            }
        }
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.ctx.getModelId());
        qf.add("scenario", "=", (Object)this.ctx.getScenarioId());
        qf.add("year", "=", (Object)this.ctx.getFyId());
        qf.add("period", "=", (Object)this.ctx.getPeriodId());
        qf.add("isdelete", "=", (Object)"0");
        qf.add("orgunit.number", "in", mergeSet);
        qf.add("shareholder.number", "in", holderSet);
        qf.add("investeecompany.number", "in", investSet);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_invrelation", (QFilter[])qf.toArray()).values().forEach(rela -> this.buildRelaModel(InvRelationTypeConstant.CatalogEnum.relation, (DynamicObject)rela));
        Long selectedBaseOrgId = TreeStructureServiceHelper.getEntityBaseMemberId(this.ctx.getOrgUnitId());
        InvDynamicStockRatioHelper.loadGroupChangeTypeRelation(this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), (Collection<String>)Lists.newArrayList((Object[])new String[]{"0"}), selectedBaseOrgId, InvDynamicStockRatioConstant.getSelectFields()).forEach(rela -> this.buildRelaModel(InvRelationTypeConstant.CatalogEnum.change_type, (DynamicObject)rela));
        return temp2RelaInfo;
    }

    private void buildRelaModel(InvRelationTypeConstant.CatalogEnum relation, DynamicObject rela) {
        RelaModel model = new RelaModel();
        model.holdCompanyId = rela.getLong("shareholder_id");
        model.holdCompanyNum = rela.getString("shareholder.number");
        model.holdCompanyName = rela.getString("shareholder.name");
        model.invCompanyId = rela.getLong("investeecompany_id");
        model.invCompanyNum = rela.getString("investeecompany.number");
        model.invCompanyName = rela.getString("investeecompany.name");
        if (InvRelationTypeConstant.CatalogEnum.relation == relation) {
            model.mergeNum = rela.getString("orgunit.number");
            model.mergeId = rela.getLong("orgunit.id");
            model.setRelationType(rela.getString("invrelatype"));
            model.put("isUsedInvRule", rela.getBoolean("isusedinvrule"));
            model.put("isConfirmedInv", rela.getBoolean("isconfirmed"));
            model.put("minConfirmScale", rela.getBigDecimal("minconfirmscale"));
        } else {
            model.mergeNum = rela.getString("merge.number");
            model.mergeId = rela.getLong("merge.id");
            model.setRelationType(rela.getString("invchangetype.number"));
        }
        model.setCategorized(relation.getCode());
        rela.getDynamicObjectCollection("effecttemp").forEach(e -> {
            if (!PaperTemplateScenarioSettingConstant.ExceptEnum.NOT_APPLICABLE.getCode().equals(e.getString("isexcept")) && "bcm_invsheetttplentrys".equals(e.getString("temtype"))) {
                model.dispenseTmpls.add((DynamicObject)e);
            }
        });
        this.relaTypeAndModelMap.put(new InvShareRelationInfo(this.ctx.getOrgUnitNumber(), model.getMergeNum(), model.getHoldCompanyNum(), model.getInvCompanyNum(), model.getRelationType(), model.getCategorized()), model);
    }

    private boolean checkBindTemplate(InvElimTemplateModel template, RelaModel relaModel) {
        boolean isOnlyLinked;
        Set dispenseTmplIds = relaModel.getDispenseTmpls().stream().map(p -> p.getLong("temp.id")).collect(Collectors.toSet());
        dispenseTmplIds.remove(0L);
        if (!dispenseTmplIds.isEmpty() && !dispenseTmplIds.contains(template.getTemplateId())) {
            return false;
        }
        return !dispenseTmplIds.isEmpty() || !(isOnlyLinked = template.isOnlyLinked());
    }

    private void buildElimRecord() {
        HashSet<String> companyNums = new HashSet<String>();
        this.relaModels.forEach(r -> {
            companyNums.add(r.holdCompanyNum);
            companyNums.add(r.invCompanyNum);
        });
        this.ctx.initMyOrICCompany(companyNums);
        int groupNum = 0;
        InvCalcLine balanceLine = null;
        BigDecimal debitSum = BigDecimal.ZERO;
        BigDecimal creditSum = BigDecimal.ZERO;
        boolean isDebugModel = DebugServiceHelper.isDebugInvElim();
        HashMap<Long, List> groupElimEntries = new HashMap<Long, List>(100);
        Set<Long> tempIds = this.templates.stream().map(InvElimTemplateModel::getTemplateId).collect(Collectors.toSet());
        Set<Long> noNeedCreateTemplate = this.collectNoNeedCreateTemplate(tempIds);
        for (InvElimTemplateModel template : this.templates) {
            Set entries = this.calcPool.get((Object)template.getTemplateId());
            if (!template.getProperty("tempstatus").equals(InvSheetTemplateConstant.BillStatusEnum.ENABLE.getCode())) {
                this.errMsg.add(String.format(ResManager.loadKDString((String)"%s\u6a21\u677f\u5df2\u7981\u7528,\u65e0\u6cd5\u751f\u6210\u5206\u5f55\u3002", (String)"InvElimSpreadGenerateService_18", (String)"fi-bcm-business", (Object[])new Object[0]), template.getNumber()));
                continue;
            }
            if (entries.isEmpty()) {
                this.errMsg.add(String.format(ResManager.loadKDString((String)"%s\u6a21\u677f\u5206\u5f55\u8bbe\u7f6e\u65e0\u53ef\u7528\u660e\u7ec6\u884c,\u65e0\u6cd5\u751f\u6210\u5206\u5f55\uff0c\u53ef\u80fd\u539f\u56e0\u4e3a\uff1a1.\u6ca1\u914d\u7f6e 2.\u5f00\u542f\u4e86\u4ec5\u5173\u8054\u4f46\u662f\u80a1\u6bd4\u672a\u5173\u8054 3.\u65e0\u6709\u6548\u80a1\u6bd4\u5bf9\u3002", (String)"InvElimSpreadGenerateService_19", (String)"fi-bcm-business", (Object[])new Object[0]), template.getNumber()));
                continue;
            }
            if (noNeedCreateTemplate.contains(template.getTemplateId())) {
                this.errMsg.add(String.format(ResManager.loadKDString((String)"%s\u6a21\u677f\u5206\u5f55\u8bbe\u7f6e\u5df2\u7ecf\u5b58\u5728\u624b\u5de5\u4fee\u6539\u7684\u5206\u5f55\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u5f55\u3002", (String)"InvElimSpreadGenerateService_20", (String)"fi-bcm-business", (Object[])new Object[0]), template.getNumber()));
                continue;
            }
            Map groupByCal = entries.stream().collect(Collectors.groupingBy(line -> InvElimSpreadGenerateService.packRelaKey(this.ctx.getOrgUnitNumber(), line.relaModel.mergeNum, line.relaModel.holdCompanyNum, line.relaModel.getRelationType(), line.relaModel.getCategorized(), line.relaModel.invCompanyNum), LinkedHashMap::new, Collectors.toList()));
            DynamicObject elim2 = this.genInvElimHeadDyna(template);
            this.elims.add(elim2);
            for (Map.Entry group : groupByCal.entrySet()) {
                List groupCals = (List)group.getValue();
                ++groupNum;
                for (InvCalcLine line2 : groupCals) {
                    Long elimEntryId;
                    DynamicObject entry;
                    if (line2.entry.isBalanceLine()) {
                        balanceLine = line2;
                        continue;
                    }
                    if (line2.value == null || line2.value.compareTo(BCMConstant.Zero) == 0 && !isDebugModel || (entry = this.genInvElimEntryDyna(elim2, line2, template, groupNum)) == null) continue;
                    groupElimEntries.computeIfAbsent(elim2.getLong("id"), e -> new ArrayList(16)).add(entry);
                    if (line2.entry.getDc() == 0) {
                        debitSum = debitSum.add(line2.value);
                    } else {
                        creditSum = creditSum.add(line2.value);
                    }
                    if (!ObjectUtils.isNotEmpty((Object)(elimEntryId = line2.elimEntryId))) continue;
                    this.elimEntriesLinkMapping.add(this.genInvElimEntriesLickMapping(this.ctx.getModelId(), entry, elim2, elimEntryId));
                }
                BigDecimal balinceValue = creditSum.subtract(debitSum);
                if (balanceLine == null) {
                    if (template.getBalanceType() == BalanceTypeEnum.BALANCE && BCMConstant.Zero.compareTo(balinceValue) != 0) {
                        elim2.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
                        this.noBlElimIds.add(elim2.getLong("id"));
                    }
                } else if (isDebugModel || BCMConstant.Zero.compareTo(balinceValue) != 0) {
                    balanceLine.value = balanceLine.entry.getDc() == 0 ? balinceValue : balinceValue.negate();
                    DynamicObject entry = this.genInvElimEntryDyna(elim2, balanceLine, template, groupNum);
                    if (entry != null && elim2 != null) {
                        groupElimEntries.computeIfAbsent(elim2.getLong("id"), e -> new ArrayList(16)).add(entry);
                    }
                }
                debitSum = BigDecimal.ZERO;
                creditSum = BigDecimal.ZERO;
                balanceLine = null;
            }
            groupNum = 0;
            this.incrementProgress(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u3010%1$s %2$s\u3011\u660e\u7ec6\u884c\u5b8c\u6210\u6784\u9020\u3002", (String)"InvElimSpreadGenerateService_7", (String)"fi-bcm-business", (Object[])new Object[0]), template.getNumber(), template.getName()));
        }
        this.elims.removeIf(elim -> {
            List tempResult = (List)groupElimEntries.remove(elim.getLong("id"));
            if (tempResult != null && !tempResult.isEmpty()) {
                AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)elim, (Collection)tempResult, (boolean)false);
                AdjustConvertUtil.resetSeq(tempResult);
                this.elimEntries.addAll(tempResult);
                tempResult.clear();
                return false;
            }
            return true;
        });
        AdjustOperationHelper.batchSetNumbers("bcm_rptadjust", this.elims);
    }

    private Set<Long> collectNoNeedCreateTemplate(Set<Long> tempPks) {
        HashSet<Long> noNeedCreateTemplate = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(tempPks)) {
            QFilter auditQf = new QFilter("entrysource", "=", (Object)(EntrySourceEnum.INVSHEETCREATE.getValue() + "")).and("adjust.sourcetype", "=", (Object)(ElimRptAdjSourceTypeEnum.MANUAL.getValue() + "")).and("adjust.entity.number", "=", (Object)this.ctx.getOrgUnitNumber()).and("adjust.checkrecord", "in", tempPks);
            Map<Long, Set<Object>> adjustMap = AdjustmentServiceHelper.collectAdjust(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), null, auditQf);
            HashSet adjustIdSet = new HashSet(16);
            adjustMap.values().forEach(idSet -> idSet.stream().forEach(id -> adjustIdSet.add((Long)id)));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryNoCreateInvAdj", (String)"bcm_rptadjust", (String)"id,extendfrom,process,checkrecord", (QFilter[])new QFilter("id", "in", adjustIdSet).toArray(), null);){
                ds.forEachRemaining(row -> {
                    String checkrecord = row.getString("checkrecord");
                    if (!StringUtils.isEmpty((CharSequence)checkrecord)) {
                        noNeedCreateTemplate.add(LongUtil.toLong((Object)checkrecord));
                    }
                });
            }
        }
        return noNeedCreateTemplate;
    }

    private Map<String, String> deleteOldData() {
        QFBuilder tempQF = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
        tempQF.and("scenario", "=", (Object)this.ctx.getScenarioId());
        tempQF.and("year", "=", (Object)this.ctx.getFyId());
        tempQF.and("period", "=", (Object)this.ctx.getPeriodId());
        tempQF.and("entity.number", "=", (Object)this.ctx.getOrgUnitNumber());
        tempQF.and("process", "in", this.getProcesses());
        tempQF.and("sourcetype", "=", (Object)Integer.toString(ElimRptAdjSourceTypeEnum.SHEETINV.getValue()));
        ArrayList<Long> pks = new ArrayList<Long>(16);
        HashMap extendfromMap = new HashMap(16);
        if (!CollectionUtil.isEmpty(this.ctx.getSheets())) {
            tempQF.and("extend", "in", this.ctx.getSheets().stream().map(template -> template.getLong("template.id")).collect(Collectors.toSet()));
        }
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(Arrays.asList("id", "sourcetype", "extend", "extendfrom", "status", "linkagelinksource"), tempQF, null, -1);){
            ds.forEachRemaining(entry -> {
                pks.add(entry.getLong("id"));
                if (RptAdjustStatusEnum.AUDIT.status().equals(entry.getString("status"))) {
                    extendfromMap.put(entry.getLong("id"), entry.getString("extendfrom"));
                }
            });
        }
        HashMap<String, String> noNeedCreateSet = new HashMap<String, String>(16);
        if (!pks.isEmpty()) {
            Map<Long, HashBasedTable<Long, Long, List<String>>> delLockScope = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f-\u751f\u6210\u5206\u5f55\u63a5\u53e3\uff08\u5220\u9664\u5386\u53f2\u5206\u5f55\uff09", (String)"InvElimSpreadGenerateService_9", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx, extendfromMap.keySet(), null);
            for (Long adjustId : new ArrayList(pks)) {
                HashBasedTable<Long, Long, List<String>> detailTable = delLockScope.get(adjustId);
                String extendFrom = (String)extendfromMap.get(adjustId);
                if (detailTable == null || extendFrom == null) continue;
                pks.remove(adjustId);
                if (detailTable.containsRow((Object)adjustId)) {
                    noNeedCreateSet.put(extendFrom, String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s[%2$s]", (String)"InvElimSpreadGenerateService_10", (String)"fi-bcm-business", (Object[])new Object[0]), extendFrom, detailTable.row((Object)adjustId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                    continue;
                }
                noNeedCreateSet.put(extendFrom, String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u8054\u52a8/\u5173\u8054)%1$s[%2$s]", (String)"InvElimSpreadGenerateService_11", (String)"fi-bcm-business", (Object[])new Object[0]), extendFrom, detailTable.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
            }
            if (!noNeedCreateSet.isEmpty()) {
                this.errMsg.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5e95\u7a3f\u5206\u5f55\u8bbe\u7f6e%s\u5bf9\u5e94\u7684\u5386\u53f2\u5206\u5f55\u5df2\u7ecf\u5206\u9636\u6bb5\u6570\u636e\u9501\u5b9a\uff0c\u65e0\u6cd5\u6253\u56de", (String)"InvElimSpreadGenerateService_17", (String)"fi-bcm-business", (Object[])new Object[0]), noNeedCreateSet.values()));
            }
            AdjustClearServiceHelper.batchDeleteAutoAdjust("InvElimSpreadGenerateService.deleteOldData", this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), pks);
        }
        return noNeedCreateSet;
    }

    private void saveData(Map<String, String> noNeedCreateSet) {
        ArrayList<Long> allElimIds = new ArrayList<Long>(this.elims.size());
        ArrayList<Long> autoCreateAdjust = new ArrayList<Long>(this.elims.size());
        this.elims.removeIf(elim -> {
            if (noNeedCreateSet.containsKey(elim.getString("extendfrom"))) {
                return true;
            }
            if (InvSheetEntryConstant.LinkCreateTypeEnum.AUTOCREATEADJUST.getValue().equals(elim.getString("linkcreatetype"))) {
                autoCreateAdjust.add(elim.getLong("id"));
            }
            allElimIds.add(elim.getLong("id"));
            this.sucessesIds.add((Long)elim.get("extend"));
            return false;
        });
        if (!this.elims.isEmpty()) {
            this.generatCount = this.elims.size();
            SaveServiceHelper.save((DynamicObject[])this.elims.toArray(new DynamicObject[0]));
        }
        this.elimEntries.removeIf(e -> !allElimIds.contains(DynUtils.getBaseId((String)"saveData", (DynamicObject)e, (String)"adjust")));
        if (!this.elimEntries.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.elimEntries.toArray(new DynamicObject[0]));
        }
        Map<Object, Object> sourceId2LinkageIdMap = Collections.emptyMap();
        if (!autoCreateAdjust.isEmpty()) {
            LinkageDataCollector linkageDataCollector = LinkageMappingService.newObject(autoCreateAdjust, EntrySourceEnum.INVLINKAGECREATE).buildAutoElimLinkage();
            sourceId2LinkageIdMap = linkageDataCollector.getSourceId2LinkageIdMap();
            this.elimEntries.addAll(linkageDataCollector.getCreateLinkageDatas());
            if (linkageDataCollector.getRetainHistoryLinkDatas() != null) {
                this.elimEntries.addAll(Arrays.asList(linkageDataCollector.getRetainHistoryLinkDatas()));
            }
        }
        if (!this.elimEntriesLinkMapping.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.elimEntriesLinkMapping.toArray(new DynamicObject[0]));
        }
        HashBasedTable<Long, Long, List<String>> newLockScope = AdjustOperationHelper.batchCheckOlapDataLock(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f-\u751f\u6210\u5206\u5f55\u63a5\u53e3\uff08\u751f\u6210\u65b0\u5206\u5f55\uff09", (String)"InvElimSpreadGenerateService_13", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx, this.elimEntries, null);
        HashSet<DynamicObject> toSaveStatusSet = new HashSet<DynamicObject>(16);
        Long linkId = 0L;
        HashSet<String> lockExtendfromSet = new HashSet<String>(16);
        for (DynamicObject elim2 : this.elims) {
            Long elimId = elim2.getLong("id");
            linkId = sourceId2LinkageIdMap.getOrDefault(elimId, 0L);
            if (this.noBlElimIds.contains(elimId)) {
                allElimIds.remove(elimId);
                continue;
            }
            if (newLockScope.containsRow((Object)elimId)) {
                elim2.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
                toSaveStatusSet.add(elim2);
                allElimIds.remove(elimId);
                lockExtendfromSet.add(String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s[%2$s]", (String)"InvElimSpreadGenerateService_10", (String)"fi-bcm-business", (Object[])new Object[0]), elim2.getString("extendfrom"), newLockScope.row((Object)elimId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                continue;
            }
            if (newLockScope.containsRow((Object)linkId)) {
                elim2.set("status", (Object)RptAdjustStatusEnum.SAVE.status());
                toSaveStatusSet.add(elim2);
                allElimIds.remove(elimId);
                lockExtendfromSet.add(String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u8054\u52a8)%1$s[%2$s]", (String)"InvElimSpreadGenerateService_14", (String)"fi-bcm-business", (Object[])new Object[0]), elim2.getString("extendfrom"), newLockScope.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                continue;
            }
            if (!LongUtil.isvalidLong((Object)linkId)) continue;
            allElimIds.add(linkId);
        }
        if (!lockExtendfromSet.isEmpty()) {
            this.errMsg.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u5f55\u6570\u636e\u5df2\u7ecf\u5206\u9636\u6bb5\u9501\u5b9a\uff0c\u5df2\u81ea\u52a8\u8f6c\u4e3a\u4fdd\u5b58\uff0c\u5982\u4e0b\u6240\u793a : %s", (String)"InvElimSpreadGenerateService_16", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", lockExtendfromSet)));
        }
        if (!toSaveStatusSet.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])toSaveStatusSet.toArray(new DynamicObject[0]));
        }
        if (!allElimIds.isEmpty()) {
            AdjustCheckServiceHelper.doSysToMdd(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), allElimIds, true);
        }
    }

    private int getCurrencyPrecision() {
        QFilter currencyFilter;
        QFilter scenarioFilter;
        String selectFields = "scaleentry.scale as scale";
        QFilter modelFilter = new QFilter("model.id", "=", (Object)this.ctx.getModelId());
        QFilter[] filters = new QFilter[]{modelFilter, scenarioFilter = new QFilter("id", "=", (Object)this.ctx.getScenarioId()), currencyFilter = new QFilter("scaleentry.currency.number", "=", (Object)this.ctx.getUnitCurrency())};
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)selectFields, (QFilter[])filters);
        if (dimObj == null || dimObj.get("scale") == null) {
            return 2;
        }
        return dimObj.getInt("scale");
    }

    private List<String> getProcesses() {
        if (this.specifiedProcess != null) {
            return new ArrayList<String>(this.specifiedProcess);
        }
        List<List<String>> elimProcess = MergeControlHelper.getUnitElimProcesses(this.ctx.getModelId());
        ArrayList<String> process = new ArrayList<String>(10);
        elimProcess.forEach(process::addAll);
        process.add("ERAdj");
        return process;
    }

    private DynamicObject genInvElimHeadDyna(InvElimTemplateModel template) {
        DynamicObject elim = InvElimRecorderGenHelper.genInvElimHeadDyna(template, null, this.ctx);
        elim.set("journaltype", (Object)template.getJournaltype());
        elim.set("sourcetype", (Object)(ElimRptAdjSourceTypeEnum.SHEETINV.getValue() + ""));
        elim.set("extend", template.getProperty("templateid"));
        elim.set("extendfrom", (Object)(template.getNumber() + "(" + this.ctx.getOrgUnitNumber() + ")"));
        return elim;
    }

    private DynamicObject genInvElimEntryDyna(DynamicObject elim, InvCalcLine line, InvElimTemplateModel template, int groupNumber) {
        DynamicObject entry = InvElimRecorderGenHelper.genInvElimEntryDyna(this.ctx, line, template, elim, 0, String.valueOf(groupNumber));
        if (entry != null) {
            entry.set("entrysource", (Object)0);
            if (entry.get("entity") != null) {
                entry.set("merge", elim.get("entity"));
            }
            return entry;
        }
        return null;
    }

    public static String packRelaKey(String belongOrg, String mergeNum, String holder, String relationType, String categorized, String invest) {
        StringJoiner joiner = new StringJoiner("->");
        joiner.add(belongOrg).add(mergeNum).add(holder).add(invest).add(relationType).add(categorized);
        return joiner.toString();
    }

    public static String getCategorized(Cell rltCell) {
        if (rltCell.getUserObject(InvRelationTypeConstant.CatalogEnum.class.getSimpleName()) == null) {
            rltCell.setUserObject(InvRelationTypeConstant.CatalogEnum.class.getSimpleName(), (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
        }
        return (String)rltCell.getUserObject(InvRelationTypeConstant.CatalogEnum.class.getSimpleName());
    }

    protected DynamicObject genInvElimEntriesLickMapping(long modelId, DynamicObject entry, DynamicObject elim, Long elimEntryId) {
        DynamicObject linkadjust = BusinessDataServiceHelper.newDynamicObject((String)"bcm_linkadjust_mapping");
        linkadjust.set("model", (Object)modelId);
        linkadjust.set("elim", (Object)elim);
        linkadjust.set("linkid", (Object)elimEntryId);
        linkadjust.set("elimentry", (Object)entry);
        linkadjust.set("biztype", (Object)"1");
        return linkadjust;
    }

    private void setProgress(int progress, String progressMsg) {
        this.progress = progress;
        if (this.observer == null) {
            return;
        }
        this.observer.accept(progressMsg, progress);
    }

    private void incrementProgress(String progressMsg) {
        int newProgress = this.progress + 30 / this.templates.size();
        this.setProgress(newProgress, progressMsg);
    }

    private /* synthetic */ void lambda$buildInvElimTemplateModel$7(Map tempDyMap, Map tmp2spread, Table accountPos, DynamicObject dy) {
        DynamicObject tmpDy = (DynamicObject)tempDyMap.get(dy.getLong("sheettemplate.id"));
        InvElimTemplateModel model = InvElimTemplateModel.trans2ModelFromSheetSet(dy);
        Pair relaType = Pair.onePair((Object)dy.getLong("relationtype.categorized"), (Object)dy.getString("relationtype.number"));
        model.setRelaType(relaType);
        model.setProcess(tmpDy.getString("process.number"));
        model.setProperty("isFlowRow", this.isFlowRow(tmpDy.getString("spreadtype")));
        model.setProperty("data", tmp2spread.get(dy.getLong("sheettemplate.id")));
        model.setProperty("accountPos", accountPos.row((Object)dy.getLong("sheettemplate.id")));
        model.setProperty("templateid", tmpDy.getLong("id"));
        model.setProperty("templatenumber", tmpDy.getString("number"));
        model.setProperty("tempstatus", tmpDy.getString("status"));
        model.setProperty("dataModel", tmpDy.getString("extdimid.number"));
        model.setProperty("groupId", tmpDy.getLong("group"));
        this.templates.add(model);
        this.adjLog.addCount();
    }

    private /* synthetic */ void lambda$buildInvElimTemplateModel$4(Map tempDyMap, Table accountPos, Row p) {
        Point point = ExcelUtils.pos2Point((String)p.getString("position"));
        DynamicObject templateDy = (DynamicObject)tempDyMap.get(p.getLong("template"));
        if (templateDy != null) {
            String spreadtype = templateDy.getString("spreadtype");
            accountPos.put((Object)p.getLong("template"), (Object)p.getString("extdimid"), (Object)(this.isFlowRow(spreadtype) ? point.x : point.y));
        }
    }
}

