/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.invest.sheet.InvPaperSheetIteratorService;
import kd.fi.bcm.business.invest.sheet.InvShareRelationInfo;
import kd.fi.bcm.business.invest.sheet.InvTemplateDistributionService;
import kd.fi.bcm.business.invest.sheet.log.IInvLimSheetLogServer;
import kd.fi.bcm.business.invest.sheet.log.InvLimSheetLogServer;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.enums.invest.SheetStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class InvLimSheetCopyFromService {
    private Object[] selectIds;
    private IDNumberTreeNode orgNode;
    private FixedItem tarF7;
    private FixedItem srcF7;
    public static final String ORG_NUMBER = "number";
    public static final String DRAFT_NUMBER = "number";
    public static final String FROM_COPY = "fromCopy";
    public static final String DRAFT_PERIOD = "period";
    public static final String DRAFT_SCENARIO = "scenario";

    public InvLimSheetCopyFromService(Object[] selectIds, IDNumberTreeNode orgNode, FixedItem tarF7, FixedItem srcF7) {
        this.selectIds = selectIds;
        this.orgNode = orgNode;
        this.tarF7 = tarF7;
        this.srcF7 = srcF7;
    }

    public List<String> copyValidate() {
        String tip;
        McStatus mcStatus;
        String tip2;
        long storageOrgId = this.getStorageOrgId();
        String orgNumber = this.orgNode.getNumber();
        ArrayList<String> notificationMsg = new ArrayList<String>(16);
        if (this.selectIds == null || this.selectIds.length < 1) {
            tip2 = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvLimSheetCopyFromService_1", (String)"fi-bcm-business", (Object[])new Object[0]);
            notificationMsg.add(tip2);
        }
        if (this.srcF7.getModelId() == this.tarF7.getModelId() && this.srcF7.getScenarioId() == this.tarF7.getScenarioId() && this.srcF7.getFyId() == this.tarF7.getFyId() && this.srcF7.getPeriodId() == this.tarF7.getPeriodId()) {
            tip2 = ResManager.loadKDString((String)"\u6e90\u671f\u95f4\u4e0d\u80fd\u548c\u76ee\u6807\u671f\u95f4\u76f8\u540c\u3002", (String)"InvLimSheetCopyFromService_2", (String)"fi-bcm-business", (Object[])new Object[0]);
            notificationMsg.add(tip2);
        }
        if (this.srcF7.getModelId() != this.tarF7.getModelId()) {
            tip2 = ResManager.loadKDString((String)"\u6e90\u548c\u76ee\u6807\u7684\u4f53\u7cfb\u5fc5\u987b\u76f8\u540c\u3002", (String)"InvLimSheetCopyFromService_3", (String)"fi-bcm-business", (Object[])new Object[0]);
            notificationMsg.add(tip2);
        }
        if (!PeriodSettingHelper.checkPeriodStatus(this.tarF7.getModelId(), orgNumber, this.tarF7.getScenarioId(), this.tarF7.getFyId(), this.tarF7.getPeriodId(), "datastatus")) {
            tip2 = ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7684\u76ee\u6807\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvLimSheetCopyFromService_4", (String)"fi-bcm-business", (Object[])new Object[0]);
            notificationMsg.add(String.format(tip2, orgNumber));
        }
        if ((mcStatus = McStatus.getMcStatus(this.tarF7.getModelId(), storageOrgId, this.tarF7.getScenarioId(), this.tarF7.getFyId(), this.tarF7.getPeriodId())).getArchive().isArchive()) {
            tip = ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7684\u9ed8\u8ba4\u5e01\u62a5\u8868\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u53ef\u6267\u884c\u64cd\u4f5c\u3002", (String)"InvLimSheetCopyFromService_5", (String)"fi-bcm-business", (Object[])new Object[0]);
            notificationMsg.add(String.format(tip, orgNumber));
        }
        if (mcStatus.getFlow().isSubmit()) {
            tip = ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7684\u9ed8\u8ba4\u5e01\u62a5\u8868\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\uff0c\u4e0d\u53ef\u6267\u884c\u64cd\u4f5c\u3002", (String)"InvLimSheetCopyFromService_6", (String)"fi-bcm-business", (Object[])new Object[0]);
            notificationMsg.add(String.format(tip, orgNumber));
        }
        return notificationMsg;
    }

    public Pair<StringJoiner, StringJoiner> getSrcAndTargetTipNumber() {
        StringJoiner src = new StringJoiner(",");
        StringJoiner target = new StringJoiner(",");
        List selectIdList = Arrays.stream(this.selectIds).map(LongUtil::toLong).collect(Collectors.toList());
        DynamicObjectCollection copyFromDys = QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)"template.number,number", (QFilter[])new QFBuilder("id", "in", selectIdList).toArray());
        ArrayList<String> templateNumbers = new ArrayList<String>(copyFromDys.size());
        for (DynamicObject copyFromDy : copyFromDys) {
            String number = copyFromDy.getString("number");
            String templateNumber = copyFromDy.getString("template.number");
            src.add(number);
            templateNumbers.add(templateNumber);
        }
        DynamicObjectCollection targetDy = this.queryTargetInvLimSheet(templateNumbers, "number");
        for (DynamicObject dynamicObject : targetDy) {
            String number = dynamicObject.getString("number");
            target.add(number);
        }
        return Pair.onePair((Object)src, (Object)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, String> doCopyAndReturn() {
        String modelNum = this.tarF7.getModelNum();
        String scenarioNum = this.tarF7.getScenarioNum();
        String fyNum = this.tarF7.getFyNum();
        String periodNum = this.tarF7.getPeriodNum();
        try (DLock lock = DLock.create((String)InvSheetConstant.lockKey((String)modelNum, (String)scenarioNum, (String)fyNum, (String)periodNum, (String)this.orgNode.getNumber()));){
            if (lock.tryLock()) {
                try {
                    Pair<String, String> pair = this.doCopyAndReturnNoLock();
                    return pair;
                }
                finally {
                    lock.unlock();
                }
            }
            Pair pair = Pair.onePair((Object)"", (Object)ResManager.loadKDString((String)"\u76ee\u6807\u671f\u95f4\u5408\u5e76\u8282\u70b9\u6b63\u5728\u751f\u6210\u5e95\u7a3f\u6216\u88ab\u4ece\u5176\u4ed6\u671f\u95f4\u590d\u5236\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"InvLimSheetCopyFromService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            return pair;
        }
    }

    public Pair<String, String> doCopyAndReturnNoLock() {
        ArrayList updateDys = new ArrayList(16);
        ArrayList saveDys = new ArrayList(16);
        IInvLimSheetLogServer logServer = InvLimSheetLogServer.buildInvLimSheetLogServer(this.tarF7.getModelId(), this.tarF7.getScenarioId(), this.tarF7.getFyId(), this.tarF7.getPeriodId(), this.orgNode.getId(), InvLimSheetLogConstant.Operation.COPY_FROM);
        CollectionResult copyData = this.collectCopyData();
        InvElimPaperGenerateService removeService = this.buildInvElimPaperRemoveService(copyData, logServer);
        GlobalIdDistributer idDistributor = new GlobalIdDistributer();
        PlatUtil.executeWithTXNew(tx -> {
            removeService.deletePaperAndEntry();
            List<DynamicObject> newDys = copyData.getNewDys();
            this.saveAndClearIfTrue(newDys, !newDys.isEmpty());
            Map<String, Map<String, Set<InvShareRelationInfo>>> dataModelAcc2relation = copyData.getDataModel2relation();
            dataModelAcc2relation.keySet().forEach(dataModel -> {
                Map row = dataModelAcc2relation.getOrDefault(dataModel, Collections.emptyMap());
                HashSet investedCompanyNumbers = new HashSet(16);
                HashSet shareholderNumbers = new HashSet(16);
                row.values().forEach(v -> v.forEach(info -> {
                    String investedCompanyNumber = info.getInvestedCompanyNumber();
                    String shareholderNumber = info.getShareholderNumber();
                    investedCompanyNumbers.add(investedCompanyNumber);
                    shareholderNumbers.add(shareholderNumber);
                }));
                QFBuilder qfBuilder2 = new QFBuilder("modelnumber", "=", (Object)this.srcF7.getModelNum()).and("Scenario", "=", (Object)this.srcF7.getScenarioNum()).and("Year", "=", (Object)this.srcF7.getFyNum()).and("Period", "=", (Object)this.srcF7.getPeriodNum()).and("org", "=", (Object)this.orgNode.getNumber()).and("datamodel", "=", dataModel).and("account", "in", row.keySet()).and("entity", "in", investedCompanyNumbers).and("internalcompany", "in", shareholderNumbers);
                DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_extenddata_inv", (String)"merge,account,internalcompany,entity,datatype,textext,numext,dateext,org,extendsgroup,templatenumber,relationtype,exttype,categorized", (QFilter[])qfBuilder2.toArray());
                for (DynamicObject sourceDy : load) {
                    String acc = sourceDy.getString("account");
                    String belongOrg = sourceDy.getString("org");
                    String merge = sourceDy.getString("merge");
                    String invested = sourceDy.getString("entity");
                    String share = sourceDy.getString("internalcompany");
                    String relation = sourceDy.getString("relationtype");
                    String categorized = sourceDy.getString("categorized");
                    Set invShareRelationInfos = row.getOrDefault(acc, Collections.emptySet());
                    List infos = invShareRelationInfos.stream().filter(info -> info.equals(new InvShareRelationInfo(belongOrg, merge, share, invested, relation, categorized))).collect(Collectors.toList());
                    for (InvShareRelationInfo info2 : infos) {
                        DynamicObject newAddDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extenddata_inv");
                        saveDys.add(newAddDy);
                        newAddDy.set("datatype", sourceDy.get("datatype"));
                        newAddDy.set("textext", sourceDy.get("textext"));
                        newAddDy.set("numext", sourceDy.get("numext"));
                        newAddDy.set("dateext", sourceDy.get("dateext"));
                        newAddDy.set("org", sourceDy.get("org"));
                        newAddDy.set("merge", sourceDy.get("merge"));
                        newAddDy.set("entity", sourceDy.get("entity"));
                        newAddDy.set("account", sourceDy.get("account"));
                        newAddDy.set("extendsgroup", sourceDy.get("extendsgroup"));
                        newAddDy.set("templatenumber", (Object)info2.getTempNumber());
                        newAddDy.set("internalcompany", sourceDy.get("internalcompany"));
                        newAddDy.set("relationtype", sourceDy.get("relationtype"));
                        newAddDy.set("categorized", sourceDy.get("categorized"));
                        newAddDy.set("exttype", sourceDy.get("exttype"));
                        newAddDy.set("datamodel", dataModel);
                        long id = idDistributor.getLongId();
                        newAddDy.set("id", (Object)id);
                        newAddDy.set("modelnumber", (Object)this.tarF7.getModelNum());
                        newAddDy.set("Scenario", (Object)this.tarF7.getScenarioNum());
                        newAddDy.set("Year", (Object)this.tarF7.getFyNum());
                        newAddDy.set("Period", (Object)this.tarF7.getPeriodNum());
                        this.saveAndClearIfTrue(saveDys, saveDys.size() > 1000);
                        this.updateIfTrue(updateDys, updateDys.size() > 1000);
                        logServer.logSheetDataCopy(newAddDy);
                    }
                }
            });
            this.saveAndClearIfTrue(saveDys, !saveDys.isEmpty());
            this.updateIfTrue(updateDys, !updateDys.isEmpty());
        });
        logServer.successLogAsync();
        return Pair.onePair((Object)String.join((CharSequence)"\n ", copyData.getSuccess()), (Object)String.join((CharSequence)"\n ", copyData.getFail()));
    }

    private InvElimPaperGenerateService buildInvElimPaperRemoveService(CollectionResult copyData, IInvLimSheetLogServer logServer) {
        InvElimPaperGenerateService invElimPaperGenerateService = new InvElimPaperGenerateService((Long)this.tarF7.getModelId(), (Long)this.tarF7.getScenarioId(), (Long)this.tarF7.getFyId(), (Long)this.tarF7.getPeriodId(), this.orgNode.getId(), logServer);
        List<Long> pks = this.getInvElimPaperRemoveIds(copyData.getNumberRmv());
        copyData.clearInvLimSheetRemoveNumber();
        ArrayList<Long> tempPks = new ArrayList<Long>(16);
        HashMap<String, Map<String, Set<InvShareRelationInfo>>> modelAcc2RelationsRm = new HashMap<String, Map<String, Set<InvShareRelationInfo>>>(16);
        if (!pks.isEmpty()) {
            invElimPaperGenerateService.collectDelSheet(tempPks, pks);
            invElimPaperGenerateService.collectDelEntryByTempPks(tempPks);
            invElimPaperGenerateService.deletePaperAndEntryFilter();
            invElimPaperGenerateService.collectTempModelAccRelation(modelAcc2RelationsRm);
            invElimPaperGenerateService.getErrMsg().forEach(copyData::addFailMsg);
        }
        Map<String, Map<String, Set<InvShareRelationInfo>>> dataModel2relation = copyData.getDataModel2relation();
        dataModel2relation.forEach((dataModel, acc2Relations) -> {
            Map acc2RelationsRm = modelAcc2RelationsRm.computeIfAbsent((String)dataModel, k -> new HashMap(16));
            acc2Relations.forEach((acc, relations) -> {
                Set invShareRelationInfosRm = acc2RelationsRm.computeIfAbsent(acc, k -> new HashSet(16));
                invShareRelationInfosRm.addAll(relations);
            });
        });
        invElimPaperGenerateService.collectDelExtendDataByModelAcc2Relation(modelAcc2RelationsRm);
        return invElimPaperGenerateService;
    }

    private List<Long> getInvElimPaperRemoveIds(List<String> numberRmv) {
        if (!numberRmv.isEmpty()) {
            DynamicObjectCollection id = this.queryTargetInvLimSheet(numberRmv, "id");
            return id.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void updateIfTrue(List<DynamicObject> updateDys, boolean canUpdate) {
        if (canUpdate) {
            SaveServiceHelper.update((DynamicObject[])updateDys.toArray(new DynamicObject[0]));
            updateDys.clear();
        }
    }

    private void saveAndClearIfTrue(List<DynamicObject> saveDys, boolean canSave) {
        if (canSave) {
            SaveServiceHelper.save((DynamicObject[])saveDys.toArray(new DynamicObject[0]));
            saveDys.clear();
        }
    }

    private CollectionResult collectCopyData() {
        List selectIdList = Arrays.stream(this.selectIds).map(LongUtil::toLong).collect(Collectors.toList());
        ArrayList commonProps = Lists.newArrayList((Object[])new String[]{"number", "name", "model", "entity", "template", "spreadjson", "data", "catalog", "groupid"});
        DynamicObjectCollection templates = InvTemplateDistributionService.queryTemplateByEntityId(this.tarF7.getModelId(), this.getStorageOrgId(), this.tarF7.getFyId(), this.tarF7.getPeriodId(), this.tarF7.getScenarioId());
        Map<Long, DynamicObject> tempId2Status = templates.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        DynamicObjectCollection parTemplates = this.orgNode.getParent() == null ? new DynamicObjectCollection() : InvTemplateDistributionService.queryTemplateByEntityId(this.tarF7.getModelId(), this.orgNode.getParent().getBaseTreeNode().getId(), this.tarF7.getFyId(), this.tarF7.getPeriodId(), this.tarF7.getScenarioId());
        Map<Long, DynamicObject> parTempId2Status = parTemplates.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        ArrayList queryProps = Lists.newArrayList((Object[])new String[]{"template.id", "template.number", "template.process.number", "from"});
        queryProps.addAll(commonProps);
        DynamicObjectCollection copyFromDys = QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)String.join((CharSequence)",", queryProps), (QFilter[])new QFBuilder("id", "in", selectIdList).toArray());
        CollectionResult result = new CollectionResult(copyFromDys.size());
        HashMap template2Location = new HashMap(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_invlimsheetentity");
        for (DynamicObject copyFromDy : copyFromDys) {
            String msg;
            long templateId = copyFromDy.getLong("template.id");
            String tempNumber = copyFromDy.getString("template.number");
            String processNumber = copyFromDy.getString("template.process.number");
            String number = copyFromDy.getString("number");
            DynamicObject template = (OrgRelaProcessMembPool.isRelaProcess((String)processNumber) ? tempId2Status : parTempId2Status).get(templateId);
            if (template == null) {
                msg = ResManager.loadKDString((String)"\u6e90\u5e95\u7a3f\u3010%1$s\u3011\u5bf9\u5e94\u6a21\u677f\u6682\u672a\u5206\u914d\u7ed9\u76ee\u6807\u5408\u5e76\u8282\u70b9\uff0c\u590d\u5236\u5931\u8d25\u3002", (String)"InvLimSheetCopyFromService_9", (String)"fi-bcm-business", (Object[])new Object[0]);
                result.addFailMsg(String.format(msg, number));
                continue;
            }
            if (!InvSheetTemplateConstant.BillStatusEnum.ENABLE.getCode().equals(template.getString("status"))) {
                msg = ResManager.loadKDString((String)"\u6e90\u5e95\u7a3f\u3010%1$s\u3011\u5bf9\u5e94\u6a21\u677f\u5728\u76ee\u6807\u671f\u95f4\u7248\u672c\u4e0d\u5339\u914d\u6216\u672a\u542f\u7528\uff0c\u590d\u5236\u5931\u8d25\u3002", (String)"InvLimSheetCopyFromService_7", (String)"fi-bcm-business", (Object[])new Object[0]);
                result.addFailMsg(String.format(msg, number));
                continue;
            }
            msg = ResManager.loadKDString((String)"%1$s\u590d\u5236\u6210\u529f\u3002", (String)"InvLimSheetCopyFromService_8", (String)"fi-bcm-business", (Object[])new Object[0]);
            result.addSuccessMsg(String.format(msg, number));
            result.addInvLimSheetRemoveNumber(tempNumber);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            for (String property : commonProps) {
                dynamicObject.set(property, copyFromDy.get(property));
            }
            SpreadManager data = JsonSerializerUtil.toSpreadManager((String)copyFromDy.getString("data"));
            Sheet effectiveSheet = data.getBook().getSheet(0);
            Map<String, Set<InvShareRelationInfo>> account2ShareRelation = this.collectAccount2ShareRelation(effectiveSheet, tempNumber, templateId);
            Map location = template2Location.computeIfAbsent(templateId, key -> new HashMap(16));
            account2ShareRelation.forEach((k, v) -> {
                Set invShareRelationInfos = location.computeIfAbsent(k, key -> new HashSet(16));
                invShareRelationInfos.addAll(v);
            });
            String sheetStatus = copyFromDy.getString("from");
            if (SheetStatusEnum.AUTO.status().equals(sheetStatus)) {
                effectiveSheet.putUserObject(FROM_COPY, (Object)true);
                dynamicObject.set("data", (Object)ObjectSerialUtil.toByteSerialized((Object)data));
            }
            dynamicObject.set(DRAFT_SCENARIO, (Object)this.tarF7.getScenarioId());
            dynamicObject.set("from", (Object)SheetStatusEnum.STORAGE.status());
            dynamicObject.set("year", (Object)this.tarF7.getFyId());
            dynamicObject.set(DRAFT_PERIOD, (Object)this.tarF7.getPeriodId());
            dynamicObject.set("cslscheme", (Object)this.tarF7.getSchemeId());
            dynamicObject.set("modifier", (Object)this.getUserId());
            dynamicObject.set("creator", (Object)this.getUserId());
            result.addNewTargetDy(dynamicObject);
        }
        Set templateIds = template2Location.keySet();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplate", (String)String.join((CharSequence)",", "extdimid.number", "id"), (QFilter[])new QFBuilder("id", "in", templateIds).toArray());
        for (DynamicObject dynamicObject : query) {
            String dataModel = dynamicObject.getString("extdimid.number");
            long tId = dynamicObject.getLong("id");
            Map<String, Set> row = template2Location.getOrDefault(tId, Collections.emptyMap());
            Map<String, Set<InvShareRelationInfo>> data = result.getAcc2RelationsByDataModel(dataModel);
            row.forEach((k, v) -> {
                Set invShareRelationInfos = data.computeIfAbsent((String)k, key -> new HashSet(16));
                invShareRelationInfos.addAll(v);
            });
        }
        return result;
    }

    private Map<String, Set<InvShareRelationInfo>> collectAccount2ShareRelation(Sheet effectiveSheet, String tempNumber, long templateId) {
        HashMap<String, Set<InvShareRelationInfo>> account2Relation = new HashMap<String, Set<InvShareRelationInfo>>(16);
        HashSet invShareRelationInfos = new HashSet(16);
        InvPaperSheetIteratorService invPaperSheetIteratorService = new InvPaperSheetIteratorService(effectiveSheet, InvElimPaperGenerateService.getSpreadType(effectiveSheet, templateId));
        invPaperSheetIteratorService.iterationRelationCell((rltCell, orgCell, shareholderCell, investedCell) -> {
            String relationType = (String)rltCell.getUserObject(InvRelaTypeEnum.class.getSimpleName());
            String categorized = InvElimSpreadGenerateService.getCategorized(rltCell);
            String unitOrg = (String)orgCell.getUserObject("number");
            String holder = (String)shareholderCell.getUserObject("number");
            String invest = (String)investedCell.getUserObject("number");
            if (Objects.nonNull(holder) && Objects.nonNull(invest)) {
                invShareRelationInfos.add(new InvShareRelationInfo(this.orgNode.getNumber(), unitOrg, holder, invest, relationType, categorized, tempNumber));
            }
        });
        invPaperSheetIteratorService.iterationAccCell(accCell -> {
            Object accountNumber = accCell.getUserObject("number");
            if (Objects.nonNull(accountNumber)) {
                account2Relation.put(String.valueOf(accountNumber), invShareRelationInfos);
            }
        });
        return account2Relation;
    }

    private long getStorageOrgId() {
        return StorageTypeEnum.STORAGE != this.orgNode.getStorageType() ? this.orgNode.getCopyfromId() : this.orgNode.getId();
    }

    private DynamicObjectCollection queryTargetInvLimSheet(List<String> templateNumbers, String selectFields) {
        QFBuilder qfBuilder = new QFBuilder("template.number", "in", templateNumbers).and("model", "=", (Object)this.tarF7.getModelId()).and(DRAFT_SCENARIO, "=", (Object)this.tarF7.getScenarioId()).and("year", "=", (Object)this.tarF7.getFyId()).and(DRAFT_PERIOD, "=", (Object)this.tarF7.getPeriodId()).and("entity.number", "=", (Object)this.orgNode.getNumber());
        return QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    private long getUserId() {
        return RequestContext.get().getCurrUserId();
    }

    private static class CollectionResult {
        private List<DynamicObject> newDys;
        private List<String> success;
        private List<String> fail;
        private List<String> numberRmv;
        private Map<String, Map<String, Set<InvShareRelationInfo>>> dataModel2relation;

        public CollectionResult(int size) {
            this.newDys = new ArrayList<DynamicObject>(size);
            this.success = new ArrayList<String>(16);
            this.fail = new ArrayList<String>(16);
            this.numberRmv = new ArrayList<String>(size);
            this.dataModel2relation = new HashMap<String, Map<String, Set<InvShareRelationInfo>>>(16);
        }

        public List<DynamicObject> getNewDys() {
            return this.newDys;
        }

        public List<String> getSuccess() {
            return this.success;
        }

        public List<String> getFail() {
            return this.fail;
        }

        public List<String> getNumberRmv() {
            return this.numberRmv;
        }

        public Map<String, Map<String, Set<InvShareRelationInfo>>> getDataModel2relation() {
            return this.dataModel2relation;
        }

        public void addInvLimSheetRemoveNumber(String number) {
            this.numberRmv.add(number);
        }

        public void addSuccessMsg(String msg) {
            this.success.add(msg);
        }

        public void addFailMsg(String msg) {
            this.fail.add(msg);
        }

        public void addNewTargetDy(DynamicObject dynamicObject) {
            this.newDys.add(dynamicObject);
        }

        public Map<String, Set<InvShareRelationInfo>> getAcc2RelationsByDataModel(String dataModel) {
            return this.dataModel2relation.computeIfAbsent(dataModel, key -> new HashMap(16));
        }

        public void clearInvLimSheetRemoveNumber() {
            this.numberRmv = null;
        }
    }
}

