/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;

public class InvLimSheetHeadInfo {
    private SimpleItem unit;
    private String relationTypeName;
    private String relationType;
    private String categorized;
    private SimpleItem shareholder;
    private SimpleItem investedCompany;

    public InvLimSheetHeadInfo(String relationType, String categorized) {
        this.relationType = relationType;
        this.categorized = categorized;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public String getCategorized() {
        return this.categorized;
    }

    public long getShareholderId() {
        return this.shareholder.id;
    }

    public String getShareholderNumber() {
        return this.shareholder.number;
    }

    public String getShareholderName() {
        return this.shareholder.name;
    }

    public void setShareholder(long id, String number, String name) {
        this.shareholder = new SimpleItem(id, number, name);
    }

    public void setUnitOrg(long id, String number, String name) {
        this.unit = new SimpleItem(id, number, name);
    }

    public long getUnitOrgId() {
        return this.unit.id;
    }

    public String getUnitOrgNumber() {
        return this.unit.number;
    }

    public String getUnitOrgName() {
        return this.unit.name;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public void setRelationTypeName(String relationTypeName) {
        this.relationTypeName = relationTypeName;
    }

    public long getInvestedCompanyId() {
        return this.investedCompany.id;
    }

    public String getInvestedCompanyNumber() {
        return this.investedCompany.number;
    }

    public String getInvestedCompanyName() {
        return this.investedCompany.name;
    }

    public void setInvestedCompany(long id, String number, String name) {
        this.investedCompany = new SimpleItem(id, number, name);
    }

    public int getInvRelationTypeOrder(List<DynamicObject> relationTypes) {
        int index = 0;
        Collections.reverse(relationTypes);
        for (DynamicObject type : relationTypes) {
            String number = type.getString("fbasedataid.number");
            String categorized = type.getString("fbasedataid.categorized");
            if (this.relationType.equals(number) && this.categorized.equals(categorized)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    private static class SimpleItem {
        private long id;
        private String number;
        private String name;

        public SimpleItem(long id, String number, String name) {
            this.id = id;
            this.number = number;
            this.name = name;
        }
    }
}

