/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.invest.elimination.model.GenerateContext;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvPaperGenerateService {
    private static Log log = LogFactory.getLog(InvPaperGenerateService.class);
    protected GenerateContext ctx;
    private Boolean isInvestGenWay = true;

    public void setInvestGenWay(Boolean investGenWay) {
        this.isInvestGenWay = investGenWay;
    }

    public InvPaperGenerateService(Long modelId, Long scenarioId, Long fyId, Long periodId) {
        this.ctx = new GenerateContext(modelId, scenarioId, fyId, periodId);
    }

    public List<String> generatePaper(Set<Long> orgNodes, Set<String> templationSet) {
        List<Callable> tasks = orgNodes.stream().map(orgId -> () -> this.generatePaperForOrgunit((Long)orgId, templationSet)).collect(Collectors.toList());
        List resultList = ThreadPoolService.runInUpdateTemplateLinkInfoThreadForCallable(tasks.toArray(new Callable[0]));
        List<String> msg = resultList.stream().map(ResultBox::getMessageList).filter(CollectionUtils::isNotEmpty).map(result -> (MessageInfo)result.get(0)).filter(Objects::nonNull).map(MessageInfo::getMessage).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return msg;
    }

    private ResultBox generatePaperForOrgunit(Long orgId, Set<String> templationSet) {
        InvElimPaperGenerateService invElimPaperGenerateService = new InvElimPaperGenerateService((Long)this.ctx.getModelId(), (Long)this.ctx.getScenarioId(), (Long)this.ctx.getFyId(), (Long)this.ctx.getPeriodId(), orgId, InvLimSheetLogConstant.Operation.GENERATE_MS_SERVICE);
        invElimPaperGenerateService.setTemplateList(templationSet);
        invElimPaperGenerateService.setInvestGenWay(this.isInvestGenWay);
        ResultBox resultBox = ResultBox.of();
        try {
            Pair<Integer, String> result = invElimPaperGenerateService.generatePaper();
            int p1Max = Math.max((Integer)result.p1, 0);
            resultBox.add(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u751f\u6210%2$s\u4e2a\u62b5\u9500\u5e95\u7a3f\u3002", (String)"InvPaperGenerateService_1", (String)"fi-bcm-business", (Object[])new Object[0]), invElimPaperGenerateService.ctx.getOrgUnitNumber(), p1Max).concat(result.p2 == null ? " " : (String)result.p2));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            resultBox.add(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u201c%1$s\u201d\u751f\u6210\u5e95\u7a3f\u5931\u8d25\uff1a%2$s\u3002", (String)"InvPaperGenerateService_2", (String)"fi-bcm-business", (Object[])new Object[0]), invElimPaperGenerateService.ctx.getOrgUnitNumber(), e.getMessage()));
        }
        return resultBox;
    }
}

