/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import java.util.function.Consumer;
import kd.fi.bcm.business.invest.function.HexaConsumer;
import kd.fi.bcm.business.invest.function.PentaConsumer;
import kd.fi.bcm.business.invest.function.QuadraConsumer;
import kd.fi.bcm.common.constant.invest.InvestConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public class InvPaperSheetIteratorService {
    public static final String START_COL = "startCol";
    public static final String START_ROW = "startRow";
    private final String spreadType;
    private final int startRow;
    private final int startCol;
    private final int floatCount;
    private final Sheet sheet;
    private final int sheetHeadLength;
    private final int investedCompanyOffSet;
    private final int shareholderOffSet;
    private final int orgOffSet;

    public InvPaperSheetIteratorService(Sheet sheet, String spreadType) {
        this.sheet = sheet;
        this.spreadType = spreadType;
        this.startRow = (Integer)sheet.getUserObject(START_ROW);
        this.startCol = (Integer)sheet.getUserObject(START_COL);
        this.floatCount = sheet.getUserObject("inv_relation_count") == null ? 0 : (Integer)sheet.getUserObject("inv_relation_count");
        this.sheetHeadLength = InvestConstant.getSheetHeadLength((String)((String)this.sheet.getUserObject("dimSetting_V2.0")));
        this.investedCompanyOffSet = this.sheetHeadLength - 1;
        this.shareholderOffSet = this.sheetHeadLength - 2;
        this.orgOffSet = this.sheetHeadLength - 3;
    }

    public void iterationAccCell(Consumer<Cell> consumer) {
        if (InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode().equals(this.spreadType)) {
            int maxRowCount = this.sheet.getMaxRowCount();
            this.sheet.iteratorRangeCells(this.startRow + InvestConstant.getSheetHeadLength((String)((String)this.sheet.getUserObject("dimSetting_V2.0"))), maxRowCount, this.startCol, this.startCol, consumer);
        } else {
            int maxColumnCount = this.sheet.getMaxColumnCount();
            this.sheet.iteratorRangeCells(this.startRow, this.startRow, this.startCol + InvestConstant.getSheetHeadLength((String)((String)this.sheet.getUserObject("dimSetting_V2.0"))), maxColumnCount, consumer);
        }
    }

    public void iterationRelationCell(QuadraConsumer<Cell, Cell, Cell, Cell> consumer) {
        if (this.spreadType.equals(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode())) {
            for (int i = this.startCol + 1; i < this.startCol + this.floatCount + 1; ++i) {
                Cell rltCell = this.sheet.getCell(this.startRow, i);
                Cell orgCell = this.sheet.getCell(this.startRow + this.orgOffSet, i);
                Cell shareholderCell = this.sheet.getCell(this.startRow + this.shareholderOffSet, i);
                Cell investedCell = this.sheet.getCell(this.startRow + this.investedCompanyOffSet, i);
                consumer.accept(rltCell, orgCell, shareholderCell, investedCell);
            }
        } else {
            for (int i = this.startRow + 1; i < this.startRow + this.floatCount + 1; ++i) {
                Cell rltCell = this.sheet.getCell(i, this.startCol);
                Cell orgCell = this.sheet.getCell(i, this.startCol + this.orgOffSet);
                Cell shareholderCell = this.sheet.getCell(i, this.startCol + this.shareholderOffSet);
                Cell investedCell = this.sheet.getCell(i, this.startCol + this.investedCompanyOffSet);
                consumer.accept(rltCell, orgCell, shareholderCell, investedCell);
            }
        }
    }

    public void iterationValueCellAxis(HexaConsumer<Cell, Cell, Cell, Cell, Cell, Cell> consumer) {
        int maxColumnCount = this.sheet.getMaxColumnCount();
        int maxRowCount = this.sheet.getMaxRowCount();
        if (this.spreadType.equals(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode())) {
            for (int i = 0; i < maxColumnCount + 1; ++i) {
                Cell rltCell = this.sheet.getCell(this.startRow, i);
                Cell orgCell = this.sheet.getCell(this.startRow + this.orgOffSet, i);
                Cell shareholderCell = this.sheet.getCell(this.startRow + this.shareholderOffSet, i);
                Cell investedCell = this.sheet.getCell(this.startRow + this.investedCompanyOffSet, i);
                for (int j = 0; j < maxRowCount + 1; ++j) {
                    Cell accCell = this.sheet.getCell(j, this.startCol);
                    Cell valueCell = this.sheet.getCell(j, i);
                    consumer.accept(rltCell, orgCell, shareholderCell, investedCell, accCell, valueCell);
                }
            }
        } else {
            for (int i = 0; i < maxRowCount + 1; ++i) {
                Cell rltCell = this.sheet.getCell(i, this.startCol);
                Cell orgCell = this.sheet.getCell(i, this.startCol + this.orgOffSet);
                Cell shareholderCell = this.sheet.getCell(i, this.startCol + this.shareholderOffSet);
                Cell investedCell = this.sheet.getCell(i, this.startCol + this.investedCompanyOffSet);
                for (int j = 0; j < maxColumnCount + 1; ++j) {
                    Cell accCell = this.sheet.getCell(this.startRow, j);
                    Cell valueCell = this.sheet.getCell(i, j);
                    consumer.accept(rltCell, orgCell, shareholderCell, investedCell, accCell, valueCell);
                }
            }
        }
    }

    public void iterationFormulaCell(Consumer<Cell> consumer) {
        int sheetHeadLength = InvestConstant.getSheetHeadLength((String)((String)this.sheet.getUserObject("dimSetting_V2.0")));
        if (InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode().equals(this.spreadType)) {
            int maxRowCount = this.sheet.getMaxRowCount();
            this.sheet.iteratorRangeCells(this.startRow + sheetHeadLength, maxRowCount, this.startCol + 1, this.startCol + 1, consumer);
        } else {
            int maxColumnCount = this.sheet.getMaxColumnCount();
            this.sheet.iteratorRangeCells(this.startRow + 1, this.startRow + 1, this.startCol + sheetHeadLength, maxColumnCount, consumer);
        }
    }

    public void findHeadCells(int row, int col, PentaConsumer<Cell, Cell, Cell, Cell, Cell> consumer) {
        Cell accCell;
        Cell investedCell;
        Cell shareholderCell;
        Cell orgCell;
        Cell rltCell;
        if (this.spreadType.equals(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode())) {
            rltCell = this.sheet.getCell(this.startRow, col);
            orgCell = this.sheet.getCell(this.startRow + this.orgOffSet, col);
            shareholderCell = this.sheet.getCell(this.startRow + this.shareholderOffSet, col);
            investedCell = this.sheet.getCell(this.startRow + this.investedCompanyOffSet, col);
            accCell = this.sheet.getCell(row, this.startCol);
        } else {
            rltCell = this.sheet.getCell(row, this.startCol);
            orgCell = this.sheet.getCell(row, this.startCol + this.orgOffSet);
            shareholderCell = this.sheet.getCell(row, this.startCol + this.shareholderOffSet);
            investedCell = this.sheet.getCell(row, this.startCol + this.investedCompanyOffSet);
            accCell = this.sheet.getCell(this.startRow, col);
        }
        consumer.accept(rltCell, orgCell, shareholderCell, investedCell, accCell);
    }

    public void newCellsFromCell(QuadraConsumer<Integer, Integer, Integer, Integer> action) {
        if (!this.spreadType.equals(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_COL.getCode())) {
            int maxColumnCount = this.sheet.getMaxColumnCount();
            for (int i = 0; i < maxColumnCount; ++i) {
                action.accept(this.startRow + 1, i, this.floatCount > 0 ? this.floatCount - 1 : 0, 1);
            }
        } else {
            int maxRowCount = this.sheet.getMaxRowCount();
            for (int i = 0; i < maxRowCount; ++i) {
                action.accept(i, this.startCol + 1, 1, this.floatCount > 0 ? this.floatCount - 1 : 0);
            }
        }
    }
}

