/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetDistributeConstant;
import kd.fi.bcm.common.constant.invest.invtemplate.InvDistributeConstant;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class InvTemplateDistributionService {
    private static final String ID = "id";
    private static final String COPY_FROM = "copyfrom";
    private static final String IS_LEAF = "isleaf";
    private static final String IS_INDEPENDENT_ORG = "isindependentorg";
    private static final String IS_EXCHANGE_RATE = "isexchangerate";
    private static final String PROPERTY_ID_PREFIX = "dpropertyid";
    private static final String LONG_NUMBER = "longnumber";
    private static final String TEMPLATE_NUMBER = "template.number";
    private static final String TEMPLATE_ISEXCEPT = "isexcept";
    private static final int ZERO = 0;

    public static DynamicObjectCollection queryTemplateByEntityId(long modelId, long entityId, long year, long period, long scenario) {
        Set<String> distributionTmpNumbers = InvTemplateDistributionService.queryTemplateByEntityId(modelId, entityId, null);
        return InvTemplateDistributionService.enableTemplate(modelId, year, period, scenario, distributionTmpNumbers);
    }

    public static Set<String> queryTemplateByEntityId(long modelId, long entityId, String entityType) {
        Set<String> emptySet = Collections.emptySet();
        if (Objects.isNull(entityId)) {
            return emptySet;
        }
        long storageId = InvTemplateDistributionService.getStorageId(entityId);
        if (storageId == 0L) {
            return emptySet;
        }
        Triple<Set<Object>, Set<String>, Set<Long>> objects = InvTemplateDistributionService.collectIdsAndLongNumbersAndPros(storageId);
        Set entityIds = (Set)objects.getLeft();
        Set longNumbers = (Set)objects.getMiddle();
        Set pros = (Set)objects.getRight();
        Pair<Set<String>, Set<String>> currentPair = InvTemplateDistributionService.getCurrentLevelDistributeTemplate(entityIds, pros, modelId, entityType);
        Set<Long> upParentEntityIds = InvTemplateDistributionService.findParentByLongNumber(longNumbers, modelId, "bcm_entitymembertree");
        Set<Long> parentProIds = InvTemplateDistributionService.findParentProIds(pros, modelId);
        Pair<Set<String>, Set<String>> parentPair = InvTemplateDistributionService.parentIncludeSonDistribute(modelId, upParentEntityIds, parentProIds, entityType);
        Set distributionTmpNumbers = (Set)currentPair.p1;
        distributionTmpNumbers.addAll((Collection)parentPair.p1);
        distributionTmpNumbers.removeIf(((Set)currentPair.p2)::contains);
        distributionTmpNumbers.removeIf(((Set)parentPair.p2)::contains);
        return distributionTmpNumbers;
    }

    public static List<SimpleItem> getSelfNonIndependentParentByCustom(String entityNum, Long cusPropId, Object modelId) {
        ArrayList<SimpleItem> result = new ArrayList<SimpleItem>();
        String propertyN = "propertyid.propertyn";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getSelfNonIndependentParentByCustom", (String)"bcm_definedpropertyvalue", (String)propertyN, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)cusPropId)}, null, (int)1);){
            if (ds.hasNext()) {
                Row row = ds.next();
                QFBuilder qfBuilder = new QFBuilder(row.getString(propertyN), "=", (Object)cusPropId).and(new QFilter("model", "=", modelId));
                InvTemplateDistributionService.queryFromDB(entityNum, result, () -> qfBuilder);
            }
        }
        return result;
    }

    private static void queryFromDB(String entityNum, List<SimpleItem> resultCollection, Supplier<QFBuilder> qFBuilderSupplier) {
        DynamicObjectCollection result = QueryServiceHelper.query((String)entityNum, (String)"id,number", (QFilter[])qFBuilderSupplier.get().and(InvTemplateDistributionService.nonDependentParentQF()).toArray());
        for (DynamicObject e : result) {
            resultCollection.add(SimpleItem.newOne(e.get(ID), e.getString("number")));
        }
    }

    public static boolean isSelfNonIndependentParent(String entityNum, Long entityId) {
        return QueryServiceHelper.exists((String)entityNum, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)entityId), InvTemplateDistributionService.nonDependentParentQF()});
    }

    public static List<SimpleItem> getAllChildNonIndependentParentByCustom(String entityNum, Object cusPropId, String cusPropLongNum, Object modelId, boolean isIncludeSelf) {
        DynamicObject cusPropDyna;
        ArrayList<SimpleItem> result = new ArrayList<SimpleItem>();
        ArrayList<Object> propIds = new ArrayList<Object>();
        if (isIncludeSelf) {
            propIds.add(cusPropId);
        }
        if ((cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn,dimension", (QFilter[])new QFilter[]{new QFilter(ID, "=", cusPropId)})) == null) {
            return result;
        }
        String dimId = cusPropDyna.getString("dimension");
        DynamicObjectCollection children = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)ID, (QFilter[])new QFilter[]{new QFilter(LONG_NUMBER, "like", (Object)(cusPropLongNum + '!' + "%")), new QFilter("dimension", "=", (Object)ConvertUtil.convertStrToLong(dimId))});
        children.forEach(e -> propIds.add(e.get(ID)));
        if (!propIds.isEmpty()) {
            QFBuilder qfBuilder = new QFBuilder(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()).and("model", "=", modelId);
            InvTemplateDistributionService.queryFromDB(entityNum, result, () -> qfBuilder);
        }
        return result;
    }

    public static List<SimpleItem> getAllChildNonIndependentParent(String entityNum, Long entityId, Object modelId, boolean isIncludeSelf) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(entityId);
        ArrayList<SimpleItem> result = new ArrayList<SimpleItem>();
        HashSet<Long> allNode = new HashSet<Long>();
        if (node != null) {
            node.getAllChildren().forEach(e -> allNode.add(e.getId()));
        }
        if (isIncludeSelf) {
            allNode.add(entityId);
        }
        if (!allNode.isEmpty()) {
            QFBuilder qfBuilder = new QFBuilder(ID, "in", (Object)allNode.toArray());
            InvTemplateDistributionService.queryFromDB(entityNum, result, () -> qfBuilder);
        }
        return result;
    }

    private static DynamicObjectCollection enableTemplate(long modelId, long year, long period, long scenario, Set<String> tmpNumbers) {
        if (tmpNumbers.isEmpty() || year == 0L || period == 0L) {
            return new DynamicObjectCollection();
        }
        Set<Long> tmplIds = QueryServiceHelper.query((String)"bcm_papertemplate", (String)ID, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "in", tmpNumbers)}).stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
        Set<Long> filterIds = PaperTemplateHelper.findTmplIdsByScene(modelId, PaperTemplateTypeEnum.INVELIM, scenario, tmplIds);
        Date endDate = PeriodUtils.calcStartAndEndDate((long)modelId, (long)year, (long)period)[1];
        QFilter expiringFilter = new QFilter("expiringdate", ">=", (Object)endDate).or("expiringdate", "is null", null);
        QFilter[] qFilters = new QFBuilder(ID, "in", filterIds).and("model", "=", (Object)modelId).and("effectivedate", "<", (Object)endDate).and(expiringFilter).toArray();
        String selectFields = new StringJoiner(",").add(ID).add("name").add("number").add("spreadjson").add("data").add("spreadtype").add("versionnumber").add("templatecatalog").add("extdimid").add("process").add("process.number").add("floatfieldorder").add("executeorder").add("group").add("status").toString();
        return QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])qFilters);
    }

    private static Pair<Set<String>, Set<String>> parentIncludeSonDistribute(long modelId, Set<Long> upParentEntityIds, Set<Long> parentProIds, String entityType) {
        String[] stringArray;
        if (entityType == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = InvSheetDistributeConstant.MemRangeComboEnum.INDEPENDENT_LEGAL_PERSON_ALL_SUB.getCode();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = String.valueOf(InvDistributeConstant.MemRangeComboEnum.ALL_SUB_NONBASE.getCode());
        }
        String[] rangs = stringArray;
        entityType = entityType == null ? "bcm_templateassignrecord" : entityType;
        HashSet<String> tmpNumbers = new HashSet<String>(16);
        QFilter[] filters = new QFBuilder("range", "in", (Object)rangs).and("model", "=", (Object)modelId).and(InvTemplateDistributionService.buildEntityProQFilter(upParentEntityIds, parentProIds)).toArray();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityType, (String)"template.number,isexcept", (QFilter[])filters);
        HashSet<String> filterNumber = new HashSet<String>(16);
        for (DynamicObject value : dynamicObjects) {
            String except = value.getString(TEMPLATE_ISEXCEPT);
            String templateNumber = value.getString(TEMPLATE_NUMBER);
            if (StringUtils.isBlank((CharSequence)templateNumber)) continue;
            if (StringUtils.isBlank((CharSequence)except) || "0".equals(except)) {
                tmpNumbers.add(templateNumber);
                continue;
            }
            filterNumber.add(templateNumber);
        }
        return Pair.onePair(tmpNumbers, filterNumber);
    }

    private static QFilter buildEntityProQFilter(Set<Long> upParentEntityIds, Set<Long> parentProIds) {
        QFilter qFilter = null;
        if (!upParentEntityIds.isEmpty()) {
            qFilter = new QFilter("entity", "in", upParentEntityIds);
        }
        if (!parentProIds.isEmpty()) {
            if (qFilter == null) {
                qFilter = new QFilter("propertyvalue", "in", parentProIds);
            } else {
                qFilter.or("propertyvalue", "in", parentProIds);
            }
        }
        return qFilter;
    }

    private static Pair<Set<String>, Set<String>> getCurrentLevelDistributeTemplate(Set<Object> entityIds, Set<Long> pros, long modelId, String entityType) {
        String[] stringArray;
        HashSet<String> tmpNumbers = new HashSet<String>(16);
        HashSet<String> filterNumber = new HashSet<String>(16);
        if (entityType == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = InvSheetDistributeConstant.MemRangeComboEnum.INDEPENDENT_LEGAL_PERSON_ALL_SUB.getCode();
            stringArray = stringArray2;
            stringArray2[1] = InvSheetDistributeConstant.MemRangeComboEnum.INDEPENDENT_LEGAL_PERSON_SELF.getCode();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = String.valueOf(InvDistributeConstant.MemRangeComboEnum.ALL_SUB_NONBASE.getCode());
            stringArray = stringArray3;
            stringArray3[1] = String.valueOf(InvDistributeConstant.MemRangeComboEnum.ONLY_SELF.getCode());
        }
        String[] rangs = stringArray;
        QFBuilder qfBuilder = new QFBuilder("range", "in", (Object)rangs).and("model", "=", (Object)modelId);
        QFilter qFilter = new QFilter("entity", "in", entityIds);
        if (!pros.isEmpty()) {
            qFilter.or("propertyvalue", "in", pros);
        }
        qfBuilder.and(qFilter);
        entityType = entityType == null ? "bcm_templateassignrecord" : entityType;
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityType, (String)"template.number,isexcept", (QFilter[])qfBuilder.toArray());
        for (DynamicObject value : dynamicObjects) {
            String except = value.getString(TEMPLATE_ISEXCEPT);
            String templateNumber = value.getString(TEMPLATE_NUMBER);
            if (StringUtils.isBlank((CharSequence)templateNumber)) continue;
            if (StringUtils.isBlank((CharSequence)except) || "0".equals(except)) {
                tmpNumbers.add(templateNumber);
                continue;
            }
            filterNumber.add(templateNumber);
        }
        return Pair.onePair(tmpNumbers, filterNumber);
    }

    private static Triple<Set<Object>, Set<String>, Set<Long>> collectIdsAndLongNumbersAndPros(long storageId) {
        int start = 1;
        int end = 11;
        HashSet<Long> pros = new HashSet<Long>(16);
        HashSet<String> parentEntityIds = new HashSet<String>(16);
        QFilter[] qFilters1 = new QFBuilder().add(InvTemplateDistributionService.nonDependentParentQF()).and(new QFilter(ID, "=", (Object)storageId).or(COPY_FROM, "=", (Object)storageId)).toArray();
        StringJoiner selectFieldsJoiner = new StringJoiner(",").add(LONG_NUMBER);
        for (int i = start; i < end; ++i) {
            selectFieldsJoiner.add(InvTemplateDistributionService.buildPropertyIdFieldName(i));
        }
        String selectFields1 = selectFieldsJoiner.toString();
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)selectFields1, (QFilter[])qFilters1);
        Set entityIds = objectDynamicObjectMap.keySet();
        for (DynamicObject dy : objectDynamicObjectMap.values()) {
            String parent = dy.getString(LONG_NUMBER);
            parentEntityIds.add(parent);
            for (int i = start; i < end; ++i) {
                long propertyId = dy.getLong(InvTemplateDistributionService.buildPropertyIdFieldName(i));
                if (propertyId == 0L) continue;
                pros.add(propertyId);
            }
        }
        return new MutableTriple(entityIds, parentEntityIds, pros);
    }

    private static String buildPropertyIdFieldName(int i) {
        return PROPERTY_ID_PREFIX + i + ".id";
    }

    private static long getStorageId(long entityId) {
        QFilter[] qFilters = new QFBuilder(ID, "=", (Object)entityId).and(InvTemplateDistributionService.nonDependentParentQF()).toArray();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)COPY_FROM, (QFilter[])qFilters);
        if (Objects.isNull(dynamicObject)) {
            return 0L;
        }
        long copyFromId = dynamicObject.getLong("copyfrom.id");
        if (copyFromId != 0L) {
            return copyFromId;
        }
        return entityId;
    }

    private static Set<Long> findParentByLongNumber(Set<String> longNumbers, long modelId, String entityName) {
        HashSet<String> parentLongNumbers = new HashSet<String>(16);
        for (String longNumber : longNumbers) {
            String[] split = longNumber.split("!");
            for (int i = 0; i < split.length - 1; ++i) {
                StringJoiner parentLongNumber = new StringJoiner("!");
                for (int j = 0; j <= i; ++j) {
                    parentLongNumber.add(split[j]);
                }
                parentLongNumbers.add(parentLongNumber.toString());
            }
        }
        QFilter[] qFilters2 = new QFBuilder(LONG_NUMBER, "in", parentLongNumbers).and("model", "=", (Object)modelId).toArray();
        return BusinessDataServiceHelper.loadFromCache((String)entityName, (String)ID, (QFilter[])qFilters2).keySet().stream().map(Long.class::cast).collect(Collectors.toSet());
    }

    private static Set<Long> findParentProIds(Set<Long> pros, long modelId) {
        HashSet<String> longNumbers = new HashSet<String>(16);
        QFilter[] qFilters = new QFBuilder(ID, "in", pros).add("model", "=", (Object)modelId).toArray();
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)LONG_NUMBER, (QFilter[])qFilters).values();
        for (DynamicObject dynamicObject : values) {
            String longNumber = dynamicObject.getString(LONG_NUMBER);
            longNumbers.add(longNumber);
        }
        return InvTemplateDistributionService.findParentByLongNumber(longNumbers, modelId, "bcm_definedpropertyvalue");
    }

    private static QFilter nonDependentParentQF() {
        return new QFilter(IS_LEAF, "=", (Object)"0").and(IS_EXCHANGE_RATE, "=", (Object)"0").and(IS_INDEPENDENT_ORG, "=", (Object)"0");
    }

    private InvTemplateDistributionService() {
    }
}

