/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetDistributeConstant;
import kd.fi.bcm.common.constant.invest.invtemplate.InvDistributeConstant;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class InvTemplateDistributionServiceHelper {
    private static final String ID = "id";
    private static final String MODEL = "model";
    private static final String COPY_FROM = "copyfrom";
    private static final String IS_LEAF = "isleaf";
    private static final String IS_INDEPENDENT_ORG = "isindependentorg";
    private static final String IS_EXCHANGE_RATE = "isexchangerate";
    private static final String PROPERTY_ID_PREFIX = "dpropertyid";
    private static final String LONG_NUMBER = "longnumber";
    private static final String TEMPLATE_NUMBER = "template.number";
    private static final String TEMPLATE_IS_EXCEPT = "isexcept";
    private static final long ZERO = 0L;
    private final long modelId;
    private final String entityType;
    private final Map<Long, Long> id2Storage;
    private final Map<Long, Set<Long>> entity2StorageId;
    private final Map<Long, Set<Long>> parentId2Storage;
    private final Map<Long, Set<String>> storageId2AllLNumber;
    private final Map<Long, Set<Long>> pro2StorageId;
    private final Map<Long, Set<Long>> proParentId2Storage;
    private final Map<Long, Set<String>> storageId2TempNumbersExcept;
    private final Map<Long, Set<String>> storageId2TempNumbersNotExcept;

    public InvTemplateDistributionServiceHelper(long modelId, String entityType) {
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6a21\u677f\u5206\u914d\u67e5\u627e\u670d\u52a1\u5f02\u5e38\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a0\u3002", (String)"InvTemplateDistributionServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!"bcm_templateassignrecord".equals(entityType) && !"bcm_invelimtplassign".equals(entityType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6a21\u677f\u5206\u914d\u67e5\u627e\u670d\u52a1\u5f02\u5e38\uff0c\u6682\u53ea\u652f\u6301\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u3001\u6743\u76ca\u5e95\u7a3f\u6a21\u677f\u7684\u5206\u914d\u3002", (String)"InvTemplateDistributionServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.modelId = modelId;
        this.entityType = entityType;
        this.id2Storage = new HashMap<Long, Long>(16);
        this.entity2StorageId = new HashMap<Long, Set<Long>>(16);
        this.parentId2Storage = new HashMap<Long, Set<Long>>(16);
        this.storageId2AllLNumber = new HashMap<Long, Set<String>>(16);
        this.pro2StorageId = new HashMap<Long, Set<Long>>(16);
        this.proParentId2Storage = new HashMap<Long, Set<Long>>(16);
        this.storageId2TempNumbersExcept = new HashMap<Long, Set<String>>(16);
        this.storageId2TempNumbersNotExcept = new HashMap<Long, Set<String>>(16);
    }

    public Map<Long, Set<String>> queryTemplateByEntityIds(Set<Long> entityIds) {
        if (CollectionUtil.isEmpty(entityIds)) {
            return Collections.emptyMap();
        }
        Map<Long, Long> id2Storage = entityIds.stream().filter(Objects::nonNull).filter(id -> id != 0L).filter(id -> MemberReader.findEntityMemberById((Long)this.modelId, (Long)id) != IDNumberTreeNode.NotFoundTreeNode).collect(Collectors.toMap(id -> id, id -> MemberReader.findEntityMemberById((Long)this.modelId, (Long)id).getBaseTreeNode().getId(), (v1, v2) -> v1));
        this.id2Storage.putAll(id2Storage);
        if (this.id2Storage.isEmpty()) {
            return Collections.emptyMap();
        }
        this.collectIdsAndLongNumbersAndPros();
        ThreadPoolService.runInWaiting4AdjustChildTaskThread(() -> this.findParentByLongNumber(this.storageId2AllLNumber, this.parentId2Storage, "bcm_entitymembertree"), this::queryCurrentLevelDistributeTemplate, this::findParentProIds);
        this.parentIncludeSonDistribute();
        HashMap<Long, Set<String>> rsMap = new HashMap<Long, Set<String>>(16);
        for (Long entityId : entityIds) {
            Long storageId = this.id2Storage.get(entityId);
            Set except = this.storageId2TempNumbersExcept.getOrDefault(storageId, Collections.emptySet());
            Set notExcept = this.storageId2TempNumbersNotExcept.getOrDefault(storageId, Collections.emptySet());
            except.removeAll(notExcept);
            rsMap.put(entityId, except);
        }
        return rsMap;
    }

    private void parentIncludeSonDistribute() {
        this.queryAndCollectDistribute(this.parentId2Storage, this.proParentId2Storage, this::parentIncludeSonRangeCodes);
    }

    private void queryCurrentLevelDistributeTemplate() {
        this.queryAndCollectDistribute(this.entity2StorageId, this.pro2StorageId, this::currentLevelRangeCodes);
    }

    private void queryAndCollectDistribute(Map<Long, Set<Long>> entityStorageMap, Map<Long, Set<Long>> pro2StorageMap, Supplier<String[]> rangesSupplier) {
        if (this.isNotNeedToHandle(entityStorageMap, pro2StorageMap)) {
            return;
        }
        Set<Long> entityIds = entityStorageMap.keySet();
        Set<Long> proIds = pro2StorageMap.keySet();
        QFilter[] filters = new QFBuilder("range", "in", (Object)rangesSupplier.get()).and(MODEL, "=", (Object)this.modelId).and(this.buildEntityProQFilter(entityIds, proIds)).toArray();
        String selectFields = new StringJoiner(",").add(TEMPLATE_NUMBER).add(TEMPLATE_IS_EXCEPT).add("entity").add("propertyvalue").toString();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.entityType, (String)selectFields, (QFilter[])filters);
        for (DynamicObject dy : dynamicObjects) {
            String templateNumber = dy.getString(TEMPLATE_NUMBER);
            if (StringUtils.isBlank((CharSequence)templateNumber)) continue;
            this.toCollection(dy, entityStorageMap, pro2StorageMap);
        }
    }

    private QFilter buildEntityProQFilter(Set<Long> entityIds, Set<Long> pros) {
        QFilter qFilter = null;
        if (!CollectionUtil.isEmpty(entityIds)) {
            qFilter = new QFilter("entity", "in", entityIds);
        }
        if (!CollectionUtil.isEmpty(pros)) {
            if (qFilter == null) {
                qFilter = new QFilter("propertyvalue", "in", pros);
            } else {
                qFilter.or("propertyvalue", "in", pros);
            }
        }
        return qFilter;
    }

    private String[] parentIncludeSonRangeCodes() {
        String[] stringArray;
        if (!"bcm_templateassignrecord".equals(this.entityType)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(InvDistributeConstant.MemRangeComboEnum.ALL_SUB_NONBASE.getCode());
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = InvSheetDistributeConstant.MemRangeComboEnum.INDEPENDENT_LEGAL_PERSON_ALL_SUB.getCode();
        }
        return stringArray;
    }

    private String[] currentLevelRangeCodes() {
        String[] stringArray;
        if (!"bcm_templateassignrecord".equals(this.entityType)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = String.valueOf(InvDistributeConstant.MemRangeComboEnum.ALL_SUB_NONBASE.getCode());
            stringArray = stringArray2;
            stringArray2[1] = String.valueOf(InvDistributeConstant.MemRangeComboEnum.ONLY_SELF.getCode());
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = InvSheetDistributeConstant.MemRangeComboEnum.INDEPENDENT_LEGAL_PERSON_ALL_SUB.getCode();
            stringArray = stringArray3;
            stringArray3[1] = InvSheetDistributeConstant.MemRangeComboEnum.INDEPENDENT_LEGAL_PERSON_SELF.getCode();
        }
        return stringArray;
    }

    private void findParentProIds() {
        if (this.pro2StorageId.isEmpty()) {
            return;
        }
        HashMap<Long, Set<String>> storage2LongNumber = new HashMap<Long, Set<String>>(16);
        Set<Long> pros = this.pro2StorageId.keySet();
        QFilter[] qFilters = new QFBuilder(ID, "in", pros).add(MODEL, "=", (Object)this.modelId).toArray();
        String selectFields = new StringJoiner(",").add(LONG_NUMBER).add(ID).toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)selectFields, (QFilter[])qFilters);
        for (DynamicObject dy : query) {
            long id = dy.getLong(ID);
            String longNumber = dy.getString(LONG_NUMBER);
            Set storageIdSet = this.pro2StorageId.getOrDefault(id, Collections.emptySet());
            for (Long storageId : storageIdSet) {
                storage2LongNumber.computeIfAbsent(storageId, key -> new HashSet(16)).add(longNumber);
            }
        }
        this.findParentByLongNumber(storage2LongNumber, this.proParentId2Storage, "bcm_definedpropertyvalue");
    }

    private void findParentByLongNumber(Map<Long, Set<String>> storageId2AllLNumber, Map<Long, Set<Long>> parentStorageMap, String entityName) {
        HashMap longNumber2StorageId = new HashMap(16);
        storageId2AllLNumber.forEach((storageId, longNumbers) -> {
            for (String longNumber : longNumbers) {
                String[] split = longNumber.split("!");
                for (int i = 0; i < split.length - 1; ++i) {
                    StringJoiner parentLongNumber = new StringJoiner("!");
                    for (int j = 0; j <= i; ++j) {
                        parentLongNumber.add(split[j]);
                    }
                    longNumber2StorageId.computeIfAbsent(parentLongNumber.toString(), key -> new HashSet(16)).add(storageId);
                }
            }
        });
        QFilter[] qFilters2 = new QFBuilder(LONG_NUMBER, "in", longNumber2StorageId.keySet()).and(MODEL, "=", (Object)this.modelId).toArray();
        String selectFields = "id,longnumber";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])qFilters2);
        for (DynamicObject dy : dynamicObjects) {
            long id = dy.getLong(ID);
            String longNumber = dy.getString(LONG_NUMBER);
            Set storageIdSet = longNumber2StorageId.getOrDefault(longNumber, Collections.emptySet());
            parentStorageMap.computeIfAbsent(id, key -> new HashSet(16)).addAll(storageIdSet);
        }
    }

    private void toCollection(DynamicObject dy, Map<Long, Set<Long>> entity2StorageId, Map<Long, Set<Long>> pro2StorageId) {
        String except = dy.getString(TEMPLATE_IS_EXCEPT);
        if (StringUtils.isBlank((CharSequence)except) || PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode().equals(except)) {
            this.toCollection(dy, this.storageId2TempNumbersExcept, entity2StorageId, pro2StorageId);
        } else {
            this.toCollection(dy, this.storageId2TempNumbersNotExcept, entity2StorageId, pro2StorageId);
        }
    }

    private void toCollection(DynamicObject dy, Map<Long, Set<String>> id2TempNumberSet, Map<Long, Set<Long>> entityStorageMap, Map<Long, Set<Long>> proStorageMap) {
        String templateNumber = dy.getString(TEMPLATE_NUMBER);
        long parentId = dy.getLong("entity");
        Set storageIdFromEntities = entityStorageMap.getOrDefault(parentId, Collections.emptySet());
        for (Long storageIdFromEntity : storageIdFromEntities) {
            id2TempNumberSet.computeIfAbsent(storageIdFromEntity, key -> new HashSet(16)).add(templateNumber);
        }
        long proParentId = dy.getLong("propertyvalue");
        Set storageIdFromPros = proStorageMap.getOrDefault(proParentId, Collections.emptySet());
        for (Long storageIdFromPro : storageIdFromPros) {
            id2TempNumberSet.computeIfAbsent(storageIdFromPro, key -> new HashSet(16)).add(templateNumber);
        }
    }

    private boolean isNotNeedToHandle(Map<Long, Set<Long>> entityStorageMap, Map<Long, Set<Long>> proStorageMap) {
        return entityStorageMap.isEmpty() && proStorageMap.isEmpty();
    }

    private void collectIdsAndLongNumbersAndPros() {
        Collection<Long> storageIds = this.id2Storage.values();
        int start = 1;
        int end = 11;
        QFilter[] qFilters = new QFBuilder().add(this.nonDependentParentQF()).and(new QFilter(ID, "in", storageIds).or(COPY_FROM, "in", storageIds)).toArray();
        StringJoiner selectFieldsJoiner = new StringJoiner(",").add(LONG_NUMBER).add(COPY_FROM).add(ID);
        for (int i = start; i < end; ++i) {
            selectFieldsJoiner.add(this.buildPropertyIdFieldName(i));
        }
        String selectFields = selectFieldsJoiner.toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selectFields, (QFilter[])qFilters);
        for (DynamicObject dy : query) {
            long storageId = dy.getLong(COPY_FROM);
            long id = dy.getLong(ID);
            if (storageId == 0L) {
                storageId = id;
            }
            this.entity2StorageId.computeIfAbsent(id, key -> new HashSet(16)).add(storageId);
            String longNumber = dy.getString(LONG_NUMBER);
            this.storageId2AllLNumber.computeIfAbsent(storageId, key -> new HashSet(16)).add(longNumber);
            for (int i = start; i < end; ++i) {
                long propertyId = dy.getLong(this.buildPropertyIdFieldName(i));
                if (propertyId == 0L) continue;
                this.pro2StorageId.computeIfAbsent(propertyId, key -> new HashSet(16)).add(storageId);
            }
        }
    }

    private QFilter nonDependentParentQF() {
        return new QFilter(IS_LEAF, "=", (Object)"0").and(IS_EXCHANGE_RATE, "=", (Object)"0").and(IS_INDEPENDENT_ORG, "=", (Object)"0");
    }

    private String buildPropertyIdFieldName(int i) {
        return PROPERTY_ID_PREFIX + i + ".id";
    }
}

