/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet;

import kd.fi.bcm.common.constant.invest.InvestConstant;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public class PositionInfo {
    private final boolean isFloatRow;
    private final int startRow;
    private final int startCol;
    private int endRow;
    private int endCol;
    private int formulaStartRow;
    private int formulaStartCol;
    private int formulaEndRow;
    private int formulaEndCol;
    private int maxExtendFloatCount;
    private int maxInvFloatCount;

    public PositionInfo(Sheet sheet, boolean isFloatRow) {
        this.isFloatRow = isFloatRow;
        this.startRow = (Integer)sheet.getUserObject("startRow");
        this.startCol = (Integer)sheet.getUserObject("startCol");
        this.endRow = sheet.getMaxRowCount();
        this.endCol = sheet.getMaxColumnCount();
        int sheetHeadLength = InvestConstant.getSheetHeadLength((String)((String)sheet.getUserObject("dimSetting_V2.0")));
        if (isFloatRow) {
            this.formulaStartRow = this.startRow + 1;
            this.formulaStartCol = this.startCol + sheetHeadLength;
        } else {
            this.formulaStartRow = this.startRow + sheetHeadLength;
            this.formulaStartCol = this.startCol + 1;
        }
        this.formulaEndRow = this.formulaStartRow;
        this.formulaEndCol = this.formulaStartCol;
    }

    public boolean isFixHeadarea(Cell cell) {
        if (this.isFloatRow) {
            return cell.getCol() >= this.startCol && cell.getCol() < this.formulaStartCol && cell.getRow() >= this.startRow && cell.getRow() <= this.formulaEndRow;
        }
        return cell.getRow() >= this.startRow && cell.getRow() < this.formulaStartRow && cell.getCol() >= this.startCol && cell.getCol() <= this.formulaEndCol;
    }

    public void resetFloatCount(int maxExtendFloatCount, int maxInvFloatCount) {
        this.maxExtendFloatCount = maxExtendFloatCount;
        this.maxInvFloatCount = maxInvFloatCount;
        if (this.isFloatRow) {
            this.formulaEndRow = this.formulaStartRow + maxInvFloatCount - 1;
            this.formulaEndCol = this.formulaStartCol + maxExtendFloatCount - 1;
        } else {
            this.formulaEndRow = this.formulaStartRow + maxExtendFloatCount - 1;
            this.formulaEndCol = this.formulaStartCol + maxInvFloatCount - 1;
        }
    }

    public boolean isFormulaFloatArea(int row, int col) {
        return row >= this.formulaStartRow && row <= this.formulaEndRow && col >= this.formulaStartCol && col <= this.formulaEndCol;
    }

    public RangeModel getFloatFormulaRangeModel(int floatIndex) {
        int y_end;
        int y_start;
        int x_end;
        int x_start;
        if (this.isFloatRow()) {
            x_start = floatIndex;
            x_end = floatIndex;
            y_start = this.formulaStartRow;
            y_end = this.formulaEndRow;
        } else {
            x_start = this.formulaStartCol;
            x_end = this.formulaEndCol;
            y_start = floatIndex;
            y_end = floatIndex;
        }
        return new RangeModel(x_start, x_end, y_start, y_end);
    }

    public RangeModel getNoFloatRangeModel(int floatIndex) {
        int y_end;
        int y_start;
        int x_end;
        int x_start;
        if (this.isFloatRow()) {
            x_start = floatIndex;
            x_end = floatIndex;
            y_start = this.formulaEndRow + 1;
            y_end = this.endRow;
        } else {
            x_start = this.formulaEndCol + 1;
            x_end = this.endCol;
            y_start = floatIndex;
            y_end = floatIndex;
        }
        return new RangeModel(x_start, x_end, y_start, y_end);
    }

    public RangeModel getNoFloatLeftRangeModel(int floatIndex) {
        int y_end;
        int y_start;
        int x_end;
        int x_start;
        if (this.isFloatRow()) {
            x_start = floatIndex;
            x_end = floatIndex;
            y_start = 0;
            y_end = this.startRow;
        } else {
            x_start = 0;
            x_end = this.startCol;
            y_start = floatIndex;
            y_end = floatIndex;
        }
        return new RangeModel(x_start, x_end, y_start, y_end);
    }

    public int maxExtendFloatCount() {
        return this.maxExtendFloatCount;
    }

    public int maxInvFloatCount() {
        return this.maxInvFloatCount;
    }

    public boolean isFloatRow() {
        return this.isFloatRow;
    }

    public int startRow() {
        return this.startRow;
    }

    public int startCol() {
        return this.startCol;
    }

    public int formulaStartRow() {
        return this.formulaStartRow;
    }

    public int formulaStartCol() {
        return this.formulaStartCol;
    }

    public int endRow() {
        return this.endRow;
    }

    public int endCol() {
        return this.endCol;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public void setEndCol(int endCol) {
        this.endCol = endCol;
    }
}

