/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.AreaFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.DefaultInvestFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.DespFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.EspFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.ExcRateFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.GetJLFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.GetinvactFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.GetinvperFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.InvFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.PFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.RefFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.VFormulaHandler;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.fel.common.StringUtils;

public class InvFormulaRegister {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvFormulaRegister.class);
    private static final String GETINSTANCE_SIGN = "InvFormulaRegister.getInstance";
    private static final String EXTERNALFORMULA_SIGN = "InvFormulaRegister.externalFormula";
    private static final DefaultInvestFormulaHandler defaultHandler = new DefaultInvestFormulaHandler();
    private static final AreaFormulaHandler areaHandler = new AreaFormulaHandler();
    private static final RefFormulaHandler refHandler = new RefFormulaHandler();
    private static final Map<String, AbstractFormulaHandler> innerRegisterMap = new ConcurrentHashMap<String, AbstractFormulaHandler>(16);
    private final Map<String, AbstractFormulaHandler> externalRegisterMap = new ConcurrentHashMap<String, AbstractFormulaHandler>(16);

    private InvFormulaRegister() {
        this.registerExternalFormula();
    }

    private static InvFormulaRegister getInstance() {
        return (InvFormulaRegister)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)GETINSTANCE_SIGN, InvFormulaRegister::new);
    }

    public static void reloadRegister() {
        CacheGenFactory.getCommonCache().invalidateByKey(GETINSTANCE_SIGN);
        CacheGenFactory.getCommonCache().invalidateByKey(EXTERNALFORMULA_SIGN);
    }

    public static AbstractFormulaHandler searchRegisteredHandler(String formulaNum) {
        String clazzPath;
        if (StringUtils.isEmpty((CharSequence)formulaNum)) {
            return InvFormulaRegister.getDefaultHandler();
        }
        AbstractFormulaHandler handler = innerRegisterMap.get(formulaNum = formulaNum.toUpperCase(Locale.ENGLISH));
        if (handler == null && (handler = InvFormulaRegister.getInstance().searchRegisteredHandlerByFnum(formulaNum)) == null && StringUtils.isNotEmpty((CharSequence)(clazzPath = InvFormulaRegister.getExternalFormulas().get(formulaNum)))) {
            handler = InvFormulaRegister.getInstance().registerFormulaBYClassPath(clazzPath);
        }
        return handler == null ? InvFormulaRegister.getDefaultHandler() : handler;
    }

    private static void registerInnerFormula() {
        InvFormulaRegister.registerInnerFormulaHandler(new EspFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new VFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new PFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new GetinvperFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new GetinvactFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new DespFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new GetJLFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new ExcRateFormulaHandler());
        InvFormulaRegister.registerInnerFormulaHandler(new InvFormulaHandler());
    }

    private static void registerInnerFormulaHandler(AbstractFormulaHandler formulaHandler) {
        innerRegisterMap.computeIfAbsent(formulaHandler.getName().toUpperCase(Locale.ENGLISH), a -> formulaHandler);
    }

    public static void registerExternalFormulaHandler(AbstractFormulaHandler formulaHandler) {
        InvFormulaRegister.getInstance().registerHandler(formulaHandler);
    }

    private static Map<String, String> getExternalFormulas() {
        return (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)EXTERNALFORMULA_SIGN, () -> {
            HashMap tmpExternalFormulas = Maps.newHashMap();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"externalFormulas", (String)"bcm_invpaperformregister", (String)"number,path", (QFilter[])QFilter.of((String)"isenable=?", (Object[])new Object[]{"1"}).toArray(), null, (int)-1);){
                ds.forEachRemaining(formulaConfig -> {
                    String number = formulaConfig.getString("number");
                    tmpExternalFormulas.computeIfAbsent(StringUtils.isEmpty((CharSequence)number) ? "" : number.toUpperCase(Locale.ENGLISH), a -> formulaConfig.getString("path"));
                });
            }
            return tmpExternalFormulas;
        });
    }

    public static DefaultInvestFormulaHandler getDefaultHandler() {
        return defaultHandler;
    }

    public static AreaFormulaHandler getAreaHandler() {
        return areaHandler;
    }

    public static RefFormulaHandler getRefHandler() {
        return refHandler;
    }

    public final void registerExternalFormula() {
        InvFormulaRegister.getExternalFormulas().forEach((number, clazzPath) -> this.registerFormulaBYClassPath((String)clazzPath));
    }

    public AbstractFormulaHandler registerFormulaBYClassPath(String clazzPath) {
        AbstractFormulaHandler handler = null;
        try {
            handler = (AbstractFormulaHandler)Class.forName(clazzPath).newInstance();
            this.registerHandler(handler);
        }
        catch (Throwable t) {
            log.error(String.format("new instance class %s fail,cause:%s", clazzPath, t.getMessage()), t);
        }
        return handler;
    }

    private void registerHandler(AbstractFormulaHandler formulaHandler) {
        if (innerRegisterMap.containsKey(formulaHandler.getName())) {
            return;
        }
        this.externalRegisterMap.computeIfAbsent(formulaHandler.getName().toUpperCase(Locale.ENGLISH), a -> formulaHandler);
    }

    private AbstractFormulaHandler searchRegisteredHandlerByFnum(String formulaName) {
        return this.externalRegisterMap.get(formulaName == null ? "" : formulaName.toUpperCase(Locale.ENGLISH));
    }

    static {
        InvFormulaRegister.registerInnerFormula();
    }
}

