/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula;

import kd.bos.cache.ThreadCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.IFormulaHandle;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvFormulaParam;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.Sheet;

public class InvestDefaultSpreadFormulaValueHandler
implements IFormulaHandle {
    private final ICalContext _ctx;
    private final Sheet effectiveSheet;

    public InvestDefaultSpreadFormulaValueHandler(ICalContext _ctx, Sheet effectiveSheet) {
        this._ctx = _ctx;
        this.effectiveSheet = effectiveSheet;
    }

    @Override
    public void handle(IFormula f) {
        if (f.hasException()) {
            return;
        }
        try {
            InvCalcLine line = null;
            String cellReference = f.getCellReference();
            if (!StringUtil.isEmptyString((String)cellReference)) {
                Point point = ExcelUtils.pos2Point((String)cellReference);
                line = (InvCalcLine)BcmThreadCache.get((Object)"searchCalcLine", (Object)this.effectiveSheet.hashCode(), (Object)((Boolean)this._ctx.getProperty("isFlowRow") != false ? point.y : point.x), () -> {
                    InvFormulaParam param = (InvFormulaParam)this._ctx.getProperty("InvFormulaParam");
                    long orgUnitId = (Long)this._ctx.getProperty("orgId");
                    long executeOrgId = (Long)this._ctx.getProperty("executeOrgId");
                    InvCalcLine lineTemp = new InvCalcLine();
                    InvestFormulaParseHelper.resetInvCalcLine(this._ctx.getCubeNumber(), orgUnitId, executeOrgId, this.effectiveSheet, lineTemp, this.effectiveSheet.getCell(point.y, point.x, false), param);
                    return lineTemp;
                });
            }
            line = line == null ? (InvCalcLine)ThreadCache.get((Object)"searchCalcLine_None", InvCalcLine::new) : line;
            line.setFromSpread(true);
            InvestFormulaParseHelper.walkBeforeCalExpress(this._ctx, f, line);
        }
        catch (Throwable t) {
            f.setException((Exception)((Object)new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0])));
        }
    }
}

