/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.invest.sheet.InvLimSheetHeadInfo;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class InvestFormulaContext
extends AbstractContext {
    private Long cslschemeId;
    private Long mergeOrgId;
    private Long executeOrgId;
    private IDNumberTreeNode mergeNode = null;
    private boolean isFlowRow = false;
    private List<InvLimSheetHeadInfo> relas = null;
    private SchemeContext sctx;
    private SpreadManager sm = null;
    private final HashMultimap<String, String> refPathParserPool = HashMultimap.create();
    private final Set<String> circularRefSet = new HashSet<String>();
    Integer maxFloatCount;

    public InvestFormulaContext(long modelId, long scenarioId, long fyId, long periodId) {
        super(modelId, scenarioId, fyId, periodId);
    }

    public void setSheet(SpreadManager sm) {
        this.sm = sm;
    }

    public SpreadManager getSheet() {
        return this.sm;
    }

    public Cell getCell(int row, int col) {
        return this.getCell(row, col, true);
    }

    public Cell getCell(int row, int col, boolean isCreated) {
        if (this.sm == null) {
            return null;
        }
        return this.sm.getBook().getSheet(0).getCell(row, col, isCreated);
    }

    public boolean addExrToRefPosPool(String srcPos, String tarPos) {
        this.refPathParserPool.put((Object)srcPos, (Object)tarPos);
        ArrayList<String> pahList = new ArrayList<String>(16);
        if (this.checkCircularReference(srcPos, pahList)) {
            this.circularRefSet.add(srcPos);
            return false;
        }
        return true;
    }

    private boolean checkCircularReference(String tarPos, List<String> pahList) {
        if (this.circularRefSet.contains(tarPos)) {
            return true;
        }
        Set refPosSet = this.refPathParserPool.get((Object)tarPos);
        if (CollectionUtils.isEmpty((Collection)refPosSet)) {
            return false;
        }
        for (String refPos : refPosSet) {
            if (pahList.contains(refPos)) {
                this.circularRefSet.add(refPos);
                return true;
            }
            pahList.add(refPos);
            if (this.checkCircularReference(refPos, pahList)) {
                this.circularRefSet.add(refPos);
                pahList.remove(pahList.size() - 1);
                return true;
            }
            pahList.remove(pahList.size() - 1);
        }
        return false;
    }

    public void clear() {
        this.circularRefSet.clear();
        this.refPathParserPool.clear();
    }

    public boolean isFlowRow() {
        return this.isFlowRow;
    }

    public void setFlowRow(boolean flowRow) {
        this.isFlowRow = flowRow;
    }

    public IDNumberTreeNode queryMergeOrg() {
        if (this.mergeNode == null) {
            this.mergeNode = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)this.getMergeOrgId());
        }
        return this.mergeNode;
    }

    public SchemeContext getSctx() {
        if (this.sctx == null) {
            this.sctx = SchemeContext.getInstance(this.getModelId());
        }
        return this.sctx;
    }

    public Long getCslschemeId() {
        return this.cslschemeId;
    }

    public void setCslschemeId(Long cslschemeId) {
        this.cslschemeId = cslschemeId;
        this.mergeNode = null;
    }

    public Long getMergeOrgId() {
        return this.mergeOrgId;
    }

    public void setMergeOrgId(Long mergeOrgId) {
        this.mergeOrgId = mergeOrgId;
    }

    public int getMaxFloatCount() {
        Sheet sheet = this.getSheet().getBook().getSheet(0);
        this.maxFloatCount = this.isFlowRow() ? Integer.valueOf(sheet.getMaxColumnCount()) : Integer.valueOf(sheet.getMaxRowCount());
        return this.maxFloatCount;
    }

    public void setRelas(List<InvLimSheetHeadInfo> relas) {
        this.relas = relas;
    }

    public List<InvLimSheetHeadInfo> getRelas() {
        return this.relas;
    }

    public boolean isRefInDataPos(int row, int col) {
        int startRow = (Integer)this.getSheet().getBook().getSheet(0).getUserObject("startRow");
        int startCol = (Integer)this.getSheet().getBook().getSheet(0).getUserObject("startCol");
        int floatCount = (Integer)this.getSheet().getBook().getSheet(0).getUserObject("inv_relation_count");
        if (this.isFlowRow()) {
            return row <= startRow + floatCount && row >= startRow;
        }
        return col <= startCol + floatCount && col >= startCol;
    }

    public Long getExecuteOrgId() {
        return this.executeOrgId;
    }

    public void setExecuteOrgId(Long executeOrgId) {
        this.executeOrgId = executeOrgId;
    }
}

