/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.model.PFormulaLogInfo;
import kd.fi.bcm.business.invest.sheet.InvPaperSheetIteratorService;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvFormulaParam;
import kd.fi.bcm.business.invest.sheet.formula.InvFormulaRegister;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.AreaExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class InvestFormulaParseHelper {
    public static final String HOLDERORG = "$HOLDERORG";
    public static final String INVESTORG = "$INVESTORG";
    public static final String INVESTORGEC = "$INVESTORGEC";
    public static final String INVESTORGPC = "$INVESTORGPC";
    public static final String HOLDERORGEC = "$HOLDERORGEC";
    public static final String HOLDERORGPC = "$HOLDERORGPC";
    public static final String COMMONORGEC = "$COMMONORGEC";

    private InvestFormulaParseHelper() {
        throw new IllegalStateException("Utility class");
    }

    @Deprecated
    public static void registerFormulaHandler(AbstractFormulaHandler formulaHandler) {
        InvFormulaRegister.registerExternalFormulaHandler(formulaHandler);
    }

    public static Pair<String, PFormulaLogInfo> buildWholePChildFormula(InvestFormulaContext ctx, InvCalcLine line, Function<InvCalcLine, Expression> func) {
        line.setHasPFormulaCell(true);
        PFormulaLogInfo.createLogPoint();
        if (line.getRow() != null && line.getCol() != null) {
            PFormulaLogInfo.setIndex(((AtomicInteger)ThreadCache.get((Object)ExcelUtils.xy2Pos((int)line.getRow(), (int)line.getCol()), AtomicInteger::new)).incrementAndGet());
        }
        StringJoiner sectionFormulas = new StringJoiner("+");
        Optional p = Optional.ofNullable(ctx.getPeriodNum());
        do {
            p.ifPresent(periodNum -> {
                String childFormula = InvestFormulaParseHelper.createSinglePChildFormula(ctx, line, periodNum, func);
                sectionFormulas.add(childFormula);
                PFormulaLogInfo.get().addChildFormulaLog((String)periodNum, childFormula);
            });
        } while (p.isPresent() && !PeriodUtils.isFirstPeriod((String)ctx.getModelNum(), (String)p.get()) && (p = PeriodUtils.getLastPeriod((String)ctx.getModelNum(), (String)ctx.getFyNum(), (String)p.get(), (boolean)true)).isPresent());
        line.setHasPFormulaCell(false);
        PFormulaLogInfo pFormulaLogInfo = PFormulaLogInfo.removeLogPoint();
        return Pair.onePair((Object)sectionFormulas.toString(), (Object)pFormulaLogInfo);
    }

    private static String createSinglePChildFormula(InvestFormulaContext ctx, InvCalcLine line, String periodNum, Function<InvCalcLine, Expression> func) {
        Optional lastPeriod;
        StringBuilder sectionFormulas = new StringBuilder();
        line.setLastPeriod4V(periodNum);
        line.setLaspPeriod4Esp(periodNum);
        sectionFormulas.append(func.apply(line).toString());
        if (!PeriodUtils.isFirstPeriod((String)ctx.getModelNum(), (String)periodNum) && (lastPeriod = PeriodUtils.getLastPeriod((String)ctx.getModelNum(), (String)ctx.getFyNum(), (String)line.getLastPeriod4V(), (boolean)true)).isPresent()) {
            sectionFormulas.append("-");
            line.setLastPeriod4V((String)lastPeriod.get());
            line.setLaspPeriod4Esp(periodNum);
            sectionFormulas.append(func.apply(line).toString());
        }
        return sectionFormulas.toString();
    }

    public static String getEntityNumBySpecialSign(String shareHolder, String investOrg, String orgNum) {
        if (HOLDERORG.equalsIgnoreCase(orgNum) || "HOLDER".equalsIgnoreCase(orgNum) || "HOLDERORG".equalsIgnoreCase(orgNum)) {
            return shareHolder;
        }
        if (INVESTORG.equalsIgnoreCase(orgNum) || "INVESTORG".equalsIgnoreCase(orgNum)) {
            return investOrg;
        }
        return orgNum;
    }

    public static String getCurrencyNumBySpecSign(Long modelId, Long scene, Long fyId, Long period, Long unitId, String specialExpress, InvCalcLine line, List<Long> relaCslConfigPks) {
        if (specialExpress != null) {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            switch (specialExpress.toUpperCase(Locale.ENGLISH)) {
                case "$INVESTORGEC": 
                case "INVESTORGEC": {
                    specialExpress = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Entity", (String)line.getInvest()).getCurrency();
                    break;
                }
                case "$INVESTORGPC": 
                case "INVESTORGPC": {
                    IDNumberTreeNode investNode = (IDNumberTreeNode)InvestServiceHelper.queryEffectiveOrgNodeWithRelaCsls((Long)modelId, (Long)scene, (Long)fyId, (Long)period, (Long)unitId, (String)line.getInvest(), relaCslConfigPks).p2;
                    if (investNode == IDNumberTreeNode.NotFoundTreeNode) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u4e0b\u627e\u4e0d\u5230\u53ef\u7528\u7684\u88ab\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvestFormulaParseHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    specialExpress = investNode.getParent().getCurrency();
                    break;
                }
                case "$HOLDERORGEC": 
                case "HOLDERORGEC": 
                case "HOLDEREC": {
                    specialExpress = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Entity", (String)line.holder).getCurrency();
                    break;
                }
                case "$HOLDERORGPC": 
                case "HOLDERORGPC": {
                    IDNumberTreeNode holderNode = (IDNumberTreeNode)InvestServiceHelper.queryEffectiveOrgNodeWithRelaCsls((Long)modelId, (Long)scene, (Long)fyId, (Long)period, (Long)unitId, (String)line.getHolder(), relaCslConfigPks).p2;
                    if (holderNode == IDNumberTreeNode.NotFoundTreeNode) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u5e76\u8282\u70b9\u4e0b\u627e\u4e0d\u5230\u53ef\u7528\u7684\u6295\u8d44\u5355\u4f4d\u3002", (String)"InvestFormulaParseHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    specialExpress = holderNode.getParent().getCurrency();
                    break;
                }
                case "$COMMONORGEC": 
                case "COMMONORGEC": {
                    specialExpress = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)line.getUnitId()).getCurrency();
                    break;
                }
            }
        }
        return specialExpress;
    }

    public static String getTransOrgAndCurbyOrgId(IDNumberTreeNode unitOrgNode, IDNumberTreeNode detailOrgNode, String bpNum, String curNum) {
        if ("DC".equals(curNum)) {
            String string = curNum = OrgRelaProcessMembPool.isRelaProcess((String)bpNum) || "RAdj".equals(bpNum) ? "PC" : "EC";
        }
        if ("PC".equals(curNum)) {
            return unitOrgNode.getCurrency();
        }
        if ("EC".equals(curNum)) {
            return detailOrgNode.getCurrency();
        }
        return curNum;
    }

    public static Expression walkFloatExpress(InvestFormulaContext ctx, Expression expression, InvCalcLine line) {
        return AdjustFormulaParseHelper.walkExpress(expression, expr -> {
            if (expr instanceof ReferenceExpr) {
                return InvFormulaRegister.getRefHandler().dealFloatFormula(ctx, (Expression)expr, line);
            }
            if (expr instanceof AreaExpr) {
                return InvFormulaRegister.getAreaHandler().dealFloatFormula(ctx, (Expression)expr, line);
            }
            if (expr instanceof FunctionExpr) {
                return InvFormulaRegister.getDefaultHandler().dealFloatFormula(ctx, (Expression)expr, line);
            }
            return expr;
        });
    }

    public static Expression walkExpress(InvestFormulaContext ctx, Expression expression, InvCalcLine line) {
        return AdjustFormulaParseHelper.walkExpress(expression, expr -> {
            if (expr instanceof ReferenceExpr) {
                expr = InvFormulaRegister.getRefHandler().dealFormula(ctx, (Expression)expr, line);
            } else if (expr instanceof FunctionExpr) {
                expr = InvFormulaRegister.searchRegisteredHandler(((FunctionExpr)expr).getFuncionName()).dealFormula(ctx, (Expression)expr, line);
            }
            return expr;
        });
    }

    public static void walkBeforeCalExpress(ICalContext _ctx, IFormula f, InvCalcLine line) {
        InvFormulaRegister.searchRegisteredHandler(f.getName()).dealBeforeCalFormula(_ctx, f, line);
    }

    public static void resetInvCalcLine(String modelNum, long mergeOrgId, long executeOrgId, Sheet sheet, InvCalcLine line, Cell cell, InvFormulaParam param) {
        line.clear();
        String spreadFlowType = sheet.getUserObject().get("spreadtype") + "";
        InvPaperSheetIteratorService iteratorService = (InvPaperSheetIteratorService)ThreadCache.get((Object)sheet.hashCode(), () -> new InvPaperSheetIteratorService(sheet, spreadFlowType));
        iteratorService.findHeadCells(cell.getRow(), cell.getCol(), (rltCell, orgCell, shareholderCell, investedCell, accCell) -> {
            line.setHolderId((Long)shareholderCell.getUserObject("id", (Object)0L));
            line.setInvestId((Long)investedCell.getUserObject("id", (Object)0L));
            line.setUnitId((Long)orgCell.getUserObject("id", (Object)0L));
            line.setRelationType((String)rltCell.getUserObject().get((Object)InvRelaTypeEnum.class.getSimpleName()));
            line.setCatalog((String)rltCell.getUserObject().get((Object)InvRelationTypeConstant.CatalogEnum.class.getSimpleName()));
        });
        line.setProcess(param.getProcess());
        if (LongUtil.isvalidLong((Object)line.getHolderId())) {
            line.setHolder(BcmThreadCache.findNodeById((String)modelNum, (String)"InternalCompany", (long)line.getHolderId()).getNumber());
        }
        if (LongUtil.isvalidLong((Object)line.getInvestId())) {
            line.setInvest(BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)line.getInvestId()).getNumber());
        }
        if (!LongUtil.isvalidLong((Object)line.getUnitId())) {
            line.setUnitId(mergeOrgId);
        }
        line.setUnitNum(BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)line.getUnitId()).getNumber());
        line.setExcuteOrgId(executeOrgId);
    }

    public static FunctionExpr createFunctionExpr(String funcName, Object ... exprsParms) {
        FunctionExpr functionExpr = new FunctionExpr(funcName);
        for (Object exprsParm : exprsParms) {
            if (exprsParm == null) {
                functionExpr.getParameters().add(new StringExpr(""));
                continue;
            }
            if (exprsParm instanceof String) {
                functionExpr.getParameters().add(new StringExpr(exprsParm.toString()));
                continue;
            }
            if (exprsParm instanceof Expression) {
                functionExpr.getParameters().add(exprsParm);
                continue;
            }
            functionExpr.getParameters().add(InvestFormulaParseHelper.parseFormula(exprsParm.toString()));
        }
        return functionExpr;
    }

    public static Expression parseFormula(String formula) {
        Expression expr_Temp = null;
        try {
            expr_Temp = ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Throwable e) {
            return new StringExpr(String.format(ResManager.loadKDString((String)"\u516c\u5f0f%1$s\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"InvestFormulaParseHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), formula, ThrowableHelper.toString((Throwable)e)));
        }
        return expr_Temp;
    }

    public static String handelParam(Object p) {
        return p == null ? "" : p.toString().trim().replace("\"", "");
    }

    public static BigDecimal delTailZero(BigDecimal bigDecimal) {
        DecimalFormat decimalFormat = new DecimalFormat("####.###############");
        return new BigDecimal(decimalFormat.format(bigDecimal));
    }

    public static String plantPFormulaLogInfoString(Collection<PFormulaLogInfo> pFormulaLogInfoList) {
        StringJoiner sj = new StringJoiner("\n");
        sj.add(ResManager.loadKDString((String)"\u5206\u6bb5\u8ba1\u7b97\u5b50\u89e3\u6790\u8fc7\u7a0b \uff1a ", (String)"InvestFormulaParseHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        for (PFormulaLogInfo pFormulaLogInfo : pFormulaLogInfoList) {
            sj.add(pFormulaLogInfo.toString());
        }
        return sj.toString();
    }
}

