/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.invest.model.InvestFormulaLog;
import kd.fi.bcm.business.invest.sheet.InvLimSheetHeadInfo;
import kd.fi.bcm.business.invest.sheet.InvPaperSheetIteratorService;
import kd.fi.bcm.business.invest.sheet.PositionInfo;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvFormulaParam;
import kd.fi.bcm.business.invest.sheet.formula.InvestCalContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestDefaultSpreadFormulaValueHandler;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.InvestSheetDataProvider;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.InvestConstant;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.datacollect.ReportCalculateHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class InvestSpreadFormulaHandler {
    public static final String ORIGINAL_FORMULA = "fo";
    public static final String ORIGINAL_VALUE = "vo";
    public static final String FLOAT_FORMULA = "ff";
    public static final String OUTAREA_FORMULA = "Of";
    public static final String FORMULA_PROCESS = "fp";
    public static final String FORMULA_SHOWSTYLE = "fs";
    public static final String ELIM_ID = "eid";
    public static final String NEWDATA_2_0 = "NEWDATA_2.0";
    public static final String NEWDATA = "NEWDATA";
    public static final String HAS_INV_PARSE_ERR = "hasInvParseErr";
    public static final String USER_FORMULA = "user_formula";
    public static final String CELL_CHANGE_FLAG = "isChanged";
    private final InvestFormulaContext ctx;
    private Expression tempExpr;

    public InvestSpreadFormulaHandler(InvestFormulaContext ctx) {
        this.ctx = ctx;
    }

    public void autoFloatFormula(SpreadManager sm, Long orgUnitId, List<InvLimSheetHeadInfo> relas, String spreadType) {
        this.initInvestFormulaContext(sm, orgUnitId, relas, spreadType);
        PositionInfo p = new PositionInfo(this.getEffectiveSheet(), this.ctx.isFlowRow());
        p.resetFloatCount(this.ctx.getMaxFloatCount(), this.ctx.getRelas().size());
        if (this.ctx.isFlowRow()) {
            this.getEffectiveSheet().insertRangeRows(0, p.endCol(), p.formulaStartRow() + 1, p.maxInvFloatCount() - 1);
        } else {
            this.getEffectiveSheet().insertRangeCols(0, p.endRow(), p.formulaStartCol() + 1, p.maxInvFloatCount() - 1);
        }
        p.setEndRow(this.getEffectiveSheet().getMaxRowCount());
        p.setEndCol(this.getEffectiveSheet().getMaxColumnCount());
        this.setInvestRelaHead(p);
        InvCalcLine cal = new InvCalcLine();
        for (int flowcount = 0; flowcount <= p.maxExtendFloatCount(); ++flowcount) {
            this.floatInsideFormulaArea(p, flowcount, cal);
            this.floatOutsideFormulaArea(p, flowcount, cal);
        }
    }

    private void initInvestFormulaContext(SpreadManager sm, Long orgUnitId, List<InvLimSheetHeadInfo> relas, String spreadType) {
        this.ctx.setSheet(sm);
        this.ctx.setFlowRow(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_ROW.getCode().equals(spreadType));
        this.ctx.setMergeOrgId(orgUnitId);
        this.ctx.setRelas(relas);
        this.getEffectiveSheet().putUserObject("inv_relation_count", (Object)relas.size());
        this.signNewData();
    }

    private void setInvestRelaHead(PositionInfo p) {
        int offset = 1;
        for (InvLimSheetHeadInfo headInfo : this.ctx.getRelas()) {
            this.updateInvestRelaHead(p.startRow(), p.startCol(), offset, headInfo);
            ++offset;
        }
    }

    private void floatInsideFormulaArea(PositionInfo p, int flowcount, InvCalcLine cal) {
        cal.setHasRelativeCell(false);
        RangeModel rangeModel = p.getFloatFormulaRangeModel(flowcount);
        Cell headCell = this.getEffectiveSheet().getCell(rangeModel.getY_start(), rangeModel.getX_start(), false);
        if (headCell != null && !p.isFixHeadarea(headCell)) {
            Object value;
            String formulaStr = InvestSpreadFormulaHandler.getCellOriginalFormula(headCell, ORIGINAL_FORMULA);
            if (StringUtils.isNotEmpty((String)formulaStr)) {
                headCell.getUserObject().put((Object)ORIGINAL_FORMULA, (Object)formulaStr);
            }
            if ((value = InvestSpreadFormulaHandler.getCellOriginalValue(headCell, ORIGINAL_VALUE)) != null) {
                headCell.getUserObject().put((Object)ORIGINAL_VALUE, value);
            }
            this.getEffectiveSheet().iteratorRangeCells(rangeModel, true, cell -> {
                cal.setRow(cell.getRow());
                cal.setCol(cell.getCol());
                cell.removeUserObject(FLOAT_FORMULA);
                if (Objects.nonNull(cell.getUserObject(USER_FORMULA))) {
                    Object o = cell.getUserObject().get((Object)USER_FORMULA);
                    String uf = o instanceof Boolean ? cell.getFormula() : (String)o;
                    cell.setFormula(uf);
                } else if (Objects.nonNull(cell.getUserObject(CELL_CHANGE_FLAG))) {
                    cell.setFormula(null);
                } else if (StringUtils.isNotEmpty((String)formulaStr)) {
                    this.walkFloatFormulaCell(this.ctx, cal, formulaStr);
                } else if (Objects.nonNull(value)) {
                    cell.setFormula(null);
                    cell.setValue(value);
                }
                cal.incrementOffset();
            });
            cal.resetOffSet();
        }
    }

    private void floatOutsideFormulaArea(PositionInfo p, int flowcount, InvCalcLine cal) {
        cal.setHasRelativeCell(false);
        RangeModel rangeModel = p.getNoFloatRangeModel(flowcount);
        this.getEffectiveSheet().iteratorRangeCells(rangeModel, false, tempCell -> this.excuteNofloatArea(cal, (Cell)tempCell));
        RangeModel leftRangeModel = p.getNoFloatLeftRangeModel(flowcount);
        this.getEffectiveSheet().iteratorRangeCells(leftRangeModel, false, tempCell -> this.excuteNofloatArea(cal, (Cell)tempCell));
    }

    private void excuteNofloatArea(InvCalcLine cal, Cell tempCell) {
        if (tempCell.hasFormula()) {
            String formula = (String)tempCell.getUserObject().get((Object)ORIGINAL_FORMULA);
            if (StringUtils.isEmpty((String)formula)) {
                formula = tempCell.getFormula();
                tempCell.getUserObject().put((Object)ORIGINAL_FORMULA, (Object)formula);
            }
            cal.setHasRelativeCell(true);
            cal.setCol(tempCell.getCol());
            cal.setRow(tempCell.getRow());
            this.walkFloatFormulaCell(this.ctx, cal, formula);
        }
    }

    public void floatSheetFormula(SpreadManager sm, Long orgUnitId, String spreadType, int floatCount) {
        this.ctx.clear();
        this.ctx.setSheet(sm);
        this.ctx.setFlowRow(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_ROW.getCode().equals(spreadType));
        this.ctx.setMergeOrgId(orgUnitId);
        this.signNewData();
        PositionInfo p = new PositionInfo(this.getEffectiveSheet(), this.ctx.isFlowRow());
        p.resetFloatCount(this.ctx.getMaxFloatCount(), floatCount);
        p.setEndRow(this.getEffectiveSheet().getMaxRowCount());
        p.setEndCol(this.getEffectiveSheet().getMaxColumnCount());
        InvCalcLine cal = new InvCalcLine();
        for (int flowcount = 0; flowcount <= p.maxExtendFloatCount(); ++flowcount) {
            this.floatInsideFormulaArea(p, flowcount, cal);
            this.floatOutsideFormulaArea(p, flowcount, cal);
        }
    }

    public void addEndRowOrCol(int floatCount, int startRow, int startCol) {
        if (this.ctx.isFlowRow()) {
            this.getEffectiveSheet().insertRangeRows(0, this.ctx.getMaxFloatCount(), startRow + floatCount, 1);
        } else {
            this.getEffectiveSheet().insertRangeCols(0, this.ctx.getMaxFloatCount(), startCol + floatCount, 1);
        }
    }

    public void updateInvestRelaHead(int startRow, int startCol, int offset, InvLimSheetHeadInfo headInfo) {
        int sheetHeadLength = InvestConstant.getSheetHeadLength((String)((String)this.getEffectiveSheet().getUserObject("dimSetting_V2.0")));
        int investedCompanyOffSet = sheetHeadLength - 1;
        int shareholderOffSet = sheetHeadLength - 2;
        int orgOffSet = sheetHeadLength - 3;
        if (this.ctx.isFlowRow()) {
            this.dealDimensionCellValue(startRow + offset, startCol + orgOffSet, "Entity", headInfo.getUnitOrgId());
            this.dealDimensionCellValue(startRow + offset, startCol + shareholderOffSet, "InternalCompany", headInfo.getShareholderId());
            this.dealDimensionCellValue(startRow + offset, startCol + investedCompanyOffSet, "Entity", headInfo.getInvestedCompanyId());
            this.signRelationType(startRow + offset, startCol, headInfo);
        } else {
            this.dealDimensionCellValue(startRow + orgOffSet, startCol + offset, "Entity", headInfo.getUnitOrgId());
            this.dealDimensionCellValue(startRow + shareholderOffSet, startCol + offset, "InternalCompany", headInfo.getShareholderId());
            this.dealDimensionCellValue(startRow + investedCompanyOffSet, startCol + offset, "Entity", headInfo.getInvestedCompanyId());
            this.signRelationType(startRow, startCol + offset, headInfo);
        }
    }

    private void signRelationType(int row, int col, InvLimSheetHeadInfo headInfo) {
        Cell cell = this.getEffectiveSheet().getCell(row, col);
        cell.setValue((Object)headInfo.getRelationTypeName());
        cell.setUserObject(InvRelaTypeEnum.class.getSimpleName(), (Object)headInfo.getRelationType());
        cell.setUserObject(InvRelationTypeConstant.CatalogEnum.class.getSimpleName(), (Object)headInfo.getCategorized());
    }

    private void walkFloatFormulaCell(InvestFormulaContext ctx, InvCalcLine cal, String formula) {
        if (StringUtils.isEmpty((String)formula)) {
            return;
        }
        Cell cell = this.getEffectiveSheet().getCell(cal.getRow().intValue(), cal.getCol().intValue(), true);
        try {
            this.tempExpr = ExcelFormulaPaserHelper.parse((String)formula);
            if (ObjectUtils.isEmpty((Object)this.tempExpr)) {
                return;
            }
            this.tempExpr = InvestFormulaParseHelper.walkFloatExpress(ctx, this.tempExpr, cal);
            cal.setRuleExpr(this.tempExpr.toString());
        }
        catch (Exception e) {
            cal.setRuleExpr(String.format(this.getErrorMsg(), formula, ThrowableHelper.toString((Exception)e)));
        }
        cell.getUserObject().put((Object)FLOAT_FORMULA, (Object)cal.getRuleExpr());
    }

    public List<String> calculateSpreadManagerFormulas(Long orgUnitId, SpreadManager sm, InvFormulaParam param) {
        Integer count = (Integer)sm.getBook().getSheet(0).getUserObject("inv_relation_count");
        if (count != null && count == 0) {
            return Collections.emptyList();
        }
        this.ctx.clear();
        this.ctx.setMergeOrgId(orgUnitId);
        this.ctx.setSheet(sm);
        String spreadFlowType = this.getEffectiveSheet().getUserObject().get("spreadtype") + "";
        this.ctx.setFlowRow(InvSheetTemplateConstant.SpreadTypeEnum.FLOAT_ROW.getCode().equals(spreadFlowType));
        InvestCalContext calContext = new InvestCalContext(this.ctx.getModelNum(), this.ctx.queryMergeOrg().getNumber(), this.ctx.getFyNum(), this.ctx.getPeriodNum(), this.ctx.getScenariodNum(), this.ctx.queryMergeOrg().getCurrency());
        calContext.setProperty("cslscheme", this.ctx.getCslschemeId());
        calContext.setProperty("model", this.ctx.getModelId());
        calContext.setProperty("modelId", this.ctx.getModelId());
        calContext.setProperty("yearId", this.ctx.getFyId());
        calContext.setProperty("periodId", this.ctx.getPeriodId());
        calContext.setProperty("scenarioId", this.ctx.getScenarioId());
        calContext.setProperty("orgId", orgUnitId);
        calContext.setProperty("executeOrgId", this.ctx.getExecuteOrgId());
        calContext.setProperty("orgUnitNumber", MemberReader.findEntityMemberById((String)this.ctx.getModelNum(), (Long)orgUnitId).getNumber());
        calContext.setProperty("sheet", sm);
        calContext.setProperty("isFlowRow", this.ctx.isFlowRow());
        calContext.setProperty("needCheckPerm", ConfigServiceHelper.getBoolParam(this.ctx.getModelId(), "CM063"));
        calContext.setProperty("InvFormulaParam", param);
        this.resolveSpreadManagerFormulas(this.ctx, param);
        calContext.setDefaultParamHandle(new InvestDefaultSpreadFormulaValueHandler(calContext, this.getEffectiveSheet()));
        calContext.setExternalDataProvider(new InvestSheetDataProvider(this.getEffectiveSheet()));
        ThreadCache.put((Object)"calculateSpreadManagerFormulas", (Object)"");
        InvPaperSheetIteratorService iteratorService = new InvPaperSheetIteratorService(sm.getBook().getSheet(0), spreadFlowType);
        List<String> resultList = ReportCalculateHelper.calculateSheet(sm.getBook().getSheet(0), calContext, this::isNeedCalculate, errorMsg -> {
            if (InvestFormulaLog.exist()) {
                Point p = ExcelUtils.pos2Point((String)errorMsg.getDims());
                iteratorService.findHeadCells(p.y, p.x, (rltCell, orgCell, shareholderCell, investedCell, accCell) -> {
                    String holder = null;
                    String invest = null;
                    if (Objects.nonNull(shareholderCell.getUserObject("id")) && Objects.nonNull(investedCell.getUserObject("id"))) {
                        holder = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"InternalCompany", (long)((Long)shareholderCell.getUserObject("id"))).getNumber();
                        invest = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)((Long)investedCell.getUserObject("id"))).getNumber();
                    }
                    String relaType = (String)rltCell.getUserObject().get((Object)InvRelaTypeEnum.class.getSimpleName());
                    String catalog = (String)rltCell.getUserObject().get((Object)InvRelationTypeConstant.CatalogEnum.class.getSimpleName());
                    String accNum = (String)accCell.getUserObject().get((Object)"number");
                    InvestFormulaLog.addErrorLog(catalog, relaType, holder, invest, accNum, errorMsg.getDims(), errorMsg.getFormula(), errorMsg.getError());
                });
            }
        });
        ThreadCache.remove((Object)"calculateSpreadManagerFormulas");
        return resultList;
    }

    public void resolveSpreadManagerFormulas(InvestFormulaContext ctx, InvFormulaParam param) {
        if (this.isOldData()) {
            return;
        }
        PositionInfo p = new PositionInfo(this.getEffectiveSheet(), ctx.isFlowRow());
        Integer count = (Integer)this.getEffectiveSheet().getUserObject("inv_relation_count");
        p.resetFloatCount(ctx.getMaxFloatCount(), count);
        InvCalcLine line = new InvCalcLine();
        ctx.getSheet().getBook().getSheet(0).iteratorRangeCells(0, p.endRow(), 0, p.endCol(), cell -> {
            String formula;
            if (!p.isFixHeadarea((Cell)cell) && StringUtils.isNotEmpty((String)(formula = InvestSpreadFormulaHandler.getRealCellFormula(cell, FLOAT_FORMULA)))) {
                try {
                    InvestFormulaParseHelper.resetInvCalcLine(ctx.getModelNum(), ctx.getMergeOrgId(), ctx.getExecuteOrgId(), this.getEffectiveSheet(), line, cell, param);
                    line.setFromSpread(true);
                    line.setRow(cell.getRow());
                    line.setCol(cell.getCol());
                    this.tempExpr = ExcelFormulaPaserHelper.parse((String)formula);
                    if (this.tempExpr == null || this.tempExpr instanceof StringExpr) {
                        cell.setFormula(null);
                    } else {
                        this.tempExpr = InvestFormulaParseHelper.walkExpress(ctx, this.tempExpr, line);
                        cell.setFormula(this.tempExpr.toString());
                        if (cell.getUserObject().containsKey((Object)"PFormulaProcess")) {
                            cell.setUserObject(FORMULA_SHOWSTYLE, (Object)this.tempExpr.castSpecShowStyle());
                        } else {
                            cell.removeUserObject(FORMULA_SHOWSTYLE);
                        }
                        if (line.isHasInvParseErr()) {
                            cell.setUserObject(HAS_INV_PARSE_ERR, (Object)true);
                        }
                    }
                }
                catch (Exception e) {
                    cell.setFormula(String.format(this.getErrorMsg(), cell.getFormula(), ThrowableHelper.toString((Exception)e)));
                }
            }
        });
    }

    private boolean isOldData() {
        return !this.ctx.getSheet().getBook().getSheet(0).getUserObject().containsKey(NEWDATA);
    }

    private void signNewData() {
        this.ctx.getSheet().getBook().getSheet(0).putUserObject(NEWDATA, null);
        this.ctx.getSheet().getBook().getSheet(0).putUserObject(NEWDATA_2_0, null);
    }

    private Boolean isNeedCalculate(Cell cell) {
        Object value = cell.getValue();
        if (value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            cell.setValue(null);
        }
        if (Objects.nonNull(cell.getUserObject(OUTAREA_FORMULA)) && cell.hasFormula()) {
            cell.setFormula((String)cell.getUserObject(OUTAREA_FORMULA));
        }
        if (Objects.isNull(cell.getUserObject(FLOAT_FORMULA)) && cell.hasFormula()) {
            cell.setUserObject(OUTAREA_FORMULA, (Object)cell.getFormula());
            cell.setUserObject(FLOAT_FORMULA, (Object)cell.getFormula());
        }
        return cell.hasFormula() && (!cell.getUserObject().containsKey((Object)CELL_CHANGE_FLAG) || !Boolean.parseBoolean(cell.getUserObject().get((Object)CELL_CHANGE_FLAG).toString()));
    }

    private String getErrorMsg() {
        return ResManager.loadKDString((String)"\u516c\u5f0f%1$s\u89e3\u6790\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%2$s\u3002", (String)"InvestSpreadFormulaHandler_0", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    private void dealDimensionCellValue(int r, int c, String dimNum, Long memId) {
        IDNumberTreeNode memTree = MemberReader.findMemberById((String)this.ctx.getModelNum(), (String)MemberReader.getEntityNumberByDim((String)this.ctx.getModelNum(), (String)dimNum), (Long)memId);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(memTree)) {
            Cell cell = this.getEffectiveSheet().getCell(r, c);
            cell.setValue((Object)memTree.getNumber());
            cell.setUserObject("number", (Object)memTree.getNumber());
            cell.setUserObject("id", (Object)memId);
            cell.setUserObject("name", (Object)memTree.getName());
        }
    }

    private Sheet getEffectiveSheet() {
        return this.ctx.getSheet().getBook().getSheet(0);
    }

    public static String getCellFormula(Cell cell) {
        return InvestSpreadFormulaHandler.getCellFormula(cell, FLOAT_FORMULA);
    }

    public static String getCellFormula(Cell cell, String formulaType) {
        Object value;
        Object formula = cell.getUserObject(formulaType);
        if (formula == null) {
            formula = cell.getFormula();
        }
        if (formula == null && (value = cell.getValue()) != null && !StringUtils.isEmpty((String)value.toString())) {
            if (cell.getValue() instanceof BigDecimal) {
                if (BigDecimal.ZERO.compareTo((BigDecimal)cell.getValue()) != 0) {
                    formula = String.format("%.2f", cell.getValue());
                }
            } else {
                formula = cell.getValue().toString();
            }
        }
        return formula == null ? null : formula.toString();
    }

    public static String getCellOriginalFormula(Cell cell, String formulaType) {
        Object formula = cell.getUserObject(formulaType);
        if (formula == null && (cell.getUserObject(CELL_CHANGE_FLAG) == null || Objects.nonNull(cell.getUserObject(USER_FORMULA)))) {
            formula = cell.getFormula();
        }
        return formula == null ? null : formula.toString();
    }

    public static Object getCellOriginalValue(Cell cell, String formulaType) {
        if (cell.getUserObject(ORIGINAL_FORMULA) != null) {
            return null;
        }
        Object value = cell.getUserObject(formulaType);
        if (value == null && (cell.getUserObject(CELL_CHANGE_FLAG) == null || Objects.nonNull(cell.getUserObject(USER_FORMULA)))) {
            value = cell.getValue();
        }
        return value;
    }

    public static String getRealCellFormula(Cell cell, String formulaType) {
        Object formula = cell.getUserObject(formulaType);
        if (formula == null) {
            formula = cell.getFormula();
        }
        return formula == null ? null : formula.toString();
    }
}

