/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.formula.handler.IFormulaHandler;
import kd.fi.bcm.business.formula.calculate.FelCalculateEngine;
import kd.fi.bcm.business.formula.model.value.Value;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public abstract class AbstractFormulaHandler
implements IFormulaHandler<InvestFormulaContext, InvCalcLine> {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AbstractFormulaHandler.class);

    protected Object engineExpr(InvestFormulaContext ctx, InvCalcLine line, Expression expr) {
        if (expr instanceof StringExpr) {
            return ((StringExpr)expr).getValue();
        }
        line.setForceWalkPass(true);
        Object val = this.walkExpress(ctx, expr, line);
        try {
            val = ((FelCalculateEngine)ThreadCache.get((Object)"engineExpr", () -> FelCalculateEngine.engine(Value::new))).calculate(val.toString());
            if (val instanceof Throwable) {
                LOG.error(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38 \uff1a ", (String)"AbstractFormulaHandler_4", (String)"fi-bcm-business", (Object[])new Object[0]) + val);
                val = this.walkExpress(ctx, expr, line).toString();
            }
        }
        catch (Throwable t) {
            LOG.error(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38 \uff1a ", (String)"AbstractFormulaHandler_4", (String)"fi-bcm-business", (Object[])new Object[0]), t);
        }
        line.setForceWalkPass(false);
        return val;
    }

    protected Expression walkFloatExpress(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        return this.walkExpress(ctx, expr, line, true);
    }

    protected Expression walkExpress(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        return this.walkExpress(ctx, expr, line, false);
    }

    protected Expression walkExpress(InvestFormulaContext ctx, Expression expr, InvCalcLine line, boolean isFloatWalk) {
        if (isFloatWalk) {
            return InvestFormulaParseHelper.walkFloatExpress(ctx, expr, line);
        }
        return InvestFormulaParseHelper.walkExpress(ctx, expr, line);
    }
}

