/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class DespFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public Expression dealFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        List params = ((FunctionExpr)expr).getParameters();
        if (params != null && params.size() == 7) {
            if (this.isBlank(params.get(4)) && StringUtils.isNotEmpty((String)line.getLastPeriod4V())) {
                params.set(4, new StringExpr(line.getLaspPeriod4Esp()));
            }
            return expr;
        }
        return new StringExpr(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u4e0d\u6ee1\u8db3\u8981\u6c42", (String)"EspFormulaHandler_0", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, InvCalcLine line) {
        ParamList paramList = f.getParamList();
        if (paramList != null && paramList.size() == 7) {
            ParamItem periodItem;
            ParamItem fyItem;
            ParamItem sceneItem;
            ParamItem typeItem;
            String catalog;
            ParamItem changeTypeItem = (ParamItem)paramList.get(0);
            if (this.isBlank(changeTypeItem.getParam()) && (StringUtils.isEmpty((String)(catalog = line.getCatalog())) || InvRelationTypeConstant.CatalogEnum.change_type.getCode().equals(catalog))) {
                changeTypeItem.fixParam(line.getRelationType());
            }
            if (changeTypeItem.getParam() instanceof BigDecimal) {
                changeTypeItem.fixParam(Integer.toString(((BigDecimal)changeTypeItem.getParam()).intValue()));
            }
            if ((typeItem = (ParamItem)paramList.get(1)).getParam() instanceof BigDecimal) {
                typeItem.fixParam(Integer.toString(((BigDecimal)typeItem.getParam()).intValue()));
            }
            if (this.isBlank((sceneItem = (ParamItem)paramList.get(2)).getParam())) {
                sceneItem.fixParam(_ctx.getScenario());
            }
            if (this.isBlank((fyItem = (ParamItem)paramList.get(3)).getParam())) {
                fyItem.fixParam(_ctx.getYear());
            }
            if (this.isBlank((periodItem = (ParamItem)paramList.get(4)).getParam())) {
                periodItem.fixParam(_ctx.getPeriod());
            }
            String fyNum = this.handelParam(fyItem.getParam());
            String periodNum = this.handelParam(periodItem.getParam());
            Pair<String, String> yearAndPeriod = InvestServiceHelper.cvtPeriodAndYear(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), fyNum, periodNum);
            fyItem.fixParam(yearAndPeriod.p1);
            periodItem.fixParam(yearAndPeriod.p2);
            ParamItem holderItem = (ParamItem)paramList.get(5);
            if (this.isBlank(holderItem.getParam())) {
                holderItem.fixParam(line.getHolder());
            } else {
                holderItem.fixParam(InvestFormulaParseHelper.getEntityNumBySpecialSign(line.getHolder(), line.getInvest(), this.handelParam(holderItem.getParam())));
            }
            ParamItem investItem = (ParamItem)paramList.get(6);
            if (this.isBlank(investItem.getParam())) {
                investItem.fixParam(line.getInvest());
            } else {
                investItem.fixParam(InvestFormulaParseHelper.getEntityNumBySpecialSign(line.getHolder(), line.getInvest(), this.handelParam(investItem.getParam())));
            }
            paramList.add(0, new ParamItem(BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getUnitId()).getNumber()));
        }
    }

    @Override
    public String getName() {
        return "DESP";
    }
}

