/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import java.util.LinkedHashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.ModelRate;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.VFormulaHandler;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.spread.formula.expr.Expression;

public class ExcRateFormulaHandler
extends VFormulaHandler {
    @Override
    public Expression dealFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        return expr;
    }

    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, InvCalcLine line) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>(f.getParamList().size());
        for (int i = 0; i < f.getParamList().size(); ++i) {
            String[] spiltStr = VFormula.splitDimAndMemb(((ParamItem)f.getParamList().get(i)).toString());
            if (spiltStr.length != 2) continue;
            paramMap.put(this.handelParam(spiltStr[0]), this.handelParam(spiltStr[1]));
        }
        SchemeContext dimContext = (SchemeContext)ThreadCache.get((Object)"SchemeContext", () -> SchemeContext.getInstance(_ctx.getModelId()));
        for (Dimension dim : dimContext.getDimensions()) {
            paramMap.computeIfAbsent(dim.getShortnum(), a -> this.getDefaultDimMem(_ctx, dim, line));
        }
        String entityNum = (String)paramMap.get(DimTypesEnum.ENTITY.getShortNumber());
        String processNum = (String)paramMap.get(DimTypesEnum.PROCESS.getShortNumber());
        String currencyNum = (String)paramMap.get(DimTypesEnum.CURRENCY.getShortNumber());
        IDNumberTreeNode unitOrgNode = BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getUnitId());
        IDNumberTreeNode detailOrgNode = BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getExcuteOrgId());
        processNum = InvestFormulaParseHelper.getCurrencyNumBySpecSign(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), processNum, line, null);
        processNum = InvestFormulaParseHelper.getTransOrgAndCurbyOrgId(unitOrgNode, detailOrgNode, line.getProcess(), processNum);
        paramMap.put(DimTypesEnum.PROCESS.getShortNumber(), processNum);
        currencyNum = InvestFormulaParseHelper.getCurrencyNumBySpecSign(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), currencyNum, line, null);
        currencyNum = InvestFormulaParseHelper.getTransOrgAndCurbyOrgId(unitOrgNode, detailOrgNode, line.getProcess(), currencyNum);
        paramMap.put(DimTypesEnum.CURRENCY.getShortNumber(), currencyNum);
        String fyNum = (String)paramMap.get(DimTypesEnum.YEAR.getShortNumber());
        String periodNum = (String)paramMap.get(DimTypesEnum.PERIOD.getShortNumber());
        Pair<String, String> yearAndPeriod = InvestServiceHelper.cvtPeriodAndYear(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), fyNum, periodNum);
        paramMap.put(DimTypesEnum.YEAR.getShortNumber(), yearAndPeriod.p1);
        paramMap.put(DimTypesEnum.PERIOD.getShortNumber(), yearAndPeriod.p2);
        if ("Entity".equals(entityNum)) {
            String rateSchemaNumber;
            String modelNumber = MemberReader.findModelNumberById((Object)_ctx.getModelId());
            IDNumberTreeNode fyMember = MemberReader.findFyMemberByNum((String)modelNumber, (String)((String)yearAndPeriod.p1));
            IDNumberTreeNode periodMember = MemberReader.findFyMemberByNum((String)modelNumber, (String)((String)yearAndPeriod.p2));
            ModelRate modelRate = ExchangeQueryHelper.getModeRate(new BaseData(_ctx.getModelId(), _ctx.getScenarioId(), fyMember.getId(), periodMember.getId()));
            RateSchema rateSchema = modelRate.getRateSchemaByOrgNum(unitOrgNode.getNumber());
            String string = rateSchemaNumber = RateSchema.EMPTY_RATE_SCHEMA == rateSchema ? "" : rateSchema.getRateSchemaNumber();
            if (StringUtils.isEmpty((String)rateSchemaNumber) || IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(rateSchemaNumber)) {
                rateSchemaNumber = "RatePreset";
            }
            paramMap.put(DimTypesEnum.ENTITY.getShortNumber(), rateSchemaNumber);
        }
        f.getParamList().clear();
        paramMap.forEach((k, v) -> f.getParamList().add(new ParamItem(ExcRateFormulaHandler.packDimAndMemb(k, v))));
    }

    @Override
    String getDefaultDimMem(ICalContext _ctx, Dimension dim, InvCalcLine line) {
        if (dim.isIssys()) {
            DimTypesEnum dimType = DimTypesEnum.getDimTypesEnumByShowNumber((String)dim.getShortnum());
            if (dimType == null) {
                return "";
            }
            switch (dimType) {
                case ENTITY: {
                    return "Entity";
                }
                case PERIOD: {
                    return _ctx.getPeriod();
                }
                case CURRENCY: {
                    return "DC";
                }
                case YEAR: {
                    return _ctx.getYear();
                }
                case SCENARIO: {
                    return _ctx.getScenario();
                }
                case PROCESS: {
                    return "Rpt";
                }
                case CHANGETYPE: {
                    return "EndingBalance";
                }
                case MYCOMPANY: {
                    return "MCNone";
                }
                case DATASORT: {
                    return "Actual";
                }
                case INTERCOMPANY: {
                    return "ICNone";
                }
                case MULTIGAAP: {
                    return "MGNone";
                }
                case AUDITTRIAL: {
                    return "ATNone";
                }
            }
        } else {
            return dim.getShortnum() + "None";
        }
        return "";
    }

    @Override
    public String getName() {
        return "EXCRATE";
    }
}

