/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.formula.calculate.adjust.GetJLEntryCalculate;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.adjust.GetJLEntryFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.formula.expr.Expression;

public class GetJLFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public Expression dealFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        return expr;
    }

    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, InvCalcLine line) {
        super.dealBeforeCalFormula(_ctx, f, line);
        ParamList paramList = f.getParamList();
        String val = null;
        for (Map.Entry<String, Integer> entry : GetJLEntryCalculate.indexMap.entrySet()) {
            ParamItem paramItem = (ParamItem)paramList.get(entry.getValue());
            if (paramItem == null) {
                paramItem = new ParamItem("");
                paramList.set(entry.getValue(), paramItem);
            }
            val = this.handelParam(paramItem.getParam());
            switch (entry.getKey()) {
                case "merge": {
                    if (!StringUtils.isEmpty((CharSequence)val)) break;
                    paramItem.fixParam(BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getUnitId()).getNumber());
                    break;
                }
                case "dimensionMem": {
                    paramItem.fixParam(this.fixDimensionField(_ctx, line, val));
                    break;
                }
                case "mergescope": {
                    if (!StringUtils.isEmpty((CharSequence)val)) break;
                    paramItem.fixParam(RangeEnum.VALUE_10.getNumber());
                    break;
                }
                case "computetype": {
                    if (!StringUtils.isEmpty((CharSequence)val)) break;
                    paramItem.fixParam("-");
                    break;
                }
            }
        }
    }

    private String fixDimensionField(ICalContext _ctx, InvCalcLine line, String dimensionParam) {
        String shareHolder = line.getHolder();
        String investOrg = line.getInvest();
        dimensionParam = this.handelParam(dimensionParam);
        LinkedHashMap<String, String> dim2ValMap = new LinkedHashMap<String, String>(16);
        LinkedHashMap<String, String[]> dim2ScopeMap = new LinkedHashMap<String, String[]>(16);
        block4: for (String p : dimensionParam.split(",")) {
            String[] dimAndMemb = GetJLEntryFormula.splitDimAndMemb(p);
            switch (dimAndMemb.length) {
                case 2: {
                    dim2ValMap.put(this.handelParam(dimAndMemb[0]), this.handelParam(dimAndMemb[1]));
                    continue block4;
                }
                case 4: {
                    dim2ValMap.put(this.handelParam(dimAndMemb[0]), this.handelParam(dimAndMemb[2]));
                    dim2ScopeMap.put(this.handelParam(dimAndMemb[0]), dimAndMemb);
                    continue block4;
                }
                default: {
                    throw new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570\u201c%s\u201d\u3002", (String)"GetJLEntryCalculate_2", (String)"fi-bcm-business", (Object[])new Object[0]), p));
                }
            }
        }
        String scene = dim2ValMap.computeIfAbsent(DimTypesEnum.SCENARIO.getShortNumber(), a -> _ctx.getScenario());
        String year = dim2ValMap.computeIfAbsent(DimTypesEnum.YEAR.getShortNumber(), a -> _ctx.getYear());
        String period = dim2ValMap.computeIfAbsent(DimTypesEnum.PERIOD.getShortNumber(), a -> _ctx.getPeriod());
        String processNum = (String)dim2ValMap.get(DimTypesEnum.PROCESS.getShortNumber());
        String curNum = (String)dim2ValMap.get(DimTypesEnum.CURRENCY.getShortNumber());
        Pair<String, String> yearAndPeriod = InvestServiceHelper.cvtPeriodAndYear(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), year, period);
        year = (String)yearAndPeriod.p1;
        period = (String)yearAndPeriod.p2;
        dim2ValMap.put(DimTypesEnum.YEAR.getShortNumber(), year);
        dim2ValMap.put(DimTypesEnum.PERIOD.getShortNumber(), period);
        String orgNum = (String)dim2ValMap.get(DimTypesEnum.ENTITY.getShortNumber());
        orgNum = InvestFormulaParseHelper.getEntityNumBySpecialSign(shareHolder, investOrg, orgNum);
        dim2ValMap.put(DimTypesEnum.ENTITY.getShortNumber(), orgNum);
        if (dim2ValMap.containsKey(DimTypesEnum.INTERCOMPANY.getShortNumber())) {
            dim2ValMap.compute(DimTypesEnum.INTERCOMPANY.getShortNumber(), (k, icNum) -> InvestFormulaParseHelper.getEntityNumBySpecialSign(shareHolder, investOrg, icNum));
        }
        if (dim2ValMap.containsKey(DimTypesEnum.MYCOMPANY.getShortNumber())) {
            dim2ValMap.compute(DimTypesEnum.MYCOMPANY.getShortNumber(), (k, mcNum) -> InvestFormulaParseHelper.getEntityNumBySpecialSign(shareHolder, investOrg, mcNum));
        }
        IDNumberTreeNode unitOrgNode = BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getUnitId());
        IDNumberTreeNode detailOrgNode = BcmThreadCache.findMemberByNum((String)_ctx.getCubeNumber(), (String)"Entity", (String)orgNum);
        curNum = InvestFormulaParseHelper.getCurrencyNumBySpecSign(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), curNum, line, null);
        curNum = InvestFormulaParseHelper.getTransOrgAndCurbyOrgId(unitOrgNode, detailOrgNode, processNum, curNum);
        dim2ValMap.put(DimTypesEnum.CURRENCY.getShortNumber(), curNum);
        StringJoiner sj = new StringJoiner(",");
        dim2ValMap.forEach((k, v) -> {
            CharSequence[] dimScope = (String[])dim2ScopeMap.get(k);
            if (dimScope == null || dimScope.length < 4) {
                sj.add(k + "." + v);
            } else {
                dimScope[2] = v;
                sj.add(String.join((CharSequence)".", dimScope));
            }
        });
        return sj.toString();
    }

    @Override
    public String getName() {
        return "GETJLENTRY";
    }
}

