/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import java.util.Date;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.invest.InvChangeType;
import kd.fi.bcm.common.enums.invest.InvDateType;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class GetinvperFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public Expression dealFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        List params = ((FunctionExpr)expr).getParameters();
        if (params != null && params.size() == 7) {
            return expr;
        }
        return new StringExpr(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u4e0d\u6ee1\u8db3\u8981\u6c42", (String)"EspFormulaHandler_0", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, InvCalcLine line) {
        ParamList paramList = f.getParamList();
        if (paramList != null && paramList.size() > 6) {
            ParamItem holderItem;
            ParamItem typeItem;
            ParamItem changeTypeItem;
            ParamItem caseItem = (ParamItem)paramList.get(0);
            if (this.isBlank(caseItem.getParam())) {
                // empty if block
            }
            if (this.isBlank((changeTypeItem = (ParamItem)paramList.get(1)).getParam())) {
                String catalog = line.getCatalog();
                if (InvRelationTypeConstant.CatalogEnum.change_type.getCode().equals(catalog)) {
                    changeTypeItem.fixParam(line.getRelationType());
                } else {
                    changeTypeItem.fixParam(InvChangeType.None.name());
                }
            }
            if (this.isBlank((typeItem = (ParamItem)paramList.get(2)).getParam())) {
                // empty if block
            }
            if (this.isBlank((holderItem = (ParamItem)paramList.get(3)).getParam())) {
                holderItem.fixParam(line.getHolder());
            } else {
                holderItem.fixParam(InvestFormulaParseHelper.getEntityNumBySpecialSign(line.getHolder(), line.getInvest(), this.handelParam(holderItem.getParam())));
            }
            ParamItem investItem = (ParamItem)paramList.get(4);
            if (this.isBlank(investItem.getParam())) {
                investItem.fixParam(line.getInvest());
            } else {
                investItem.fixParam(InvestFormulaParseHelper.getEntityNumBySpecialSign(line.getHolder(), line.getInvest(), this.handelParam(investItem.getParam())));
            }
            Date[] startAndEndDate = (Date[])BcmThreadCache.get((Object)"StartAndEndDate", (Object)_ctx.getModelId(), (Object)_ctx.getYearId(), (Object)_ctx.getPeriodId(), () -> PeriodUtils.calcStartAndEndDate((long)_ctx.getModelId(), (long)_ctx.getYearId(), (long)_ctx.getPeriodId()));
            DynamicObject model = (DynamicObject)ThreadCache.get((Object)"model", () -> BusinessDataServiceHelper.loadSingle((Object)_ctx.getModelId(), (String)"bcm_model"));
            ParamItem startDateItem = (ParamItem)paramList.get(5);
            String begin = startDateItem.toString();
            if (InvDateType.PeriodBegin.name().equalsIgnoreCase(begin)) {
                if (startAndEndDate != null) {
                    begin = PeriodUtils.formatDate((Date)startAndEndDate[0]);
                }
            } else if (InvDateType.BeginYear.name().equalsIgnoreCase(begin)) {
                int beginPeriod = model.getInt("beginperiod");
                String year = _ctx.getYear().replace("FY", "");
                String month = beginPeriod < 10 ? "0" + beginPeriod : String.valueOf(beginPeriod);
                begin = year.concat("-").concat(month).concat("-01");
            } else if (InvDateType.None.name().equalsIgnoreCase(begin)) {
                begin = "";
            }
            startDateItem.fixParam(begin);
            ParamItem endDateItem = (ParamItem)paramList.get(6);
            String end = endDateItem.toString();
            if (InvDateType.PeriodEnd.name().equalsIgnoreCase(end)) {
                if (startAndEndDate != null) {
                    end = PeriodUtils.formatDate((Date)startAndEndDate[1]);
                }
            } else if (InvDateType.None.name().equalsIgnoreCase(end)) {
                end = "";
            }
            endDateItem.fixParam(end);
        }
    }

    @Override
    public String getName() {
        return "GETINVPER";
    }
}

