/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.spread.formula.expr.Expression;

public class InvFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public Expression dealFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        return expr;
    }

    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, InvCalcLine line) {
        super.dealBeforeCalFormula(_ctx, f, line);
        ParamList paramList = f.getParamList();
        if (paramList != null && paramList.size() == 7) {
            String currencyNum;
            ParamItem investItem = (ParamItem)paramList.get(0);
            if (this.isBlank(investItem.getParam())) {
                investItem.fixParam(line.getInvest());
            }
            IDNumberTreeNode unitOrgNode = BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getUnitId());
            ParamItem curItem = (ParamItem)paramList.get(3);
            String string = currencyNum = curItem == null ? null : curItem.toString();
            if (curItem == null) {
                paramList.set(3, new ParamItem(currencyNum));
            } else {
                currencyNum = curItem.toString();
                if (this.isBlank(currencyNum)) {
                    curItem.fixParam(unitOrgNode.getCurrency());
                } else {
                    IDNumberTreeNode parentNode = unitOrgNode.getParent() == null || "Entity".equals(unitOrgNode.getParent().getNumber()) ? unitOrgNode : unitOrgNode.getParent();
                    currencyNum = InvestFormulaParseHelper.getCurrencyNumBySpecSign(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), currencyNum, line, null);
                    currencyNum = InvestFormulaParseHelper.getTransOrgAndCurbyOrgId(parentNode, unitOrgNode, line.getProcess(), currencyNum);
                    curItem.fixParam(currencyNum);
                }
            }
        }
    }

    @Override
    public String getName() {
        return "INV";
    }
}

