/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestSheetDataProvider;
import kd.fi.bcm.business.invest.sheet.formula.InvestSpreadFormulaHandler;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class RefFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public Expression dealFloatFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        ReferenceExpr newRef = (ReferenceExpr)expr;
        if (ctx.isRefInDataPos(line.getRow(), line.getCol())) {
            if (ctx.isFlowRow()) {
                int newRefIndex = newRef.row + line.getOffset();
                if (newRef.isRowRel()) {
                    newRef.setRow(newRefIndex);
                    line.setHasRelativeCell(true);
                }
                if (newRefIndex > line.getRow()) {
                    int floatCount = (Integer)ctx.getSheet().getBook().getSheet(0).getUserObject("inv_relation_count");
                    newRef.setRow(newRef.row + floatCount - 1);
                }
            } else {
                int newRefIndex = newRef.col + line.getOffset();
                if (newRef.isColRel()) {
                    newRef.setCol(newRefIndex);
                    line.setHasRelativeCell(true);
                }
                if (newRefIndex > line.getCol()) {
                    int floatCount = (Integer)ctx.getSheet().getBook().getSheet(0).getUserObject("inv_relation_count");
                    newRef.setCol(newRef.col + floatCount - 1);
                }
            }
        } else {
            int floatCount = (Integer)ctx.getSheet().getBook().getSheet(0).getUserObject("inv_relation_count");
            if (ctx.isFlowRow()) {
                if (newRef.isRowRel()) {
                    newRef.setRow(newRef.row + floatCount - 1);
                }
            } else if (newRef.isColRel()) {
                newRef.setCol(newRef.col + floatCount - 1);
            }
        }
        return newRef;
    }

    @Override
    public Expression dealFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        String tarPos;
        ReferenceExpr newRef = (ReferenceExpr)expr;
        String srcPos = ExcelUtils.xy2Pos((int)line.getCol(), (int)line.getRow());
        if (ctx.addExrToRefPosPool(srcPos, tarPos = ExcelUtils.xy2Pos((int)newRef.col, (int)newRef.row))) {
            Cell refCell = ctx.getCell(newRef.row, newRef.col, false);
            if (refCell != null) {
                if (refCell.hasFormula()) {
                    String realRefFormulaStr = InvestSpreadFormulaHandler.getRealCellFormula(refCell, "ff");
                    if (line.isHasPFormulaCell() || line.isForceWalkPass()) {
                        expr = this.walkExpress(ctx, this.parseFormula(realRefFormulaStr), line);
                    }
                } else if (line.isForceWalkPass()) {
                    expr = new StringExpr(((InvestSheetDataProvider)ThreadCache.get((Object)ctx.getSheet().hashCode(), () -> new InvestSheetDataProvider(ctx.getSheet().getBook().getSheet(0)))).get(tarPos).toString());
                }
            }
        } else {
            ctx.getSheet().getBook().getSheet(0).getCell(line.getRow().intValue(), line.getCol().intValue()).setUserObject("formula_fail", (Object)true);
            expr = new StringExpr(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u5faa\u73af\u5f15\u7528\uff0c\u5f53\u524d\u5355\u5143\u683c\u201c%s\u201d\u76f4\u63a5\u6216\u95f4\u63a5\u7684\u5f15\u7528\u4e86\u81ea\u5df1\uff0c\u8bf7\u4fee\u6b63\u516c\u5f0f\u3002", (String)"RefFormulaHandler_3", (String)"fi-bcm-business", (Object[])new Object[0]), srcPos));
        }
        return expr;
    }

    @Override
    public String getName() {
        return "REF";
    }
}

