/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.formula.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.sheet.formula.InvCalcLine;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaContext;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.invest.sheet.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvFsfetchType;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class VFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public Expression dealFormula(InvestFormulaContext ctx, Expression expr, InvCalcLine line) {
        if (StringUtils.isNotEmpty((String)line.getLastPeriod4V())) {
            List params = ((FunctionExpr)expr).getParameters();
            HashSet<String> dimSet = new HashSet<String>(16);
            for (Object param : params) {
                String[] splitArr;
                if (param == null || (splitArr = VFormula.splitDimAndMemb(this.handelParam(this.engineExpr(ctx, line, (Expression)param).toString()))).length != 2) continue;
                dimSet.add(this.handelParam(splitArr[0]));
            }
            if (!dimSet.contains(DimTypesEnum.PERIOD.getShortNumber())) {
                params.add(new StringExpr(DimTypesEnum.PERIOD.getShortNumber() + "." + line.getLastPeriod4V()));
            }
        }
        return expr;
    }

    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, InvCalcLine line) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>(f.getParamList().size());
        for (int i = 0; i < f.getParamList().size(); ++i) {
            String[] spiltStr = VFormula.splitDimAndMemb(((ParamItem)f.getParamList().get(i)).toString());
            if (spiltStr.length != 2) continue;
            paramMap.put(this.handelParam(spiltStr[0]), this.handelParam(spiltStr[1]));
        }
        SchemeContext dimContext = (SchemeContext)ThreadCache.get((Object)"SchemeContext", () -> SchemeContext.getInstance(_ctx.getModelId()));
        for (Dimension dim : dimContext.getDimensions()) {
            paramMap.computeIfAbsent(dim.getShortnum(), a -> this.getDefaultDimMem(_ctx, dim, line));
        }
        String entityNum = paramMap.getOrDefault(DimTypesEnum.ENTITY.getShortNumber(), "");
        String icNum = (String)paramMap.get(DimTypesEnum.INTERCOMPANY.getShortNumber());
        String mcNum = (String)paramMap.get(DimTypesEnum.MYCOMPANY.getShortNumber());
        String processNum = (String)paramMap.get(DimTypesEnum.PROCESS.getShortNumber());
        String currencyNum = (String)paramMap.get(DimTypesEnum.CURRENCY.getShortNumber());
        String fyNum = (String)paramMap.get(DimTypesEnum.YEAR.getShortNumber());
        String periodNum = (String)paramMap.get(DimTypesEnum.PERIOD.getShortNumber());
        String fgConfig = (String)paramMap.get("FS");
        List<Long> relaCslConfigPks = this.resolveRelaCslConfig(_ctx.getModelId(), (String)paramMap.get("RC"));
        if ("EIRpt".equalsIgnoreCase(processNum)) {
            processNum = "IRpt";
            paramMap.put(DimTypesEnum.PROCESS.getShortNumber(), processNum);
        }
        if (StringUtils.isNotEmpty((String)entityNum) && !entityNum.contains("_")) {
            IDNumberTreeNode unitNode = BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getUnitId());
            boolean isInvestOrg = "INVESTORG".equalsIgnoreCase(entityNum) || "$INVESTORG".equalsIgnoreCase(entityNum);
            entityNum = InvestFormulaParseHelper.getEntityNumBySpecialSign(line.getHolder(), line.getInvest(), entityNum);
            if (StringUtils.isEmpty((String)fgConfig)) {
                String string = fgConfig = entityNum.equals(line.holder) || entityNum.equals(line.invest) ? InvFsfetchType.COMMON_PARENT.getCode() : InvFsfetchType.DIRECT_SUPER.getCode();
            }
            if (isInvestOrg || line.isFromSpread() && StringUtil.equals((String)entityNum, (String)line.invest)) {
                for (Long cslId : relaCslConfigPks.isEmpty() ? Collections.singletonList((Long)unitNode.getProperty("cslscheme.id")) : relaCslConfigPks) {
                    entityNum = InvestServiceHelper.searchCtrlHoldingCompany(_ctx.getModelId(), cslId, _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.invest);
                    if (StringUtils.isEmpty((String)entityNum)) continue;
                    break;
                }
                String string = entityNum = StringUtils.isEmpty((String)entityNum) ? line.invest : entityNum;
            }
            if (StringUtils.isEmpty((String)entityNum)) {
                throw new KDBizException("handleVOrgSpecParam : not found orgNum");
            }
            if (OrgRelaProcessMembPool.isRelaProcess((String)processNum)) {
                entityNum = fgConfig.contains(InvFsfetchType.COMMON_PARENT.getCode()) ? (ConfigServiceHelper.getBoolParam(_ctx.getModelId(), "isUseNewCommonParentCal") ? InvestServiceHelper.searchNewCommonParent(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), entityNum) : InvestServiceHelper.searchOldCommonParent(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), line.holder, line.invest, entityNum)) : InvestServiceHelper.searchDirectParent(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), entityNum, relaCslConfigPks);
            }
        }
        paramMap.put(DimTypesEnum.ENTITY.getShortNumber(), entityNum);
        IDNumberTreeNode unitOrgNode = BcmThreadCache.findNodeById((String)_ctx.getCubeNumber(), (String)"Entity", (long)line.getUnitId());
        IDNumberTreeNode detailOrgNode = BcmThreadCache.findMemberByNum((String)_ctx.getCubeNumber(), (String)"Entity", (String)entityNum);
        currencyNum = InvestFormulaParseHelper.getCurrencyNumBySpecSign(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), line.getUnitId(), currencyNum, line, relaCslConfigPks);
        currencyNum = InvestFormulaParseHelper.getTransOrgAndCurbyOrgId(unitOrgNode, detailOrgNode, line.getProcess(), currencyNum);
        paramMap.put(DimTypesEnum.CURRENCY.getShortNumber(), currencyNum);
        if (paramMap.containsKey(DimTypesEnum.INTERCOMPANY.getShortNumber())) {
            icNum = InvestFormulaParseHelper.getEntityNumBySpecialSign(line.getHolder(), line.getInvest(), icNum);
            paramMap.put(DimTypesEnum.INTERCOMPANY.getShortNumber(), icNum);
        }
        if (paramMap.containsKey(DimTypesEnum.MYCOMPANY.getShortNumber())) {
            mcNum = InvestFormulaParseHelper.getEntityNumBySpecialSign(line.getHolder(), line.getInvest(), mcNum);
            paramMap.put(DimTypesEnum.MYCOMPANY.getShortNumber(), mcNum);
        }
        Pair<String, String> yearAndPeriod = InvestServiceHelper.cvtPeriodAndYear(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), fyNum, periodNum);
        paramMap.put(DimTypesEnum.YEAR.getShortNumber(), yearAndPeriod.p1);
        paramMap.put(DimTypesEnum.PERIOD.getShortNumber(), yearAndPeriod.p2);
        f.getParamList().clear();
        paramMap.remove("FS");
        paramMap.remove("RC");
        paramMap.forEach((k, v) -> f.getParamList().add(new ParamItem(VFormulaHandler.packDimAndMemb(k, v))));
        _ctx.getConvertParam().put(String.join((CharSequence)",", entityNum, processNum, currencyNum), (Tuple<String, String, String>)Tuple.create((Object)entityNum, (Object)processNum, (Object)currencyNum));
    }

    private List<Long> resolveRelaCslConfig(long modelId, String relaCslConfig) {
        ArrayList<Long> relaCslConfigList = new ArrayList<Long>(16);
        if (!StringUtils.isEmpty((String)relaCslConfig)) {
            Map cslNum2PkMap = (Map)ThreadCache.get((Object)"cslNum2PkMap", () -> (Map)GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemporaryCache).getOrLoad("cslNum2PkMap_" + modelId, () -> QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, null, (int)-1).stream().collect(Collectors.toMap(p -> p.getString("number"), p -> p.getLong("id")))));
            for (String cslNum : relaCslConfig.split("\\|")) {
                if (!cslNum2PkMap.containsKey(cslNum)) continue;
                relaCslConfigList.add((Long)cslNum2PkMap.get(cslNum));
            }
        }
        return relaCslConfigList;
    }

    String getDefaultDimMem(ICalContext _ctx, Dimension dim, InvCalcLine line) {
        DimTypesEnum dimType = DimTypesEnum.getDimTypesEnumByShowNumber((String)dim.getShortnum());
        String modelNum = MemberReader.findModelNumberById((Object)_ctx.getModelId());
        if (dimType != null) {
            switch (dimType) {
                case PERIOD: {
                    return BcmThreadCache.findNodeById((String)modelNum, (String)"Period", (long)_ctx.getPeriodId()).getNumber();
                }
                case CURRENCY: {
                    return BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)line.getUnitId()).getNumber();
                }
                case YEAR: {
                    return BcmThreadCache.findNodeById((String)modelNum, (String)"Year", (long)_ctx.getYearId()).getNumber();
                }
                case SCENARIO: {
                    return BcmThreadCache.findNodeById((String)modelNum, (String)"Scenario", (long)_ctx.getScenarioId()).getNumber();
                }
                case PROCESS: {
                    return "Rpt";
                }
                case DATASORT: {
                    return "Actual";
                }
                case INTERCOMPANY: {
                    return "ICNone";
                }
                case MYCOMPANY: {
                    return "MCNone";
                }
                case MULTIGAAP: {
                    return "PRCGAAP";
                }
                case AUDITTRIAL: {
                    return "ATTotal";
                }
            }
        } else if (!dim.isIssys()) {
            return dim.getShortnum() + "None";
        }
        return "";
    }

    public static String packDimAndMemb(String dim, String memb) {
        return dim + '.' + memb;
    }

    @Override
    public String getName() {
        return "V";
    }
}

