/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.sheet.log;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logorm.LogORM;
import kd.fi.bcm.business.allinone.service.thread.BCMFuture;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.invest.extdim.InvExtDataSaveService;
import kd.fi.bcm.business.invest.extdim.model.ExtendExtUniqueKey;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.business.invest.sheet.log.IInvLimSheetLogServer;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.domain.Cell;

public class InvLimSheetLogServer
implements IInvLimSheetLogServer {
    private final InvLimSheetLogConstant.Operation operationType;
    private final long modelId;
    private final long scenarioId;
    private final long fyId;
    private final long periodId;
    private final long belongOrgId;
    private final Set<Log> sheetDataRemoveLogs = new HashSet<Log>(16);
    private final Set<Log> generateLogs = new HashSet<Log>(16);
    private static final IInvLimSheetLogServer COMMON_NULL_LOG = new IInvLimSheetLogServer(){

        @Override
        public void logSheetDataRemove(String templateNumber, String dataModel, ExtendExtUniqueKey uniqueKey) {
        }

        @Override
        public void logPageDataRemove(String templateNumber, String dataModel, ExtendExtUniqueKey uniqueKey) {
        }

        @Override
        public void logSheetDataCopy(DynamicObject dynamicObject) {
        }

        @Override
        public void logSheetDataSave(InvEDSaveComInfo edSaveComInfo, EDColumn saveComInfo, Cell cell) {
        }

        @Override
        public void successLogAsync() {
        }

        @Override
        public void failLogAsync() {
        }
    };

    public static IInvLimSheetLogServer buildInvLimSheetLogServer(long modelId, long scenarioId, long fyId, long periodId, long belongOrgId, InvLimSheetLogConstant.Operation operationType) {
        if (!ConfigServiceHelper.getGlobalBoolParam("isInvLimSheetLog")) {
            return COMMON_NULL_LOG;
        }
        return new InvLimSheetLogServer(modelId, scenarioId, fyId, periodId, belongOrgId, operationType);
    }

    private InvLimSheetLogServer(long modelId, long scenarioId, long fyId, long periodId, long belongOrgId, InvLimSheetLogConstant.Operation operationType) {
        this.operationType = operationType;
        this.modelId = modelId;
        this.scenarioId = scenarioId;
        this.fyId = fyId;
        this.periodId = periodId;
        this.belongOrgId = belongOrgId;
    }

    @Override
    public void logSheetDataRemove(String templateNumber, String dataModel, ExtendExtUniqueKey uniqueKey) {
        Log log = new Log(dataModel, uniqueKey, InvLimSheetLogConstant.ChangeType.SHEET_REMOVE);
        log.setTempNumber(templateNumber);
        this.generateLogs.add(log);
    }

    @Override
    public void logPageDataRemove(String templateNumber, String dataModel, ExtendExtUniqueKey uniqueKey) {
        Log log = new Log(dataModel, uniqueKey, InvLimSheetLogConstant.ChangeType.PAGE_REMOVE);
        log.setTempNumber(templateNumber);
        this.sheetDataRemoveLogs.add(log);
    }

    @Override
    public void logSheetDataCopy(DynamicObject data) {
        String dataModel = data.getString("datamodel");
        String belongOrg = data.getString("org");
        String merge = data.getString("merge");
        String acc = data.getString("account");
        String tempNumber = data.getString("templatenumber");
        String shareholderNumber = data.getString("internalcompany");
        String investedCompanyNumber = data.getString("entity");
        String categorized = data.getString("categorized");
        String relationType = data.getString("relationtype");
        String dataType = data.getString("datatype");
        String field = InvExtDataSaveService.getValueField(dataType);
        Log log = new Log(dataModel, new ExtendExtUniqueKey(acc, belongOrg, merge, shareholderNumber, investedCompanyNumber, relationType, categorized), InvLimSheetLogConstant.ChangeType.SHEET_COPY);
        BigDecimal newVal = InvestUtils.convertToBigDecimal((Object)data.get(field));
        log.setValue(newVal == null ? data.getString(field) : newVal.toPlainString());
        log.setTempNumber(tempNumber);
        this.generateLogs.add(log);
    }

    @Override
    public void logSheetDataSave(InvEDSaveComInfo edSaveComInfo, EDColumn saveComInfo, Cell cell) {
        if (cell != null && !cell.isChangeVal() && InvLimSheetLogConstant.Operation.SAVE == this.operationType) {
            return;
        }
        String dataModel = edSaveComInfo.getDatamodel();
        String acc = saveComInfo.getMdName();
        String templateNumber = edSaveComInfo.getTemplateNumber();
        String shareholderNumber = edSaveComInfo.getSharehold();
        String investedCompanyNumber = edSaveComInfo.getInvestOrg();
        String categorized = edSaveComInfo.getCategorized();
        String relationType = edSaveComInfo.getRelationType();
        Object value = saveComInfo.getValue();
        Log log = new Log(dataModel, new ExtendExtUniqueKey(acc, edSaveComInfo.getBelongOrg(), edSaveComInfo.getMerge(), shareholderNumber, investedCompanyNumber, relationType, categorized), InvLimSheetLogConstant.ChangeType.SHEET_SAVE);
        log.setValue(String.valueOf(value));
        log.setTempNumber(templateNumber);
        this.generateLogs.add(log);
    }

    @Override
    public void successLogAsync() {
        BCMFuture.runAsync(this::successLog);
    }

    private void successLog() {
        String modelNumber = MemberReader.findDMModelSNumberById((Object)this.modelId);
        IDNumberTreeNode scenaMember = MemberReader.findScenaMemberById((Long)this.modelId, (Long)this.scenarioId);
        IDNumberTreeNode fyMember = MemberReader.findFyMemberById((Long)this.modelId, (Long)this.fyId);
        IDNumberTreeNode periodMember = MemberReader.findPeriodMemberById((Long)this.modelId, (Long)this.periodId);
        IDNumberTreeNode entityMember = MemberReader.findEntityMemberById((Long)this.modelId, (Long)this.belongOrgId);
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"bcm_invlimsheetlog");
        this.sheetDataRemoveLogs.addAll(this.generateLogs);
        List collect = this.sheetDataRemoveLogs.parallelStream().map(arg_0 -> this.lambda$successLog$0((DynamicObjectType)dynamicObjectType, modelNumber, scenaMember, fyMember, periodMember, entityMember, arg_0)).collect(Collectors.toList());
        LogORM logORM = LogORM.create();
        logORM.insert(collect);
        this.sheetDataRemoveLogs.clear();
        this.generateLogs.clear();
    }

    @Override
    public void failLogAsync() {
        BCMFuture.runAsync(this::failLog);
    }

    private void failLog() {
        this.sheetDataRemoveLogs.addAll(this.generateLogs);
        Set traceIds = this.sheetDataRemoveLogs.parallelStream().map(Log::getTraceId).collect(Collectors.toSet());
        QFBuilder qfBuilder = new QFBuilder("traceid", "in", traceIds);
        LogORM logORM = LogORM.create();
        logORM.delete("bcm_invlimsheetlog", qfBuilder.toArray());
    }

    private /* synthetic */ DynamicObject lambda$successLog$0(DynamicObjectType dynamicObjectType, String modelNumber, IDNumberTreeNode scenaMember, IDNumberTreeNode fyMember, IDNumberTreeNode periodMember, IDNumberTreeNode entityMember, Log log) {
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        dynamicObject.set("username", (Object)log.getUsername());
        dynamicObject.set("opdate", (Object)log.getOperationDate());
        dynamicObject.set("operation", (Object)this.operationType.getCode());
        dynamicObject.set("model", (Object)modelNumber);
        dynamicObject.set("scenario", (Object)scenaMember.getNumber());
        dynamicObject.set("year", (Object)fyMember.getNumber());
        dynamicObject.set("period", (Object)periodMember.getNumber());
        dynamicObject.set("orgunit", (Object)entityMember.getNumber());
        dynamicObject.set("merge", (Object)log.getMergeNum());
        dynamicObject.set("datamodel", (Object)log.getDataModel());
        dynamicObject.set("categorized", (Object)log.getCategorized());
        dynamicObject.set("relationtype", (Object)log.getRelationType());
        dynamicObject.set("shareholder", (Object)log.getShareholderNumber());
        dynamicObject.set("investeecompany", (Object)log.getInvestedCompanyNumber());
        dynamicObject.set("account", (Object)log.getAcc());
        dynamicObject.set("templatenumber", (Object)log.getTempNumber());
        dynamicObject.set("changetype", (Object)log.getChangeType().getCode());
        dynamicObject.set("value", (Object)log.getValue());
        dynamicObject.set("traceid", (Object)log.getTraceId());
        return dynamicObject;
    }

    static class Log {
        private final String dataModel;
        private final ExtendExtUniqueKey uniqueKey;
        private final String traceId;
        private final String username;
        private final Date operationDate;
        private final InvLimSheetLogConstant.ChangeType changeType;
        private String tempNumber;
        private String value;

        public Log(String dataModel, ExtendExtUniqueKey uniqueKey, InvLimSheetLogConstant.ChangeType changeType) {
            this.dataModel = dataModel;
            this.uniqueKey = uniqueKey;
            this.operationDate = new Date();
            this.traceId = RequestContext.getOrCreate().getTraceId();
            this.username = RequestContext.getOrCreate().getUserName();
            this.changeType = changeType;
        }

        public String getDataModel() {
            return this.dataModel;
        }

        public String getAcc() {
            return this.uniqueKey.getExtendsNumber();
        }

        public String getShareholderNumber() {
            return this.uniqueKey.getHoldCompanyNum();
        }

        public String getInvestedCompanyNumber() {
            return this.uniqueKey.getInvCompanyNum();
        }

        public String getCategorized() {
            return this.uniqueKey.getCategorized();
        }

        public String getUsername() {
            return this.username;
        }

        public InvLimSheetLogConstant.ChangeType getChangeType() {
            return this.changeType;
        }

        public String getRelationType() {
            return this.uniqueKey.getRelationType();
        }

        public String getTempNumber() {
            return this.tempNumber;
        }

        public String getValue() {
            return this.value;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public Date getOperationDate() {
            return this.operationDate;
        }

        public void setTempNumber(String tempNumber) {
            this.tempNumber = tempNumber;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getMergeNum() {
            return this.uniqueKey.getMergeOrg();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Log log = (Log)o;
            return Objects.equals(this.dataModel, log.dataModel) && Objects.equals(this.uniqueKey, log.uniqueKey);
        }

        public int hashCode() {
            return Objects.hash(this.dataModel, this.uniqueKey);
        }
    }
}

