/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.taskjob;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.invest.SheetStatusEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class InvElimSpreadGenerateJobHandler
extends AbstractTask {
    protected static final Log LOG = LogFactory.getLog(InvElimSpreadGenerateJobHandler.class);
    public static final String PARAM_FIXED_ITEM = "spreadGenerateParam";
    public static final String SHEET_LIST = "sheetList";
    public static final String BACK = "generateSpreadBack";
    public static final String SUCCESS = "success";
    public static final String DEAL_COUNT = "dealCount";
    public static final String MESSAGE = "message";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"InvElimSpreadGenerateJobHandler_1", (String)"fi-bcm-business", (Object[])new Object[0]), null);
            FixedItem fixedItem = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)((String)map.get(PARAM_FIXED_ITEM)));
            List selectedSheets = (List)ObjectSerialUtil.deSerializedBytes((String)((String)map.get(SHEET_LIST)));
            long modelId = fixedItem.getModelId();
            long scenarioId = fixedItem.getScenarioId();
            long fyId = fixedItem.getFyId();
            long periodId = fixedItem.getPeriodId();
            long orgId = fixedItem.getOrgId();
            InvestServiceHelper.checkOrgAccessible(modelId, scenarioId, fyId, periodId, orgId);
            InvElimSpreadGenerateService elimCreateService = new InvElimSpreadGenerateService(modelId, scenarioId, fyId, periodId, orgId, selectedSheets);
            elimCreateService.setObserver((desc, progress) -> this.feedbackProgress(progress, (String)desc, null));
            Tuple<Integer, Set<Long>, String> generate = elimCreateService.generate();
            Set successIds = (Set)generate.p2;
            if (!successIds.isEmpty()) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_invlimsheetentity");
                Object[] load = BusinessDataServiceHelper.load((Object[])selectedSheets.stream().filter(dy -> successIds.contains(dy.getLong("template.id"))).map(dy -> dy.getLong("id")).distinct().toArray(), (DynamicObjectType)dataEntityType);
                Arrays.stream(load).filter(dy -> SheetStatusEnum.STORAGE.status().equals(dy.getString("from"))).forEach(dy -> dy.set("from", (Object)SheetStatusEnum.HAND.status()));
                SaveServiceHelper.save((IDataEntityType)dataEntityType, (Object[])load);
            }
            int dealCount = (Integer)generate.p1;
            Set<String> errMsg = elimCreateService.getErrMsg();
            if (successIds.isEmpty()) {
                // empty if block
            }
            if (CollectionUtil.isEmpty(errMsg)) {
                // empty if block
            }
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put(SUCCESS, successIds);
            result.put(DEAL_COUNT, dealCount);
            result.put(MESSAGE, errMsg);
            this.feedbackCustomdata(result);
        }
        catch (Exception e) {
            LOG.error(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55\u5931\u8d25\u3002", (String)"InvElimSpreadGenerateJobHandler_2", (String)"fi-bcm-business", (Object[])new Object[0]), (Throwable)e);
            HashMap<String, Serializable> result = new HashMap<String, Serializable>(4);
            result.put(SUCCESS, Sets.newHashSet());
            result.put(DEAL_COUNT, Integer.valueOf(0));
            result.put(MESSAGE, Sets.newHashSet((Object[])new String[]{e.getMessage()}));
            this.feedbackCustomdata(result);
        }
    }
}

