/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.taskjob;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class InvPaperGenerateJobHandler
extends AbstractTask {
    protected static final Log LOG = LogFactory.getLog(InvPaperGenerateJobHandler.class);
    public static final String PARAM_FIXED_ITEM = "paperGenerateParam";
    public static final String IS_GENERATE_EMPTY_SHEET = "isGenerateEmptySheet";
    public static final String TEMPLATES = "templates";
    public static final String BACK = "generatePaperBack";
    public static final String SUCCESS = "success";
    public static final String MESSAGE = "message";
    private long modelId;
    private long scenarioId;
    private long fyId;
    private long periodId;
    private boolean isGenerateEmptySheet;
    private Set<String> selectedTemplates;
    private final Set<Long> successOrgSet = new ConcurrentHashSet(16);
    private final Map<String, String> id2Message = new HashMap<String, String>(16);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"InvPaperGenerateJobHandler_1", (String)"fi-bcm-business", (Object[])new Object[0]), null);
        FixedItem fixedItem = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)((String)map.get(PARAM_FIXED_ITEM)));
        this.isGenerateEmptySheet = (Boolean)ObjectSerialUtil.deSerializedBytes((String)((String)map.get(IS_GENERATE_EMPTY_SHEET)));
        this.selectedTemplates = (Set)ObjectSerialUtil.deSerializedBytes((String)((String)map.get(TEMPLATES)));
        this.modelId = fixedItem.getModelId();
        this.scenarioId = fixedItem.getScenarioId();
        this.fyId = fixedItem.getFyId();
        this.periodId = fixedItem.getPeriodId();
        List orgList = (List)fixedItem.getOrgList();
        int time = orgList.size();
        this.generatePaperBatch(orgList, (longNumber, index) -> {
            String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u7b2c %1$s / %2$s \u6b21\u6267\u884c\uff0c\u7ec4\u7ec7 %3$s", (String)"InvPaperGenerateJobHandler_2", (String)"fi-bcm-business", (Object[])new Object[0]), index + 1, time, longNumber);
            this.feedbackProgress(100 * index / time, desc, null);
        });
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(SUCCESS, this.successOrgSet.size() == orgList.size());
        result.put(MESSAGE, this.id2Message);
        this.feedbackCustomdata(result);
    }

    private void generatePaperBatch(List<SimpleItem> orgList, ObjIntConsumer<String> notifyProgress) {
        HashMap<Long, Long> dis = new HashMap<Long, Long>(16);
        Set orgIds = orgList.stream().map(SimpleItem::getId).collect(Collectors.toSet());
        DynamicObjectCollection nodeDyns = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,longnumber", (QFilter[])new QFBuilder("id", "in", orgIds).toArray());
        Map<Long, String> id2LongNumber = nodeDyns.stream().collect(Collectors.toMap(k -> k.getLong("id"), dy -> dy.getString("longnumber"), (v1, v2) -> v1));
        Map<String, Long> collect = nodeDyns.stream().collect(Collectors.toMap(k -> k.getString("number"), dy -> dy.getLong("id"), (v1, v2) -> {
            dis.put((Long)v2, (Long)v1);
            return v1;
        }));
        Collection<Long> allDistinctOrg = collect.values();
        HashSet hasPermOrg = Sets.newHashSet(allDistinctOrg);
        InvRelationSearchService.dealNoPermOrg(hasPermOrg, this.modelId);
        Sets.SetView difference = Sets.difference((Set)Sets.newHashSet(allDistinctOrg), (Set)hasPermOrg);
        ArrayList<Callable<Pair<Long, String>>> tasks = new ArrayList<Callable<Pair<Long, String>>>(16);
        int threadNumber = Runtime.getRuntime().availableProcessors() - 1;
        Set<String> periodStatusOpenOrgNum = null;
        if (ConfigServiceHelper.getBoolParam(this.modelId, "CM012")) {
            periodStatusOpenOrgNum = PeriodSettingHelper.batchSelectPeriodStatusOpen(this.modelId, orgList.stream().map(p -> BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)this.modelId), (String)"Entity", (long)LongUtil.toLong((Object)p.id)).getNumber()).collect(Collectors.toSet()), this.scenarioId, this.fyId, this.periodId, "entrystatus");
        }
        Map<Long, McStatus> mcStatusMap = MergeStatusHelper.batchGetMcStatus(this.modelId, this.scenarioId, this.fyId, this.periodId, orgList.stream().map(p -> LongUtil.toLong((Object)p.id)).collect(Collectors.toSet()));
        for (int i = 0; i < orgList.size(); ++i) {
            Long shareId;
            SimpleItem org = orgList.get(i);
            Long id = (Long)org.getId();
            IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)this.modelId), (String)"Entity", (long)id);
            notifyProgress.accept(id2LongNumber.get(id), i);
            if (difference.contains((Object)id) || Objects.nonNull(shareId = (Long)dis.get(id)) && difference.contains((Object)shareId)) {
                this.id2Message.put(id.toString(), ResManager.loadKDString((String)"\u65e0\u6743\u6216\u53ea\u8bfb\u4e0d\u80fd\u751f\u6210\u5e95\u7a3f\u3002", (String)"InvPaperGenerateJobHandler_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                continue;
            }
            if (periodStatusOpenOrgNum != null && !periodStatusOpenOrgNum.contains(orgNode.getNumber())) {
                this.id2Message.put(id.toString(), ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvPaperGenerateJobHandler_4", (String)"fi-bcm-business", (Object[])new Object[0]));
                continue;
            }
            if (MergeControlHelper.isQuoteLocked(this.modelId, this.scenarioId, this.fyId, this.periodId, id)) {
                this.id2Message.put(id.toString(), ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u5f00\u542f\u7248\u672c\u5316\u3002", (String)"InvPaperGenerateJobHandler_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                continue;
            }
            McStatus mcStatus = mcStatusMap.get(id);
            if (mcStatus != null && mcStatus.getFlow().isSubmit()) {
                this.id2Message.put(id.toString(), ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u9ed8\u8ba4\u5e01\u62a5\u8868\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u8005\u201c\u5df2\u5f52\u6863\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvPaperGenerateJobHandler_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                continue;
            }
            if (!hasPermOrg.contains(id)) continue;
            tasks.add(() -> this.generatePaperForOrgUnit(id));
            this.doRun(tasks.size() == threadNumber, tasks, dis);
        }
        this.doRun(!tasks.isEmpty(), tasks, dis);
        dis.entrySet().stream().filter(entry -> this.successOrgSet.contains(entry.getValue())).forEach(entry -> this.successOrgSet.add((Long)entry.getKey()));
    }

    private void doRun(boolean isRun, List<Callable<Pair<Long, String>>> tasks, Map<Long, Long> dis) {
        if (isRun) {
            List<Pair> resultList = ThreadPoolService.runInUpdateTemplateLinkInfoThreadForCallable(tasks.toArray(new Callable[0]));
            for (Pair pair : resultList) {
                this.id2Message.put(((Long)pair.p1).toString(), (String)pair.p2);
                dis.entrySet().stream().filter(entry -> ((Long)entry.getValue()).equals(pair.p1)).forEach(entry -> this.id2Message.put(((Long)entry.getKey()).toString(), (String)pair.p2));
            }
            tasks.clear();
        }
    }

    private Pair<Long, String> generatePaperForOrgUnit(Long orgId) {
        String msg;
        InvElimPaperGenerateService orgRelaService = new InvElimPaperGenerateService((Long)this.modelId, (Long)this.scenarioId, (Long)this.fyId, (Long)this.periodId, orgId, InvLimSheetLogConstant.Operation.GENERATE_LIST);
        orgRelaService.setElimTemplateType(1);
        orgRelaService.setTemplateList(this.selectedTemplates);
        orgRelaService.setInvestGenWay(this.isGenerateEmptySheet);
        InvElimPaperGenerateService invElimPaperGenerateService = new InvElimPaperGenerateService((Long)this.modelId, (Long)this.scenarioId, (Long)this.fyId, (Long)this.periodId, orgId, InvLimSheetLogConstant.Operation.GENERATE_LIST);
        invElimPaperGenerateService.setElimTemplateType(2);
        invElimPaperGenerateService.setTemplateList(this.selectedTemplates);
        invElimPaperGenerateService.setInvestGenWay(this.isGenerateEmptySheet);
        try {
            Pair<Integer, String> result1 = orgRelaService.generatePaper();
            Pair<Integer, String> result2 = invElimPaperGenerateService.generatePaper();
            int p1Max = Math.max((Integer)result1.p1, 0) + Math.max((Integer)result2.p1, 0);
            msg = String.format(ResManager.loadKDString((String)"\u751f\u6210%1$s\u4e2a\u62b5\u9500\u5e95\u7a3f\u3002", (String)"InvPaperGenerateJobHandler_7", (String)"fi-bcm-business", (Object[])new Object[0]), p1Max).concat(result1.p2 == null ? " " : (String)result1.p2).concat(result2.p2 == null ? " " : (String)result2.p2);
            this.successOrgSet.add(orgId);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            msg = String.format(ResManager.loadKDString((String)"\u751f\u6210\u5e95\u7a3f\u5931\u8d25\uff1a%1$s", (String)"InvPaperGenerateJobHandler_8", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage());
        }
        return Pair.onePair((Object)orgId, (Object)msg);
    }
}

