/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.taskjob;

import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;

public class InvTaskJobService {
    private final AbstractFormPlugin plugin;
    private final String taskClassname;
    private final String jobTitle;
    private JobType jobType;

    public InvTaskJobService(AbstractFormPlugin plugin, Class<?> taskClassname, String jobTitle) {
        this.plugin = plugin;
        this.taskClassname = taskClassname.getName();
        this.jobTitle = jobTitle;
        this.jobType = JobType.REALTIME;
    }

    public void createTask(Map<String, Object> params, String callBackId) {
        IFormView view = this.plugin.getView();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(view.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(this.jobType);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(this.taskClassname);
        jobInfo.setName(this.jobTitle);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, callBackId);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(view.getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }
}

