/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.journal;

import com.google.common.collect.HashBasedTable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AdjustClearOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.common.util.CartesianUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ComputingContext;
import org.mozilla.javascript.WrappedException;

public class Journal {
    private ComputingContext ctx;
    private String currentid;
    private String auditnumber;
    private int journalType;
    private boolean autoLink;
    private List<DynamicObject> entryRows = new ArrayList<DynamicObject>(10);
    private Set<String> insertHead = new HashSet<String>(16);
    private final Map<String, DynamicObject> newHeads = new HashMap<String, DynamicObject>(16);
    private final Map<String, DynamicObject> updateHeads = new HashMap<String, DynamicObject>(16);
    private Map<String, Long> mapped = new HashMap<String, Long>(16);
    private List<String> allDim = new ArrayList<String>(16);
    private Map<String, String> fieldMapped = new HashMap<String, String>(16);
    private Map<String, String> dimnumToFormMapper = new HashMap<String, String>(16);
    private Map<String, String> shortNumberMap = new HashMap<String, String>(16);
    private String measures = FacTabFieldDefEnum.FIELD_MONEY.getField();
    private CellSet cellSets;
    private Set<String> process = new HashSet<String>(16);
    private Set<String> process2 = new HashSet<String>(Arrays.asList("CCADJ", "EJE", "CADJ", "ADJ"));
    private long modelId = 0L;
    private Map<String, Integer> headId2EntryCount = new HashMap<String, Integer>();
    private Map<String, Integer> headId2GroupCount = new HashMap<String, Integer>();
    private final Map<String, Object> headPropertyMap = new HashMap<String, Object>();
    private final Map<String, Object> entryPropertyMap = new HashMap<String, Object>();
    private final Set<String> headProperties = new HashSet<String>(16);
    private final Set<String> entryProperties = new HashSet<String>(16);
    private boolean customDC;
    private List<String> fields = new ArrayList<String>(10);

    public Journal() {
        throw new BizRuleException(ResManager.loadKDString((String)"\u521b\u5efaJournal\u5bf9\u8c61\u8bf7\u4f20\u5165\u4e0a\u4e0b\u6587\u53d8\u91cfctx\u6216\u8005\u4f7f\u7528getJournal()\u51fd\u6570\u8fd4\u56de\u7684\u5bf9\u8c61\u3002", (String)"Journal_10", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    public Journal(ComputingContext ctx) {
        this.ctx = ctx;
        this.modelId = MemberReader.findModelIdByNum((String)ctx.getOutline().getModelNum());
        this.checkProcess();
        this.getAllDimNumberIdMapped();
        this.cellSets = new CellSet(this.allDim.toArray(new String[this.allDim.size()]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        this.headProperties.addAll(EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust").getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet()));
        this.entryProperties.addAll(EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata").getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet()));
    }

    private String getSelector() {
        StringBuilder selector = new StringBuilder();
        for (String dim : this.fields) {
            selector.append(dim.toLowerCase(Locale.ENGLISH)).append(",");
        }
        return selector.substring(0, selector.length() - 1);
    }

    public int getJournalType() {
        return this.journalType;
    }

    public void setJournalType(int journalType) {
        this.journalType = journalType;
    }

    public boolean isAutoLink() {
        return this.autoLink;
    }

    public void setAutoLink(boolean autoLink) {
        this.autoLink = autoLink;
    }

    public boolean isCustomDC() {
        return this.customDC;
    }

    public void setCustomDC(boolean customDC) {
        this.customDC = customDC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addProperty(String type, String property, Object value) {
        if ("H".equals(type)) {
            if (!this.headProperties.contains(property)) throw new RuntimeException("not exists property " + property);
            this.headPropertyMap.put(property, value);
            return;
        } else {
            if (!"D".equals(type)) throw new BizRuleException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5b57\u6bb5\u4f4d\u7f6e\uff0c\u5176\u4e2dH\u8868\u793a\u5206\u5f55\u5934\uff0cD\u6807\u8bc6\u5206\u5f55\u884c", (String)"Journal_9", (String)"fi-bcm-business", (Object[])new Object[0]));
            if (!this.entryProperties.contains(property)) throw new RuntimeException("not exists property " + property);
            this.entryPropertyMap.put(property, value);
        }
    }

    private void doClear(ComputingContext ctx, boolean deleteShare, String jlCode) {
        Long scenario = (Long)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1;
        Long year = (Long)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Year.getNumber())).p1;
        Long period = (Long)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Period.getNumber())).p1;
        Long entity = (Long)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Entity.getNumber())).p1;
        String processNumber = (String)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Process.getNumber())).p2;
        QFilter qFilter = new QFilter("entrysource", "=", (Object)"8");
        if (StringUtils.isNotEmpty((String)jlCode)) {
            qFilter.and("adjust.number", "=", (Object)jlCode);
        }
        qFilter.and("adjust.process", "=", (Object)processNumber);
        qFilter.and("adjust", "!=", (Object)0L);
        if (!deleteShare) {
            qFilter.and("adjust.entrysource", "=", (Object)"0");
        }
        if ("ERAdj".equals(processNumber) || "RAdj".equals(processNumber)) {
            LinkedList<Long> ids = new LinkedList<Long>();
            ids.add(entity);
            String entityNum = (String)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Entity.getNumber())).p2;
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)ctx.getOutline().getModelNum(), (String)PresetConstant.ENTITY_DIM, (String)entityNum);
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                if (!node.getId().equals(entity)) {
                    ids.add(node.getId());
                }
                if (node.getShareNodes() != null) {
                    node.getShareNodes().forEach(s -> ids.add(s.getId()));
                }
            }
            qFilter.and("entity", "in", ids);
        } else {
            qFilter.and("entity", "=", (Object)entity);
        }
        ArrayList<Long> adjustIdlist = new ArrayList<Long>(10);
        adjustIdlist.addAll(AdjustQueryServiceHelper.queryAdjustIds(this.modelId, scenario, year, period, null, Collections.singletonList(qFilter)));
        ArrayList lockEntry = new ArrayList();
        Map<Long, HashBasedTable<Long, Long, List<String>>> table = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds("Journal.clear", new AdjustOperationContext(this.modelId, (Long)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1, (Long)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Year.getNumber())).p1, (Long)((Pair)ctx.getScopeItems().get((Object)SysDimensionEnum.Period.getNumber())).p1), adjustIdlist, pair -> String.valueOf(lockEntry.add(pair.p1)));
        if (!table.isEmpty()) {
            String lockDimNumber = LockScopeServiceHelper.getLockDimNumber(this.modelId);
            String idmName = (String)MemberReader.getDimNumberMapNameById((long)this.modelId).get(lockDimNumber);
            String field = this.fieldMapped.get(lockDimNumber) == null ? lockDimNumber.toLowerCase() : this.fieldMapped.get(lockDimNumber);
            Set<String> members = lockEntry.stream().map(entry -> entry.getString(field + ".number")).collect(Collectors.toSet());
            StringJoiner sj = new StringJoiner(",");
            members.forEach(sj::add);
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5206\u5f55\u5931\u8d25\uff0c%1$s\u7ef4\u5ea6\u6210\u5458\u3010%2$s\u3011\u5df2\u9501\u5b9a\u3002", (String)"Journal_12", (String)"fi-bcm-business", (Object[])new Object[0]), idmName, sj));
        }
        if (!adjustIdlist.isEmpty()) {
            AdjustClearOperation clearOperation = new AdjustClearOperation((Long)this.modelId, scenario, year, period, adjustIdlist);
            clearOperation.setAutoElim(true);
            clearOperation.excute();
        }
    }

    public void clear(ComputingContext ctx, boolean deleteShare) {
        this.doClear(ctx, deleteShare, null);
    }

    public void clear() {
        this.doClear(this.ctx, false, null);
    }

    public void clear(boolean deleteShare) {
        this.doClear(this.ctx, deleteShare, null);
    }

    public void clear(String jlCode) {
        String finalJlCode = this.dealJlCodeParam(jlCode);
        this.doClear(this.ctx, false, finalJlCode);
    }

    public void clear(String jlCode, boolean deletShare) {
        String finalJlCode = this.dealJlCodeParam(jlCode);
        this.doClear(this.ctx, deletShare, finalJlCode);
    }

    public void open(String jlCode, String jlName, String atCode, String templateCode, String jlDesc) {
        if (this.ctx == null) {
            throw new RuntimeException("Journal Object should contain Context(ctx)");
        }
        String tempJLCode = this.dealJlCodeParam(jlCode);
        this.checkAuditTrail(atCode);
        this.checkAdjCatalog(templateCode);
        this.getAdjEntryByNumber(tempJLCode, atCode, templateCode, jlName, jlDesc);
    }

    public void insert(Number srcDims, String tarDims, Double tarFactor, String summary, String groupNumber) {
        BigDecimal factor;
        BigDecimal tar;
        BigDecimal src;
        this.checkFactor(tarFactor);
        Boolean isDebit = this.getDebit(tarFactor);
        if (isDebit != null) {
            src = new BigDecimal(srcDims.toString());
        } else if (srcDims instanceof Integer) {
            src = BigDecimal.valueOf((double)((Integer)srcDims).intValue() * tarFactor);
        } else if (srcDims instanceof Double) {
            tar = BigDecimal.valueOf((Double)srcDims);
            factor = BigDecimal.valueOf(tarFactor);
            src = tar.multiply(factor);
        } else if (srcDims instanceof BigDecimal) {
            tar = (BigDecimal)srcDims;
            factor = BigDecimal.valueOf(tarFactor);
            src = tar.multiply(factor);
        } else {
            src = srcDims instanceof Long ? BigDecimal.valueOf((double)((Long)srcDims).longValue() * tarFactor) : new BigDecimal(srcDims.toString());
        }
        List<List<String>> memberList = this.dealTarDims(tarDims);
        LinkedList result = new LinkedList();
        this.checkDimSize(memberList);
        CartesianUtil.descartes(memberList, result, (int)0, new ArrayList(10));
        int gNumber = StringUtils.isEmpty((String)groupNumber) ? 1 : Integer.parseInt(groupNumber);
        this.headId2GroupCount.putIfAbsent(this.currentid, gNumber);
        this.headId2GroupCount.put(this.currentid, Integer.max(this.headId2GroupCount.get(this.currentid), gNumber));
        int seq = 1;
        int start = this.entryRows.size();
        for (List lis : result) {
            this.addEntryRows(lis, src, summary, seq++, String.valueOf(gNumber), isDebit);
            this.cellSets.set(lis.toArray(new String[this.allDim.size()]), this.measures, (Object)src);
        }
        this.entryInsertCheck(start);
    }

    private void entryInsertCheck(int start) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (start == this.entryRows.size()) {
            return;
        }
        IntStream.range(start, this.entryRows.size()).forEach(ind -> list.add(this.entryRows.get(ind)));
        HashBasedTable<Long, Long, List<String>> res = AdjustOperationHelper.batchCheckOlapDataLock("Journal.insert", new AdjustOperationContext(this.modelId, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Year.getNumber())).p1, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Period.getNumber())).p1), list, null);
        if (!res.isEmpty()) {
            String lockDimNumber = LockScopeServiceHelper.getLockDimNumber(this.modelId);
            String idmName = (String)MemberReader.getDimNumberMapNameById((long)this.modelId).get(lockDimNumber);
            String field = this.fieldMapped.get(lockDimNumber) == null ? lockDimNumber.toLowerCase() : this.fieldMapped.get(lockDimNumber);
            Set<String> members = list.stream().map(entry -> MemberReader.findMemberById((long)this.modelId, (String)MemberReader.getEntityNumberByDim((String)this.ctx.getOutline().getModelNum(), (String)lockDimNumber), (Long)entry.getLong(field)).getNumber()).collect(Collectors.toSet());
            StringJoiner sj = new StringJoiner(",");
            members.forEach(sj::add);
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u63d2\u5165\u5206\u5f55\u5931\u8d25\uff0c%1$s\u7ef4\u5ea6\u6210\u5458\u3010%2$s\u3011\u5df2\u9501\u5b9a\u3002", (String)"Journal_14", (String)"fi-bcm-business", (Object[])new Object[0]), idmName, sj));
        }
    }

    private Boolean getDebit(Double tarFactor) {
        Boolean isDebit = null;
        if (this.isCustomDC()) {
            isDebit = tarFactor == 1.0;
        }
        return isDebit;
    }

    private void checkFactor(Double tarFactor) {
        if (this.customDC && tarFactor != 1.0 && tarFactor != -1.0) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u89c4\u5219\u751f\u6210\u81ea\u5b9a\u4e49\u501f\u8d37\u65b9\u5411\u7684\u5206\u5f55\u65f6\uff0cfactor\u53c2\u6570\u53ea\u80fd\u8f93\u51651\uff08\u501f\u65b9\uff09\u6216-1\uff08\u8d37\u65b9\uff09\u3002", (String)"Journal_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public void insert(String srcDims, String tarDims, Double tarFactor, String summary, String groupNumber) {
        int start;
        this.checkFactor(tarFactor);
        if (null == srcDims) {
            this.insert(tarDims, tarFactor, summary);
            return;
        }
        if (srcDims.trim().length() != 0) {
            String[] p_s;
            Map<String, String> srcMap = this.dealSrcStr(srcDims);
            Map<String, String> tarMap = this.dealTarStr(tarDims);
            Map<String, String> commonMap = this.getCommonDimensionMap(srcMap);
            String process = commonMap.get(SysDimensionEnum.Process.getNumber());
            String entity = commonMap.get(SysDimensionEnum.Entity.getNumber());
            if (!TransMemberUtil.isSpecialEntity(process) && (p_s = entity.split("_")).length > 1) {
                commonMap.put(SysDimensionEnum.Entity.getNumber(), p_s[1]);
            }
            MDResultSet mdResultSet = this.getOlapDatas(commonMap);
            HashMap<String, Integer> allDimIndex = new HashMap<String, Integer>(this.mapped.size());
            MDResultSetMetaData md = mdResultSet.getMetaData();
            for (String dim : this.mapped.keySet()) {
                allDimIndex.put(dim, md.getColIndex(dim));
            }
            mdResultSet.beforeFirst();
            int seq = 1;
            Boolean isDebit = this.getDebit(tarFactor);
            start = this.entryRows.size();
            while (mdResultSet.next()) {
                Row row = mdResultSet.getRow();
                LinkedList<String> members = new LinkedList<String>();
                for (String dim : this.allDim) {
                    if (SysDimensionEnum.AuditTrail.getNumber().equals(dim) && StringUtils.isNotEmpty((String)this.auditnumber)) {
                        members.add(this.auditnumber);
                        continue;
                    }
                    String memberNum = row.getValue((Integer)allDimIndex.get(dim)).toString();
                    if (tarMap.get(dim) != null) {
                        members.add(tarMap.get(dim));
                        continue;
                    }
                    members.add(memberNum);
                }
                BigDecimal val = row.getBigDecimal(this.measures);
                BigDecimal value = isDebit != null ? val : val.multiply(BigDecimal.valueOf(tarFactor));
                this.cellSets.set(members.toArray(new String[members.size()]), this.measures, (Object)value);
                this.addEntryRows(members, value, summary, seq++, groupNumber, isDebit);
            }
        } else {
            throw new RuntimeException("dimension or member missed!!!");
        }
        this.entryInsertCheck(start);
    }

    public void insert(String tarDims, Double tarFactor, String summary) {
        List<List<String>> memberList = this.dealTarDims(tarDims);
        LinkedList result = new LinkedList();
        this.checkDimSize(memberList);
        CartesianUtil.descartes(memberList, result, (int)0, new ArrayList(10));
        for (List lis : result) {
            this.cellSets.set(lis.toArray(new String[this.allDim.size()]), this.measures, null);
        }
    }

    public void submit() {
        this.doSubmit();
    }

    public void doSubmit() {
        ArrayList<Long> pks = new ArrayList<Long>(10);
        ArrayList<DynamicObject> newHeadList = new ArrayList<DynamicObject>(this.newHeads.values());
        ArrayList<DynamicObject> updateHeadList = new ArrayList<DynamicObject>(this.updateHeads.values());
        if (!this.insertHead.isEmpty() && !this.entryRows.isEmpty()) {
            for (String string : this.insertHead) {
                if (this.headId2EntryCount.get(string) == null) continue;
                pks.add(Long.valueOf(string));
            }
            newHeadList.removeIf(head -> !pks.contains(head.getLong("id")));
            updateHeadList.removeIf(head -> !pks.contains(head.getLong("id")));
            ArrayList<DynamicObject> allHead = new ArrayList<DynamicObject>();
            allHead.addAll(newHeadList);
            allHead.addAll(updateHeadList);
            for (DynamicObject head2 : allHead) {
                DynamicObjectCollection commembentry = head2.getDynamicObjectCollection("commembentry");
                this.insertCommonEntry(commembentry);
                DynamicObjectCollection dynamicObjectCollection = head2.getDynamicObjectCollection("spreadmembentry");
                this.insertSpreadMemEntry(dynamicObjectCollection);
            }
        }
        HashMap map = new HashMap();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap groupMap = new HashMap();
        this.headId2EntryCount.forEach((k, v) -> {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumIntegerDigits(String.valueOf(v).length());
            numberFormat.setGroupingUsed(false);
            map.put(k, numberFormat);
            countMap.put((String)k, 0);
        });
        this.headId2GroupCount.forEach((k, v) -> {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumIntegerDigits(String.valueOf(v).length());
            numberFormat.setGroupingUsed(false);
            groupMap.put(k, numberFormat);
        });
        for (DynamicObject dynamicObject : this.entryRows) {
            String groupnum;
            String adjust = dynamicObject.getString("adjust");
            if (map.containsKey(adjust)) {
                int number = (Integer)hashMap.get(adjust) + 1;
                dynamicObject.set("dseq", (Object)((NumberFormat)map.get(adjust)).format(number));
                hashMap.put(adjust, number);
            }
            if (!groupMap.containsKey(adjust) || !(groupnum = dynamicObject.getString("groupnum")).startsWith("G")) continue;
            int number = Integer.parseInt(groupnum.substring(1));
            dynamicObject.set("groupnum", (Object)("G" + ((NumberFormat)groupMap.get(adjust)).format(number)));
        }
        if (!pks.isEmpty()) {
            Map<Long, List<DynamicObject>> pk2Entries = this.entryRows.stream().collect(Collectors.groupingBy(p -> p.getLong("adjust")));
            AdjustConvertUtil.setAdjustDataShowSeqByMoreAdjust(this.entryRows, AdjustDataSortRuleEnum.GROUPSEQ_SORT);
            if (!newHeadList.isEmpty()) {
                for (DynamicObject head3 : newHeadList) {
                    AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)head3, (Collection)pk2Entries.get(head3.getLong("id")), (boolean)true);
                }
                SaveServiceHelper.save((DynamicObject[])newHeadList.toArray(new DynamicObject[0]));
            }
            if (!updateHeadList.isEmpty()) {
                for (DynamicObject head2 : updateHeadList) {
                    AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)head2, (Collection)pk2Entries.get(head2.getLong("id")), (boolean)true);
                }
                SaveServiceHelper.save((DynamicObject[])updateHeadList.toArray(new DynamicObject[0]));
            }
            Object[] objectArray = SaveServiceHelper.save((DynamicObject[])this.entryRows.toArray(new DynamicObject[this.entryRows.size()]));
            ThreadCache.put((Object)"ignoreClear", (Object)true);
            if (this.isAutoLink()) {
                LinkageMappingService linkageMappingService = LinkageMappingService.newObject(pks, EntrySourceEnum.MANUALLINKAGECREATE);
                if (LockScopeServiceHelper.isExistLockDim(this.modelId)) {
                    LinkageDataCollector linkageAdjustData = linkageMappingService.getPreGenerateLinkageAdjustData();
                    List<DynamicObject> links = linkageAdjustData.getCreateLinkageDatas();
                    HashBasedTable<Long, Long, List<String>> res = AdjustOperationHelper.batchCheckOlapDataLock("Journal.insert", new AdjustOperationContext(this.modelId, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Year.getNumber())).p1, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Period.getNumber())).p1), links, null);
                    if (!res.isEmpty()) {
                        if (!newHeadList.isEmpty()) {
                            DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)newHeadList.get(0)).getDynamicObjectType(), (Object[])newHeadList.stream().map(head -> head.getLong("id")).toArray());
                        }
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata"), (Object[])this.entryRows.stream().map(row -> row.getLong("id")).toArray());
                        throw new BizRuleException(ResManager.loadKDString((String)"\u63d2\u5165\u7684\u7ef4\u5ea6\u7ec4\u5408\u6210\u5458\u5b58\u5728\u9501\u5b9a\u7684\u8054\u52a8\u7684\u7ef4\u5ea6\u7ec4\u5408\u6210\u5458\uff0c\u89c4\u5219\u6267\u884c\u5931\u8d25\u3002", (String)"Journal_13", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    Collection values = linkageMappingService.buildAutoElimLinkage().getSourceId2LinkageIdMap().values().stream().filter(e -> e != 0L).collect(Collectors.toList());
                    pks.addAll(values);
                } else {
                    Collection values = linkageMappingService.buildAutoElimLinkage().getSourceId2LinkageIdMap().values().stream().filter(e -> e != 0L).collect(Collectors.toList());
                    pks.addAll(values);
                }
            }
            ThreadCache.put((Object)"ignoreLock", (Object)true);
            AdjustmentServiceHelper.sycToMDD(new OperationResult(), pks, true, AdjustTypeEnum.ADJUST, false);
            if (ThreadCache.get((Object)"isLockException") != null) {
                ThreadCache.remove((Object)"isLockException");
                if (newHeadList.size() > 0) {
                    List ids = newHeadList.stream().map(head -> head.getLong("id")).collect(Collectors.toList());
                    DeleteServiceHelper.delete((String)"bcm_rptadjust", (QFilter[])new QFBuilder("id", "in", ids).toArray());
                }
                if (objectArray.length > 0) {
                    List entries = Arrays.stream(objectArray).map(save -> ((DynamicObject)save).getLong("id")).collect(Collectors.toList());
                    DeleteServiceHelper.delete((String)"bcm_rptadjustdata", (QFilter[])new QFBuilder("id", "in", entries).toArray());
                }
            }
            ThreadCache.put((Object)"ignoreLock", (Object)true);
            ThreadCache.remove((Object)"ignoreClear");
            this.newHeads.clear();
            this.updateHeads.clear();
        }
    }

    private void checkProcess() {
        this.process = this.getAdjProcess();
        String processNumber = (String)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Process.getNumber())).p2;
        if (processNumber == null || !this.process.contains(processNumber)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u975e\u8c03\u6574\u8fc7\u7a0b\u4e0b\uff0c\u4e0d\u80fd\u901a\u8fc7\u89c4\u5219\u751f\u6210\u5206\u5f55\u3002", (String)"Journal_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private Set<String> getAdjProcess() {
        QFBuilder range = new QFBuilder("model", "=", (Object)this.modelId);
        range.and("datasource", "=", (Object)"2");
        range.and("isbizrule", "=", (Object)true);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_processmembertree", (String)"number", (QFilter[])range.toArray());
        return map.values().stream().map(value -> value.getString("number")).collect(Collectors.toSet());
    }

    private void getAdjEntryByNumber(String tempJLCode, String atCode, String templateCode, String jlName, String jlDesc) {
        DynamicObject dyn;
        QFBuilder range = new QFBuilder("number", "=", (Object)tempJLCode);
        range.and("model.number", "=", (Object)this.ctx.getOutline().getModelNum());
        StringBuilder selectFields = new StringBuilder("id,name,number,model,scenario,year,period,process,audittrail,status,creator,createtime,modifier,modifytime,journaltype,balancetype,sourcetype,entity,bussnesstype,updatecycle,belongorg,inputmode,commembentry,commembentry.comdimension,commembentry.commembid,commembentry.seq,commembentry.comentitysign,spreadmembentry,spreadmembentry.spreaddimension,spreadmembentry.spreadmembid,spreadmembentry.seq,spreadmembentry.spreadentitysign,templatecatalog,description,checkrecord,entrysource,linkagelinksource,linkcreatetype,multiplecurrency,belongorglist,belongorglist.belongorgmem");
        if (!this.headPropertyMap.isEmpty()) {
            for (String property : this.headPropertyMap.keySet()) {
                selectFields.append(",").append(property);
            }
        }
        if ((dyn = BusinessDataServiceHelper.loadSingle((String)"bcm_rptadjust", (String)selectFields.toString(), (QFilter[])range.toArray())) == null) {
            DynamicObject dynamicObject = dyn = this.newHeads.get(tempJLCode) == null ? this.updateHeads.get(tempJLCode) : this.newHeads.get(tempJLCode);
        }
        if (dyn == null) {
            dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
            this.initHeadDynamic1(dyn, tempJLCode);
            this.newHeads.put(tempJLCode, dyn);
        } else {
            this.updateHeads.put(tempJLCode, dyn);
            Map<Long, HashBasedTable<Long, Long, List<String>>> res = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds("Journal.open", new AdjustOperationContext(this.modelId, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Year.getNumber())).p1, (Long)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Period.getNumber())).p1), Collections.singletonList(dyn.getLong("id")), null);
            if (!res.isEmpty()) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u63d2\u5165\u7684\u7ef4\u5ea6\u7ec4\u5408\u6210\u5458\u5b58\u5728\u9501\u5b9a\u7684\u7ef4\u5ea6\u7ec4\u5408\u6210\u5458\uff0c\u89c4\u5219\u6267\u884c\u5931\u8d25\u3002", (String)"Journal_11", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        this.initHeadDynamic2(dyn, tempJLCode, atCode, templateCode, jlName, jlDesc);
        this.currentid = dyn.getString("id");
        this.auditnumber = atCode;
    }

    private void initHeadDynamic1(DynamicObject dyn, String number) {
        dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyn.set("model", (Object)this.modelId);
        dyn.set("number", (Object)number);
        dyn.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dyn.set("createtime", (Object)TimeServiceHelper.now());
    }

    private void initHeadDynamic2(DynamicObject dyn, String number, String audNumber, String templateCode, String jlName, String jlDesc) {
        dyn.set("name", (Object)jlName);
        dyn.set("scenario", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1);
        dyn.set("year", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Year.getNumber())).p1);
        dyn.set("period", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Period.getNumber())).p1);
        dyn.set("status", (Object)RptAdjustStatusEnum.AUDIT.status());
        dyn.set("process", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Process.getNumber())).p2);
        dyn.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        dyn.set("journaltype", (Object)(this.journalType == 0 ? 1 : this.journalType));
        dyn.set("balancetype", (Object)2);
        Long entryId = this.getEntryId((Pair<Long, String>)((Pair)this.ctx.getScopeItems().get(SysDimensionEnum.Entity.getNumber())));
        dyn.set("entity", (Object)entryId);
        dyn.set("bussnesstype", (Object)AdjustBusinessTypeUtil.getBusinessTypeByProcess((String)((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Process.getNumber())).p2));
        dyn.set("updatecycle", (Object)"REQUIRED");
        dyn.set("belongorg", (Object)entryId);
        dyn.set("inputmode", (Object)"summoney");
        dyn.set("templatecatalog", this.checkAdjCatalog(templateCode).getPkValue());
        dyn.set("description", (Object)jlDesc);
        dyn.set("checkrecord", (Object)0);
        dyn.set("linkcreatetype", (Object)(this.isAutoLink() ? AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus() : AdjustLinkCreateEnum.COMMONADJUST.getStatus()));
        dyn.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.AUTO.getValue());
        dyn.set("entrysource", (Object)"0");
        dyn.set("multiplecurrency", (Object)"0");
        if (this.headPropertyMap.size() > 0) {
            for (Map.Entry<String, Object> entry : this.headPropertyMap.entrySet()) {
                dyn.set(entry.getKey(), entry.getValue());
            }
        }
    }

    private DynamicObject checkAdjCatalog(String templateCode) {
        if (StringUtils.isEmpty((String)templateCode)) {
            templateCode = "root";
        }
        QFBuilder range = new QFBuilder("number", "=", (Object)templateCode);
        range.and("model.number", "=", (Object)this.ctx.getOutline().getModelNum());
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_templatecatalog", (QFilter[])range.toArray());
        if (dyn == null) {
            throw new RuntimeException("AdjCatalog number is error!!!");
        }
        return dyn;
    }

    private IDNumberTreeNode checkAuditTrail(String atCode) {
        if (StringUtils.isNotEmpty((String)atCode)) {
            String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.AUDITTRIAL.getNumber(), (String)atCode);
            if (node != null && node.getId() != -1L) {
                return node;
            }
            throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u5ba1\u8ba1\u7ebf\u7d22\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"Journal_2", (String)"fi-bcm-business", (Object[])new Object[0]), atCode)));
        }
        return null;
    }

    private String dealJlCodeParam(String jlCode) {
        String result = jlCode;
        HashSet<String> curProcess = new HashSet<String>(Arrays.asList("RAdj", "ERAdj", "DEJE", "DADJ"));
        HashSet<String> parProcess = new HashSet<String>(Arrays.asList("CCADJ", "EJE", "CADJ", "ADJ"));
        Pair process = (Pair)this.ctx.getScopeItems().get(SysDimensionEnum.Process.getNumber());
        Pair entity = (Pair)this.ctx.getScopeItems().get(SysDimensionEnum.Entity.getNumber());
        String year = (String)((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.FY_DIM)).p2;
        String period = (String)((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p2;
        IDNumberTreeNode processNode = MemberReader.findProcessMemberById((String)this.ctx.getOutline().getModelNum(), (Long)((Long)process.p1));
        if (process == null) {
            throw new RuntimeException("Dimension Process is missing");
        }
        String processNum = (String)process.p2;
        if (curProcess.contains(processNum)) {
            result = String.format("R_JL_%s_%s_%s%s_%s", process.p2, entity.p2, year.substring(2), period.substring(3), jlCode);
        } else if (parProcess.contains(processNum) || processNode.getParent() != IDNumberTreeNode.NotFoundTreeNode && "EJE".equals(processNode.getParent().getNumber())) {
            String parentEntity = this.queryMemberParentNumber((Long)entity.p1);
            result = ((String)entity.p2).startsWith(parentEntity) ? String.format("R_JL_%s_%s_%s%s_%s", process.p2, entity.p2, year.substring(2), period.substring(3), jlCode) : String.format("R_JL_%s_%s_%s%s_%s", process.p2, parentEntity + "_" + (String)entity.p2, year.substring(2), period.substring(3), jlCode);
        }
        return result;
    }

    private String queryMemberParentNumber(Long p1) {
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])new Long[]{p1}, (String)"bcm_entitymembertree");
        return ((DynamicObject)map.get(p1)).getDynamicObject("parent").getString("number");
    }

    private Long queryMemberParentId(Long p1) {
        IDNumberTreeNode node = MemberReader.findMemberById((long)this.modelId, (String)"bcm_entitymembertree", (Long)p1);
        if (node != null && node.getParent() != null) {
            return node.getParent().getId();
        }
        return 0L;
    }

    private Long getEntryId(Pair<Long, String> processPair) {
        Long entryId = 0L;
        Pair processDim = (Pair)this.ctx.getScopeItems().get(SysDimensionEnum.Process.getNumber());
        IDNumberTreeNode processNode = MemberReader.findProcessMemberById((String)this.ctx.getOutline().getModelNum(), (Long)((Long)processDim.p1));
        entryId = this.process2.contains(processDim.p2) || processNode.getParent() != IDNumberTreeNode.NotFoundTreeNode && "EJE".equals(processNode.getParent().getNumber()) ? this.queryMemberParentId((Long)processPair.p1) : (Long)processPair.p1;
        return entryId;
    }

    private List<List<String>> dealTarDims(String tarDims) {
        ArrayList<List<String>> memberList = new ArrayList<List<String>>(10);
        Map<String, String> memberMap = this.dealTarStr(tarDims);
        HashMap notCommScopeInfo = new HashMap(16);
        this.ctx.getRuntimeScope(null).getFilters().forEach(d -> {
            if (!this.ctx.getScopeItems().containsKey(d.getName())) {
                notCommScopeInfo.put(d.getName(), d.getValues());
            }
        });
        this.allDim.forEach(dim -> {
            if (this.ctx.getScopeItems().containsKey(dim)) {
                memberList.add(new ArrayList<Object>(Collections.singletonList(((Pair)this.ctx.getScopeItems().get((Object)dim)).p2)));
            } else if (memberMap.containsKey(dim)) {
                memberList.add(new ArrayList(Collections.singletonList(memberMap.get(dim))));
            } else if (notCommScopeInfo.containsKey(dim)) {
                memberList.add(new ArrayList((Collection)notCommScopeInfo.get(dim)));
            } else if (SysDimensionEnum.AuditTrail.getNumber().equals(dim)) {
                if (StringUtils.isNotEmpty((String)this.auditnumber)) {
                    memberList.add(new ArrayList<String>(Collections.singletonList(this.auditnumber)));
                } else {
                    memberList.add(new ArrayList<String>(Collections.singletonList("")));
                }
            } else {
                List<String> members = this.getBaseMember((String)dim);
                memberList.add(members);
            }
        });
        return memberList;
    }

    private List<String> getBaseMember(String dim) {
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        Collection nodes = MemberReader.getAllNodeByDimNum((String)dim, (String)modelNum);
        ArrayList<String> numList = new ArrayList<String>(nodes.size());
        for (IDNumberTreeNode node : nodes) {
            if (!node.isLeaf()) continue;
            numList.add(node.getNumber());
        }
        return numList;
    }

    private Set<String> getBaseMemberSet(String dim) {
        SysDimensionEnum sysEnum = SysDimensionEnum.getEnumByNumber((String)dim);
        String entity = sysEnum == null ? "bcm_userdefinedmembertree" : sysEnum.getMemberTreemodel();
        QFBuilder range = new QFBuilder("model", "=", (Object)this.modelId);
        range.and("isleaf", "=", (Object)true);
        range.and("dimension", "=", (Object)this.mapped.get(dim));
        return QueryServiceHelper.query((String)entity, (String)"number", (QFilter[])range.toArray()).stream().map(dyn -> dyn.getString("number")).collect(Collectors.toSet());
    }

    private Map<String, String> dealTarStr(String tarDims) {
        String[] splits;
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        for (String split : splits = tarDims.split(",")) {
            if (split.contains("@")) {
                String[] temps = split.split("@");
                String dim = temps[0];
                String mem = temps[1];
                if (this.mapped.containsKey(dim)) {
                    if (this.ctx.getScopeItems().containsKey(dim)) {
                        throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u4e0d\u53ef\u5305\u542bscope\u8303\u56f4\u4e2d\u7684\u7ef4\u5ea6\u201c%1$s\u201d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"Journal_5", (String)"fi-bcm-business", (Object[])new Object[0]), dim)));
                    }
                    memberMap.put(dim, mem);
                    continue;
                }
                if (this.shortNumberMap.containsKey(dim)) {
                    memberMap.put(this.shortNumberMap.get(dim), mem);
                    continue;
                }
                throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4fee\u6b63\u540e\u91cd\u8bd5\u3002", (String)"Journal_4", (String)"fi-bcm-business", (Object[])new Object[0]), dim)));
            }
            throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u7684\u683c\u5f0f\u5fc5\u987b\u662f\u201cXX@XX\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"Journal_6", (String)"fi-bcm-business", (Object[])new Object[0]), split)));
        }
        return memberMap;
    }

    private Map<String, String> dealSrcStr(String srcDims) {
        String[] splits;
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        for (String split : splits = srcDims.split(",")) {
            if (split.contains("@")) {
                String[] temps = split.split("@");
                String dim = temps[0];
                String mem = temps[1];
                if (this.mapped.containsKey(dim)) {
                    memberMap.put(dim, mem);
                    continue;
                }
                if (this.shortNumberMap.containsKey(dim)) {
                    memberMap.put(this.shortNumberMap.get(dim), mem);
                    continue;
                }
                throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4fee\u6b63\u540e\u91cd\u8bd5\u3002", (String)"Journal_4", (String)"fi-bcm-business", (Object[])new Object[0]), dim)));
            }
            throw new WrappedException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u7684\u683c\u5f0f\u5fc5\u987b\u662f\u201cXX@XX\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"Journal_6", (String)"fi-bcm-business", (Object[])new Object[0]), split)));
        }
        return memberMap;
    }

    private Map<String, String> getCommonDimensionMap(Map<String, String> srcMap) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        this.allDim.forEach(dim -> {
            if (srcMap.get(dim) != null) {
                map.put((String)dim, (String)srcMap.get(dim));
            } else if (this.ctx.getScopeItems().containsKey(dim)) {
                map.put((String)dim, (String)((Pair)this.ctx.getScopeItems().get((Object)dim)).p2);
            }
        });
        return map;
    }

    private void addEntryRows(List<String> members, BigDecimal value, String summary, int seq, String groupNumber, Boolean isDebit) {
        value = (BigDecimal)this.ctx.executeRound((Object)value);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata");
        DynamicObject entry = new DynamicObject((DynamicObjectType)entityType, null);
        entry.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        entry.set("dseq", seq < 10 ? "0" + seq : Integer.valueOf(seq));
        entry.set("adjust", (Object)this.currentid);
        entry.set("model", (Object)this.modelId);
        entry.set("scenario", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1);
        entry.set("year", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Year.getNumber())).p1);
        entry.set("period", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Period.getNumber())).p1);
        entry.set("process", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Process.getNumber())).p1);
        Long audit = this.getMemId(members, SysDimensionEnum.AuditTrail);
        if (audit == 0L) {
            throw new BizRuleException("missing auditTrail");
        }
        entry.set("audittrail", (Object)audit);
        entry.set("entity", ((Pair)this.ctx.getScopeItems().get((Object)SysDimensionEnum.Entity.getNumber())).p1);
        entry.set("mycompany", (Object)this.getMemId(members, SysDimensionEnum.MyCompany));
        entry.set("internalcompany", (Object)this.getMemId(members, SysDimensionEnum.InternalCompany));
        entry.set("merge", (Object)this.getEntryId((Pair<Long, String>)((Pair)this.ctx.getScopeItems().get(SysDimensionEnum.Entity.getNumber()))));
        Long accountId = this.getMemId(members, SysDimensionEnum.Account);
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bcm_accountmembertree", (String)"drcrdirect");
        if (isDebit != null) {
            if (isDebit.booleanValue()) {
                entry.set("debit", (Object)value);
            } else {
                entry.set("credit", (Object)value);
            }
        } else {
            BigDecimal journalValue = value.abs();
            if ("1".equals(account.getString("drcrdirect"))) {
                if (value.compareTo(BigDecimal.ZERO) >= 0) {
                    entry.set("debit", (Object)journalValue);
                } else {
                    entry.set("credit", (Object)journalValue);
                }
            } else if ("2".equals(account.getString("drcrdirect"))) {
                if (value.compareTo(BigDecimal.ZERO) < 0) {
                    entry.set("debit", (Object)journalValue);
                } else {
                    entry.set("credit", (Object)journalValue);
                }
            } else {
                return;
            }
        }
        entry.set("summoney", (Object)value);
        entry.set("account", (Object)accountId);
        entry.set("changetype", (Object)this.getMemId(members, SysDimensionEnum.ChangeType));
        entry.set("multigaap", (Object)this.getMemId(members, SysDimensionEnum.MultiGAAP));
        entry.set("datasort", (Object)this.getMemId(members, SysDimensionEnum.DataSort));
        entry.set("currency", ((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.CURRENCY_DIM)).p1);
        entry.set("dim1", (Object)(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(0)) == null ? Long.valueOf(0L) : this.queryDimensionMemberByNumber(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(0)), members.get(this.allDim.indexOf(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(0)))))));
        entry.set("dim2", (Object)(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(1)) == null ? Long.valueOf(0L) : this.queryDimensionMemberByNumber(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(1)), members.get(this.allDim.indexOf(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(1)))))));
        entry.set("dim3", (Object)(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(2)) == null ? Long.valueOf(0L) : this.queryDimensionMemberByNumber(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(2)), members.get(this.allDim.indexOf(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(2)))))));
        entry.set("dim4", (Object)(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(3)) == null ? Long.valueOf(0L) : this.queryDimensionMemberByNumber(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(3)), members.get(this.allDim.indexOf(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(3)))))));
        entry.set("dim5", (Object)(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(4)) == null ? Long.valueOf(0L) : this.queryDimensionMemberByNumber(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(4)), members.get(this.allDim.indexOf(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(4)))))));
        entry.set("dim6", (Object)(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(5)) == null ? Long.valueOf(0L) : this.queryDimensionMemberByNumber(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(5)), members.get(this.allDim.indexOf(this.fieldMapped.get(CheckConstant.PRESET_DIMFIELDS.get(5)))))));
        entry.set("groupnum", (Object)("G" + groupNumber));
        entry.set("entrysource", (Object)8);
        entry.set("description", (Object)(summary.length() > 0 ? summary : ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5206\u5f55", (String)"Journal_1", (String)"fi-bcm-business", (Object[])new Object[0])));
        entry.set("differ", (Object)0.0);
        entry.set("isdefaultcurrency", (Object)"1");
        entry.set("linksource", (Object)0);
        if (this.entryPropertyMap.size() > 0) {
            for (Map.Entry<String, Object> objectEntry : this.entryPropertyMap.entrySet()) {
                entry.set(objectEntry.getKey(), objectEntry.getValue());
            }
        }
        this.entryRows.add(entry);
        this.insertHead.add(this.currentid);
        this.headId2EntryCount.putIfAbsent(this.currentid, 0);
        this.headId2EntryCount.put(this.currentid, this.headId2EntryCount.get(this.currentid) + 1);
    }

    private Long getMemId(List<String> members, SysDimensionEnum sysDimensionEnum) {
        if (!this.allDim.contains(sysDimensionEnum.getNumber()) || StringUtils.isEmpty((String)members.get(this.allDim.indexOf(sysDimensionEnum.getNumber())))) {
            return 0L;
        }
        return this.queryDimensionMemberByNumber(sysDimensionEnum.getNumber(), members.get(this.allDim.indexOf(sysDimensionEnum.getNumber())));
    }

    public Long queryDimensionMemberByNumber(String dimNumber, String dimMemNumber) {
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNumber, (String)dimMemNumber);
        if (node != null && node.getId() != -1L) {
            return node.getId();
        }
        throw new WrappedException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e0d\u5b58\u5728\u6210\u5458%2$s\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"Journal_3", (String)"fi-bcm-business", (Object[])new Object[0]), dimNumber, dimMemNumber)));
    }

    private void insertSpreadMemEntry(DynamicObjectCollection spreadmembentry) {
        spreadmembentry.clear();
        DynamicObjectType typespread = spreadmembentry.getDynamicObjectType();
        List<String> commonDims = Arrays.asList(PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM);
        ArrayList<String> spreadDefaultDimNumSet = new ArrayList<String>(10);
        spreadDefaultDimNumSet.add(PresetConstant.ENTITY_DIM);
        spreadDefaultDimNumSet.add(PresetConstant.ACCOUNT_DIM);
        if (MemberReader.isExistChangeTypeDimension((long)this.modelId)) {
            spreadDefaultDimNumSet.add(PresetConstant.CHANGETYPE_DIM);
        }
        if (this.allDim.contains(PresetConstant.MYCOMPANY_DIM)) {
            spreadDefaultDimNumSet.add(PresetConstant.MYCOMPANY_DIM);
        }
        spreadDefaultDimNumSet.add(PresetConstant.INTERNALCOMPANY_DIM);
        if (this.allDim.contains(PresetConstant.RULE_DIM)) {
            spreadDefaultDimNumSet.add(PresetConstant.RULE_DIM);
        }
        if (this.allDim.contains(PresetConstant.DATASORT_DIM)) {
            spreadDefaultDimNumSet.add(PresetConstant.DATASORT_DIM);
        }
        int seqspread = 0;
        for (String dim : spreadDefaultDimNumSet) {
            spreadmembentry.add((Object)this.getSpreadDimDynamicObject(typespread, this.mapped.get(dim), null, this.dimnumToFormMapper.get(dim), seqspread++));
        }
        Map dimMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.ctx.getOutline().getModelNum());
        for (String dim : dimMap.values()) {
            if (commonDims.contains(dim) || spreadDefaultDimNumSet.contains(dim)) continue;
            spreadmembentry.add((Object)this.getSpreadDimDynamicObject(typespread, this.mapped.get(dim), null, this.dimnumToFormMapper.get(dim), seqspread++));
        }
    }

    private DynamicObject getSpreadDimDynamicObject(DynamicObjectType objType, Long dimId, Long memId, String spreadentitysign, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("spreaddimension", (Object)dimId);
        dynaObj.set("spreadmembid", (Object)memId);
        dynaObj.set("spreadentitysign", (Object)spreadentitysign);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private void insertCommonEntry(DynamicObjectCollection commembentry) {
        commembentry.clear();
        DynamicObjectType type = commembentry.getDynamicObjectType();
        int seq = 0;
        commembentry.add((Object)this.getCommonDimDynamicObject(type, this.mapped.get(PresetConstant.SCENE_DIM), (Long)((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p1, this.dimnumToFormMapper.get(PresetConstant.SCENE_DIM), seq++));
        commembentry.add((Object)this.getCommonDimDynamicObject(type, this.mapped.get(PresetConstant.FY_DIM), (Long)((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.FY_DIM)).p1, this.dimnumToFormMapper.get(PresetConstant.FY_DIM), seq++));
        commembentry.add((Object)this.getCommonDimDynamicObject(type, this.mapped.get(PresetConstant.PERIOD_DIM), (Long)((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p1, this.dimnumToFormMapper.get(PresetConstant.PERIOD_DIM), seq++));
        commembentry.add((Object)this.getCommonDimDynamicObject(type, this.mapped.get(PresetConstant.PROCESS_DIM), (Long)((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.PROCESS_DIM)).p1, this.dimnumToFormMapper.get(PresetConstant.PROCESS_DIM), seq++));
        commembentry.add((Object)this.getCommonDimDynamicObject(type, this.mapped.get(PresetConstant.CURRENCY_DIM), (Long)((Pair)this.ctx.getScopeItems().get((Object)PresetConstant.CURRENCY_DIM)).p1, this.dimnumToFormMapper.get(PresetConstant.CURRENCY_DIM), seq++));
    }

    private void getAllDimNumberIdMapped() {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension,memberform", (QFilter[])new QFBuilder().add("model", "=", (Object)this.modelId).toArray(), (String)"dseq");
        dims.forEach(dim -> {
            this.mapped.put(dim.getString("number"), dim.getLong("id"));
            this.allDim.add(dim.getString("number"));
            this.shortNumberMap.put(dim.getString("shortnumber"), dim.getString("number"));
            if (!dim.getBoolean("issysdimension")) {
                this.fieldMapped.put(dim.getString("fieldmapped"), dim.getString("number"));
                this.fieldMapped.put(dim.getString("number"), dim.getString("fieldmapped"));
            }
            this.fields.add(dim.getBoolean("issysdimension") ? dim.getString("number").toLowerCase(Locale.ENGLISH) : dim.getString("fieldmapped"));
            this.dimnumToFormMapper.put(dim.getString("number"), dim.getString("memberform"));
        });
    }

    private DynamicObject getCommonDimDynamicObject(DynamicObjectType objType, Long dimId, Long memId, String comentitysign, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("comdimension", (Object)dimId);
        dynaObj.set("commembid", (Object)memId);
        dynaObj.set("comentitysign", (Object)comentitysign);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private MDResultSet getOlapDatas(Map<String, String> dimensionMap) {
        SQLBuilder sqlBuilder = new SQLBuilder(this.ctx.getOutline().getModelNum());
        dimensionMap.forEach((k, v) -> sqlBuilder.addFilter((String)k, (String)v));
        sqlBuilder.addSelectField(this.allDim.toArray(new String[this.allDim.size()]));
        sqlBuilder.addMeasures(this.measures);
        sqlBuilder.setIncludeNull(false);
        sqlBuilder.setExcludeDynaData(false);
        return OlapServiceHelper.queryData(sqlBuilder);
    }

    private void checkDimSize(List<List<String>> memberList) {
        if (memberList.stream().mapToLong(List::size).reduce(1L, (a, b) -> a * b) > 500000L) {
            throw new KDBizException(ResManager.loadKDString((String)"insert\u64cd\u4f5c\u6d89\u53ca\u7684\u7ef4\u5ea6\u7ec4\u5408\u8303\u56f4\u592a\u5927\uff0c\u8bf7\u7f29\u51cf\u8303\u56f4\u540e\u91cd\u8bd5\u3002", (String)"Journal_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }
}

