/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.journal;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.script.ScriptWrapper;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.fi.bcm.business.journal.Journal;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import org.mozilla.javascript.WrappedException;

@KSObject(name="Journal")
public class KJournal
implements ScriptWrapper<Journal> {
    private Journal journal;

    public KJournal() {
        this.journal = (Journal)AuditLogHelper.proxyWithAuditEvent((Object)new Journal(), null, null);
    }

    public KJournal(ComputingContext ctx) {
        this.journal = (Journal)AuditLogHelper.proxyWithAuditEvent((Object)new Journal(ctx), (Class[])new Class[]{ComputingContext.class}, (Object[])new Object[]{ctx});
    }

    public Journal unwrap() {
        return this.journal;
    }

    @KSMethod
    public void setProperty(String type, String property, Object value) {
        this.journal.addProperty(type, property, value);
    }

    @KSMethod
    public void open(Object ... args) {
        int min = 3;
        int special = 4;
        if (null == args || args.length < min) {
            throw new RuntimeException("execute open method: params is error");
        }
        int length = args.length;
        String jlCode = this.getStrParam(args[0]);
        String jlName = this.getStrParam(args[1]);
        String atCode = this.getStrParam(args[2]);
        String templateCode = "";
        String jlDesc = "";
        if (length == min) {
            templateCode = "root";
        } else if (length == special) {
            templateCode = this.getStrParam(args[3]);
        } else {
            templateCode = this.getStrParam(args[3]);
            jlDesc = this.getStrParam(args[4]);
        }
        this.journal.open(jlCode, jlName, atCode, templateCode, jlDesc);
    }

    @KSMethod
    public void openContinue(Object ... args) {
        this.journal.setJournalType(4);
        this.open(args);
    }

    @KSMethod
    public void setAutoLink(boolean autoLink) {
        this.journal.setAutoLink(autoLink);
    }

    @KSMethod
    public void setCustomDC(boolean customDC) {
        this.journal.setCustomDC(customDC);
    }

    @KSMethod
    public void insert(Object ... args) {
        int min = 3;
        if (null == args || args.length < min) {
            throw new RuntimeException("execute open method: params is error");
        }
        int length = args.length;
        Object srcDims = args[0];
        String tarDims = this.getStrParam(args[1]);
        Double tarFactor = this.getNumberParam(args[2]);
        String summary = "";
        if (length > min) {
            summary = this.getStrParam(args[3]);
        }
        String groupNumber = "";
        if (length > 4) {
            groupNumber = this.getStrParam(args[4]);
            try {
                if (Integer.parseInt(groupNumber) <= 0) {
                    throw new WrappedException((Throwable)new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u7f16\u53f7\u201c%s\u201d\u9519\u8bef\uff0c\u53ea\u5141\u8bb8\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"KJournal_0", (String)"fi-bcm-business", (Object[])new Object[0]), groupNumber)));
                }
            }
            catch (NumberFormatException e) {
                throw new WrappedException((Throwable)new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u7f16\u53f7\u201c%s\u201d\u9519\u8bef\uff0c\u53ea\u5141\u8bb8\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"KJournal_0", (String)"fi-bcm-business", (Object[])new Object[0]), groupNumber)));
            }
        }
        if (srcDims instanceof Number) {
            this.journal.insert((Number)srcDims, tarDims, tarFactor, summary, groupNumber);
        } else {
            this.journal.insert((String)srcDims, tarDims, tarFactor, summary, groupNumber);
        }
    }

    @KSMethod
    public void submit() {
        this.journal.submit();
    }

    @KSMethod
    public void clear(ComputingContext ctx) {
        this.journal.clear(ctx, false);
    }

    @KSMethod
    public void clear(boolean deleteShare) {
        this.journal.clear(deleteShare);
    }

    @KSMethod
    public void clear(String jlCode) {
        this.journal.clear(jlCode);
    }

    @KSMethod
    public void clear(String jlCode, boolean deleteShare) {
        this.journal.clear(jlCode, deleteShare);
    }

    @KSMethod
    public void clear() {
        this.journal.clear();
    }

    @KSMethod
    public void clear(ComputingContext ctx, boolean deleteShare) {
        this.journal.clear(ctx, deleteShare);
    }

    @KSMethod
    public void clear(Object ctx, Object param) {
        if (!(ctx instanceof ComputingContext)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5f55\u7684clear\u51fd\u6570\u7f3a\u5931\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u53c2\u6570ctx\u3002", (String)"KJournal_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (param instanceof Boolean) {
            this.clear((Boolean)param);
        } else if (param instanceof String) {
            this.clear((String)param);
        } else {
            throw new BizRuleException(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5f55\u7684clear\u51fd\u6570\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5e03\u5c14\u503c\u6216\u5b57\u7b26\u4e32\u3002", (String)"KJournal_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    @KSMethod
    public void clear(Object ctx, Object jlCode, Object deleteShare) {
        if (!(ctx instanceof ComputingContext)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5f55\u7684clear\u51fd\u6570\u7f3a\u5931\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u53c2\u6570ctx\u3002", (String)"KJournal_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!(jlCode instanceof String) || !(deleteShare instanceof Boolean)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u5f55\u7684clear\u51fd\u6570\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5b57\u7b26\u4e32\uff0c\u7b2c\u4e09\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5e03\u5c14\u503c\u3002", (String)"KJournal_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.journal.clear((String)jlCode, (boolean)((Boolean)deleteShare));
    }

    private String getStrParam(Object arg) {
        String result = "";
        if (arg == null) {
            throw new RuntimeException("string param can't be null");
        }
        if (arg instanceof String) {
            result = ((String)arg).trim();
        } else if (arg instanceof Number) {
            result = String.valueOf(arg);
        } else {
            throw new RuntimeException("param type is error");
        }
        return result;
    }

    private Double getNumberParam(Object arg) {
        Double result;
        if (arg == null) {
            result = 0.0;
        } else if (arg instanceof String) {
            result = Double.valueOf((String)arg);
        } else if (arg instanceof Number) {
            result = arg instanceof Integer ? ((Integer)arg == 0 ? Double.valueOf(0.0) : Double.valueOf(((Integer)arg).doubleValue())) : (arg instanceof Double ? (Double)arg : Double.valueOf(Double.parseDouble(arg.toString())));
        } else {
            throw new RuntimeException("param type is error");
        }
        return result;
    }
}

