/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.linkquery;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.express.FormulaAnalyze;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.external.IFormatParam;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;
import kd.fi.bcm.business.formula.register.ExternalFormulaServiceConfig;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.expr.IntExpr;
import org.apache.commons.lang.math.NumberUtils;

public class LinkFormulaUtil {
    private static final List<String> supportInnerFormula = Arrays.asList("REF", "V");
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)false, LinkFormulaUtil.class);

    public static List<?> getLinkPageParam(String type, PairList<String, Long> formulas, Map<String, Object> commParam) {
        boolean useLinkMethodOld;
        ExternalFormulaServiceConfig service;
        block15: {
            type = type.toLowerCase(Locale.ENGLISH);
            service = new ExternalFormulaServiceConfig();
            try {
                service = ExternalFormulaLoader.getInstance().getFormulaServiceConfig(type);
            }
            catch (Exception e) {
                log.info("LinkFormulaUtil" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
                boolean isSupport = supportInnerFormula.stream().anyMatch(type::equalsIgnoreCase);
                if (isSupport) break block15;
                return new ArrayList();
            }
        }
        Formula formula = ResourcesLoaderUtil.getFormulaByNumber(type);
        Map<String, String> lm = formula.getLinkMethod();
        if (type.equals("acct") && (useLinkMethodOld = ConfigServiceHelper.getGlobalBoolParam("useLinkMethodOld")) && formula.getLinkMethodOld() != null) {
            lm = formula.getLinkMethodOld();
        }
        if (lm == null || lm.isEmpty() || !lm.containsKey("method")) {
            return new ArrayList();
        }
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        HashMap<String, List<Object>> formulaStr = new HashMap<String, List<Object>>();
        HashMap<String, Long> templateMap = new HashMap<String, Long>(16);
        for (Pair p : formulas) {
            try {
                Pair<String, List<IFormula>> pair = parser.parse((String)p.p1, coder);
                ((List)pair.p2).forEach(fp -> {
                    if (fp instanceof IFormatParam) {
                        formulaStr.put(fp.getUUID(), ((IFormatParam)((Object)fp)).formatParam());
                    }
                    if (p.p2 != null) {
                        templateMap.put(fp.getUUID(), (Long)p.p2);
                    }
                });
            }
            catch (Exception e) {
                log.info("LinkFormulaUtil" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
            }
        }
        String cloudId = lm.containsKey("cloudId") ? lm.get("cloudId") : service.getCloudId();
        String appId = lm.containsKey("appId") ? lm.get("appId") : service.getAppId();
        String servicename = lm.containsKey("service") ? lm.get("service") : service.getService();
        String method = lm.containsKey("method") ? lm.get("method") : service.getMethod();
        String clazzPath = lm.containsKey("clazzPath") ? lm.get("clazzPath") : service.getClazzPath();
        String paramJson = LinkFormulaUtil.toJson(type, formulaStr, commParam, templateMap);
        log.info("LinkFormulaUtil param: " + paramJson);
        Object result = StringUtils.isNotEmpty((String)service.getClazzPath()) ? MsServiceHelper.invokeBizServiceByGivenClassPath((String)cloudId, (String)appId, (String)clazzPath, (String)servicename, (String)method, (Object[])new Object[]{paramJson}) : MsServiceHelper.invokeService((String)cloudId, (String)appId, (String)servicename, (String)method, (Object[])new Object[]{paramJson});
        if (result instanceof String) {
            log.info("LinkFormulaUtil result: " + result);
            ArrayList<FormShowParameter> ps = new ArrayList<FormShowParameter>();
            if (StringUtils.isNotEmpty((String)result.toString())) {
                try {
                    Object errorInfo;
                    Map resultMap = (Map)JSONUtils.cast((String)result.toString(), Map.class);
                    StringBuilder errMsg = new StringBuilder();
                    if (resultMap.get("error") != null && (errorInfo = resultMap.get("error")) instanceof Map) {
                        Map errorMap = (Map)errorInfo;
                        errorMap.forEach((k, v) -> errMsg.append((String)k).append(":").append((String)v).append("\uff0c"));
                    }
                    if (errMsg.length() > 0) {
                        throw new KDBizException(errMsg.substring(0, errMsg.length() - 1));
                    }
                    List params = (List)resultMap.get("pageParam");
                    for (String param : params) {
                        ps.add(FormShowParameter.fromJsonString((String)param));
                    }
                }
                catch (IOException e) {
                    throw new KDBizException("cast to map exception:" + result);
                }
            }
            return ps;
        }
        if (result instanceof List) {
            return (List)result;
        }
        return new ArrayList();
    }

    private static String toJson(String formula, Map<String, List<Object>> paramMap, Map<String, Object> commParam, Map<String, Long> templateMap) {
        JSONObject objJson = new JSONObject();
        String formulaName = formula.toLowerCase(Locale.ENGLISH);
        objJson.put("formulaName", (Object)formulaName);
        objJson.put("param", paramMap);
        if (formulaName.startsWith("acct")) {
            LinkFormulaUtil.setFy(commParam);
            LinkFormulaUtil.setScopePeriod(commParam);
            LinkFormulaUtil.setPeriod(commParam);
        } else {
            objJson.put("linkTemplate", templateMap);
        }
        objJson.put("commParam", commParam);
        return objJson.toJSONString();
    }

    private static void setFy(Map<String, Object> commParams) {
        String yearNum = commParams.get("fy").toString();
        IntExpr year = FormulaAnalyze.setFYOrPeriodDefaultValue(yearNum);
        commParams.put("fy", year.getValue().intValue());
    }

    private static void setScopePeriod(Map<String, Object> commParams) {
        long modelId = LongUtil.toLong((Object)commParams.get("model"));
        String period = commParams.get("period").toString();
        if (StringUtils.isNotEmpty((String)period) && (period.contains("Q_Q") || period.contains("HF"))) {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter periodnumber = new QFilter("number", "=", (Object)period);
            DynamicObject periodObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"expmonth, effmonth", (QFilter[])new QFilter[]{periodnumber, modelFilter});
            String[] scopePeriod = new String[]{periodObj.getString("effmonth"), periodObj.getString("expmonth")};
            commParams.put("scopePeriod", scopePeriod);
        }
    }

    private static void setPeriod(Map<String, Object> commParams) {
        long modelId = LongUtil.toLong((Object)commParams.get("model"));
        String period = commParams.get("period").toString();
        String orignPeriod = commParams.get("period").toString();
        if (StringUtils.isNotEmpty((String)period)) {
            DynamicObject[] memberDims;
            if (period.contains("Q_Q") || period.contains("HF")) {
                QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
                QFilter periodnumber = new QFilter("number", "=", (Object)period);
                DynamicObject periodObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"id, expmonth, effmonth", (QFilter[])new QFilter[]{periodnumber, modelFilter});
                period = "M_M" + (Integer.parseInt(periodObj.getString("expmonth")) < 10 ? "0" + periodObj.getString("expmonth") : periodObj.getString("expmonth"));
            }
            if (PeriodUtils.isStandardPeriod((String)period)) {
                commParams.put("period", PeriodUtils.trans2IntPeriod((String)period));
                commParams.put("period_type", PeriodUtils.getPeriodType((String)period));
            } else {
                commParams.put("period", 0);
            }
            commParams.put("original_period", period);
            Long periodDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Period");
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("bcmdim", "=", (Object)periodDimId);
            for (DynamicObject memberDim : memberDims = BusinessDataServiceHelper.load((String)"bcm_membermapentity", (String)"id, bcmdim, bcmdim.membermodel, bcmmember, assttype, asstmember, model", (QFilter[])qFilter.toArray())) {
                if (!memberDim.getString("bcmmember").equalsIgnoreCase(orignPeriod) || !memberDim.getString("bcmdim.membermodel").equals("bcm_periodmembertree")) continue;
                orignPeriod = memberDim.getString("asstmember");
                if (NumberUtils.isNumber((String)orignPeriod)) {
                    commParams.put("period", Integer.parseInt(orignPeriod));
                    commParams.remove("scopePeriod");
                    break;
                }
                DataCollectUtil.dealScopePeriodByCommonDim(orignPeriod, null, periodList -> {
                    String[] scopePeriod = new String[]{(String)periodList.get(0), (String)periodList.get(1)};
                    commParams.put("scopePeriod", scopePeriod);
                    commParams.put("isAdjustPeriod", true);
                }, periodStr -> {
                    commParams.put("period", periodStr);
                    commParams.remove("scopePeriod");
                });
                break;
            }
        }
    }

    public static FormShowParameter getLinkQueryParameter(boolean isEntityTab, String formulas, Object cellValue, String orgNum, String year, String period, Map<String, Object> ids) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_rptlinkquerylist");
        parameter.setCustomParam("formulas", (Object)formulas);
        parameter.setCustomParam("cellValue", (Object)(cellValue == null ? "0.00" : cellValue.toString()));
        parameter.setCustomParam("org", (Object)orgNum);
        parameter.setCustomParam("year", (Object)year);
        parameter.setCustomParam("period", (Object)period);
        parameter.setCustomParam("ids", ids);
        parameter.setCustomParam("isEntityTab", (Object)isEntityTab);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        return parameter;
    }

    public static FormShowParameter getLinkQueryParameter(String dataTrace, String orgNum, String year, String period, Map<String, Object> ids, String traceInfo) {
        return LinkFormulaUtil.getLinkQueryParameter(true, dataTrace, orgNum, year, period, ids, traceInfo);
    }

    public static FormShowParameter getLinkQueryParameter(boolean isEntityTab, String dataTrace, String orgNum, String year, String period, Map<String, Object> ids, String traceInfo) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_rptlinkquerylist");
        parameter.setCustomParam("datatrace", (Object)dataTrace);
        parameter.setCustomParam("org", (Object)orgNum);
        parameter.setCustomParam("year", (Object)year);
        parameter.setCustomParam("period", (Object)period);
        parameter.setCustomParam("ids", ids);
        parameter.setCustomParam("isEntityTab", (Object)isEntityTab);
        parameter.setCustomParam("traceinfo", (Object)traceInfo);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        return parameter;
    }
}

