/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.linkquery;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.ReportShowParameter;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.linkquery.LinkFormulaUtil;
import kd.fi.bcm.business.linkquery.LinkQueryUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTraceSourceEnum;
import kd.fi.bcm.common.json.JacksonUtils;

public class LinkQueryService {
    private long modelId;
    private IFormView view;
    private IFormPlugin plugin;

    public LinkQueryService(long modelId, IFormView view) {
        this.modelId = modelId;
        this.view = view;
    }

    public void setPlugin(IFormPlugin plugin) {
        this.plugin = plugin;
    }

    public String link(DataTraceFrom dtf, Map<String, String> memberMap, boolean isEntityTab, Map<String, Object> commParam) {
        if (DataTraceSourceEnum.DI_OUTPUT.getCode().equals(dtf.getF())) {
            return this.linkDiByDataTrace(dtf, memberMap);
        }
        String traceInfo = LinkQueryUtil.createDimMember(memberMap, this.modelId);
        FormShowParameter parameter = LinkFormulaUtil.getLinkQueryParameter(isEntityTab, JacksonUtils.toJson((Object)dtf), memberMap.get("Entity"), memberMap.get("Year"), memberMap.get("Period"), commParam, traceInfo);
        String pageId = UUID.randomUUID().toString();
        parameter.setPageId(pageId);
        if (this.plugin != null) {
            parameter.setCloseCallBack(new CloseCallBack(this.plugin, "closeLinkQuery"));
        }
        this.view.showForm(parameter);
        return pageId;
    }

    public String linkDiByDataTrace(DataTraceFrom dtf, Map<String, String> dimMembers) {
        String d = dtf.getD();
        JSONObject json = JSON.parseObject((String)d);
        String table = json.getString("table");
        String id = json.getString("id");
        if (!DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)table)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5b58\u5728\u8054\u67e5\u6570\u636e\uff0c\u6216\u8054\u67e5\u6570\u636e\u5df2\u88ab\u6e05\u9664\uff0c\u65e0\u6cd5\u8fdb\u884c\u8054\u67e5\u3002", (String)"LinkQueryService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String sql = "select fidnew from " + table + " where fidnew = " + id;
        if (!DB.queryDataSet((String)"LinkQueryService", (DBRoute)BCMConstant.DBROUTE, (String)sql).hasNext()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5b58\u5728\u8054\u67e5\u6570\u636e\uff0c\u6216\u8054\u67e5\u6570\u636e\u5df2\u88ab\u6e05\u9664\uff0c\u65e0\u6cd5\u8fdb\u884c\u8054\u67e5\u3002", (String)"LinkQueryService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return this.showForm(json, dimMembers);
    }

    public String showForm(JSONObject json, Map<String, String> dimMembers) {
        ReportShowParameter param = new ReportShowParameter();
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u8be6\u60c5", (String)"DISchemeDataCollectListPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setFormId("di_executdetailreport");
        param.setCustomParam("modelId", (Object)this.modelId);
        param.setCustomParam("scenarioId", (Object)this.getMemberId("Scenario", dimMembers.get("Scenario")));
        param.setCustomParam("yearId", (Object)this.getMemberId("Year", dimMembers.get("Year")));
        param.setCustomParam("yearNumber", (Object)dimMembers.get("Year"));
        param.setCustomParam("periodId", (Object)this.getMemberId("Period", dimMembers.get("Period")));
        param.setCustomParam("periodNumber", (Object)dimMembers.get("Period"));
        param.setCustomParam("currencyId", (Object)json.getLong("currency"));
        param.setCustomParam("schemeId", (Object)json.getLong("scheme"));
        long orgId = this.getMemberId("Entity", dimMembers.get("Entity"));
        param.setCustomParam("orgId", (Object)orgId);
        long cslScheme = (Long)MemberReader.findEntityMemberById((Long)this.modelId, (Long)orgId).getProperty("cslscheme.id");
        param.setCustomParam("cslschemeId", (Object)cslScheme);
        param.setCustomParam("executeId", (Object)json.getLong("executeId"));
        param.setCustomParam("linkId", (Object)json.getLong("id"));
        String pageId = UUID.randomUUID().toString();
        param.setPageId(pageId);
        this.view.showForm((FormShowParameter)param);
        return pageId;
    }

    private long getMemberId(String dimNum, String memberNum) {
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        return MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memberNum).getId();
    }
}

