/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.linkquery;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.ReportEditStatus;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateUsageEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class LinkQueryUtil {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(LinkQueryUtil.class);
    private static final String ACCT = "ACCT";
    private static final String LINKMETHOD = "getLinkParam";

    public static boolean isSupportNewLink() {
        return (Boolean)GlobalCacheServiceHelper.getOrLoadNodeFixKey((String)"supportNewLink", () -> {
            Formula formula = ResourcesLoaderUtil.getFormulaByNumber(ACCT);
            Map<String, String> lm = formula.getLinkMethod();
            return lm != null && !lm.isEmpty() && LINKMETHOD.equals(lm.get("method"));
        });
    }

    public static Map<String, Object> getLinkParam(long modelId, Map<String, String> dimMemberMap, Long extendModelId) {
        Set<Long> matchTemplates;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String entityId = dimMemberMap.remove("EntityId");
        if (extendModelId == null) {
            Map dimShort2Num = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
            if (dimMemberMap.size() != dimShort2Num.size()) {
                return null;
            }
            matchTemplates = LinkQueryUtil.getMatchTemplate(modelId, dimMemberMap);
        } else {
            matchTemplates = LinkQueryUtil.getMatchTemplateForExtendModel(modelId, dimMemberMap, extendModelId);
        }
        if (matchTemplates.isEmpty()) {
            return null;
        }
        long templateId = matchTemplates.iterator().next();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("entity", MemberReader.findEntityMemberByNum((String)modelNum, (String)dimMemberMap.get("Entity")).getId());
        result.put("scene", MemberReader.findScenaMemberByNum((String)modelNum, (String)dimMemberMap.get("Scenario")).getId());
        result.put("fyear", MemberReader.findFyMemberByNum((String)modelNum, (String)dimMemberMap.get("Year")).getId());
        result.put("period", MemberReader.findPeriodMemberByNum((String)modelNum, (String)dimMemberMap.get("Period")).getId());
        result.put("currency", MemberReader.findCurrencyMemberByNum((String)modelNum, (String)dimMemberMap.get("Currency")).getId());
        result.put("tem", templateId);
        result.put("matchTemplates", matchTemplates);
        result.put("model", modelId);
        if (extendModelId == null) {
            result.put("numtomems", dimMemberMap);
        } else {
            result.put("extendnumtomems", dimMemberMap);
        }
        return result;
    }

    public static Map<Long, String> getMatchTemplates(long modelId, Map<String, String> dimMemberMap) {
        log.startWatch();
        Map<String, Long> memberIdMap = LinkQueryUtil.getMemberNumIdMap(modelId, dimMemberMap);
        String currency = dimMemberMap.get("Currency");
        boolean isEC = MemberReader.findEntityMemberById((Long)modelId, (Long)memberIdMap.get("Entity")).getCurrency().equals(currency);
        Set<Long> templateIds = LinkQueryUtil.getTemplateIds(modelId, memberIdMap);
        QFBuilder builder = new QFBuilder("template", "in", templateIds);
        DynamicObject[] templateMembers = BusinessDataServiceHelper.load((String)"bcm_templatemember", (String)"template,pageviewdim,pageviewmember,rowcolinfo,rowcolinfo.dimension,rowcolinfo.member,rowcolinfo.isfloat", (QFilter[])builder.toArray());
        int size = templateMembers == null ? 0 : templateMembers.length;
        log.info("LinkQueryUtil queryTemplate size:" + size + " -->spendtime");
        HashMap<Long, String> matchTemplate = new HashMap<Long, String>(16);
        if (templateMembers == null || templateMembers.length == 0) {
            return matchTemplate;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        block0: for (DynamicObject templateMember : templateMembers) {
            String pageViewDimString = templateMember.getString("pageviewdim");
            if (!StringUtil.isEmptyString((String)pageViewDimString)) {
                String[] pageViewDim = pageViewDimString.split("\\|");
                String[] pageViewMember = templateMember.getString("pageviewmember").split("\\|");
                for (int i = 0; i < pageViewDim.length; ++i) {
                    String dim = pageViewDim[i];
                    String member = pageViewMember[i];
                    Set<String> realMembers = LinkQueryUtil.getRealMembers(modelId, modelNum, dim, member);
                    if ((!"Entity".equals(dim) || !realMembers.contains("null")) && !realMembers.contains(dimMemberMap.get(dim))) continue block0;
                }
            }
            DynamicObjectCollection rowColMembers = templateMember.getDynamicObjectCollection("rowcolinfo");
            boolean existFloat = false;
            String rowColDim = null;
            for (DynamicObject object : rowColMembers) {
                boolean isFloat = object.getBoolean("isfloat");
                if (isFloat) {
                    existFloat = true;
                    rowColDim = object.getString("dimension");
                    continue;
                }
                String[] rowColMember = object.getString("member").split("#");
                int matchCount = 0;
                for (String member : rowColMember) {
                    String[] temp = member.split(":");
                    String dimension = temp[0];
                    if (isEC && "Currency".equals(dimension) && "EC".equals(temp[1])) {
                        ++matchCount;
                        continue;
                    }
                    if (!temp[1].equals(dimMemberMap.get(temp[0]))) break;
                    ++matchCount;
                }
                if (matchCount != rowColMember.length) continue;
                DynamicObject template = templateMember.getDynamicObject("template");
                matchTemplate.put(template.getLong("id"), template.getString("number") + "|" + template.getString("name"));
                break block0;
            }
            if (!existFloat || rowColDim == null) continue;
            String[] dims = rowColDim.split("\\|");
            TemplateModel t = TemplateServiceHelper.getTemplateModelById(templateMember.getLong("template.id"));
            SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)t.getRptData());
            List<Map<String, Set<String>>> members = SpreadMemUtil.analysisMemberFromSheet(sm, t, dims);
            for (Map<String, Set<String>> member : members) {
                if (isEC && member.containsKey("Currency") && member.get("Currency").contains("EC")) {
                    member.get("Currency").add(currency);
                }
                boolean flag = true;
                for (Map.Entry<String, Set<String>> entry : member.entrySet()) {
                    if (entry.getValue().isEmpty() || entry.getValue().contains(dimMemberMap.get(entry.getKey()))) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                matchTemplate.put(t.getId(), t.getNumber() + "|" + t.getName());
                break block0;
            }
        }
        log.info("LinkQueryUtil getMatchTemplate -->spendtime");
        return matchTemplate;
    }

    private static Set<Long> getMatchTemplate(long modelId, Map<String, String> dimMemberMap) {
        Map<String, Long> memberIdMap = LinkQueryUtil.getMemberNumIdMap(modelId, dimMemberMap);
        String v = dimMemberMap.get("Currency");
        if (v != null) {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)"Currency", (String)v);
            memberIdMap.put("Currency", node.getId());
        }
        List<TemplateModel> templates = LinkQueryUtil.getTemplates(modelId, memberIdMap, true);
        String[] dims = dimMemberMap.keySet().toArray(new String[0]);
        HashSet<Long> matchTemplate = new HashSet<Long>();
        for (TemplateModel t : templates) {
            SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)t.getRptData());
            List<Map<String, Set<String>>> members = SpreadMemUtil.analysisMemberFromSheet(sm, t, dims);
            for (Map<String, Set<String>> member : members) {
                if (member.size() != dims.length) continue;
                boolean flag = true;
                for (Map.Entry<String, Set<String>> entry : member.entrySet()) {
                    if (entry.getValue().isEmpty() || "Currency".equals(entry.getKey()) && (entry.getValue().contains("DC") || entry.getValue().contains("EC")) || entry.getValue().contains(dimMemberMap.get(entry.getKey()))) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                matchTemplate.add(t.getId());
            }
        }
        return matchTemplate;
    }

    private static Set<Long> getMatchTemplateForExtendModel(long modelId, Map<String, String> dimMemberMap, Long extendModelId) {
        Map<String, Long> memberIdMap = LinkQueryUtil.getMemberNumIdMap(modelId, dimMemberMap);
        List<TemplateModel> templates = LinkQueryUtil.getTemplates(modelId, memberIdMap, false);
        QFilter tempQFilter = new QFilter("model", "=", (Object)modelId);
        tempQFilter.and("extmodel.id", "=", (Object)extendModelId);
        tempQFilter.and("template.usage", "=", (Object)TemplateUsageEnum.FORWEAVE.getValue());
        Set refTemplates = QueryServiceHelper.query((String)"bcm_extmodelref", (String)"id,template.id", (QFilter[])tempQFilter.toArray()).stream().map(e -> e.getLong("template.id")).collect(Collectors.toSet());
        HashSet<Long> matchTemplate = new HashSet<Long>();
        for (TemplateModel t : templates) {
            if (!refTemplates.contains(t.getId())) continue;
            matchTemplate.add(t.getId());
        }
        return matchTemplate;
    }

    private static List<TemplateModel> getTemplates(long modelId, Map<String, Long> memberIdMap, Boolean fromCheckDetail) {
        HashSet<Long> havePermIds = new HashSet<Long>(16);
        long orgId = memberIdMap.get("Entity");
        LinkQueryUtil.dealHavePermTemplates(orgId, modelId, havePermIds, fromCheckDetail, memberIdMap);
        ArrayList<TemplateModel> result = new ArrayList<TemplateModel>(10);
        if (havePermIds.size() > 0) {
            long yearId = memberIdMap.get("Year");
            long periodId = memberIdMap.get("Period");
            long scenarioId = memberIdMap.get("Scenario");
            Map<Long, Long> source2Right = TemplateUtil.getRightTplIdByVersioned(modelId, yearId, periodId, havePermIds, true);
            havePermIds.clear();
            havePermIds.addAll(source2Right.values());
            List<TemplateModel> templateModels = TemplateRangeService.getWholeTemplateModels(havePermIds);
            for (TemplateModel t : templateModels) {
                if (!TemplateRangeService.isInnerRange("bcm_scenemembertree", t, scenarioId)) {
                    havePermIds.remove(t.getId());
                    continue;
                }
                result.add(t);
            }
        }
        return result;
    }

    private static void dealHavePermTemplates(long orgId, Long modelId, Set<Long> havePermIds, Boolean fromCheckDetail, Map<String, Long> memberIdMap) {
        Set<Object> templateIds = new HashSet();
        if (fromCheckDetail.booleanValue()) {
            List<Long> templateIdsList;
            RightVersionTemplateParams params = new RightVersionTemplateParams(modelId, memberIdMap.get("Entity"), memberIdMap.get("Scenario"), memberIdMap.get("Year"), memberIdMap.get("Period"), memberIdMap.get("Currency"), RequestContext.get().getCurrUserId(), null, false);
            Map<Long, ReportEditStatus> resultMap = TemplateUtil.getCommitReportCount(params);
            if (resultMap.get(orgId) != null && (templateIdsList = resultMap.get(orgId).getAllTemplates()).size() > 0) {
                templateIds = new HashSet<Long>(templateIdsList);
            }
        } else {
            templateIds = TemplateUtil.getTempDisOrgs(modelId, orgId, true);
        }
        boolean ifUserHasRootPermByModel = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId));
        if (ifUserHasRootPermByModel) {
            havePermIds.addAll(templateIds);
            return;
        }
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMap("bcm_templateentity", String.valueOf(modelId), RequestContext.get().getUserId());
        List noPermIds = map.get((Object)"1");
        templateIds.forEach(e -> {
            if (CollectionUtils.isEmpty((Collection)noPermIds) || !noPermIds.contains(e)) {
                havePermIds.add((Long)e);
            }
        });
    }

    private static Map<String, Long> getMemberNumIdMap(long modelId, Map<String, String> dimMemberMap) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        HashMap<String, Long> result = new HashMap<String, Long>(4);
        dimMemberMap.forEach((k, v) -> {
            switch (k) {
                case "Entity": 
                case "Scenario": 
                case "Period": 
                case "Year": {
                    IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)k, (String)v);
                    result.put((String)k, node.getId());
                }
            }
        });
        return result;
    }

    private static Set<Long> getTemplateIds(long modelId, Map<String, Long> memberIdMap) {
        HashSet<Long> havePermIds = new HashSet<Long>(16);
        long orgId = memberIdMap.get("Entity");
        LinkQueryUtil.dealHavePermTemplates(orgId, modelId, havePermIds, false, memberIdMap);
        HashSet<Long> result = new HashSet<Long>(10);
        if (havePermIds.size() > 0) {
            long yearId = memberIdMap.get("Year");
            long periodId = memberIdMap.get("Period");
            Map<Long, Long> source2Right = TemplateUtil.getRightTplIdByVersioned(modelId, yearId, periodId, havePermIds);
            havePermIds.clear();
            havePermIds.addAll(source2Right.values());
            return havePermIds;
        }
        return result;
    }

    private static Set<String> getRealMembers(long modelId, String modelNum, String dim, String member) {
        HashSet<String> result = new HashSet<String>(16);
        ArrayList<String> memberInfo = new ArrayList<String>(10);
        if (member.contains("@")) {
            String[] mems = member.split("@");
            memberInfo.addAll(Arrays.asList(mems));
        } else {
            memberInfo.add(member);
        }
        memberInfo.forEach(m -> {
            if (m.contains("#")) {
                String[] temp = m.split("#");
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dim, (String)temp[0]);
                Set<String> numbers = QueryMemberDetailsHelper.queryMemberNumbersByRange(DimensionServiceHelper.getDimMembEntityNumByDimNum(dim), node.getId(), node.getNumber(), Integer.parseInt(temp[1]), String.valueOf(modelId), DetailTypeEnum.OTHERS);
                result.addAll(numbers);
            } else {
                result.add((String)m);
            }
        });
        return result;
    }

    public static boolean isAllLeaf4DataTrace(String modelNum, Map<String, String> memberMap) {
        boolean isCSTE = "CSTE".equals(memberMap.get("Process"));
        for (Map.Entry<String, String> entry : memberMap.entrySet()) {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)entry.getKey(), (String)entry.getValue());
            if (isCSTE && "Entity".equals(entry.getKey()) || node.isLeaf()) continue;
            return false;
        }
        return true;
    }

    public static boolean isStorage(String modelNum, Map<String, String> memberMap) {
        for (Map.Entry<String, String> entry : memberMap.entrySet()) {
            IDNumberTreeNode node;
            if ("Entity".equals(entry.getKey()) || (node = MemberReader.findMemberByNumber((String)modelNum, (String)entry.getKey(), (String)entry.getValue())).isLeaf() || node.getStorageType() == StorageTypeEnum.STORAGE) continue;
            return false;
        }
        return true;
    }

    public static String createDimMember(Map<String, String> memberMap, long modelId) {
        Map dim = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
        StringBuilder sb = new StringBuilder();
        HashMap reversedMap = new HashMap();
        dim.forEach((key, value) -> reversedMap.put(value, key));
        dim.forEach((key, value) -> reversedMap.put(value, key));
        memberMap.forEach((k, v) -> sb.append((String)reversedMap.get(k)).append("@").append((String)v).append(","));
        return sb.toString();
    }
}

