/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.lockdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.lockdata.ReportLockComboFactory;
import kd.fi.bcm.business.lockdata.handle.BuildComboParam;
import kd.fi.bcm.business.lockdata.handle.IComboHandle;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSetReader;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class ReportLockDataUtil {
    private static final WatchLogger LOGGER = BcmLogFactory.getWatchLogInstance((boolean)true, ReportLockDataUtil.class);

    public static void unLockByReport(Object[] pks) {
        ReportLockDataUtil.lockORUnLockByReport(pks, false);
    }

    public static void lockByReport(Object[] pks) {
        ReportLockDataUtil.lockORUnLockByReport(pks, true);
    }

    private static void lockORUnLockByReport(Object[] pks, boolean isLock) {
        Row report;
        TemplateModel tm;
        String selectFields = "template,fyear,period,scene,currency,entity,data";
        QFilter filter = new QFilter("id", "in", (Object)pks);
        DataSet reports = QueryServiceHelper.queryDataSet((String)"bcm_lockByReport", (String)"bcm_reportentity", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        boolean hasLock = true;
        Iterator iterator = reports.iterator();
        while (iterator.hasNext() && (hasLock = OlapServiceHelper.checkMeasure(MemberReader.findModelNumberById((Object)(tm = TemplateUtil.getTemplateModel((report = (Row)iterator.next()).getLong("template"))).getModelId()), FacTabFieldDefEnum.FIELD_LOCK.getField()))) {
            HashMap<String, String> mems = new HashMap<String, String>();
            mems.put(DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberById((Long)tm.getModelId(), (Long)report.getLong("entity")).getNumber());
            mems.put(DimTypesEnum.YEAR.getNumber(), MemberReader.findFyMemberById((Long)tm.getModelId(), (Long)report.getLong("fyear")).getNumber());
            mems.put(DimTypesEnum.PERIOD.getNumber(), MemberReader.findPeriodMemberById((Long)tm.getModelId(), (Long)report.getLong("period")).getNumber());
            mems.put(DimTypesEnum.SCENARIO.getNumber(), MemberReader.findScenaMemberById((Long)tm.getModelId(), (Long)report.getLong("scene")).getNumber());
            mems.put(DimTypesEnum.CURRENCY.getNumber(), MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)tm.getModelId()), (Long)report.getLong("currency")).getNumber());
            String dataStr = report.getString("data");
            SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)(StringUtils.isNotEmpty((String)dataStr) ? dataStr : tm.getRptData()));
            if (isLock) {
                ReportLockDataUtil.lockByReport(tm, sm, mems);
                continue;
            }
            ReportLockDataUtil.unLockByReport(tm, sm, mems);
        }
        reports.close();
    }

    public static void lockByReport(TemplateModel model, SpreadManager sm, Map<String, String> mems) {
        ReportLockDataUtil.lockOrUnLockByReport(model, sm, mems, true);
    }

    public static void unLockByReport(TemplateModel model, SpreadManager sm, Map<String, String> mems) {
        ReportLockDataUtil.lockOrUnLockByReport(model, sm, mems, false);
    }

    private static void lockOrUnLockByReport(TemplateModel model, SpreadManager sm, Map<String, String> mems, boolean isLock) {
        BuildComboParam bp = new BuildComboParam(model, sm, mems);
        IComboHandle handle = ReportLockComboFactory.getHandle(bp);
        int changeSize = ReportLockDataUtil.getChangeSize();
        for (Pair<Map<String, Set<String>>, List<Map<String, String>>> pair : handle.getScopeAndCombo()) {
            Map scope = (Map)pair.p1;
            List combo = (List)pair.p2;
            if (isLock) {
                if (combo.size() >= changeSize) {
                    ReportLockDataUtil.lockDimData(MemberReader.findModelNumberById((Object)model.getModelId()), scope, combo, 1);
                    continue;
                }
                new RunScriptBuilder(MemberReader.findModelNumberById((Object)model.getModelId())).lockDimData(scope, combo);
                continue;
            }
            if (combo.size() >= changeSize) {
                ReportLockDataUtil.lockDimData(MemberReader.findModelNumberById((Object)model.getModelId()), scope, combo, null);
                continue;
            }
            new RunScriptBuilder(MemberReader.findModelNumberById((Object)model.getModelId())).unlockDimData(scope, combo);
        }
    }

    public static void lockDimData(String cube, Map<String, Set<String>> scope, List<Map<String, String>> combo, Object value) {
        SQLBuilder sql = new SQLBuilder(cube);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        scope.forEach((dim, mems) -> {
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dim)) {
                sql.addLazyFilter((String)dim, mems::contains);
            } else {
                sql.addFilter((String)dim, mems.toArray(new String[0]));
            }
        });
        Map<String, Set<String>> comboMap = ReportLockDataUtil.transToMAp(combo);
        comboMap.forEach((dim, mems) -> sql.addFilter((String)dim, mems.toArray(new String[0])));
        String[] selects = ReportLockDataUtil.getSelectDims(cube, scope, combo);
        sql.addSelectField(selects);
        sql.setExcludeDynaData(true);
        ArrayList<String> comboDimkey = new ArrayList<String>();
        Set<Object> combokeys = new HashSet();
        if (!combo.isEmpty()) {
            comboDimkey.addAll(combo.get(0).keySet());
            combokeys = ReportLockDataUtil.transToKey(combo, comboDimkey);
        }
        boolean isAll = comboDimkey.isEmpty();
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_LOCK.getField()});
        info.setDimensions(selects);
        scope.forEach((dim, mems) -> {
            if (mems.size() == 1) {
                info.addfixedDimension(new String[]{dim, (String)mems.iterator().next()});
            }
        });
        CellSet cellSets = new CellSet(selects, new String[]{FacTabFieldDefEnum.FIELD_LOCK.getField()});
        cellSets.setFromQuery(false);
        try (MDResultSetReader resultSet = OlapServiceHelper.queryDataReader(sql);){
            while (resultSet.next()) {
                StringBuilder sb = new StringBuilder();
                for (String dim2 : comboDimkey) {
                    sb.append(resultSet.getString(dim2)).append("|");
                }
                if (!isAll && !combokeys.contains(sb.toString())) continue;
                String[] dest = new String[selects.length];
                for (int i = 0; i < selects.length; ++i) {
                    dest[i] = resultSet.getString(selects[i]);
                }
                cellSets.set(dest, FacTabFieldDefEnum.FIELD_LOCK.getField(), value);
            }
            ThreadCache.put((Object)"unchecksource", (Object)true);
            OlapServiceHelper.saveData(info, cellSets, cube, false);
            ThreadCache.remove((Object)"unchecksource");
        }
        catch (Exception e) {
            LOGGER.error(ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)20));
        }
    }

    private static String[] getSelectDims(String cube, Map<String, Set<String>> scope, List<Map<String, String>> combo) {
        HashSet allDims = new HashSet(((Map)MemberReader.getModelDimIDAndNumberMap((long)MemberReader.findModelIdByNum((String)cube).longValue()).p2).keySet());
        HashSet<String> combodims = new HashSet<String>();
        if (!combo.isEmpty()) {
            combodims.addAll(combo.get(0).keySet());
        }
        allDims.removeAll(combodims);
        allDims.removeAll(scope.keySet());
        combodims.addAll(allDims);
        for (Map.Entry<String, Set<String>> sc : scope.entrySet()) {
            if (sc.getValue().size() <= 1) continue;
            combodims.add(sc.getKey());
        }
        combodims.remove("Extends");
        return combodims.toArray(new String[0]);
    }

    private static Map<String, Set<String>> transToMAp(List<Map<String, String>> combos) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        combos.forEach(combo -> {
            for (Map.Entry m : combo.entrySet()) {
                map.computeIfAbsent((String)m.getKey(), k -> new HashSet()).add(m.getValue());
            }
        });
        return map;
    }

    private static Set<String> transToKey(List<Map<String, String>> combos, List<String> dim) {
        HashSet<String> keys = new HashSet<String>();
        combos.forEach(combo -> {
            StringBuilder sb = new StringBuilder();
            for (String d : dim) {
                sb.append((String)combo.get(d)).append("|");
            }
            keys.add(sb.toString());
        });
        return keys;
    }

    public static int getChangeSize() {
        return (Integer)ThreadCache.get((Object)"RLDU.GCS", () -> {
            try {
                String size = ConfigServiceHelper.getStringParamNoModel("lockBySaveSize");
                if (StringUtils.isNotEmpty((String)size)) {
                    int num = Integer.parseInt(size);
                    return Math.max(num, 1);
                }
            }
            catch (Exception e) {
                LOGGER.error(ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)20));
            }
            return 0;
        });
    }
}

