/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.lockdata.handle;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.lockdata.handle.BuildComboParam;
import kd.fi.bcm.business.lockdata.handle.IComboHandle;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.template.model.FilterDimMember;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;

public abstract class AbstractComboHandle
implements IComboHandle {
    private List<Pair<Map<String, Set<String>>, List<Map<String, String>>>> scopeAndCombo;
    private Map<String, Set<String>> defaultScope = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> filterScope = new HashMap<String, Set<String>>();
    private BuildComboParam param;
    private static final Set<String> COMDIM = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.CURRENCY.getNumber()});
    private static final Set<String> FIXEDDIM = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});

    public AbstractComboHandle(BuildComboParam param) {
        this.param = param;
    }

    @Override
    public void buildScopeAndCombo() {
        this.getViewAndPageMembers();
        this.buildFixCombo();
        this.buildFloatCombo();
    }

    @Override
    public List<Pair<Map<String, Set<String>>, List<Map<String, String>>>> getScopeAndCombo() {
        if (this.scopeAndCombo == null) {
            this.scopeAndCombo = new ArrayList<Pair<Map<String, Set<String>>, List<Map<String, String>>>>();
            this.buildScopeAndCombo();
        }
        return this.scopeAndCombo;
    }

    protected void addScopeAndCombo(Map<String, Set<String>> scope, List<Map<String, String>> combos) {
        this.addScopeAndCombo(scope, combos, false);
    }

    protected void addScopeAndCombo(Map<String, Set<String>> scope, List<Map<String, String>> combos, boolean onlyAdd) {
        for (Set<String> mems : scope.values()) {
            if (mems.size() != 0) continue;
            return;
        }
        this.scopeAndCombo.add((Pair<Map<String, Set<String>>, List<Map<String, String>>>)Pair.onePair(scope, combos));
        if (!onlyAdd) {
            this.afterAddScopeAndCombo(scope, combos);
        }
    }

    public void afterAddScopeAndCombo(Map<String, Set<String>> scope, List<Map<String, String>> combos) {
    }

    private void buildFixCombo() {
        ArrayList<Map<String, String>> fixCombos = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> curCombos = new ArrayList<Map<String, String>>();
        AtomicBoolean hasDim = new AtomicBoolean(false);
        for (PositionInfo ps : this.getParam().getSm().getAreaManager().getPostionInfoSet()) {
            RangeModel rm = new RangeModel(ps.getAreaRange());
            this.getParam().getSm().getBook().getSheet(0).iteratorRangeCells(rm, cell -> {
                if (cell.isMdDataDomain() && this.checkIsFixMD(ps, cell.getRow(), cell.getCol())) {
                    HashMap<String, String> combo = new HashMap<String, String>(1);
                    boolean isCur = false;
                    for (IDimMember m : cell.getNotNullMemberUserObject()) {
                        if (SystemVarsEnum.CURRENT.getNumber().equals(m.getNumber())) {
                            isCur = true;
                        }
                        combo.put(m.getDimension().getNumber(), m.getNumber());
                    }
                    if (!isCur) {
                        hasDim.set(true);
                    }
                    this.addCombo(isCur ? curCombos : fixCombos, combo);
                }
            });
        }
        this.addCurScopeAndCombo(fixCombos, curCombos);
        if (hasDim.get()) {
            HashMap<String, Set<String>> scope = new HashMap<String, Set<String>>();
            this.fixScope(scope);
            this.addScopeAndCombo(scope, fixCombos);
        }
    }

    private boolean checkIsFixMD(PositionInfo ps, int row, int col) {
        for (BasePointInfo bp : ps.getBasePoints()) {
            RangeModel rm = new RangeModel(bp.getDynaRange());
            if (!(bp.isDirectHoriz() ? rm.getX_start() <= col && rm.getX_end() >= col : rm.getY_start() <= row && rm.getY_end() >= row)) continue;
            return false;
        }
        return true;
    }

    private void addCurScopeAndCombo(List<Map<String, String>> fixCombos, List<Map<String, String>> curCombos) {
        if (!curCombos.isEmpty()) {
            HashMap<String, Set<String>> scope = new HashMap<String, Set<String>>();
            this.fixScope(scope);
            for (Map<String, String> combo : curCombos) {
                ArrayList<Map<String, String>> combos = new ArrayList<Map<String, String>>(1);
                boolean isCur = false;
                Iterator<Map.Entry<String, String>> dimit = combo.entrySet().iterator();
                while (dimit.hasNext()) {
                    Map.Entry<String, String> dim = dimit.next();
                    if (!SystemVarsEnum.CURRENT.getNumber().equals(dim.getValue())) continue;
                    isCur = true;
                    scope.put(dim.getKey(), this.filterScope.get(dim.getKey()));
                    dimit.remove();
                }
                if (isCur) {
                    combos.add(combo);
                    this.addScopeAndCombo(scope, combos);
                    continue;
                }
                fixCombos.add(combo);
            }
        }
    }

    private void buildFloatCombo() {
        for (PositionInfo ps : this.getParam().getSm().getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo bs : ps.getBasePoints()) {
                HashMap<String, Set<String>> scope = new HashMap<String, Set<String>>();
                this.fixScope(scope);
                List<Map<String, String>> combos = this.buildFloatFixCombos(bs);
                if (bs.getFixMemberPosition().isEmpty()) continue;
                for (BasePointInnerLineInfo info : bs.getBasePointInnerLineInfo()) {
                    if (!this.checkIsNormalDim(info.getDimension().getNumber())) continue;
                    HashSet nums = new HashSet();
                    boolean hasScope = false;
                    for (DynaMembScopeInfo scinfo : info.getDynaMembScopes()) {
                        hasScope = true;
                        if (SystemVarsEnum.CURRENT.getNumber().equals(scinfo.getMember().getNumber()) || SystemVarsEnum.CURRENT.getNumber().equals(((DimMember)scinfo.getMember()).getTemp_number())) {
                            nums.addAll(this.filterScope.get(scinfo.getMember().getDimension().getNumber()));
                            continue;
                        }
                        if (SystemVarsEnum.PR_NONE.getNumber().equals(scinfo.getMember().getNumber())) {
                            QFBuilder qb = new QFBuilder("model", "=", (Object)this.getParam().getModel().getModelId());
                            qb.and("dimension.number", "=", (Object)scinfo.getMember().getDimension().getNumber()).and("dpropertyid1", "=", (Object)0).and("dpropertyid2", "=", (Object)0).and("dpropertyid3", "=", (Object)0).and("dpropertyid4", "=", (Object)0).and("dpropertyid5", "=", (Object)0).and("dpropertyid6", "=", (Object)0).and("dpropertyid7", "=", (Object)0).and("dpropertyid8", "=", (Object)0).and("dpropertyid9", "=", (Object)0).and("dpropertyid10", "=", (Object)0);
                            DynamicObjectCollection doc = QueryServiceHelper.query((String)scinfo.getMember().getDimension().getUqCode(), (String)"number", (QFilter[])qb.toArray(), null, (int)-1);
                            nums.addAll(doc.stream().map(d -> d.getString("number")).collect(Collectors.toSet()));
                            continue;
                        }
                        new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), (Long)scinfo.getMember().getId(), scinfo.getMember().getNumber(), scinfo.getRangeId(), scinfo.isCustom(), (Object)this.getParam().getModel().getModelId()).matchItems(c -> nums.add(c.getNumber()));
                    }
                    if (!hasScope) continue;
                    scope.put(info.getDimension().getNumber(), nums);
                }
                this.addScopeAndCombo(scope, combos);
            }
        }
    }

    private List<Map<String, String>> buildFloatFixCombos(BasePointInfo bs) {
        ArrayList<Map<String, String>> combos = new ArrayList<Map<String, String>>();
        bs.getFixMemberPosition().values().forEach(fixmem -> {
            HashMap<String, String> memMap = new HashMap<String, String>();
            fixmem.forEach(mem -> memMap.put(mem.getDimension().getNumber(), mem.getNumber()));
            if (!memMap.isEmpty()) {
                this.addCombo(combos, memMap);
            }
        });
        return combos;
    }

    private void fixScope(Map<String, Set<String>> scope) {
        this.defaultScope.forEach((k, v) -> {
            if (this.checkIsNormalDim((String)k)) {
                scope.put((String)k, (Set<String>)v);
            }
        });
        this.getComdim().forEach(dim -> scope.put((String)dim, Collections.singleton(this.getParam().getMems().get(dim))));
        this.fixSpecialScope(scope);
    }

    public void fixSpecialScope(Map<String, Set<String>> scope) {
        scope.put(DimTypesEnum.PROCESS.getNumber(), this.getSpecialProcessNums());
    }

    public abstract Set<String> getSpecialProcessNums();

    protected void getViewAndPageMembers() {
        HashSet<String> numbers;
        for (ViewPointDimensionEntry viewPointDimensionEntry : this.param.getModel().getViewPointDimensionEntries()) {
            this.defaultScope.put(viewPointDimensionEntry.getDimension().getNumber(), Collections.singleton(viewPointDimensionEntry.getMember().getNumber()));
        }
        for (PageDimensionEntry pageDimensionEntry : this.param.getModel().getPageDimensionEntries()) {
            numbers = new HashSet<String>(16);
            for (Member member : pageDimensionEntry.getMembers()) {
                numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange(pageDimensionEntry.getDimension().getMemberEntityNumber(), member.getId(), member.getNumber(), member.getScope(), String.valueOf(this.param.getModel().getModelId()), DetailTypeEnum.OTHERS));
            }
            this.defaultScope.put(pageDimensionEntry.getDimension().getNumber(), numbers);
        }
        for (PageDimPropEntry pageDimPropEntry : this.param.getModel().getPagePropEntries()) {
            numbers = new HashSet(16);
            for (MembProperty membProperty : pageDimPropEntry.getAllMembProperties()) {
                numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number(pageDimPropEntry.getDimension().getMemberEntityNumber(), membProperty.getId(), membProperty.getNumber(), membProperty.getScope(), String.valueOf(this.param.getModel().getModelId()), DetailTypeEnum.OTHERS));
            }
            this.defaultScope.put(pageDimPropEntry.getDimension().getNumber(), numbers);
        }
        for (FilterDimensionEntry filterDimensionEntry : this.param.getModel().getFilterDimensionEntries()) {
            numbers = new HashSet(16);
            for (FilterDimMember filterDimMember : filterDimensionEntry.getMembers()) {
                if (!filterDimMember.isCustom()) {
                    numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange(filterDimensionEntry.getDimension().getMemberEntityNumber(), filterDimMember.getId(), filterDimMember.getNumber(), filterDimMember.getScope(), String.valueOf(this.param.getModel().getModelId()), DetailTypeEnum.OTHERS));
                    continue;
                }
                numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number(filterDimensionEntry.getDimension().getMemberEntityNumber(), filterDimMember.getId(), filterDimMember.getNumber(), filterDimMember.getScope(), String.valueOf(this.param.getModel().getModelId()), DetailTypeEnum.OTHERS));
            }
            this.filterScope.put(filterDimensionEntry.getDimension().getNumber(), numbers);
        }
    }

    private void addCombo(List<Map<String, String>> fixCombos, Map<String, String> fixCombo) {
        if (this.checkCanAddCombos(fixCombo) && !fixCombo.isEmpty()) {
            fixCombos.add(fixCombo);
        }
    }

    private boolean checkCanAddCombos(Map<String, String> combo) {
        boolean can = true;
        for (Map.Entry<String, String> mem : combo.entrySet()) {
            if (this.getComdim().contains(mem.getKey())) {
                if (!mem.getValue().equals(this.getParam().getMems().get(mem.getKey()))) {
                    can = false;
                }
                if (DimTypesEnum.YEAR.getNumber().equals(mem.getKey()) && "LastYear".equals(mem.getValue())) {
                    can = false;
                }
                if (!DimTypesEnum.PERIOD.getNumber().equals(mem.getKey()) || !"LastPeriod".equals(mem.getValue())) continue;
                can = false;
                continue;
            }
            if (!DimTypesEnum.PROCESS.getNumber().equals(mem.getKey())) continue;
            can = this.isProcessCanAdd(mem);
        }
        if (can) {
            this.removeFixedComFromCombos(combo);
        }
        return can;
    }

    protected boolean isProcessCanAdd(Map.Entry<String, String> mem) {
        return this.getSpecialProcessNums().contains(mem.getValue());
    }

    private void removeFixedComFromCombos(Map<String, String> combo) {
        this.getFixeddim().forEach(combo::remove);
    }

    private boolean checkIsNormalDim(String dim) {
        return !this.getFixeddim().contains(dim);
    }

    public BuildComboParam getParam() {
        return this.param;
    }

    public void addDefaultScope(String dim, Set<String> nums) {
        this.defaultScope.put(dim, nums);
    }

    public Set<String> getComdim() {
        return COMDIM;
    }

    public Set<String> getFixeddim() {
        return FIXEDDIM;
    }
}

