/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.lockdata.handle;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.lockdata.handle.AbstractComboHandle;
import kd.fi.bcm.business.lockdata.handle.BuildComboParam;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class MergeOrgAndECHandle
extends AbstractComboHandle {
    public MergeOrgAndECHandle(BuildComboParam param) {
        super(param);
    }

    @Override
    public Set<String> getSpecialProcessNums() {
        return Sets.newHashSet((Object[])new String[]{"EIRpt", "ERAdj", "IRpt", "RAdj", "CSTE", "DADJ", "DEJE"});
    }

    @Override
    public void afterAddScopeAndCombo(Map<String, Set<String>> scope, List<Map<String, String>> combos) {
        Pair<Set<String>, Set<String>> childs = this.getChildOrgNums();
        ((Set)childs.p1).forEach(pToSOrg -> {
            HashMap<String, Set<String>> pToSScope = new HashMap<String, Set<String>>(scope);
            pToSScope.put(DimTypesEnum.PROCESS.getNumber(), Sets.newHashSet((Object[])new String[]{"ADJ", "EJE", "CADJ", "CCADJ"}));
            pToSScope.put(DimTypesEnum.ENTITY.getNumber(), Collections.singleton(pToSOrg));
            this.addScopeAndCombo(pToSScope, combos, true);
        });
        ((Set)childs.p2).forEach(diffCurOrg -> {
            HashMap<String, Set<String>> diffCurScope = new HashMap<String, Set<String>>(scope);
            diffCurScope.put(DimTypesEnum.PROCESS.getNumber(), Sets.newHashSet((Object[])new String[]{"IRpt", "RAdj"}));
            diffCurScope.put(DimTypesEnum.ENTITY.getNumber(), Collections.singleton(diffCurOrg));
            this.addScopeAndCombo(diffCurScope, combos, true);
        });
    }

    public Pair<Set<String>, Set<String>> getChildOrgNums() {
        HashSet<String> diffCurorgs = new HashSet<String>();
        String orgnum = this.getParam().getMems().get(DimTypesEnum.ENTITY.getNumber());
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)this.getParam().getCube(), (String)orgnum);
        HashSet<String> pToSOrgs = new HashSet<String>(orgNode.getChildren().size());
        for (IDNumberTreeNode child : orgNode.getChildren()) {
            pToSOrgs.add(child.getParent_SonNumber());
            if (child.getCurrency().equals(orgNode.getCurrency())) continue;
            diffCurorgs.add(child.getNumber());
        }
        return Pair.onePair(pToSOrgs, diffCurorgs);
    }
}

