/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.log;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Page;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.auditlog.AuditLogBill;
import kd.fi.bcm.common.auditlog.AuditLogESIndexStrategy;
import kd.fi.bcm.common.auditlog.ESClient;
import kd.fi.bcm.common.auditlog.ESDateUtils;
import kd.fi.bcm.common.auditlog.LogESHelper;
import kd.fi.bcm.common.auditlog.LogTransactionType;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class AuditLogESHelper {
    private static final Log LOG = LogFactory.getLog(AuditLogESHelper.class);
    public static final String FIELD_FORMID = "formId";
    public static final String EVENT_ID = "eventId";
    public static final String ENTITY = "Entity";
    public static final String ACCOUNT = "Account";
    public static final String YEAR = "Year";
    public static final String PERIOD = "Period";
    public static final String SCENARIO = "Scenario";
    public static final String PROCESS = "Process";
    public static final String CURRENCY = "Currency";
    public static final String AUDITTRIAL = "AuditTrail";
    public static final String CHANGETYPE = "ChangeType";
    public static final String INTERNALCOMPANY = "InternalCompany";
    public static final String MULTIGAAP = "MultiGAAP";
    public static final String MYCOMPANY = "MyCompany";
    public static final String DATASORT = "DataSort";
    private static final String DATE_FIELD = "created";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final Integer SUBLIST = 100;
    private static final String BUSINESS = "fi-bcm-business";
    public static final Set<String> SPECIAL_CURRENCY = new HashSet<String>(Arrays.asList("EC", "DC", "PC"));
    protected static final Map<String, String> PROCESS_NUMBER_CONVERT_MAP = new HashMap<String, String>(3);
    protected static RequestOptions DEFAULT_REQUEST_OPTIONS;
    private static Map<String, String> dataMappingDimensionToMainEntityType;

    public static Set<String> getSpecialCurrency() {
        return SPECIAL_CURRENCY;
    }

    public static Map<String, Object> search(long modelId, AuditLogQueryParam queryParam, Integer page, Integer pageSize, Boolean flag) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        String message = "";
        if (queryParam == null) {
            throw new IllegalArgumentException("param 'queryParam' is null");
        }
        if (page == null) {
            throw new IllegalArgumentException("param 'page' is null");
        }
        if (pageSize == null) {
            throw new IllegalArgumentException("param 'pageSize' is null");
        }
        String modelCubeId = MemberReader.findModelNumberById((Object)modelId);
        LinkedHashMap eventIdSummaryDocDict = Maps.newLinkedHashMapWithExpectedSize((int)1000);
        long dataSearchTick = System.currentTimeMillis();
        List<Map<String, Object>> dataDocs = AuditLogESHelper.getDataDocs(flag, eventIdSummaryDocDict, modelCubeId, queryParam, page, pageSize);
        if (dataDocs == null || CollectionUtils.isEmpty(dataDocs)) {
            message = flag != false ? ResManager.loadKDString((String)"\u53ef\u8bbe\u7f6e\u66f4\u591a\u7ef4\u5ea6\u6761\u4ef6\u67e5\u8be2\u9700\u8981\u7684\u6570\u636e\u3002", (String)"AuditLogESHelper_1", (String)BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53ef\u901a\u8fc7\u8bbe\u7f6e\u7ef4\u5ea6\u6761\u4ef6\u67e5\u8be2\u66f4\u591a\u6570\u636e\u3002", (String)"AuditLogESHelper_2", (String)BUSINESS, (Object[])new Object[0]);
            Page pageResult = new Page((long)page.intValue(), (long)pageSize.intValue(), 0L);
            result.put("message", message);
            result.put("pageResult", pageResult);
            return result;
        }
        long s = System.currentTimeMillis();
        List<AuditLogBill> billList = AuditLogESHelper.convertAuditLogToBill(modelId, dataDocs, eventIdSummaryDocDict);
        LOG.info("audit_log_search_convert cost time:" + (System.currentTimeMillis() - s));
        Page pageResult = new Page((long)page.intValue(), (long)pageSize.intValue(), (long)dataDocs.size());
        pageResult.setRecords(billList);
        result.put("message", message);
        result.put("pageResult", pageResult);
        return result;
    }

    public static Page<AuditLogBill> search(long modelId, AuditLogQueryParam queryParam, Integer page, Integer pageSize) {
        Map<String, Object> result = AuditLogESHelper.search(modelId, queryParam, page, pageSize, false);
        return (Page)result.get("pageResult");
    }

    public static List<Map<String, Object>> getDataDocs(boolean flag, Map<String, Map<String, Object>> eventIdSummaryDocDict, String modelCubeId, AuditLogQueryParam queryParam, Integer page, Integer pageSize) {
        List<Map<String, Object>> dataDocs;
        if (flag) {
            LinkedHashMap eventIdDataDocDict = Maps.newLinkedHashMapWithExpectedSize((int)1000);
            SearchHits searchHitsData = AuditLogESHelper.getDataSerachHit(eventIdSummaryDocDict, modelCubeId, queryParam, page, pageSize);
            if (searchHitsData.getTotalHits() == 0L) {
                return null;
            }
            dataDocs = AuditLogESHelper.convertHits(searchHitsData.getHits());
            for (Map<String, Object> x : dataDocs) {
                eventIdDataDocDict.put((String)x.get(EVENT_ID), x);
            }
            if (CollectionUtils.isEmpty((Map)eventIdDataDocDict)) {
                return null;
            }
            SearchHits summaryHits = AuditLogESHelper.getEventIdSummaryHits(eventIdDataDocDict, modelCubeId, queryParam, page, pageSize);
            if (summaryHits.getTotalHits() == 0L) {
                return null;
            }
            List<Map<String, Object>> summaryDocs = AuditLogESHelper.convertHits(summaryHits.getHits());
            for (Map<String, Object> x : summaryDocs) {
                eventIdSummaryDocDict.put((String)x.get(EVENT_ID), x);
            }
            if (CollectionUtils.isEmpty(eventIdSummaryDocDict)) {
                return null;
            }
            dataDocs = dataDocs.stream().filter(oneObjec -> {
                Object eventId = oneObjec.get(EVENT_ID);
                return eventIdSummaryDocDict.containsKey(eventId);
            }).collect(Collectors.toList());
        } else {
            SearchHits summaryHits = AuditLogESHelper.getEventIdSummaryHits(null, modelCubeId, queryParam, page, pageSize);
            if (summaryHits.getTotalHits() == 0L) {
                return null;
            }
            List<Map<String, Object>> summaryDocs = AuditLogESHelper.convertHits(summaryHits.getHits());
            for (Map<String, Object> x : summaryDocs) {
                eventIdSummaryDocDict.put((String)x.get(EVENT_ID), x);
            }
            if (CollectionUtils.isEmpty(eventIdSummaryDocDict)) {
                return null;
            }
            SearchHits searchHitsData = AuditLogESHelper.getDataSerachHit(eventIdSummaryDocDict, modelCubeId, queryParam, page, pageSize);
            SearchHit[] searchHits = searchHitsData.getHits();
            if (searchHits.length == 0) {
                return null;
            }
            dataDocs = AuditLogESHelper.convertHits(searchHits);
        }
        return dataDocs;
    }

    private static SearchHits getEventIdSummaryHits(Map<String, Map<String, Object>> eventIdDataDocDict, String modelCubeId, AuditLogQueryParam queryParam, Integer page, Integer pageSize) {
        long summarySearchTick = System.currentTimeMillis();
        SearchSourceBuilder summarySearchBuilder = AuditLogESHelper.buildAuditSummarySearch(eventIdDataDocDict, queryParam, pageSize);
        summarySearchBuilder.from((page - 1) * pageSize);
        summarySearchBuilder.size(page * pageSize);
        summarySearchBuilder.timeout(TimeValue.timeValueSeconds((long)10L));
        SearchHits summaryHits = AuditLogESHelper.doQuery(AuditLogESIndexStrategy.decideSearchIndexName((String)modelCubeId, (AuditLogESIndexStrategy.AuditLogIndexType)AuditLogESIndexStrategy.AuditLogIndexType.summary, (Date)queryParam.getStartTime(), (Date)queryParam.getEndTime()), summarySearchBuilder);
        LOG.info("audit_log_search_summary cost time: " + (System.currentTimeMillis() - summarySearchTick));
        return summaryHits;
    }

    public static SearchHits getDataSerachHit(Map<String, Map<String, Object>> eventIdSummaryDocDict, String modelCubeId, AuditLogQueryParam queryParam, Integer page, Integer pageSize) {
        long dataSearchTick = System.currentTimeMillis();
        SearchSourceBuilder dataSearchBuilder = AuditLogESHelper.buildAuditDataSearch(eventIdSummaryDocDict, queryParam);
        dataSearchBuilder.from((page - 1) * pageSize);
        dataSearchBuilder.size(page * pageSize);
        dataSearchBuilder.timeout(TimeValue.timeValueSeconds((long)10L));
        SearchHits dataHits = AuditLogESHelper.doQuery(AuditLogESIndexStrategy.decideSearchIndexName((String)modelCubeId, (AuditLogESIndexStrategy.AuditLogIndexType)AuditLogESIndexStrategy.AuditLogIndexType.data, (Date)queryParam.getStartTime(), (Date)queryParam.getEndTime()), dataSearchBuilder);
        LOG.info("audit_log_search_summary cost time: " + (System.currentTimeMillis() - dataSearchTick));
        return dataHits;
    }

    private static List<String> listCustomDimensionNumbers(long modelId) {
        DynamicObjectCollection customDimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("issysdimension", "=", (Object)"0")}, (String)"dseq asc");
        return customDimensions.stream().map(x -> x.getString(NUMBER)).collect(Collectors.toList());
    }

    private static SearchHits doQuery(String indexName, SearchSourceBuilder sourceBuilder) {
        try {
            SearchRequest request = new SearchRequest(new String[]{indexName});
            request.source(sourceBuilder);
            request.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
            SearchResponse search = ESClient.getESClient().search(request, DEFAULT_REQUEST_OPTIONS);
            return search.getHits();
        }
        catch (IOException e) {
            LOG.error(String.format("failed to execute ES query, index: %s, queryBuilder: %s", indexName, sourceBuilder), (Throwable)e);
            throw new KDBizException(ESClient.getErrorCode(), new Object[]{e});
        }
    }

    private static SearchSourceBuilder buildAuditSummarySearch(Map<String, Map<String, Object>> eventIdDataDocDict, AuditLogQueryParam qp, int pageSize) {
        Set<String> filterEventIds;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder conditionBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder("operateTime");
        rangeQueryBuilder.from((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getStartTime()));
        rangeQueryBuilder.to((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getEndTime()));
        conditionBuilder.filter((QueryBuilder)rangeQueryBuilder);
        if (Objects.nonNull(qp.getUserId())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"userId", (Object[])new Long[]{qp.getUserId()}));
        }
        if (!CollectionUtils.isEmpty(eventIdDataDocDict) && !CollectionUtils.isEmpty(filterEventIds = eventIdDataDocDict.keySet())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)EVENT_ID, filterEventIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)qp.getTransactionTag())) {
            AuditLogESHelper.buildTransactionTag(conditionBuilder, qp.getTransactionTag());
        }
        searchSourceBuilder.sort("operateTime", qp.isSortByTimeAsc ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.query((QueryBuilder)conditionBuilder);
        searchSourceBuilder.from(0);
        searchSourceBuilder.size(pageSize);
        return searchSourceBuilder;
    }

    private static SearchSourceBuilder buildAuditDataSearch(Map<String, Map<String, Object>> eventIdSummaryDocDict, AuditLogQueryParam qp) {
        Set<String> filterEventIds;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder conditionBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(DATE_FIELD);
        rangeQueryBuilder.from((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getStartTime()));
        rangeQueryBuilder.to((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getEndTime()));
        conditionBuilder.filter((QueryBuilder)rangeQueryBuilder);
        if (!CollectionUtils.isEmpty(eventIdSummaryDocDict) && !CollectionUtils.isEmpty(filterEventIds = eventIdSummaryDocDict.keySet())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)EVENT_ID, filterEventIds));
        }
        if (!CollectionUtils.isEmpty(qp.getAccountDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ACCOUNT, qp.getAccountDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getScenarioDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)SCENARIO, qp.getScenarioDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getYearDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)YEAR, qp.getYearDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getPeriodDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)PERIOD, qp.getPeriodDims()));
        }
        if (!qp.getCurrencyDims().isEmpty() && CollectionUtils.containsAny(qp.getCurrencyDims(), SPECIAL_CURRENCY)) {
            if (qp.getEntityDims().size() != 1) {
                throw new IllegalArgumentException("only one entity is specified if the currency include 'EC', or 'DC'");
            }
            if (CollectionUtils.isEmpty(qp.getProcessDims())) {
                throw new IllegalArgumentException("the process dimension must be specified if the currency include 'EC', or 'DC'");
            }
            List<CurrencyConditionGrp> currencyConGrp = AuditLogESHelper.buildCurrencyConditionGroup(qp.getModelId(), qp.getEntityDims().iterator().next(), qp.getProcessDims(), qp.getCurrencyDims());
            if (!currencyConGrp.isEmpty()) {
                BoolQueryBuilder currencyQueryBuilder = QueryBuilders.boolQuery();
                for (CurrencyConditionGrp currencyConditionGrp : currencyConGrp) {
                    BoolQueryBuilder oneGrpCondition = QueryBuilders.boolQuery();
                    oneGrpCondition.must((QueryBuilder)QueryBuilders.termsQuery((String)ENTITY, (String[])new String[]{currencyConditionGrp.getEntityNum()}));
                    oneGrpCondition.must((QueryBuilder)QueryBuilders.termsQuery((String)PROCESS, currencyConditionGrp.getProcessNums()));
                    oneGrpCondition.must((QueryBuilder)QueryBuilders.termsQuery((String)CURRENCY, currencyConditionGrp.getCurrencyNums()));
                    currencyQueryBuilder.should((QueryBuilder)oneGrpCondition);
                }
                conditionBuilder.must((QueryBuilder)currencyQueryBuilder);
            }
        } else {
            if (!CollectionUtils.isEmpty(qp.getEntityDims())) {
                conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ENTITY, qp.getEntityDims()));
            }
            if (!CollectionUtils.isEmpty(qp.getProcessDims())) {
                conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)PROCESS, AuditLogESHelper.mapSpecialProcess(qp.getProcessDims())));
            }
            if (!CollectionUtils.isEmpty(qp.getCurrencyDims())) {
                conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)CURRENCY, qp.getCurrencyDims()));
            }
        }
        if (!CollectionUtils.isEmpty(qp.getAuditTrailDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)AUDITTRIAL, qp.getAuditTrailDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getChangeTypeDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)CHANGETYPE, qp.getChangeTypeDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getInternalCompanyDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)INTERNALCOMPANY, qp.getInternalCompanyDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getDataSortDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)DATASORT, qp.getDataSortDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getMultiGAAPDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)MULTIGAAP, qp.getMultiGAAPDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getMyCompanyDims())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)MYCOMPANY, qp.getMyCompanyDims()));
        }
        if (!CollectionUtils.isEmpty(qp.getCustomDefinedFilters())) {
            for (Map.Entry<String, Set<String>> custEntry : qp.getCustomDefinedFilters().entrySet()) {
                Set<String> custDims = custEntry.getValue();
                if (CollectionUtils.isEmpty(custDims)) continue;
                conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)custEntry.getKey(), custDims));
            }
        }
        searchSourceBuilder.sort(DATE_FIELD, qp.isSortByTimeAsc ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.query((QueryBuilder)conditionBuilder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("audit_log_query condition:" + conditionBuilder);
        }
        return searchSourceBuilder;
    }

    public static List<CurrencyConditionGrp> buildCurrencyConditionGroup(long modelId, String entityNumber, Set<String> processNumbers, Set<String> currencyNumbers) {
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            throw new IllegalArgumentException("param entityNumber is empty");
        }
        if (CollectionUtils.isEmpty(processNumbers)) {
            throw new IllegalArgumentException("param processNumbers can not be empty");
        }
        if (CollectionUtils.isEmpty(currencyNumbers)) {
            throw new IllegalArgumentException("param currencyNumbers can not be empty");
        }
        ArrayList<CurrencyConditionGrp> result = new ArrayList<CurrencyConditionGrp>(8);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode entityTreeNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)entityNumber);
        Set<String> nonSpecialCurs = currencyNumbers.stream().filter(x -> !SPECIAL_CURRENCY.contains(x)).collect(Collectors.toSet());
        if (!nonSpecialCurs.isEmpty()) {
            result.add(new CurrencyConditionGrp(entityNumber, AuditLogESHelper.mapSpecialProcess(processNumbers), nonSpecialCurs));
        }
        Set specialCurs = currencyNumbers.stream().filter(x -> SPECIAL_CURRENCY.contains(x)).collect(Collectors.toSet());
        for (String specialCur : specialCurs) {
            for (String process : processNumbers) {
                Pair<String, String> pair = TransMemberUtil.transOrgAndCurbyOrgId(modelId, (long)entityTreeNode.getId(), process, specialCur, 0L, 0L);
                String newCurrency = (String)pair.p2;
                result.add(new CurrencyConditionGrp(entityNumber, Collections.singleton(AuditLogESHelper.mapSpecialProcess(process)), Collections.singleton(newCurrency)));
            }
        }
        return result;
    }

    public static List<Map<String, Object>> convertHits(SearchHit[] hits) {
        if (ArrayUtils.isEmpty((Object[])hits)) {
            return Collections.emptyList();
        }
        ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
        return Arrays.stream(hits).map(hit -> {
            try {
                return (Map)objectMapper.readValue(hit.getSourceAsString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new KDBizException(ESClient.getErrorCode(), new Object[]{"failed to parse string to map:" + hit.getSourceAsString()});
            }
        }).collect(Collectors.toList());
    }

    private static List<AuditLogBill> convertAuditLogToBill(long modelId, List<Map<String, Object>> dataDocs, Map<String, Map<String, Object>> eventIdSummaryDocDict) {
        long dataSearchTick1 = System.currentTimeMillis();
        Map<Object, DynamicObject> entityNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, ENTITY, modelId);
        Map<Object, DynamicObject> accountNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, ACCOUNT, modelId);
        Map<Object, DynamicObject> scenarioNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, SCENARIO, modelId);
        Map<Object, DynamicObject> yearNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, YEAR, modelId);
        Map<Object, DynamicObject> periodNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, PERIOD, modelId);
        Map<Object, DynamicObject> processNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, PROCESS, modelId);
        Map<Object, DynamicObject> currencyNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, CURRENCY, modelId);
        Map<Object, DynamicObject> auditTrailNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, AUDITTRIAL, modelId);
        Map<Object, DynamicObject> changeTypeNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, CHANGETYPE, modelId);
        Map<Object, DynamicObject> internalCompanyNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, INTERNALCOMPANY, modelId);
        Map<Object, DynamicObject> multiGAAPNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, MULTIGAAP, modelId);
        Map<Object, DynamicObject> myCompanyNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, MYCOMPANY, modelId);
        Map<Object, DynamicObject> dataSortNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, DATASORT, modelId);
        List<String> custDimNums = AuditLogESHelper.listCustomDimensionNumbers(modelId);
        HashMap<String, Map<Object, DynamicObject>> customDimsionNumberIdMap = new HashMap<String, Map<Object, DynamicObject>>(custDimNums.size());
        for (String custDim : custDimNums) {
            Map<Object, DynamicObject> oneNumberIdMap = AuditLogESHelper.mapMemberNumberToID(dataDocs, custDim, modelId);
            customDimsionNumberIdMap.put(custDim, oneNumberIdMap);
        }
        Set<Long> userIds = eventIdSummaryDocDict.values().stream().map(x -> (String)x.get("userId")).filter(x -> StringUtils.isNotEmpty((CharSequence)x)).map(x -> Long.parseLong(x)).collect(Collectors.toSet());
        Map userCache = BusinessDataServiceHelper.loadFromCache((Object[])userIds.toArray(new Long[0]), (String)"bos_user");
        LOG.info("mapMemberNumberToID cost time: " + (System.currentTimeMillis() - dataSearchTick1));
        boolean isShowAuditLogData = Boolean.parseBoolean(System.getProperty("fi.bcm.auditlog.islog", "false"));
        long dataSearchTick = System.currentTimeMillis();
        List<Object> result = new ArrayList();
        result = dataDocs.size() >= 5000 ? AuditLogESHelper.getResultDataByThread(dataDocs, isShowAuditLogData, customDimsionNumberIdMap, userCache, entityNumberIdMap, accountNumberIdMap, scenarioNumberIdMap, scenarioNumberIdMap, yearNumberIdMap, periodNumberIdMap, processNumberIdMap, currencyNumberIdMap, auditTrailNumberIdMap, changeTypeNumberIdMap, internalCompanyNumberIdMap, multiGAAPNumberIdMap, myCompanyNumberIdMap, dataSortNumberIdMap, eventIdSummaryDocDict, custDimNums) : AuditLogESHelper.getResultData(dataDocs, isShowAuditLogData, customDimsionNumberIdMap, userCache, entityNumberIdMap, accountNumberIdMap, scenarioNumberIdMap, scenarioNumberIdMap, yearNumberIdMap, periodNumberIdMap, processNumberIdMap, currencyNumberIdMap, auditTrailNumberIdMap, changeTypeNumberIdMap, internalCompanyNumberIdMap, multiGAAPNumberIdMap, myCompanyNumberIdMap, dataSortNumberIdMap, eventIdSummaryDocDict, custDimNums);
        LOG.info("getdatas cost time: " + (System.currentTimeMillis() - dataSearchTick));
        return result;
    }

    private static List<AuditLogBill> getResultData(List<Map<String, Object>> dataDocs, boolean isShowAuditLogData, Map<String, Map<Object, DynamicObject>> customDimsionNumberIdMap, Map<Object, DynamicObject> userCache, Map<Object, DynamicObject> entityNumberIdMap, Map<Object, DynamicObject> accountNumberIdMap, Map<Object, DynamicObject> scenarioNumberIdMap, Map<Object, DynamicObject> scenarioNumberIdMap1, Map<Object, DynamicObject> yearNumberIdMap, Map<Object, DynamicObject> periodNumberIdMap, Map<Object, DynamicObject> processNumberIdMap, Map<Object, DynamicObject> currencyNumberIdMap, Map<Object, DynamicObject> auditTrailNumberIdMap, Map<Object, DynamicObject> changeTypeNumberIdMap, Map<Object, DynamicObject> internalCompanyNumberIdMap, Map<Object, DynamicObject> multiGAAPNumberIdMap, Map<Object, DynamicObject> myCompanyNumberIdMap, Map<Object, DynamicObject> dataSortNumberIdMap, Map<String, Map<String, Object>> eventIdSummaryDocDict, List<String> custDimNums) {
        long dataSearchTick = System.currentTimeMillis();
        List<AuditLogBill> result = dataDocs.stream().map(x -> {
            AuditLogBill logBill = AuditLogESHelper.getAuditLogBillData(x, isShowAuditLogData, customDimsionNumberIdMap, userCache, entityNumberIdMap, accountNumberIdMap, scenarioNumberIdMap, scenarioNumberIdMap, yearNumberIdMap, periodNumberIdMap, processNumberIdMap, currencyNumberIdMap, auditTrailNumberIdMap, changeTypeNumberIdMap, internalCompanyNumberIdMap, multiGAAPNumberIdMap, myCompanyNumberIdMap, dataSortNumberIdMap, eventIdSummaryDocDict, custDimNums);
            return logBill;
        }).collect(Collectors.toList());
        LOG.info("getResultData cost time: " + (System.currentTimeMillis() - dataSearchTick));
        return result;
    }

    private static AuditLogBill getAuditLogBillData(Map<String, Object> x, boolean isShowAuditLogData, Map<String, Map<Object, DynamicObject>> customDimsionNumberIdMap, Map<Object, DynamicObject> userCache, Map<Object, DynamicObject> entityNumberIdMap, Map<Object, DynamicObject> accountNumberIdMap, Map<Object, DynamicObject> scenarioNumberIdMap, Map<Object, DynamicObject> scenarioNumberIdMap1, Map<Object, DynamicObject> yearNumberIdMap, Map<Object, DynamicObject> periodNumberIdMap, Map<Object, DynamicObject> processNumberIdMap, Map<Object, DynamicObject> currencyNumberIdMap, Map<Object, DynamicObject> auditTrailNumberIdMap, Map<Object, DynamicObject> changeTypeNumberIdMap, Map<Object, DynamicObject> internalCompanyNumberIdMap, Map<Object, DynamicObject> multiGAAPNumberIdMap, Map<Object, DynamicObject> myCompanyNumberIdMap, Map<Object, DynamicObject> dataSortNumberIdMap, Map<String, Map<String, Object>> eventIdSummaryDocDict, List<String> custDimNums) {
        long dataSearchTick = System.currentTimeMillis();
        AuditLogBill logBill = new AuditLogBill();
        String eventId = (String)x.get(EVENT_ID);
        if (isShowAuditLogData) {
            LOG.info("audit_log_search_log: eventId:{} {}", (Object)eventId, (Object)JacksonUtils.toJson(x));
        }
        logBill.setEventId(eventId);
        logBill.setDataDocId((String)x.get("_id"));
        Map<String, Object> summaryDoc = eventIdSummaryDocDict.get(eventId);
        if (Objects.nonNull(summaryDoc)) {
            Map metaEntityTransactionTypeMap = LogESHelper.getMetaEntityTransactionTypeMap();
            logBill.setTraceId((String)summaryDoc.get("traceId"));
            String userId = (String)summaryDoc.get("userId");
            if (StringUtils.isNotEmpty((CharSequence)userId)) {
                logBill.setUserDy(userCache.get(Long.parseLong(userId)));
            }
            logBill.setIp((String)summaryDoc.get("ip"));
            logBill.setOperateType((String)summaryDoc.get("operateType"));
            logBill.setTransactionType((String)metaEntityTransactionTypeMap.getOrDefault(summaryDoc.get(FIELD_FORMID), metaEntityTransactionTypeMap.get("biz_rule")));
            if (Objects.isNull(logBill.getUserDy())) {
                LOG.info("audit_log_search_blank summary: {}", (Object)JacksonUtils.toJson(summaryDoc));
            }
        } else {
            LOG.info("audit_log_search_without_summary: eventID[{}], is involved into filter event ids: {}", (Object)eventId, (Object)eventIdSummaryDocDict.containsKey(eventId));
        }
        try {
            logBill.setOperateTime(ESDateUtils.parseUTCDate((String)((String)x.get(DATE_FIELD))));
        }
        catch (Exception e) {
            LOG.error("failed_to_parse_es_dat_formate: " + x.get(DATE_FIELD), (Throwable)e);
            logBill.setOperateTime(null);
        }
        logBill.setEntityDy(AuditLogESHelper.tolerateRetrieveMember(entityNumberIdMap, x.get(ENTITY), true));
        logBill.setAccountDy(AuditLogESHelper.tolerateRetrieveMember(accountNumberIdMap, x.get(ACCOUNT)));
        logBill.setScenarioDy(AuditLogESHelper.tolerateRetrieveMember(scenarioNumberIdMap, x.get(SCENARIO)));
        logBill.setYearDy(AuditLogESHelper.tolerateRetrieveMember(yearNumberIdMap, x.get(YEAR)));
        logBill.setPeriodDy(AuditLogESHelper.tolerateRetrieveMember(periodNumberIdMap, x.get(PERIOD)));
        logBill.setProcessDy(AuditLogESHelper.tolerateRetrieveMember(processNumberIdMap, x.get(PROCESS)));
        logBill.setCurrencyDy(AuditLogESHelper.tolerateRetrieveMember(currencyNumberIdMap, x.get(CURRENCY)));
        logBill.setAuditTrailDy(AuditLogESHelper.tolerateRetrieveMember(auditTrailNumberIdMap, x.get(AUDITTRIAL)));
        logBill.setChangeTypeDy(AuditLogESHelper.tolerateRetrieveMember(changeTypeNumberIdMap, x.get(CHANGETYPE)));
        logBill.setInternalCompanyDy(AuditLogESHelper.tolerateRetrieveMember(internalCompanyNumberIdMap, x.get(INTERNALCOMPANY)));
        logBill.setDataSortDy(AuditLogESHelper.tolerateRetrieveMember(dataSortNumberIdMap, x.get(DATASORT)));
        logBill.setMultiGAAPDy(AuditLogESHelper.tolerateRetrieveMember(multiGAAPNumberIdMap, x.get(MULTIGAAP)));
        logBill.setMyCompanyDy(AuditLogESHelper.tolerateRetrieveMember(myCompanyNumberIdMap, x.get(MYCOMPANY)));
        logBill.setOldValue(Objects.isNull(x.get("oldValue")) ? "" : String.valueOf(x.get("oldValue")));
        logBill.setNewValue(Objects.isNull(x.get("newValue")) ? "" : String.valueOf(x.get("newValue")));
        logBill.setTypeChange((String)x.get("typeChange"));
        if (custDimNums.size() > 0) {
            String firstCustDimNum = custDimNums.get(0);
            logBill.setC1Dy(AuditLogESHelper.tolerateRetrieveMember(customDimsionNumberIdMap.get(firstCustDimNum), x.get(firstCustDimNum)));
        }
        if (custDimNums.size() > 1) {
            String secondCustDim = custDimNums.get(1);
            logBill.setC2Dy(AuditLogESHelper.tolerateRetrieveMember(customDimsionNumberIdMap.get(secondCustDim), x.get(secondCustDim)));
        }
        if (custDimNums.size() > 2) {
            String thirdCustDimNum = custDimNums.get(2);
            logBill.setC3Dy(AuditLogESHelper.tolerateRetrieveMember(customDimsionNumberIdMap.get(thirdCustDimNum), x.get(thirdCustDimNum)));
        }
        if (custDimNums.size() > 3) {
            String fourthCustDimNum = custDimNums.get(3);
            logBill.setC4Dy(AuditLogESHelper.tolerateRetrieveMember(customDimsionNumberIdMap.get(fourthCustDimNum), x.get(fourthCustDimNum)));
        }
        if (custDimNums.size() > 4) {
            String fifthCustDimNum = custDimNums.get(4);
            logBill.setC5Dy(AuditLogESHelper.tolerateRetrieveMember(customDimsionNumberIdMap.get(fifthCustDimNum), x.get(fifthCustDimNum)));
        }
        if (custDimNums.size() > 5) {
            String sixCustDimNum = custDimNums.get(5);
            logBill.setC6Dy(AuditLogESHelper.tolerateRetrieveMember(customDimsionNumberIdMap.get(sixCustDimNum), x.get(sixCustDimNum)));
        }
        LOG.info("getAuditLogBillData cost time: " + (System.currentTimeMillis() - dataSearchTick));
        return logBill;
    }

    private static List<AuditLogBill> getResultDataByThread(List<Map<String, Object>> dataDocs, boolean isShowAuditLogData, Map<String, Map<Object, DynamicObject>> customDimsionNumberIdMap, Map<Object, DynamicObject> userCache, Map<Object, DynamicObject> entityNumberIdMap, Map<Object, DynamicObject> accountNumberIdMap, Map<Object, DynamicObject> scenarioNumberIdMap, Map<Object, DynamicObject> scenarioNumberIdMap1, Map<Object, DynamicObject> yearNumberIdMap, Map<Object, DynamicObject> periodNumberIdMap, Map<Object, DynamicObject> processNumberIdMap, Map<Object, DynamicObject> currencyNumberIdMap, Map<Object, DynamicObject> auditTrailNumberIdMap, Map<Object, DynamicObject> changeTypeNumberIdMap, Map<Object, DynamicObject> internalCompanyNumberIdMap, Map<Object, DynamicObject> multiGAAPNumberIdMap, Map<Object, DynamicObject> myCompanyNumberIdMap, Map<Object, DynamicObject> dataSortNumberIdMap, Map<String, Map<String, Object>> eventIdSummaryDocDict, List<String> custDimNums) {
        long dataSearchTick = System.currentTimeMillis();
        ArrayList<AuditLogBill> result = new ArrayList();
        int size = dataDocs.size() % SUBLIST > 0 ? dataDocs.size() / SUBLIST + 1 : dataDocs.size() / SUBLIST;
        ConcurrentHashMap dataMap = new ConcurrentHashMap(dataDocs.size());
        CountDownLatch latch = new CountDownLatch(size);
        int i = 0;
        while (i < size) {
            List tempList;
            List finalTempList = tempList = dataDocs.stream().skip((long)SUBLIST.intValue() * (long)i).limit(SUBLIST.intValue()).collect(Collectors.toList());
            int start = i++;
            ThreadPoolService.runAuditLogsAsyncThread(() -> {
                try {
                    AuditLogESHelper.getHandleDataDocs(start, finalTempList, dataMap, isShowAuditLogData, customDimsionNumberIdMap, userCache, entityNumberIdMap, accountNumberIdMap, scenarioNumberIdMap, yearNumberIdMap, periodNumberIdMap, processNumberIdMap, currencyNumberIdMap, auditTrailNumberIdMap, changeTypeNumberIdMap, internalCompanyNumberIdMap, multiGAAPNumberIdMap, myCompanyNumberIdMap, dataSortNumberIdMap, eventIdSummaryDocDict, custDimNums);
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, new ErrorCode("AuditLogESHelper", e.getMessage()), new Object[0]);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
            result = dataMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            throw new KDException((Throwable)e, new ErrorCode("AuditLogESHelper", e.getMessage()), new Object[0]);
        }
        LOG.info("getResultDataByThread cost time: " + (System.currentTimeMillis() - dataSearchTick));
        return result;
    }

    private static void getHandleDataDocs(int start, List<Map<String, Object>> dataDocs, Map<Integer, AuditLogBill> dataMap, boolean isShowAuditLogData, Map<String, Map<Object, DynamicObject>> customDimsionNumberIdMap, Map<Object, DynamicObject> userCache, Map<Object, DynamicObject> entityNumberIdMap, Map<Object, DynamicObject> accountNumberIdMap, Map<Object, DynamicObject> scenarioNumberIdMap, Map<Object, DynamicObject> yearNumberIdMap, Map<Object, DynamicObject> periodNumberIdMap, Map<Object, DynamicObject> processNumberIdMap, Map<Object, DynamicObject> currencyNumberIdMap, Map<Object, DynamicObject> auditTrailNumberIdMap, Map<Object, DynamicObject> changeTypeNumberIdMap, Map<Object, DynamicObject> internalCompanyNumberIdMap, Map<Object, DynamicObject> multiGAAPNumberIdMap, Map<Object, DynamicObject> myCompanyNumberIdMap, Map<Object, DynamicObject> dataSortNumberIdMap, Map<String, Map<String, Object>> eventIdSummaryDocDict, List<String> custDimNums) {
        long dataSearchTick = System.currentTimeMillis();
        for (int i = 0; i < dataDocs.size(); ++i) {
            Map<String, Object> x = dataDocs.get(i);
            AuditLogBill logBill = AuditLogESHelper.getAuditLogBillData(x, isShowAuditLogData, customDimsionNumberIdMap, userCache, entityNumberIdMap, accountNumberIdMap, scenarioNumberIdMap, scenarioNumberIdMap, yearNumberIdMap, periodNumberIdMap, processNumberIdMap, currencyNumberIdMap, auditTrailNumberIdMap, changeTypeNumberIdMap, internalCompanyNumberIdMap, multiGAAPNumberIdMap, myCompanyNumberIdMap, dataSortNumberIdMap, eventIdSummaryDocDict, custDimNums);
            dataMap.put(start * SUBLIST + i, logBill);
        }
        LOG.info("getHandleDataDocs cost time: " + (System.currentTimeMillis() - dataSearchTick));
    }

    private static DynamicObject tolerateRetrieveMember(Map<Object, DynamicObject> indexData, Object memberNumber) {
        return AuditLogESHelper.tolerateRetrieveMember(indexData, memberNumber, false);
    }

    private static DynamicObject tolerateRetrieveMember(Map<Object, DynamicObject> indexData, Object memberNumber, boolean isEntityDimension) {
        if (!Objects.nonNull(memberNumber)) {
            return null;
        }
        String finalMemberNumberStr = "";
        if (isEntityDimension && Objects.nonNull(memberNumber) && memberNumber.toString().contains("_")) {
            String memberNumberStr = memberNumber.toString();
            finalMemberNumberStr = memberNumberStr.substring(memberNumberStr.indexOf("_") + 1);
        } else {
            finalMemberNumberStr = memberNumber.toString();
        }
        DynamicObject dynamicObject = indexData.get(finalMemberNumberStr);
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            dynamicObject = AuditLogESHelper.getNewDynamic(indexData, finalMemberNumberStr);
        }
        return dynamicObject;
    }

    private static DynamicObject getNewDynamic(Map<Object, DynamicObject> indexData, Object memberNumber) {
        DynamicObject sample = indexData.values().iterator().next();
        DynamicObject newDy = (DynamicObject)sample.getDynamicObjectType().createInstance();
        newDy.set(NUMBER, memberNumber);
        newDy.set(NAME, (Object)"");
        indexData.put(memberNumber, newDy);
        return newDy;
    }

    private static Map<Object, DynamicObject> mapMemberNumberToID(List<Map<String, Object>> auditDataDocs, String targetDimensionKey, long modelId) {
        boolean isCustomDimension = !dataMappingDimensionToMainEntityType.containsKey(targetDimensionKey);
        String mainEntity = isCustomDimension ? "bcm_userdefinedmembertree" : dataMappingDimensionToMainEntityType.get(targetDimensionKey);
        Set entityNumbers = auditDataDocs.stream().filter(x -> x.containsKey(targetDimensionKey)).map(x -> (String)x.get(targetDimensionKey)).collect(Collectors.toSet());
        if (entityNumbers.isEmpty()) {
            return Collections.emptyMap();
        }
        QFBuilder memberFilters = new QFBuilder();
        memberFilters.add("model", "=", (Object)modelId);
        if (entityNumbers.size() < 100) {
            memberFilters.add(NUMBER, "in", entityNumbers);
        }
        memberFilters.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        if (isCustomDimension) {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)modelId).add(NUMBER, "=", (Object)targetDimensionKey).add("issysdimension", "=", (Object)"0");
            DynamicObject customDimension = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])qf.toArray());
            memberFilters.add("dimension", "=", (Object)customDimension.getLong("id"));
        }
        Map members = BusinessDataServiceHelper.loadFromCache((String)mainEntity, (String)"id,number,name", (QFilter[])memberFilters.toArray());
        HashMap<Object, DynamicObject> newMembers = new HashMap<Object, DynamicObject>();
        List collect = members.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        collect.stream().forEach(c -> {
            DynamicObject o = c;
            newMembers.put(o.getString(NUMBER), o);
        });
        return newMembers;
    }

    private static Set<String> mapSpecialProcess(Set<String> processNumbers) {
        if (CollectionUtils.isEmpty(processNumbers)) {
            return Collections.emptySet();
        }
        return processNumbers.stream().map(x -> PROCESS_NUMBER_CONVERT_MAP.getOrDefault(x, (String)x)).collect(Collectors.toSet());
    }

    private static String mapSpecialProcess(String processNumber) {
        return PROCESS_NUMBER_CONVERT_MAP.getOrDefault(processNumber, processNumber);
    }

    public static void buildTransactionTag(BoolQueryBuilder conditionBuilder, String transactionTag) {
        Map transactionLogTypes = LogESHelper.getTransactionLogTypes();
        if (StringUtils.isNotEmpty((CharSequence)transactionTag)) {
            LogTransactionType transactionType = (LogTransactionType)transactionLogTypes.get(transactionTag);
            if (null == transactionType) {
                conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)FIELD_FORMID, (Collection)Lists.newArrayList()));
            } else if (!CollectionUtils.isEmpty((Collection)transactionType.getMetaEntities())) {
                conditionBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)FIELD_FORMID, (Collection)transactionType.getMetaEntities()));
            } else {
                ArrayList antiEntities = new ArrayList(10);
                transactionLogTypes.entrySet().stream().filter(x -> !transactionTag.equalsIgnoreCase((String)x.getKey())).forEach(x -> antiEntities.addAll(((LogTransactionType)x.getValue()).getMetaEntities()));
                conditionBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)FIELD_FORMID, antiEntities));
            }
        }
    }

    static {
        PROCESS_NUMBER_CONVERT_MAP.put("ERpt", "Rpt");
        PROCESS_NUMBER_CONVERT_MAP.put("EIRpt", "IRpt");
        PROCESS_NUMBER_CONVERT_MAP.put("ERAdj", "RAdj");
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(0x40000000));
        DEFAULT_REQUEST_OPTIONS = builder.build();
        dataMappingDimensionToMainEntityType = new HashMap<String, String>(10);
        dataMappingDimensionToMainEntityType.put(ENTITY, "bcm_entitymembertree");
        dataMappingDimensionToMainEntityType.put(ACCOUNT, "bcm_accountmembertree");
        dataMappingDimensionToMainEntityType.put(SCENARIO, "bcm_scenemembertree");
        dataMappingDimensionToMainEntityType.put(YEAR, "bcm_fymembertree");
        dataMappingDimensionToMainEntityType.put(PERIOD, "bcm_periodmembertree");
        dataMappingDimensionToMainEntityType.put(PROCESS, "bcm_processmembertree");
        dataMappingDimensionToMainEntityType.put(CURRENCY, "bcm_currencymembertree");
        dataMappingDimensionToMainEntityType.put(AUDITTRIAL, "bcm_audittrialmembertree");
        dataMappingDimensionToMainEntityType.put(CHANGETYPE, "bcm_changetypemembertree");
        dataMappingDimensionToMainEntityType.put(INTERNALCOMPANY, "bcm_icmembertree");
        dataMappingDimensionToMainEntityType.put(MYCOMPANY, "bcm_mycompanymembertree");
        dataMappingDimensionToMainEntityType.put(DATASORT, "bcm_datasortmembertree");
        dataMappingDimensionToMainEntityType.put(MULTIGAAP, "bcm_rulemembertree");
    }

    public static class AuditLogQueryParam {
        private final Long modelId;
        private final Long userId;
        private final Date startTime;
        private final Date endTime;
        private final String transactionTag;
        private final Set<String> entityDims;
        private final Set<String> accountDims;
        private final Set<String> scenarioDims;
        private final Set<String> yearDims;
        private final Set<String> periodDims;
        private final Set<String> processDims;
        private final Set<String> currencyDims;
        private final Set<String> auditTrailDims;
        private final Set<String> changeTypeDims;
        private final Set<String> internalCompanyDims;
        private final Set<String> dataSortDims;
        private final Set<String> multiGAAPDims;
        private final Set<String> myCompanyDims;
        private final Map<String, Set<String>> customDefinedFilters;
        private boolean isSortByTimeAsc = false;

        public Long getModelId() {
            return this.modelId;
        }

        public Long getUserId() {
            return this.userId;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public String getTransactionTag() {
            return this.transactionTag;
        }

        public Set<String> getEntityDims() {
            return this.entityDims;
        }

        public Set<String> getAccountDims() {
            return this.accountDims;
        }

        public Set<String> getScenarioDims() {
            return this.scenarioDims;
        }

        public Set<String> getYearDims() {
            return this.yearDims;
        }

        public Set<String> getPeriodDims() {
            return this.periodDims;
        }

        public Set<String> getProcessDims() {
            return this.processDims;
        }

        public Set<String> getCurrencyDims() {
            return this.currencyDims;
        }

        public Set<String> getAuditTrailDims() {
            return this.auditTrailDims;
        }

        public Set<String> getChangeTypeDims() {
            return this.changeTypeDims;
        }

        public Set<String> getInternalCompanyDims() {
            return this.internalCompanyDims;
        }

        public Set<String> getDataSortDims() {
            return this.dataSortDims;
        }

        public Set<String> getMultiGAAPDims() {
            return this.multiGAAPDims;
        }

        public Set<String> getMyCompanyDims() {
            return this.myCompanyDims;
        }

        public boolean isSortByTimeAsc() {
            return this.isSortByTimeAsc;
        }

        public Map<String, Set<String>> getCustomDefinedFilters() {
            return this.customDefinedFilters;
        }

        private AuditLogQueryParam(Builder builder) {
            this.modelId = builder.modelId;
            this.userId = builder.userId;
            this.startTime = builder.startTime;
            this.endTime = builder.endTime;
            this.transactionTag = builder.transactionTag;
            this.entityDims = builder.entityDims;
            this.accountDims = builder.accountDims;
            this.scenarioDims = builder.scenarioDims;
            this.yearDims = builder.yearDims;
            this.periodDims = builder.periodDims;
            this.processDims = builder.processDims;
            this.currencyDims = builder.currencyDims;
            this.auditTrailDims = builder.auditTrailDims;
            this.changeTypeDims = builder.changeTypeDims;
            this.internalCompanyDims = builder.internalCompanyDims;
            this.dataSortDims = builder.dataSortDims;
            this.multiGAAPDims = builder.multiGAAPDims;
            this.myCompanyDims = builder.myCompanyDims;
            this.customDefinedFilters = builder.customDefinedFilters;
            this.isSortByTimeAsc = builder.isSortByTimeAsc;
        }

        public static class Builder {
            private long modelId;
            private Long userId;
            private Date startTime;
            private Date endTime;
            private String transactionTag;
            private Set<String> entityDims;
            private Set<String> accountDims;
            private Set<String> scenarioDims;
            private Set<String> yearDims;
            private Set<String> periodDims;
            private Set<String> processDims;
            private Set<String> currencyDims;
            private Set<String> auditTrailDims;
            private Set<String> changeTypeDims;
            private Set<String> internalCompanyDims;
            private Set<String> dataSortDims;
            private Set<String> multiGAAPDims;
            private Set<String> myCompanyDims;
            private Map<String, Set<String>> customDefinedFilters = new HashMap<String, Set<String>>(2);
            private boolean isSortByTimeAsc = false;

            public Builder(long modelId, Date startTime, Date endTime) {
                if (modelId <= 0L) {
                    throw new IllegalArgumentException("param modelId is 0");
                }
                if (Objects.isNull(startTime)) {
                    throw new IllegalArgumentException("param startTime is null");
                }
                if (Objects.isNull(endTime)) {
                    throw new IllegalArgumentException("param endTime is null");
                }
                this.modelId = modelId;
                this.startTime = startTime;
                this.endTime = endTime;
            }

            public AuditLogQueryParam build() {
                return new AuditLogQueryParam(this);
            }

            public Builder setUserId(Long userId) {
                this.userId = userId;
                return this;
            }

            public void setTransactionTag(String transactionTag) {
                this.transactionTag = transactionTag;
            }

            public void setEntityDims(Set<String> entityDims) {
                this.entityDims = entityDims;
            }

            public void setAccountDims(Set<String> accountDims) {
                this.accountDims = accountDims;
            }

            public void setScenarioDims(Set<String> scenarioDims) {
                this.scenarioDims = scenarioDims;
            }

            public void setYearDims(Set<String> yearDims) {
                this.yearDims = yearDims;
            }

            public void setPeriodDims(Set<String> periodDims) {
                this.periodDims = periodDims;
            }

            public void setProcessDims(Set<String> processDims) {
                this.processDims = processDims;
            }

            public void setCurrencyDims(Set<String> currencyDims) {
                this.currencyDims = currencyDims;
            }

            public void setAuditTrailDims(Set<String> auditTrailDims) {
                this.auditTrailDims = auditTrailDims;
            }

            public void setChangeTypeDims(Set<String> changeTypeDims) {
                this.changeTypeDims = changeTypeDims;
            }

            public void setInternalCompanyDims(Set<String> internalCompanyDims) {
                this.internalCompanyDims = internalCompanyDims;
            }

            public void setDataSortDims(Set<String> dataSortDims) {
                this.dataSortDims = dataSortDims;
            }

            public void setMultiGAAPDims(Set<String> multiGAAPDims) {
                this.multiGAAPDims = multiGAAPDims;
            }

            public void setMyCompanyDims(Set<String> myCompanyDims) {
                this.myCompanyDims = myCompanyDims;
            }

            public void addCustomDims(String customDimName, Set<String> internalCompanyDims) {
                this.customDefinedFilters.put(customDimName, internalCompanyDims);
            }

            public void setIsSortByTimeAsc(boolean isSortByTimeAsc) {
                this.isSortByTimeAsc = isSortByTimeAsc;
            }
        }
    }

    public static class CurrencyConditionGrp {
        private String entityNum;
        private Set<String> processNums;
        private Set<String> currencyNums;

        public CurrencyConditionGrp(String entityNum, Set<String> processNums, Set<String> currencyNums) {
            this.entityNum = entityNum;
            this.processNums = processNums;
            this.currencyNums = currencyNums;
        }

        public String getEntityNum() {
            return this.entityNum;
        }

        public Set<String> getProcessNums() {
            return this.processNums;
        }

        public Set<String> getCurrencyNums() {
            return this.currencyNums;
        }
    }
}

