/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.log;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.log.DataPermLogModel;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;

public class DataPermLogHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DataPermLogHelper.class);
    private static final String MODEL = "model";
    private static final String USERS_NAME = "users.name";
    private static final String DMEMBER = "dmember";
    private static final String RANGE = "range";
    private static final String SELFRANGE = String.valueOf(RangeEnum.VALUE_10.getValue());
    private static final Set<String> ALLSELFRANGE = Sets.newHashSet((Object[])new String[]{SELFRANGE, String.valueOf(RangeEnum.VALUE_30.getValue()), String.valueOf(RangeEnum.VALUE_50.getValue()), String.valueOf(RangeEnum.VALUE_70.getValue()), String.valueOf(RangeEnum.VALUE_90.getValue()), String.valueOf(RangeEnum.VALUE_110.getValue())});
    private IDataModel model;
    private String bizAppId;
    private Collection<DynamicObject> oldPermMem;

    public static DynamicObject newDataPermLog(Long modelId, String dimensionNumber, String memberNumber, String memberName, String permission, String permClassNumber, String distributeObject, String operateName, String range, String userNumber, String userName, long createUserId, String clientType, String clientAddress, String appNumber) {
        DynamicObject dataPermLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datapermlog");
        dataPermLog.set("modelid", (Object)modelId);
        dataPermLog.set("dimensionnumber", (Object)dimensionNumber);
        dataPermLog.set("membernumber", (Object)memberNumber);
        dataPermLog.set("membername", (Object)memberName);
        dataPermLog.set("permission", (Object)permission);
        dataPermLog.set(RANGE, (Object)range);
        dataPermLog.set("permclassnumber", (Object)permClassNumber);
        dataPermLog.set("distributeobject", (Object)distributeObject);
        dataPermLog.set("operation", (Object)operateName);
        dataPermLog.set("usernumber", (Object)userNumber);
        dataPermLog.set("username", (Object)userName);
        dataPermLog.set("modifierid", (Object)createUserId);
        dataPermLog.set("modifytime", (Object)TimeServiceHelper.now());
        dataPermLog.set("clienttype", (Object)clientType);
        dataPermLog.set("clientaddress", (Object)clientAddress);
        dataPermLog.set("appnumber", (Object)appNumber);
        return dataPermLog;
    }

    public static DynamicObject newMemberPermLog(Long modelId, String dimensionNumber, String memberNumber, String memberName, String permission, String distributeObject, String operateName, String range, String userNumber, String userName, String clientType, String clientAddress, String appNumber) {
        return DataPermLogHelper.newDataPermLog(modelId, dimensionNumber, memberNumber, memberName, permission, null, distributeObject, operateName, range, userNumber, userName, RequestContext.get().getCurrUserId(), clientType, clientAddress, appNumber);
    }

    public static DynamicObject newMemberPermLog(DynamicObject dt, String operateName, String appNumber) {
        return DataPermLogHelper.newDataPermLog(dt.getLong("model.id"), dt.getString("dimension.number"), dt.getString("member.number"), dt.getString("member.name"), dt.getString("permission"), null, null, operateName, dt.getString(RANGE), dt.getString("users.number"), dt.getString(USERS_NAME), RequestContext.get().getCurrUserId(), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), appNumber);
    }

    public static DynamicObject newMemberPermLog(DynamicObject memberPerm, DynamicObject appendProperty, String operateName, String appNumber) {
        return DataPermLogHelper.newMemberPermLog(memberPerm.getLong(MODEL), appendProperty.getString("dimensionnumber"), appendProperty.getString("membernumber"), appendProperty.getString("membername"), memberPerm.getString("permission"), null, operateName, memberPerm.getString(RANGE), appendProperty.getString("usernumber"), appendProperty.getString("username"), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), appNumber);
    }

    public static DynamicObject newDataPermControlLog(Long modelId, String permission, String permClassNumber, String operateName, String userNumber, String userName, String appNumber) {
        return DataPermLogHelper.newDataPermLog(modelId, null, null, null, permission, permClassNumber, null, operateName, null, userNumber, userName, RequestContext.get().getCurrUserId(), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), appNumber);
    }

    public static DynamicObject newPermClassControlLog(Long modelId, String permClassNumber, String operateName, String appNumber) {
        return DataPermLogHelper.newDataPermLog(modelId, null, null, null, null, permClassNumber, null, operateName, null, null, null, RequestContext.get().getCurrUserId(), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), appNumber);
    }

    public static DynamicObject newPermClassDistributeLog(Long modelId, String dimensionNumber, String memberNumber, String memberName, String permClassNumber, String distributeObject, String operateName, String appNumber) {
        return DataPermLogHelper.newDataPermLog(modelId, dimensionNumber, memberNumber, memberName, null, permClassNumber, distributeObject, operateName, null, null, null, RequestContext.get().getCurrUserId(), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), appNumber);
    }

    public static DynamicObject newDataPermLog(DataPermLogModel dataPermLogModel) {
        DynamicObject dataPermLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datapermlog");
        dataPermLog.set("modelid", (Object)dataPermLogModel.getModelId());
        dataPermLog.set("dimensionnumber", (Object)dataPermLogModel.getDimensionNumber());
        dataPermLog.set("membernumber", (Object)dataPermLogModel.getMemberNumber());
        dataPermLog.set("membername", (Object)dataPermLogModel.getMemberName());
        dataPermLog.set("permission", (Object)dataPermLogModel.getPermission());
        dataPermLog.set(RANGE, (Object)dataPermLogModel.getRange());
        dataPermLog.set("permclassnumber", (Object)dataPermLogModel.getPermClassNumber());
        dataPermLog.set("distributeobject", (Object)dataPermLogModel.getDistributeObject());
        dataPermLog.set("operation", (Object)dataPermLogModel.getOperation());
        dataPermLog.set("usernumber", (Object)dataPermLogModel.getUserNumber());
        dataPermLog.set("username", (Object)dataPermLogModel.getUserName());
        dataPermLog.set("modifierid", (Object)RequestContext.get().getCurrUserId());
        dataPermLog.set("modifytime", (Object)TimeServiceHelper.now());
        dataPermLog.set("clienttype", (Object)RequestContext.get().getClient());
        dataPermLog.set("clientaddress", (Object)RequestContext.get().getLoginIP());
        dataPermLog.set("appnumber", (Object)dataPermLogModel.getAppNumber());
        return dataPermLog;
    }

    public static void batchInsertDataPermLog(List<DynamicObject> logs) {
        if (logs.size() > 0) {
            DynamicObjectType objectType = logs.get(0).getDynamicObjectType();
            int batchSize = 999;
            if (logs.size() < batchSize) {
                BusinessDataWriter.save((IDataEntityType)objectType, (Object[])logs.toArray(new DynamicObject[0]));
            } else {
                ArrayList<DynamicObject> batch = new ArrayList<DynamicObject>(batchSize);
                for (DynamicObject log : logs) {
                    batch.add(log);
                    if (batch.size() < batchSize) continue;
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
                if (!batch.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
            }
        }
    }

    public static void saveDataPermissionLogs(Long modelId, String number, DynamicObject permClass, DynamicObject dynamicObject, DataPermLogMultiLangEnum dataPermLogMultiLangEnum, WatchLogger log, String bizAppId) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(1);
        try {
            String operateName = null;
            String permClassNumber = null;
            if (dynamicObject == null && permClass != null) {
                operateName = DataPermLogMultiLangEnum.PermCLASS_Distribute_AddNew.getOperateName();
                permClassNumber = permClass.getString("number");
            } else if (permClass == null && dynamicObject != null) {
                operateName = DataPermLogMultiLangEnum.PermCLASS_Distribute_DELETE.getOperateName();
                permClassNumber = dynamicObject.getString("permclass.number");
            } else if (dynamicObject != null && permClass != null && !permClass.getString("number").equals(dynamicObject.getString("permclass.number"))) {
                operateName = DataPermLogMultiLangEnum.PermCLASS_Distribute_MODIFY.getOperateName();
                permClassNumber = permClass.getString("number");
            }
            if (operateName != null) {
                DynamicObject permLog = DataPermLogHelper.newPermClassDistributeLog(modelId, null, null, null, permClassNumber, dataPermLogMultiLangEnum.getOperateName() + "_" + number, operateName, bizAppId);
                logs.add(permLog);
                if (logs.size() > 0) {
                    DataPermLogHelper.batchInsertDataPermLog(logs);
                }
            }
        }
        catch (KDException e) {
            log.error((Throwable)e);
        }
    }

    public DataPermLogHelper(IDataModel model, String bizAppId) {
        try {
            this.bizAppId = bizAppId;
            this.model = model;
            this.initOldPermMem();
        }
        catch (KDException e) {
            log.error(e.getMessage());
        }
    }

    private void initOldPermMem() {
        Tuple<Long, Long, String> modelDim = this.getModelDim(Boolean.TRUE);
        QFBuilder qfBuilder = new QFBuilder("model.id", "=", modelDim.p1);
        qfBuilder.add("dimension.id", "=", modelDim.p2);
        qfBuilder.add("member.id", "=", this.model.getValue("id"));
        qfBuilder.add("membertype", "=", (Object)this.model.getDataEntityType().getName());
        qfBuilder.add(RANGE, "in", ALLSELFRANGE);
        this.oldPermMem = BusinessDataServiceHelper.loadFromCache((String)"bcm_memberperm", (String)"users.id,usertype,users.number,users.name,permission,range", (QFilter[])qfBuilder.toArray()).values();
    }

    public void memPermLog(String entityId) {
        try {
            DynamicObject dataEntity = this.model.getDataEntity();
            DynamicObjectCollection newPermMem = dataEntity.getDynamicObjectCollection(entityId);
            long memId = ConvertUtil.convertObjToLong(this.model.getValue("id"));
            ArrayList logs = Lists.newArrayListWithExpectedSize((int)(this.oldPermMem.size() + newPermMem.size()));
            if (!DataEntityUtils.isIncludeShareField((String)dataEntity.getDataEntityType().getName()) || !StorageTypeEnum.isShare((String)dataEntity.getString("storagetype"))) {
                newPermMem.stream().filter(pPM -> Objects.equals(pPM.getLong(DMEMBER), 0L) || Objects.equals(memId, pPM.getLong(DMEMBER))).forEach(pPM -> logs.add(this.buildLog((DynamicObject)pPM, Boolean.TRUE)));
            }
            this.oldPermMem.forEach(pM -> logs.add(this.buildLog((DynamicObject)pM, Boolean.FALSE)));
            if (CollectionUtils.isNotEmpty((Collection)logs)) {
                DataPermLogHelper.batchInsertDataPermLog(logs);
            }
        }
        catch (KDException e) {
            log.error(e.getMessage());
        }
    }

    private Tuple<Long, Long, String> getModelDim(boolean isDimId) {
        DynamicObject dataEntity = this.model.getDataEntity();
        DynamicObject dimension = dataEntity.getDynamicObject("dimension");
        return Tuple.create((Object)dataEntity.getDynamicObject(MODEL).getLong("id"), (Object)(isDimId ? Long.valueOf(dimension.getLong("id")) : null), isDimId ? null : dimension.getString("number"));
    }

    private DynamicObject buildLog(DynamicObject pM, boolean isDstrbt) {
        Tuple<Long, Long, String> modelDim = this.getModelDim(Boolean.FALSE);
        long modelId = (Long)modelDim.p1;
        return DataPermLogHelper.newMemberPermLog(modelId, (String)modelDim.p3, this.model.getValue("number").toString(), this.model.getValue("name").toString(), pM.getString("permission"), null, isDstrbt ? DataPermLogMultiLangEnum.MemberPerm_Distribute.getOperateName() : DataPermLogMultiLangEnum.MemberPerm_DelDistribute.getOperateName(), isDstrbt ? SELFRANGE : pM.getString(RANGE), pM.getString("users.number"), pM.getString(USERS_NAME), RequestContext.get().getClient(), RequestContext.get().getLoginIP(), this.bizAppId);
    }
}

