/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.log;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ErrorLogServiceHelper {
    private static final String BCM_ERROR_LOG = "bcm_error_log";
    private static final Log logger = LogFactory.getLog(ErrorLogServiceHelper.class);

    private ErrorLogServiceHelper() {
    }

    public static void saveErrorLog(Long modelId, String bizType, String command, String message) {
        StringBuilder text = new StringBuilder();
        text.append("command:").append(command).append("\n");
        text.append("message:").append(message);
        ErrorLogServiceHelper.saveErrorLog(modelId, bizType, text.toString());
    }

    public static void saveErrorLog(Long modelId, String bizType, String message) {
        try (TXHandle tx = TX.requiresNew((String)BCM_ERROR_LOG);){
            try {
                DynamicObject errorLog = BusinessDataServiceHelper.newDynamicObject((String)BCM_ERROR_LOG);
                errorLog.set("model", (Object)modelId);
                errorLog.set("biztype", (Object)bizType);
                errorLog.set("traceid", (Object)RequestContext.get().getTraceId());
                errorLog.set("message", (Object)message);
                errorLog.set("createtime", (Object)TimeServiceHelper.now());
                errorLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{errorLog});
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                tx.markRollback();
            }
        }
    }
}

