/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.log;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.log.AuditLogESHelper;
import kd.fi.bcm.common.Page;
import kd.fi.bcm.common.auditlog.AuditLogESIndexStrategy;
import kd.fi.bcm.common.auditlog.ESClient;
import kd.fi.bcm.common.auditlog.ESDateUtils;
import kd.fi.bcm.common.auditlog.TransactionLogBill;
import kd.fi.bcm.fel.common.ArrayUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class TransactionLogESHelper {
    private static final Log LOG = LogFactory.getLog(TransactionLogESHelper.class);
    public static final String FIELD_FORMID = "formId";
    private static final String DATA_INDEX_DATE_FIELD = "startTime";

    public static Page<TransactionLogBill> search(long modelId, TransactionLogQueryParam queryParam, Integer page, Integer pageSize) {
        if (queryParam == null) {
            throw new IllegalArgumentException("param 'queryParam' is null");
        }
        if (page == null) {
            throw new IllegalArgumentException("param 'page' is null");
        }
        if (pageSize == null) {
            throw new IllegalArgumentException("param 'pageSize' is null");
        }
        DynamicObject modelDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray());
        String modelCubeId = modelDy.getString("number");
        long summarySearchTick = System.currentTimeMillis();
        SearchSourceBuilder summarySearchBuilder = TransactionLogESHelper.buildAuditSummarySearch(queryParam, pageSize);
        summarySearchBuilder.timeout(TimeValue.timeValueSeconds((long)3L));
        SearchHits oplog = TransactionLogESHelper.doQuery(AuditLogESIndexStrategy.decideSearchIndexName((String)modelCubeId, (AuditLogESIndexStrategy.AuditLogIndexType)AuditLogESIndexStrategy.AuditLogIndexType.oplog, (Date)queryParam.getStartTime(), (Date)queryParam.getEndTime()), summarySearchBuilder);
        LOG.info("audit_log_search_summary cost time: " + (System.currentTimeMillis() - summarySearchTick));
        if (oplog.getTotalHits() == 0L) {
            return new Page((long)page.intValue(), (long)pageSize.intValue(), 0L);
        }
        LinkedHashMap<String, Map<String, Object>> eventIdSummaryDocDict = new LinkedHashMap<String, Map<String, Object>>(1000);
        List<TransactionLogBill> billList = TransactionLogESHelper.convertAuditLogToBill(modelDy.getLong("id"), oplog.getHits(), eventIdSummaryDocDict);
        Page pageResult = new Page((long)page.intValue(), (long)pageSize.intValue(), oplog.getTotalHits());
        pageResult.setRecords(billList);
        return pageResult;
    }

    private static SearchSourceBuilder buildAuditSummarySearch(TransactionLogQueryParam qp, int pageSize) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder conditionBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(DATA_INDEX_DATE_FIELD);
        rangeQueryBuilder.from((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getStartTime()));
        rangeQueryBuilder.to((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getEndTime()));
        conditionBuilder.filter((QueryBuilder)rangeQueryBuilder);
        if (Objects.nonNull(qp.getUserId())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"opUserId", (Object)qp.getUserId()));
        }
        if (Objects.nonNull(qp.getTransactionType())) {
            conditionBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"opCategory", (String)qp.getTransactionType()));
        }
        searchSourceBuilder.sort(DATA_INDEX_DATE_FIELD, qp.isSortByTimeAsc ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.query((QueryBuilder)conditionBuilder);
        searchSourceBuilder.from(0);
        searchSourceBuilder.size(pageSize);
        return searchSourceBuilder;
    }

    private static SearchHits doQuery(String indexName, SearchSourceBuilder sourceBuilder) {
        try {
            SearchRequest request = new SearchRequest(new String[]{indexName});
            request.source(sourceBuilder);
            request.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
            SearchResponse search = ESClient.getESClient().search(request, AuditLogESHelper.DEFAULT_REQUEST_OPTIONS);
            return search.getHits();
        }
        catch (IOException e) {
            LOG.error(String.format("failed to execute ES query, index: %s, queryBuilder: %s", indexName, sourceBuilder.toString()), (Throwable)e);
            throw new KDBizException(ESClient.getErrorCode(), new Object[]{e});
        }
        catch (Exception e) {
            throw new KDBizException(ESClient.getErrorCode(), new Object[]{e});
        }
    }

    public static List<Map<String, Object>> convertHits(SearchHit[] hits) {
        if (ArrayUtils.isEmpty((Object[])hits)) {
            return Collections.emptyList();
        }
        ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
        return Arrays.stream(hits).map(hit -> {
            try {
                return (Map)objectMapper.readValue(hit.getSourceAsString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new KDBizException(ESClient.getErrorCode(), new Object[]{"failed to parse string to map:" + hit.getSourceAsString()});
            }
        }).collect(Collectors.toList());
    }

    private static SearchSourceBuilder buildAuditDataSearch(Set<String> filterEventIds, TransactionLogQueryParam qp) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder conditionBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(DATA_INDEX_DATE_FIELD);
        rangeQueryBuilder.from((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getStartTime()));
        rangeQueryBuilder.to((Object)ESDateUtils.formatUTCDateFormat((Date)qp.getEndTime()));
        conditionBuilder.filter((QueryBuilder)rangeQueryBuilder);
        searchSourceBuilder.sort(DATA_INDEX_DATE_FIELD, qp.isSortByTimeAsc ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.query((QueryBuilder)conditionBuilder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("transaction_log_query condition:" + conditionBuilder.toString());
        }
        return searchSourceBuilder;
    }

    private static List<TransactionLogBill> convertAuditLogToBill(long modelId, SearchHit[] hits, Map<String, Map<String, Object>> eventIdSummaryDocDict) {
        List<Map<String, Object>> dataDocs = TransactionLogESHelper.convertHits(hits);
        ArrayList data = Lists.newArrayListWithCapacity((int)dataDocs.size());
        if (dataDocs.size() > 0) {
            for (int i = 0; i < dataDocs.size(); ++i) {
                Map<String, Object> dataMap = dataDocs.get(i);
                String userIp = (String)dataMap.get("userIP");
                Integer operationType = (Integer)dataMap.get("opCategory");
                String operation = (String)dataMap.get("subSourceKey");
                String status = (String)dataMap.get("status");
                BigDecimal result = null;
                if (null != dataMap.get("cost")) {
                    BigDecimal costTime = new BigDecimal(dataMap.get("cost") + "");
                    BigDecimal bigDecimal = new BigDecimal("1000");
                    result = costTime.divide(bigDecimal);
                }
                TransactionLogBill transactionLogBill = null;
                transactionLogBill = null != dataMap.get("endTime") ? new TransactionLogBill(BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(String.valueOf(dataMap.get("opUserId"))), (String)"bos_user"), userIp, operationType, operation, ESDateUtils.parseUTCDate((String)String.valueOf(dataMap.get(DATA_INDEX_DATE_FIELD))), ESDateUtils.parseUTCDate((String)String.valueOf(dataMap.get("endTime"))), result, status) : new TransactionLogBill(BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf((String)dataMap.get("opUserId")), (String)"bos_user"), userIp, operationType, operation, ESDateUtils.parseUTCDate((String)String.valueOf(dataMap.get(DATA_INDEX_DATE_FIELD))), result, status);
                data.add(transactionLogBill);
            }
            return data;
        }
        return data;
    }

    public static class TransactionLogQueryParam {
        private final Long modelId;
        private final Long userId;
        private final String transactionType;
        private final Date startTime;
        private final Date endTime;
        private boolean isSortByTimeAsc = false;

        public TransactionLogQueryParam(Builder builder) {
            this.modelId = builder.modelId;
            this.userId = builder.userId;
            this.transactionType = builder.transactionType;
            this.startTime = builder.startTime;
            this.endTime = builder.endTime;
        }

        public Long getModelId() {
            return this.modelId;
        }

        public Long getUserId() {
            return this.userId;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public String getTransactionType() {
            return this.transactionType;
        }

        public static class Builder {
            private long modelId;
            private Long userId;
            private String transactionType;
            private Date startTime;
            private Date endTime;

            public Builder(long modelId, Date startTime, Date endTime) {
                if (modelId <= 0L) {
                    throw new IllegalArgumentException("param modelId is 0");
                }
                if (Objects.isNull(startTime)) {
                    throw new IllegalArgumentException("param startTime is null");
                }
                if (Objects.isNull(endTime)) {
                    throw new IllegalArgumentException("param endTime is null");
                }
                this.modelId = modelId;
                this.startTime = startTime;
                this.endTime = endTime;
            }

            public TransactionLogQueryParam build() {
                return new TransactionLogQueryParam(this);
            }

            public Builder setModelId(long modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder setUserId(Long userId) {
                this.userId = userId;
                return this;
            }

            public Builder setTransactionType(String transactionType) {
                this.transactionType = transactionType;
                return this;
            }

            public Builder setStartTime(Date startTime) {
                this.startTime = startTime;
                return this;
            }

            public Builder setEndTime(Date endTime) {
                this.endTime = endTime;
                return this;
            }
        }
    }
}

