/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.member;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class MemberListUtil {
    public static QFilter buildFilter(Object modelId, String entityName, Object scope) {
        QFBuilder modelBuilder = new QFBuilder("modelid", "=", (Object)LongUtil.toLong((Object)modelId));
        modelBuilder.add("membscope", "=", (Object)LongUtil.toLong((Object)scope));
        DynamicObject one = BusinessDataServiceHelper.loadSingle((String)"bcm_memberlist", (String)"id,modelid,dimensionid,membscope,bcmstaticlist.memberid,bcmdynamiclist.member,bcmdynamiclist.base,bcmdynamiclist.range,bcmdynamiclist.formula_tag", (QFilter[])modelBuilder.toArray());
        if (Integer.parseInt(one.getString("membscope")) < 20000) {
            DynamicObjectCollection colls = one.getDynamicObjectCollection("bcmstaticlist");
            HashSet ids = new HashSet();
            colls.forEach(col -> ids.add(col.getLong("memberid")));
            return new QFilter("id", "in", ids);
        }
        DynamicObjectCollection colls = one.getDynamicObjectCollection("bcmdynamiclist");
        QFilter range = null;
        int index = 0;
        String gridFormula = "";
        for (DynamicObject coll : colls) {
            long base = coll.getLong("base");
            QFilter temp = null;
            if (base == 0L && StringUtils.isEmpty((CharSequence)coll.getString("member"))) {
                if (StringUtils.isNotEmpty((CharSequence)coll.getString("formula_tag"))) {
                    String data = coll.getString("formula_tag");
                    CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)data, CRCondition.class);
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
                    FilterBuilder filterBuilder = new FilterBuilder(type, condition.getFilterCondition());
                    filterBuilder.buildFilter(true);
                    gridFormula = MemberListUtil.replaceIllegalStatement(filterBuilder.getQFilter().toString());
                    String handFormula = MemberListUtil.replaceFunctions(condition.getExpression());
                    temp = QFilter.of((String)MemberListUtil.joinFilter(gridFormula, handFormula), (Object[])new Object[0]).and("dimension", "=", (Object)one.getLong("dimensionid.id"));
                }
            } else if (StringUtils.isNotEmpty((CharSequence)coll.getString("member"))) {
                Set<Object> bases;
                if (base == 0L) {
                    bases = MemberListUtil.getBaseRange(entityName, ConvertUtil.convertStrToLong(coll.getString("member")), coll.getInt("range"), one.getLong("modelid.id"));
                    temp = new QFilter("id", "in", bases);
                } else {
                    bases = MemberListUtil.getBaseRange(entityName, base, coll.getInt("range"), one.getLong("modelid.id"));
                    if (bases.size() > 0) {
                        temp = new QFilter("id", "in", bases);
                        if (StringUtils.isNotEmpty((CharSequence)coll.getString("formula_tag"))) {
                            String data = coll.getString("formula_tag");
                            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)data, CRCondition.class);
                            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
                            FilterBuilder filterBuilder = new FilterBuilder(type, condition.getFilterCondition());
                            filterBuilder.buildFilter(true);
                            filterBuilder.buildFilter(true);
                            gridFormula = MemberListUtil.replaceIllegalStatement(filterBuilder.getQFilter().toString());
                            String handFormula = MemberListUtil.replaceFunctions(condition.getExpression());
                            handFormula = handFormula.replaceAll("isBase", "storagetype != 3");
                            temp.and(QFilter.of((String)MemberListUtil.joinFilter(gridFormula, handFormula), (Object[])new Object[0]));
                        }
                    }
                }
            }
            if (index == 0) {
                if (temp != null) {
                    range = temp.copy();
                }
            } else if (temp != null && range != null) {
                range.or(temp);
            }
            ++index;
        }
        return range;
    }

    private static String replaceFunctions(String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return expression;
        }
        expression = expression.replaceAll("isBase", "storagetype != 3");
        return expression;
    }

    private static Set<Object> getBaseRange(String entityName, long base, int range, Object modelId) {
        HashSet<Object> allIds = new HashSet<Object>();
        IDNumberTreeNode member = MemberReader.findMemberById((long)ConvertUtil.convertObjToLong(modelId), (String)entityName, (Long)base);
        if (range < RangeEnum.VALUE_20000.getValue()) {
            new MembRangeItem(entityName, (Long)base, member.getNumber(), range, false, modelId).matchItems(v -> allIds.add(v.id));
        }
        return allIds;
    }

    private static String joinFilter(String filter1, String filter2) {
        if (StringUtils.isBlank((CharSequence)filter1)) {
            return filter2;
        }
        return StringUtils.isBlank((CharSequence)filter2) ? filter1 : String.format("(%s) and (%s)", filter1, filter2);
    }

    public static String replaceIllegalStatement(String rawFormula) {
        if (StringUtils.isEmpty((CharSequence)rawFormula)) {
            return rawFormula;
        }
        rawFormula = rawFormula.replaceAll(" = 'EMPTY'", " is null");
        rawFormula = rawFormula.replaceAll("!= NULL", "is not null");
        rawFormula = rawFormula.replaceAll("= true ", "= 1");
        rawFormula = rawFormula.replaceAll("= false ", "= 0");
        return rawFormula;
    }

    public static List<Long> getMemberList(Object modelId, Long dimensionId, Object scope) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter idFilter = new QFilter("dimensionid", "=", (Object)dimensionId);
        QFilter fmembscope = new QFilter("membscope", "=", scope);
        QFilter modelFilter = new QFilter("modelid", "=", modelId);
        QFilter[] filters = new QFilter[]{idFilter, fmembscope, modelFilter};
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_memberlist", (String)"id,name,number,dimensionid.membermodel,membscope,bcmstaticlist.memberid", (QFilter[])filters);
        if (members.size() > 0) {
            String entityName = ((DynamicObject)members.get(0)).getString("dimensionid.membermodel");
            Integer tempScope = ((DynamicObject)members.get(0)).getInt("membscope");
            if (tempScope >= 20000) {
                QFilter range = MemberListUtil.buildFilter(modelId, entityName, scope);
                DynamicObjectCollection list = QueryServiceHelper.query((String)entityName, (String)"id,number,name", (QFilter[])range.toArray());
                list.forEach(val -> ids.add(val.getLong("id")));
            } else if (tempScope >= 10000) {
                for (DynamicObject dy : members) {
                    ids.add(dy.getLong("bcmstaticlist.memberid"));
                }
            }
        }
        return ids;
    }
}

