/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bcm.business.allinone.model.TreeMapVO;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;

public class AdjustShareDimRangeParse {
    private Multimap<Long, AdjustSettingVO> adjustSettingGroup = ArrayListMultimap.create();
    private DynamicObjectCollection adjustDataDC;
    private DynamicObjectCollection adjustSettingDataDC;
    private DynamicObjectCollection allSourceEntityDC;
    private DynamicObjectCollection allShareOrgDC;
    private List<TreeMapVO> adjBelongOrgVOs;

    public static AdjustShareDimRangeParse getInstance(DynamicObjectCollection dynCollection, DynamicObjectCollection reportAdjustDC, Multimap<Long, Long> member2orgIdMapping) {
        AdjustShareDimRangeParse parse = new AdjustShareDimRangeParse();
        parse.adjustDataDC = reportAdjustDC;
        parse.adjustSettingDataDC = dynCollection;
        parse.init();
        return parse;
    }

    public static AdjustShareDimRangeParse getInstance(DynamicObjectCollection dynCollection, DynamicObjectCollection reportAdjustDC, Multimap<Long, Long> member2orgIdMapping, List<TreeMapVO> adjBelongOrgVOs) {
        AdjustShareDimRangeParse parse = new AdjustShareDimRangeParse();
        parse.adjustDataDC = reportAdjustDC;
        parse.adjustSettingDataDC = dynCollection;
        parse.adjBelongOrgVOs = adjBelongOrgVOs;
        parse.init();
        return parse;
    }

    public List<TreeMapVO> getAdjBelongOrgVOs() {
        return this.adjBelongOrgVOs;
    }

    public void setAdjBelongOrgVOs(List<TreeMapVO> adjBelongOrgVOs) {
        this.adjBelongOrgVOs = adjBelongOrgVOs;
    }

    public DynamicObjectCollection getAllSourceEntityDC() {
        return this.allSourceEntityDC;
    }

    public void setAllSourceEntityDC(DynamicObjectCollection allSourceEntityDC) {
        this.allSourceEntityDC = allSourceEntityDC;
    }

    public DynamicObjectCollection getAllShareOrgDC() {
        return this.allShareOrgDC;
    }

    public void setAllShareOrgDC(DynamicObjectCollection allShareOrgDC) {
        this.allShareOrgDC = allShareOrgDC;
    }

    private void init() {
        if (this.adjustSettingDataDC != null) {
            this.adjustSettingDataDC.forEach(row -> {
                for (TreeMapVO adjBelongOrgVO : this.adjBelongOrgVOs) {
                    AdjustSettingVO vo = new AdjustSettingVO();
                    vo.sourceId = adjBelongOrgVO.getSourceId();
                    vo.shareId = row.getLong("shareorg");
                    HashSet businessType = Sets.newHashSet();
                    Stream.of(row.getString("businesstype").split(",")).forEach(v -> {
                        BusinessTypeEnum temp = BusinessTypeEnum.indexOf((String)v);
                        if (temp != null) {
                            businessType.add(temp.getName());
                        }
                    });
                    vo.businessType = businessType;
                    vo.journalType = Sets.newHashSet((Object[])row.getString("journaltype").split(","));
                    vo.audittrail = Sets.newHashSet((Object[])row.getString("audittrail").split(","));
                    this.addDimRangeVo((DynamicObject)row, vo, "scenario");
                    this.addDimRangeVo((DynamicObject)row, vo, "year");
                    this.addDimRangeVo((DynamicObject)row, vo, "period");
                    this.adjustSettingGroup.put((Object)vo.sourceId, (Object)vo);
                }
            });
        }
    }

    public void addDimRangeVo(DynamicObject row, AdjustSettingVO vo, String ele) {
        String json;
        String[] split = row.getString(ele).split("#");
        if (split.length > 1 && StringUtils.isNotEmpty((CharSequence)(json = split[1]))) {
            List temp = SerializationUtils.fromJsonStringToList((String)json, DimRangeVO.class);
            temp.forEach(t -> {
                t.setModelId(row.getString("model"));
                vo.DimRangeMap.put((Object)ele, t);
            });
        }
    }

    public Multimap<Long, Long> findValideAdjust2OrgMapping() {
        TreeMultimap result = TreeMultimap.create();
        if (this.adjustDataDC != null) {
            this.adjustDataDC.forEach(arg_0 -> this.lambda$findValideAdjust2OrgMapping$3((Multimap)result, arg_0));
        }
        return result;
    }

    private /* synthetic */ void lambda$findValideAdjust2OrgMapping$3(Multimap result, DynamicObject row) {
        for (AdjustSettingVO value : this.adjustSettingGroup.values()) {
            result.put((Object)row.getLong("id"), (Object)value.shareId);
        }
    }

    public static class DimRangeVO {
        private String entity;
        private int scope;
        private long memberid;
        private String name;
        private String number;
        private String modelId;
        private boolean isCustom;
        private Set<Long> rangeIds = null;

        public boolean inRange(Long id) {
            if (this.rangeIds == null) {
                this.init();
            }
            return this.rangeIds.contains(id);
        }

        private void init() {
            this.rangeIds = Sets.newHashSet();
            if (this.isCustom) {
                this.rangeIds.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange(this.entity, this.memberid, this.number, this.scope, this.modelId, DetailTypeEnum.OTHERS));
            } else {
                this.rangeIds.addAll(QueryMemberDetailsHelper.queryMemberIdsMapByRange(this.entity, this.memberid, this.scope, this.modelId, DetailTypeEnum.OTHERS).keySet());
            }
        }

        public String getEntity() {
            return this.entity;
        }

        public void setEntity(String entity) {
            this.entity = entity;
        }

        public int getScope() {
            return this.scope;
        }

        public void setScope(int scope) {
            this.scope = scope;
        }

        public long getMemberid() {
            return this.memberid;
        }

        public void setMemberid(long memberid) {
            this.memberid = memberid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public boolean isCustom() {
            return this.isCustom;
        }

        public void setCustom(boolean isCustom) {
            this.isCustom = isCustom;
        }

        public String getModelId() {
            return this.modelId;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }
    }

    private static class AdjustSettingVO {
        private Long sourceId;
        private Long shareId;
        private Set<String> businessType;
        private Set<String> journalType;
        private Set<String> audittrail;
        private Multimap<String, DimRangeVO> DimRangeMap = ArrayListMultimap.create();

        private AdjustSettingVO() {
        }

        public Set<String> getBusinessType() {
            return this.businessType;
        }

        public Set<String> getJournalType() {
            return this.journalType;
        }

        public Set<String> getAudittrail() {
            return this.audittrail;
        }
    }
}

