/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.mergecontrol.MergeEntityService;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.sql.MDDataChecker;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class MergeControlHelper {
    private static final MergeControlService mergeService = MergeControlService.getInstance();
    private static final MergeEntityService meService = MergeEntityService.getInstance();
    static final Set<String> NOT_MERGE_PROCESSES = Sets.newHashSet((Object[])new String[]{"CCTotal", "CC", "PRPT", "ARPT"});

    public static boolean isQuoteScene(Long modelId, Long scenarioId) {
        return meService.isQuoteScene(modelId, scenarioId);
    }

    public static long getSrcScene(Long modelId, Long scenarioId) {
        return meService.getSrcScene(modelId, scenarioId);
    }

    public static boolean isQuoteLocked(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        return meService.isQuoteScene(modelId, scenarioId) && !MergeControlHelper.isVersionedOrg(modelId, scenarioId, yearId, periodId, orgId);
    }

    public static boolean isVersionedOrg(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
            return true;
        }
        Set<String> versionedOrgs = MergeControlHelper.getAllVersionedOrgs(modelId, scenarioId, yearId, periodId);
        if (versionedOrgs.isEmpty()) {
            return false;
        }
        return versionedOrgs.contains(orgNode.getNumber());
    }

    public static Set<String> getAllVersionedOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        return (Set)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)meService.packKey(modelId, scenarioId, yearId, periodId), () -> meService.getAllVersionedOrgs(modelId, scenarioId, yearId, periodId));
    }

    public static Map<String, Boolean> getIfMergeMapByParentOrgId(Long modelId, Long scenarioId, String yearNum, Long periodId, Long parentOrgId) {
        String cacheKey = String.format("%s_%s_%s_%s_%s_%s", "queryDirectSubIdMerge", modelId, scenarioId, yearNum, periodId, parentOrgId);
        return (Map)GlobalCacheServiceHelper.getOrLoadNode((String)cacheKey, () -> {
            IDNumberTreeNode parentOrgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)parentOrgId);
            HashMap<String, Boolean> isMerge = new HashMap<String, Boolean>(16);
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            qf.add("scenario", "=", (Object)scenarioId);
            qf.add("year.number", "=", (Object)yearNum);
            qf.add("period", "=", (Object)periodId);
            qf.add("orgpnumber", "=", (Object)parentOrgNode.getNumber());
            DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orgnumber, ismerge", (QFilter[])qf.toArray());
            if (data.isEmpty()) {
                StorageTypeEnum storageType = parentOrgNode.getBaseTreeNode().getStorageType();
                boolean isLabel = storageType == StorageTypeEnum.LABEL;
                List children = MemberReader.findEntityMemberById((Long)LongUtil.toLong((Object)modelId), (Long)parentOrgId).getChildren();
                for (IDNumberTreeNode orgNode : children) {
                    isMerge.put(orgNode.getNumber(), !isLabel);
                }
            } else {
                data.forEach(d -> isMerge.put(d.getString("orgnumber"), d.getBoolean("ismerge")));
            }
            return isMerge;
        });
    }

    public static HashMultimap<String, Pair<String, String>> getCancelMergeDataByModel(long modelId, long scenarioId, long yearId, long periodId) {
        String cacheKey = Joiner.on((String)"|").join((Object)"notmerg-", (Object)modelId, new Object[]{scenarioId, yearId, periodId});
        return (HashMultimap)GlobalCacheServiceHelper.getOrLoadNode((String)cacheKey, () -> {
            HashMultimap notMergeMap = HashMultimap.create();
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)modelId);
            qf.add("scenario", "=", (Object)scenarioId);
            qf.add("year", "=", (Object)yearId);
            qf.add("period", "=", (Object)periodId);
            DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orgnumber,orgpnumber, ismerge", (QFilter[])qf.toArray());
            HashSet mergeSet = new HashSet();
            data.forEach(d -> {
                if (d.getBoolean("ismerge")) {
                    mergeSet.add(d.getString("orgpnumber") + "_" + d.getString("orgnumber"));
                } else {
                    notMergeMap.put((Object)d.getString("orgnumber"), (Object)Pair.onePair((Object)d.getString("orgnumber"), (Object)d.getString("orgpnumber")));
                }
            });
            MemberReader.findMemberByConsumer((String)MemberReader.findModelNumberById((Object)modelId), (String)PresetConstant.ENTITY_DIM, node -> {
                if (IDNumberTreeNode.NotFoundTreeNode != node && !"Entity".equals(node.getNumber()) && node.getStorageType() == StorageTypeEnum.LABEL) {
                    node.getChildren().forEach(c -> {
                        if (!mergeSet.contains(c.getVirtualEntityForSearch())) {
                            notMergeMap.put((Object)c.getNumber(), (Object)Pair.onePair((Object)c.getNumber(), (Object)c.getParent().getNumber()));
                        }
                    });
                }
            });
            return notMergeMap;
        });
    }

    public static boolean isValidateMDData(String modelNum, kd.fi.bcm.business.sql.Row row, MDDataChecker checker) {
        String process = checker.getOrDefault(PresetConstant.PROCESS_DIM, row.getString(PresetConstant.PROCESS_DIM));
        String entity = checker.getOrDefault(PresetConstant.ENTITY_DIM, row.getString(PresetConstant.ENTITY_DIM));
        String fy = checker.getOrDefault(PresetConstant.FY_DIM, row.getString(PresetConstant.FY_DIM));
        if (StringUtils.isEmpty((CharSequence)process) || StringUtils.isEmpty((CharSequence)entity) || StringUtils.isEmpty((CharSequence)fy)) {
            return true;
        }
        if (!(OrgRelaProcessMembPool.isRelaProcess((String)process) && entity.contains("_") || !OrgRelaProcessMembPool.isRelaProcess((String)process) && !entity.contains("_") || !checker.isCheckPar_Son())) {
            return false;
        }
        if (!NOT_MERGE_PROCESSES.contains(process)) {
            return true;
        }
        if (!entity.contains("_")) {
            return true;
        }
        String period = checker.getOrDefault(PresetConstant.PERIOD_DIM, row.getString(PresetConstant.PERIOD_DIM));
        String scene = checker.getOrDefault(PresetConstant.SCENE_DIM, row.getString(PresetConstant.SCENE_DIM));
        long modelId = (Long)ThreadCache.get((Object)("mid:" + modelNum), () -> MemberReader.findModelIdByNum((String)modelNum));
        long fyId = (Long)ThreadCache.get((Object)("fyid:" + fy), () -> MemberReader.findFyMemberByNum((String)modelNum, (String)fy).getId());
        long periodId = (Long)ThreadCache.get((Object)("periodid:" + period), () -> MemberReader.findPeriodMemberByNum((String)modelNum, (String)period).getId());
        long sceneId = (Long)ThreadCache.get((Object)("sceneid:" + scene), () -> MemberReader.findScenaMemberByNum((String)modelNum, (String)scene).getId());
        Set notMergeOrgs = (Set)ThreadCache.get((Object)Joiner.on((String)"|").join((Object)"nomerge-set", (Object)modelNum, new Object[]{fy, period, scene}), () -> {
            HashSet set = new HashSet(10);
            MergeControlHelper.getCancelMergeDataByModel(modelId, sceneId, fyId, periodId).asMap().values().forEach(pl -> pl.forEach(p -> set.add(Joiner.on((String)"_").join(p.p2, p.p1, new Object[0]))));
            return set;
        });
        return !notMergeOrgs.contains(entity);
    }

    public static boolean isCancelMerge(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        IDNumberTreeNode orgNode;
        Table<String, String, Boolean> table = MergeControlHelper.getAllStructInfoForTable(modelId, scenarioId, yearId, periodId);
        Boolean isMerge = (Boolean)table.get((Object)(orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId)).getParent().getNumber(), (Object)orgNode.getNumber());
        if (isMerge == null && orgNode.getParent() != IDNumberTreeNode.NotFoundTreeNode) {
            StorageTypeEnum parentStorage = orgNode.getParent().getBaseTreeNode().getStorageType();
            return parentStorage == StorageTypeEnum.LABEL;
        }
        return Boolean.FALSE.equals(isMerge);
    }

    public static Map<String, Boolean> getMergeMapByUnitOrg(Long modelId, Long scenarioId, Long yearId, Long periodId, Long parentId) {
        IDNumberTreeNode parentNode = MemberReader.findEntityMemberById((Long)LongUtil.toLong((Object)modelId), (Long)LongUtil.toLong((Object)parentId));
        String parentNumber = parentNode.getNumber();
        Table<String, String, Boolean> table = MergeControlHelper.getAllStructInfoForTable(modelId, scenarioId, yearId, periodId);
        HashMap<String, Boolean> mcMap = (HashMap<String, Boolean>)table.rowMap().get(parentNumber);
        if (mcMap == null) {
            mcMap = new HashMap<String, Boolean>(16);
        }
        if (mcMap.isEmpty()) {
            StorageTypeEnum parentStorage = parentNode.getBaseTreeNode().getStorageType();
            boolean isLabel = parentStorage == StorageTypeEnum.LABEL;
            List children = parentNode.getChildren();
            for (IDNumberTreeNode o : children) {
                mcMap.put(o.getNumber(), !isLabel);
            }
        }
        return mcMap;
    }

    public static Map<String, MergeDataSourceEnum> getMergeSource(Object modelId, Object scenarioId, Object yearId, Object periodId, Set<String> orgNums) {
        HashSet<Long> ids = new HashSet<Long>(orgNums.size());
        HashMap<String, MergeDataSourceEnum> result = new HashMap<String, MergeDataSourceEnum>(orgNums.size());
        for (String orgNum : orgNums) {
            IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)orgNum);
            ids.add(node.getBaseTreeNode().getId());
            result.put(orgNum, MergeDataSourceEnum.SIRpt);
        }
        QFBuilder qf = new QFBuilder("model", "=", modelId);
        qf.add("scenario", "=", scenarioId).add("year", "=", yearId).add("period", "=", periodId).add("org", "in", ids);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_mergesetentity", (String)"org.number, mergedatasource", (QFilter[])qf.toArray()).values().forEach(e -> result.put(e.getString("org.number"), MergeDataSourceEnum.getValueByIndex((String)e.getString("mergedatasource"))));
        return result;
    }

    public static MergeDataSourceEnum getMergeSource(Object modelId, Object scenarioId, Object yearId, Object periodId, Object orgId) {
        IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)LongUtil.toLong((Object)modelId), (Long)LongUtil.toLong((Object)orgId));
        long baseId = node.getBaseTreeNode().getId();
        Map<Long, String> mdsMap = MergeControlHelper.geAllMergeDs(modelId, scenarioId, yearId, periodId);
        String mds = mdsMap.get(baseId);
        if (!StringUtils.isBlank((CharSequence)mds)) {
            return MergeDataSourceEnum.getValueByIndex((String)mds);
        }
        return MergeDataSourceEnum.SIRpt;
    }

    public static Object[] saveMergeDataSet(long modelId, long scenarioId, long yearId, long periodId, Map<Long, String> data) {
        if (data.isEmpty()) {
            return new Object[0];
        }
        Map<Long, Long> source2tarOrgId = TreeStructureServiceHelper.getEntityBaseMemberIds(data.keySet());
        HashMap<Long, String> newData = new HashMap<Long, String>(data.size());
        data.forEach((k, v) -> newData.put((Long)source2tarOrgId.get(k), (String)v));
        data = newData;
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId);
        QFBuilder qfHas = new QFBuilder();
        qfHas.add(qf).add("org", "in", data.keySet());
        Map hasSetData = BusinessDataServiceHelper.loadFromCache((String)"bcm_mergesetentity", (String)"org.id, mergedatasource", (QFilter[])qfHas.toArray());
        HashMap orgIdMergeSet = new HashMap();
        hasSetData.values().forEach(d -> orgIdMergeSet.put(d.getLong("org.id"), d.getString("mergedatasource")));
        ArrayList<Long> changedOrgIds = new ArrayList<Long>();
        ArrayList<Long> noInitMcStatus = new ArrayList<Long>();
        for (Map.Entry<Long, String> entry : data.entrySet()) {
            Long key = entry.getKey();
            String value = entry.getValue();
            if (orgIdMergeSet.get(key) == null || !((String)orgIdMergeSet.get(key)).equals(value)) {
                changedOrgIds.add(key);
            }
            if (orgIdMergeSet.containsKey(key) || !MergeDataSourceEnum.SIRpt.getIndex().equals(value)) continue;
            noInitMcStatus.add(key);
        }
        if (CollectionUtils.isEmpty(changedOrgIds)) {
            return new Object[0];
        }
        QFBuilder qfd = new QFBuilder("id", "in", changedOrgIds);
        Map orgDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id, longnumber", (QFilter[])qfd.toArray());
        HashSet<String> filterOut = new HashSet<String>();
        for (DynamicObject di : orgDys.values()) {
            String longNumberi = di.getString("longnumber");
            if (filterOut.contains(longNumberi) || noInitMcStatus.contains(di.getLong("id"))) continue;
            for (DynamicObject dj : orgDys.values()) {
                String longNumberj = dj.getString("longnumber");
                if (filterOut.contains(longNumberj) || longNumberi.equals(longNumberj) || noInitMcStatus.contains(dj.getLong("id")) || !longNumberi.startsWith(longNumberj) || !longNumberi.replace(longNumberj, "").startsWith("!")) continue;
                filterOut.add(longNumberj);
            }
        }
        ArrayList<DynamicObject> mergeDataSets = new ArrayList<DynamicObject>(changedOrgIds.size());
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        HashSet<Long> parentOrgIds = new HashSet<Long>(16);
        for (Long orgId : changedOrgIds) {
            DynamicObject mergeDataSet = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergesetentity");
            mergeDataSet.set("model", (Object)modelId);
            mergeDataSet.set("scenario", (Object)scenarioId);
            mergeDataSet.set("year", (Object)yearId);
            mergeDataSet.set("period", (Object)periodId);
            mergeDataSet.set("org", (Object)orgId);
            mergeDataSet.set("mergedatasource", (Object)data.get(orgId));
            mergeDataSet.set("modifier", (Object)userId);
            mergeDataSet.set("modifytime", (Object)now);
            mergeDataSets.add(mergeDataSet);
            DynamicObject dy = (DynamicObject)orgDys.get(orgId);
            if (dy == null || filterOut.contains(dy.getString("longnumber")) || noInitMcStatus.contains(orgId)) continue;
            DynamicObjectCollection orgs = MergeControlHelper.getOrgParents(modelId, dy.getString("longnumber"), true);
            parentOrgIds.addAll(orgs.stream().map(o -> o.getLong("id")).collect(Collectors.toSet()));
        }
        MergeStatusHelper.batchUpdateCalcStatus(modelId, scenarioId, yearId, periodId, parentOrgIds);
        DeleteServiceHelper.delete((String)"bcm_mergesetentity", (QFilter[])new QFBuilder().add(qf).add("org", "in", changedOrgIds).toArray());
        return SaveServiceHelper.save((DynamicObject[])mergeDataSets.toArray(new DynamicObject[0]));
    }

    public static DynamicObjectCollection getOrgParents(long modelId, String longnumber, boolean isInclude) {
        String[] orgNumbers = longnumber.split("!");
        ArrayList<String> list = new ArrayList<String>(orgNumbers.length);
        String tmpStr = orgNumbers[0];
        for (int i = 1; i < orgNumbers.length - 1; ++i) {
            tmpStr = tmpStr.concat("!").concat(orgNumbers[i]);
            list.add(tmpStr);
        }
        if (isInclude) {
            list.add(longnumber);
        }
        QFilter qcs = new QFilter("model", "=", (Object)modelId);
        qcs.and("longnumber", "in", (Object)list.toArray());
        qcs.and("longnumber", "!=", (Object)"Entity");
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,isleaf,level", (QFilter[])new QFilter[]{qcs});
    }

    public static List<String> getMergeAccounts(Object modelId) {
        return (List)GlobalCacheServiceHelper.getOrLoadNode((String)("mergeAcct#" + modelId), () -> {
            ArrayList<String> storageTypes = new ArrayList<String>(2);
            storageTypes.add(StorageTypeEnum.STORAGE.index);
            storageTypes.add(StorageTypeEnum.UNSHARE.index);
            QFilter qfilter = new QFilter("model", "=", modelId);
            qfilter.and("isparticipmerge", "=", (Object)Boolean.TRUE);
            qfilter.and("storagetype", "in", storageTypes);
            DynamicObjectCollection mergeAccounts = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])new QFilter[]{qfilter});
            ArrayList accountList = new ArrayList(mergeAccounts.size());
            mergeAccounts.forEach(m -> accountList.add(m.getString("number")));
            return accountList;
        });
    }

    public static List<String> getMergeChangeType(long modelId) {
        return (List)GlobalCacheServiceHelper.getOrLoadNode((String)("mergeChangeType#" + modelId), () -> {
            ArrayList<String> storageTypes = new ArrayList<String>(2);
            storageTypes.add(StorageTypeEnum.STORAGE.index);
            storageTypes.add(StorageTypeEnum.UNSHARE.index);
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)modelId);
            qf.add("ismerge", "=", (Object)Boolean.TRUE);
            qf.and("storagetype", "in", storageTypes);
            qf.add("number", "not in", Arrays.asList("BFLY", "BOP"));
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_changetypemembertree", (String)"number", (QFilter[])qf.toArray());
            return dyns.stream().map(dyn -> dyn.getString("number")).collect(Collectors.toList());
        });
    }

    public static List<String> getMergeMembers(String modelNum, String dimNum) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)dimNum) + "#getMergeMembers";
        String entityName = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        if (!DimEntityNumEnum.isMergeDim((String)entityName)) {
            return new ArrayList<String>(16);
        }
        return (List)GlobalCacheServiceHelper.getOrLoadNode((String)cacheKey, () -> {
            long modelId = MemberReader.findModelIdByNum((String)modelNum);
            long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("dimension", "=", (Object)dimId));
            if (DimEntityNumEnum.ACCOUNT.getNumber().equals(dimNum)) {
                filter.and(new QFilter("isparticipmerge", "=", (Object)Boolean.TRUE));
            } else {
                filter.and(new QFilter("ismerge", "=", (Object)Boolean.TRUE));
            }
            ArrayList<String> storageTypes = new ArrayList<String>(2);
            storageTypes.add(StorageTypeEnum.STORAGE.index);
            storageTypes.add(StorageTypeEnum.UNSHARE.index);
            filter.and(new QFilter("storagetype", "in", storageTypes));
            return QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filter.toArray()).stream().map(m -> m.getString("number")).collect(Collectors.toList());
        });
    }

    public static List<String> getNoMergeMembersForAllInOneMerge(String modelNum, String dimNum) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)dimNum) + "-getNoMergeMembers";
        String entityName = DimEntityNumEnum.getEntieyNumByNumber((String)dimNum);
        if (!DimEntityNumEnum.isMergeDim((String)entityName)) {
            return new ArrayList<String>(16);
        }
        return (List)GlobalCacheServiceHelper.getDimMemberCache().getOrLoad(cacheKey, () -> {
            long modelId = MemberReader.findModelIdByNum((String)modelNum);
            long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("dimension", "=", (Object)dimId));
            if (DimEntityNumEnum.ACCOUNT.getNumber().equals(dimNum)) {
                filter.and(new QFilter("isparticipmerge", "=", (Object)Boolean.FALSE));
            } else {
                filter.and(new QFilter("ismerge", "=", (Object)Boolean.FALSE));
            }
            ArrayList<String> storageTypes = new ArrayList<String>(2);
            storageTypes.add(StorageTypeEnum.STORAGE.index);
            storageTypes.add(StorageTypeEnum.UNSHARE.index);
            filter.and(new QFilter("storagetype", "in", storageTypes));
            return QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filter.toArray()).stream().map(m -> m.getString("number")).collect(Collectors.toList());
        });
    }

    public static List<String> getUserDefineDimensionNumListByModel(Long modelId) {
        return (List)GlobalCacheServiceHelper.getDimMemberCache().getOrLoad("userDefineDim#" + modelId, () -> {
            QFilter[] filters = new QFBuilder().add("model", "=", (Object)modelId).add("issysdimension", "=", (Object)"0").toArray();
            return QueryServiceHelper.query((String)"bcm_dimension", (String)"number", (QFilter[])filters).stream().map(e -> e.getString("number")).collect(Collectors.toList());
        });
    }

    public static Map<Long, String> geAllMergeDs(Object modelId, Object scenarioId, Object yearId, Object periodId) {
        return (Map)GlobalCacheServiceHelper.getOrLoadNode((String)("getAllMergeDs" + modelId + scenarioId + yearId + periodId), () -> {
            QFBuilder qf = new QFBuilder("model", "=", modelId);
            qf.add("scenario", "=", scenarioId).add("year", "=", yearId).add("period", "=", periodId);
            DynamicObjectCollection mdsColl = QueryServiceHelper.query((String)"bcm_mergesetentity", (String)"org,mergedatasource", (QFilter[])qf.toArray());
            HashMap mdsMap = new HashMap(mdsColl.size());
            mdsColl.forEach(m -> mdsMap.put(m.getLong("org"), m.getString("mergedatasource")));
            return mdsMap;
        });
    }

    public static void resetMergeDataSetCache(long modelId, long scenarioId, long yearId, long periodId) {
        String key = "getAllMergeDs" + modelId + scenarioId + yearId + periodId;
        GlobalCacheServiceHelper.invalidateCacheByKey((String)key);
    }

    public static Set<String> getNoMergeOrgWithChildrenByNumber(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgLongNumber) {
        return (Set)ThreadCache.get((Object)(modelId + "|" + scenarioId + "|" + yearId + "|" + periodId + "|" + orgLongNumber), () -> {
            HashSet<String> notMergeOrgNumSet = new HashSet<String>(16);
            if (orgLongNumber != null) {
                QFBuilder orgFilter = new QFBuilder("model", "=", (Object)modelId);
                orgFilter.add("longnumber", "like", (Object)(orgLongNumber + "!%"));
                orgFilter.and("status", "!=", (Object)"A");
                DynamicObjectCollection orgCollection = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])orgFilter.toArray());
                String yearNum = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)yearId).getNumber();
                FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam((long)modelId, (long)scenarioId, yearNum, (long)periodId);
                EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgCollection);
                Set orgIdVersionSet = orgCollection.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                DynamicObjectCollection noMergeOrgList = OrgServiceHelper.getNoMergeOrgList(orgCollection, modelId, scenarioId, yearId, periodId);
                Set noMergeOrgIdSet = noMergeOrgList.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
                HashSet<Long> noMergeChildrenOrgId = new HashSet<Long>(16);
                for (Long orgId : noMergeOrgIdSet) {
                    IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                    if (orgNode.isLeaf()) continue;
                    List allChildren = orgNode.getAllChildren();
                    for (IDNumberTreeNode child : allChildren) {
                        if (!orgIdVersionSet.contains(child.getId())) continue;
                        noMergeChildrenOrgId.add(child.getId());
                    }
                }
                Set noMergeOrgNumberSet = noMergeOrgList.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
                HashSet<String> mergeOrgNumberSet = new HashSet<String>(16);
                Map<String, List<DynamicObject>> orgNumGroupMap = orgCollection.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
                for (Map.Entry<String, List<DynamicObject>> entry : orgNumGroupMap.entrySet()) {
                    String key = entry.getKey();
                    List<DynamicObject> value = entry.getValue();
                    if (value.size() <= 1) continue;
                    Set commonNumberOrgId = value.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
                    if (noMergeOrgNumberSet.contains(key)) {
                        commonNumberOrgId.removeAll(noMergeOrgIdSet);
                        if (commonNumberOrgId.isEmpty()) continue;
                        noMergeOrgList.removeAll(value);
                        continue;
                    }
                    commonNumberOrgId.removeAll(noMergeChildrenOrgId);
                    if (commonNumberOrgId.isEmpty()) continue;
                    mergeOrgNumberSet.add(key);
                }
                for (DynamicObject org : noMergeOrgList) {
                    IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)org.getLong("id"));
                    notMergeOrgNumSet.add(orgNode.getNumber());
                    if (orgNode.isLeaf()) continue;
                    List allChildren = orgNode.getAllChildren();
                    for (IDNumberTreeNode child : allChildren) {
                        if (!orgIdVersionSet.contains(child.getId()) || mergeOrgNumberSet.contains(child.getNumber())) continue;
                        notMergeOrgNumSet.add(child.getNumber());
                    }
                }
            }
            return notMergeOrgNumSet;
        });
    }

    public static Set<String> getNoMergeByNumber(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        HashSet<String> notMergeKey = new HashSet<String>();
        Map<String, Boolean> allStructInfoForMap = MergeControlHelper.getAllStructInfoForMap(modelId, scenarioId, yearId, periodId);
        for (Map.Entry<String, Boolean> entry : allStructInfoForMap.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            notMergeKey.add(entry.getKey());
        }
        return notMergeKey;
    }

    public static Map<String, Boolean> getAllStructInfoForMap(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        return (Map)BcmThreadCache.get((Object)"MergeStructInfoMap", (Object)scenarioId, (Object)yearId, (Object)periodId, () -> {
            HashMap structInfoMap = new HashMap();
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("scenario", "=", (Object)scenarioId);
            qfBuilder.add("year", "=", (Object)yearId);
            qfBuilder.add("period", "=", (Object)periodId);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMergeStructInfo", (String)"bcm_mergestructinfo", (String)"orgnumber,orgpnumber,ismerge", (QFilter[])qfBuilder.toArray(), null);){
                ds.forEachRemaining(p -> structInfoMap.put(p.getString("orgpnumber") + "!" + p.getString("orgnumber"), p.getBoolean("ismerge")));
            }
            return structInfoMap;
        });
    }

    public static Table<String, String, Boolean> getAllStructInfoForTable(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        return (Table)BcmThreadCache.get((Object)"MergeStructInfoTable", (Object)scenarioId, (Object)yearId, (Object)periodId, () -> {
            HashBasedTable structInfoTable = HashBasedTable.create();
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("scenario", "=", (Object)scenarioId);
            qfBuilder.add("year", "=", (Object)yearId);
            qfBuilder.add("period", "=", (Object)periodId);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMergeStructInfo", (String)"bcm_mergestructinfo", (String)"orgnumber,orgpnumber,ismerge", (QFilter[])qfBuilder.toArray(), null);){
                ds.forEachRemaining(arg_0 -> MergeControlHelper.lambda$null$38((Table)structInfoTable, arg_0));
            }
            return structInfoTable;
        });
    }

    public static ResultBox execMerge(FixedItem fixedItem, MergeCondition condition) {
        Long mergeProgressId;
        ResultBox result = mergeService.checkMerge(fixedItem, OpItemEnum.EXEC_ALLMERGE);
        if (result.isSuccess() && (mergeProgressId = mergeService.execAllMerge(fixedItem, condition)) != null) {
            result.setData((Object)mergeProgressId);
        }
        return result;
    }

    public static ResultBox execCalculate(FixedItem fixedItem, MergeCondition condition) {
        ResultBox result = mergeService.checkCalculate(fixedItem, OpItemEnum.EXEC_CALCULATE);
        if (result.isSuccess()) {
            mergeService.executeCalculate(fixedItem, condition);
        }
        return result;
    }

    public static List<List<String>> getUnitElimProcesses(long modelId) {
        ArrayList<List<String>> elimProcess = new ArrayList<List<String>>(16);
        elimProcess.add(Collections.singletonList("ADJ"));
        elimProcess.add(Collections.singletonList("CADJ"));
        if (DimensionServiceHelper.isCM02Model(modelId)) {
            elimProcess.add(Collections.singletonList("EJE"));
        } else {
            elimProcess.add(Arrays.asList("EJE", "EICA", "EIT", "EOE", "ECF", "EOther"));
        }
        elimProcess.add(Collections.singletonList("CCADJ"));
        elimProcess.add(Collections.singletonList("DADJ"));
        elimProcess.add(Collections.singletonList("DEJE"));
        return elimProcess;
    }

    public static List<String> getUnitProcess(long modelId) {
        ArrayList<String> adjProcess = new ArrayList<String>(16);
        adjProcess.add("ADJ");
        adjProcess.add("CADJ");
        if (DimensionServiceHelper.isCM02Model(modelId)) {
            adjProcess.add("EJE");
        } else {
            adjProcess.addAll(Arrays.asList("EICA", "EIT", "EOE", "ECF", "EOther"));
        }
        adjProcess.add("CCADJ");
        return adjProcess;
    }

    public static List<Pair<String, String>> getNoMergeOrgListWithChildrenByNumber(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgLongNumber) {
        return (List)ThreadCache.get((Object)("setICMemeberBackgroundColor:" + modelId + "|" + scenarioId + "|" + yearId + "|" + periodId + "|" + orgLongNumber), () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)modelId);
            qfBuilder.add("scenario", "=", (Object)scenarioId);
            qfBuilder.add("year", "=", (Object)yearId);
            qfBuilder.add("period", "=", (Object)periodId);
            qfBuilder.add("ismerge", "in", (Object)"0");
            HashMultimap num2Longnumbers = HashMultimap.create();
            if (orgLongNumber != null) {
                QFBuilder orgFilter = new QFBuilder("model", "=", (Object)modelId);
                orgFilter.add("longnumber", "like", (Object)(orgLongNumber + "!%"));
                orgFilter.and("status", "!=", (Object)"A");
                DynamicObjectCollection orgCollection = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])orgFilter.toArray());
                String yearNum = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)yearId).getNumber();
                FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam((long)modelId, (long)scenarioId, yearNum, (long)periodId);
                EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgCollection);
                Set allChildrenNumber = orgCollection.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
                for (DynamicObject obj : orgCollection) {
                    num2Longnumbers.put((Object)obj.getString("number"), (Object)obj.getString("longnumber"));
                }
                if (!allChildrenNumber.isEmpty()) {
                    qfBuilder.add("orgnumber", "in", allChildrenNumber);
                }
            }
            DynamicObjectCollection notMergeOrgINfo = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orgpnumber,orgnumber", (QFilter[])qfBuilder.toArray());
            ArrayList<Pair> notMergeOrgNums = new ArrayList<Pair>(16);
            HashSet<String> longnumbers = new HashSet<String>(16);
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            for (DynamicObject org : notMergeOrgINfo) {
                String orgNumber = org.getString("orgnumber");
                String orgPnumber = org.getString("orgpnumber");
                Set orglongnumbers = num2Longnumbers.get((Object)orgNumber);
                for (String orglongnumber : orglongnumbers) {
                    if (!orglongnumber.contains(orgPnumber + "!" + orgNumber)) continue;
                    IDNumberTreeNode orgNode = MemberReader.findMemberByLongNumber((String)modelNumber, (String)DimTypesEnum.ENTITY.getNumber(), (String)orglongnumber);
                    if (!longnumbers.contains(orgNode.getLongNumber()) && orgNode.getLongNumber().contains(orgLongNumber)) {
                        notMergeOrgNums.add(Pair.onePair((Object)orgNode.getNumber(), (Object)(orgNode.getParent() == null ? "" : orgNode.getParent().getNumber())));
                        longnumbers.add(orgNode.getLongNumber());
                    }
                    if (orgNode.isLeaf()) continue;
                    List allChildren = orgNode.getAllChildren();
                    for (IDNumberTreeNode child : allChildren) {
                        if (longnumbers.contains(child.getLongNumber()) || !child.getLongNumber().contains(orgLongNumber)) continue;
                        longnumbers.add(child.getLongNumber());
                        notMergeOrgNums.add(Pair.onePair((Object)child.getNumber(), (Object)(child.getParent() == null ? "" : child.getParent().getNumber())));
                    }
                }
            }
            return notMergeOrgNums;
        });
    }

    public static Set<String> getallNoMergeOrgWithChildrenByNumber(Long modelId, String cube, Long scenarioId, Long yearId, Long periodId, String orgNumber, String orgLongNumber) {
        List<Pair<String, String>> notMergeOrgNums = MergeControlHelper.getNoMergeOrgListWithChildrenByNumber(modelId, scenarioId, yearId, periodId, orgLongNumber);
        HashMap<Object, Integer> noMerge2Num2Sums = new HashMap<Object, Integer>(16);
        for (Pair<String, String> orgNum : notMergeOrgNums) {
            noMerge2Num2Sums.merge(orgNum.p1, 1, Integer::sum);
        }
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)cube, (String)orgNumber);
        HashMap<String, Integer> num2Sums = new HashMap<String, Integer>(16);
        if (!orgNode.isLeaf()) {
            List allChildren = orgNode.getAllChildren();
            for (IDNumberTreeNode iDNumberTreeNode : allChildren) {
                num2Sums.merge(iDNumberTreeNode.getNumber(), 1, Integer::sum);
            }
        }
        HashSet<String> final_noMerges = new HashSet<String>(16);
        for (Map.Entry entry : noMerge2Num2Sums.entrySet()) {
            if (num2Sums.get(entry.getKey()) != null && !Objects.equals(num2Sums.get(entry.getKey()), entry.getValue())) continue;
            final_noMerges.add((String)entry.getKey());
        }
        return final_noMerges;
    }

    public static Set<Long> getNoMergeOrgIdWithChildrenByNumber(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgLongNumber) {
        return (Set)ThreadCache.get((Object)("ExtDataQueryService.getAllChildMergeOrg" + modelId + "|" + scenarioId + "|" + yearId + "|" + periodId + "|" + orgLongNumber), () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)modelId);
            qfBuilder.add("scenario", "=", (Object)scenarioId);
            qfBuilder.add("year", "=", (Object)yearId);
            qfBuilder.add("period", "=", (Object)periodId);
            qfBuilder.add("ismerge", "in", (Object)"0");
            ArrayList<Long> removeNodes = new ArrayList<Long>(16);
            if (orgLongNumber != null) {
                QFBuilder orgFilter = new QFBuilder("model", "=", (Object)modelId);
                orgFilter.add("longnumber", "like", (Object)(orgLongNumber + "!%"));
                orgFilter.and("status", "!=", (Object)"A");
                DynamicObjectCollection orgCollection = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])orgFilter.toArray());
                String yearNum = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)yearId).getNumber();
                FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam((long)modelId, (long)scenarioId, yearNum, (long)periodId);
                removeNodes.addAll(EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgCollection));
                Set allChildrenNumber = orgCollection.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
                if (allChildrenNumber.size() > 0) {
                    qfBuilder.add("orgnumber", "in", allChildrenNumber);
                }
            }
            DynamicObjectCollection notMergeOrgINfo = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orglnumber,orgpnumber,orgnumber", (QFilter[])qfBuilder.toArray());
            HashSet<Long> notMergeOrgNumSet = new HashSet<Long>(16);
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            for (DynamicObject org : notMergeOrgINfo) {
                String orgNumber = org.getString("orgnumber");
                String orgPnumber = org.getString("orgpnumber");
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNumber);
                if (StringUtils.isNotEmpty((CharSequence)orgNode.getLongNumber()) && StringUtils.isNotEmpty((CharSequence)orgPnumber)) {
                    if (orgNode.getLongNumber().startsWith(orgLongNumber + "!") && orgPnumber.equals(orgNode.getParent().getNumber())) {
                        notMergeOrgNumSet.add(orgNode.getId());
                    } else {
                        for (IDNumberTreeNode shareNode : orgNode.getShareNodes()) {
                            if (!shareNode.getLongNumber().startsWith(orgLongNumber + "!") || !orgPnumber.equals(shareNode.getParent().getNumber())) continue;
                            notMergeOrgNumSet.add(shareNode.getId());
                        }
                    }
                } else {
                    notMergeOrgNumSet.add(orgNode.getId());
                }
                if (orgNode.isLeaf()) continue;
                List allChildren = orgNode.getAllChildren();
                for (IDNumberTreeNode child : allChildren) {
                    notMergeOrgNumSet.add(child.getId());
                }
            }
            notMergeOrgNumSet.addAll(removeNodes);
            return notMergeOrgNumSet;
        });
    }

    public static Set<String> getAllShareNumbers(Long modelId, Long entryOrgId, Long scenarioId, Long yearId, Long periodId) {
        return (Set)GlobalCacheServiceHelper.getOrLoadNode((String)("getAllShareNumbers" + modelId + entryOrgId + yearId + periodId), () -> {
            DynamicObjectCollection allOrgChildren = OrgServiceHelper.getAllOrgChildren(modelId, entryOrgId, true);
            IDNumberTreeNode yearNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam((long)modelId, (long)scenarioId, yearNode.getNumber(), (long)periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)allOrgChildren);
            HashSet orgNumbers = new HashSet(16);
            HashSet shareNumbers = new HashSet(16);
            allOrgChildren.forEach(o -> {
                String orgNumber = o.getString("number");
                if (!orgNumbers.add(orgNumber)) {
                    shareNumbers.add(orgNumber);
                }
            });
            return shareNumbers;
        });
    }

    public static Set<String> batchGetMcDataInProgress(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<String> orgNumbers, Long progressId) {
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers).and("progressid", "=", (Object)progressId).and("calculatestatus", "=", (Object)"Z");
        DynamicObjectCollection mcs = QueryServiceHelper.query((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray());
        return mcs.stream().map(m -> m.getString("orgnumber")).collect(Collectors.toSet());
    }

    private static /* synthetic */ void lambda$null$38(Table structInfoTable, Row p) {
        structInfoTable.put((Object)p.getString("orgpnumber"), (Object)p.getString("orgnumber"), (Object)p.getBoolean("ismerge"));
    }
}

