/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntryType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.allinone.dispatch.CslService2Dispatcher;
import kd.fi.bcm.business.allinone.dispatch.CslServiceDispatcher;
import kd.fi.bcm.business.allinone.dispatch.McCalculateDispatcher;
import kd.fi.bcm.business.allinone.dispatch.McContributionDispatcher;
import kd.fi.bcm.business.allinone.dispatch.McConvertDispatcher;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.McContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.model.StageMcStatus;
import kd.fi.bcm.business.allinone.service.MergeProgressHelper;
import kd.fi.bcm.business.allinone.service.ProgressCacheHelper;
import kd.fi.bcm.business.allinone.service.chk.MergeChkCheckContext;
import kd.fi.bcm.business.allinone.service.thread.AbortThreadHelper;
import kd.fi.bcm.business.allinone.service.thread.JVMShutdownHook;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.datalock.StageServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeEntityService;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.mergecontrol.check.CheckCancelCompleteExecutor;
import kd.fi.bcm.business.mergecontrol.check.CheckCompleteExecutor;
import kd.fi.bcm.business.mergecontrol.flow.FlowOpService;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.business.mergecontrol.flow.MergeArchiveExecutor;
import kd.fi.bcm.business.mergecontrol.flow.MergeCancelArchiveExecutor;
import kd.fi.bcm.business.mergecontrol.versioned.DataCancelVersionedExecutor;
import kd.fi.bcm.business.mergecontrol.versioned.DataVersionedExecutor;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.util.MessageServiceUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MergeControlService {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(MergeControlService.class);
    private final MergeStatusService mcService = MergeStatusService.getInstance();

    private MergeControlService() {
    }

    public static MergeControlService getInstance() {
        return new MergeControlService();
    }

    public DynamicObjectCollection queryMergeControlEntity(FixedItem fixedItem, Long pid, EntryType entityType, String pageItem, boolean isContainSelf, String processType, boolean isFromCard) {
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        String modelNum = fixedItem.getModelNum();
        DynamicObjectCollection orgTree = this.getOrgTree(fixedItem, pid, pageItem, isContainSelf);
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet<Long> memberIds = new HashSet<Long>();
        ArrayList<String> memberNumbers = new ArrayList<String>();
        orgTree.forEach(o -> {
            memberIds.add(o.getLong("id"));
            memberNumbers.add(o.getString("number"));
        });
        Map<Long, MergeData> mcDataMap = this.mcService.batchGetMcData(modelId, scenarioId, yearId, periodId, memberIds);
        Set<String> unAuditOrSet = AdjustmentServiceHelper.collectUnAuditAdjust(modelId, scenarioId, yearId, periodId, orgTree);
        Map<Long, String> mdsMap = MergeControlHelper.geAllMergeDs(modelId, scenarioId, yearId, periodId);
        Set<String> nonMergeSet = this.getNonMerge(modelId, scenarioId, yearId, periodId, memberNumbers);
        HashMap<Object, Object> planStageMap = new HashMap<Object, Object>(16);
        boolean isNeedDealStageShow = false;
        if (!isFromCard) {
            Pair<Long, List<Tuple<Long, String, String>>> dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo(modelId, scenarioId, yearId, periodId);
            if ((Long)dataLockPlanInfo.p1 > 0L) {
                for (Tuple stageItem : (List)dataLockPlanInfo.p2) {
                    planStageMap.put(stageItem.p2, stageItem.p1);
                }
            }
            if (!planStageMap.isEmpty()) {
                isNeedDealStageShow = true;
            }
        }
        HashSet<Long> ecDataIdSet = new HashSet<Long>(mcDataMap.size());
        for (MergeData mergeData : mcDataMap.values()) {
            DynamicObject ecData = mergeData.getEcData();
            if (null == ecData) continue;
            ecDataIdSet.add(ecData.getLong("id"));
        }
        HashMap flowDetailMap = new HashMap(ecDataIdSet.size());
        QFilter filter = new QFilter("bizid", "in", ecDataIdSet);
        try (DataSet lDataSet = QueryServiceHelper.queryDataSet((String)"Query-Flow-Record-l", (String)"bcm_flowtask", (String)"id,bizid,actor.name,finishtime", (QFilter[])filter.toArray(), null);
             DataSet rDataSet = QueryServiceHelper.queryDataSet((String)"Query-Flow-Record-r", (String)"bcm_flowtask", (String)"bizid,finishtime", (QFilter[])filter.toArray(), null);){
            DataSet oneDataSet = lDataSet.join(rDataSet.groupBy(new String[]{"bizid"}).max("finishtime").finish()).on("bizid", "bizid").on("finishtime", "finishtime").select(new String[]{"bizid", "actor.name", "finishtime"}).finish();
            oneDataSet.forEachRemaining(row -> flowDetailMap.put(row.getLong("bizid"), Pair.onePair((Object)row.getString("actor.name"), (Object)row.getDate("finishtime"))));
        }
        Set<String> versionOrgNumbers = MergeEntityService.getInstance().getVersionedOrgs(modelId, scenarioId, yearId, periodId, memberIds);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNum, (Long)scenarioId);
        boolean isSceneQuote = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
        IDNumberTreeNode quoteNode = (IDNumberTreeNode)sceneNode.getProperty("quoteNode");
        for (DynamicObject org : orgTree) {
            long orgId = org.getLong("id");
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            long baseOrgId = org.getLong("copyfrom");
            baseOrgId = baseOrgId == 0L ? orgId : baseOrgId;
            String longNumber = org.getString("longnumber");
            boolean isLeaf = org.getBoolean("isleaf");
            DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
            for (String col : this.getOrgProperties()) {
                rowObj.set(col, org.get(col));
            }
            MergeData mergeData = mcDataMap.get(orgId);
            DynamicObject ecData = mergeData.getEcData();
            DynamicObject pcData = mergeData.getPcData();
            McStatus mcStatus = mergeData.getMergeStatus();
            String flowStatus = this.getFlowName(orgNode, mcStatus.getFlow().getStatus(), ecData, true);
            String pcFlowStatus = this.getFlowName(orgNode, mcStatus.getPcFlow().getStatus(), pcData, false);
            String source = mdsMap.get(baseOrgId);
            if (!StringUtils.isNotBlank((String)source)) {
                source = MergeDataSourceEnum.SIRpt.getIndex();
            }
            if (!isLeaf) {
                rowObj.set("mergestatus", (Object)(mcStatus.getMergeStatus().getStatus() + source));
            }
            rowObj.set("calculatestatus", (Object)mcStatus.getCalculate().getStatus());
            rowObj.set("pccalculatestatus", (Object)mcStatus.getConvert().getStatus());
            rowObj.set("flowstatus", (Object)flowStatus);
            rowObj.set("pcflowstatus", (Object)pcFlowStatus);
            rowObj.set("archivestatus", (Object)mcStatus.getArchive().getStatus());
            String checkResult = processType.equals(AdjustTypeEnum.ERPT.getValue()) ? mcStatus.getChkStatus().getStatus() : mcStatus.getPcChkStatus().getStatus();
            rowObj.set("chkstatus", (Object)checkResult);
            rowObj.set("isversioned", (Object)false);
            if (isNeedDealStageShow) {
                Map<Long, StageMcStatus> stageMergeStatus = mergeData.getStageMergeStatusMap();
                for (Map.Entry entry : planStageMap.entrySet()) {
                    String stageLevel = (String)entry.getKey();
                    Long stageId = (Long)entry.getValue();
                    StageMcStatus stageMcStatus = stageMergeStatus.get(stageId);
                    rowObj.set("flowstatusstage" + stageLevel, (Object)this.getStageFlowName(orgNode, stageMcStatus, true));
                    rowObj.set("pcflowstatusstage" + stageLevel, (Object)this.getStageFlowName(orgNode, stageMcStatus, false));
                }
            }
            String sceneName = sceneNode.getName();
            if (isSceneQuote) {
                boolean isOrgVersioned = versionOrgNumbers.contains(orgNode.getNumber());
                if (!isOrgVersioned) {
                    sceneName = quoteNode.getName();
                } else {
                    rowObj.set("isversioned", (Object)true);
                }
            }
            rowObj.set("scenename", (Object)sceneName);
            String checkStatus = "A";
            if (ecData != null && StringUtils.isNotEmpty((String)ecData.getString("checkstatus"))) {
                checkStatus = ecData.getString("checkstatus");
            }
            rowObj.set("checkstatus", (Object)checkStatus);
            rowObj.set("begintime", ecData == null ? null : ecData.getDate("begintime"));
            rowObj.set("endtime", ecData == null ? null : ecData.getDate("endtime"));
            rowObj.set("modifiername", ecData == null ? null : ecData.getString("modifier.name"));
            rowObj.set("ecdataid", (Object)(ecData == null ? 0L : ecData.getLong("id")));
            rowObj.set("pcdataid", (Object)(pcData == null ? 0L : pcData.getLong("id")));
            Pair lastFlowDetail = (Pair)flowDetailMap.get(rowObj.getLong("ecdataid"));
            rowObj.set("flowusername", lastFlowDetail == null ? null : lastFlowDetail.p1);
            rowObj.set("flowtime", lastFlowDetail == null ? null : lastFlowDetail.p2);
            String[] split = longNumber.split("!");
            if (split.length == 1) {
                rowObj.set("ismerge", (Object)"1");
            } else {
                if (split.length > 2) {
                    longNumber = split[split.length - 2] + "!" + split[split.length - 1];
                }
                if (nonMergeSet.contains(longNumber)) {
                    rowObj.set("ismerge", (Object)"0");
                } else {
                    rowObj.set("ismerge", (Object)"1");
                }
            }
            if (!"Entity".equalsIgnoreCase(orgNode.getNumber())) {
                rowObj.set("adjuststatus", (Object)(unAuditOrSet.contains(orgNode.getNumber()) ? "1" : "0"));
            }
            result.add((Object)rowObj);
        }
        return result;
    }

    public String getFlowName(IDNumberTreeNode orgNode, String status, DynamicObject mcData, boolean isEc) {
        String flowStatus = "";
        if ("C".equals(status)) {
            flowStatus = MergeMessage.FLOW_SUBMIT.getText();
        } else if (mcData != null && "B".equals(status)) {
            long taskId = mcData.getLong("flowtask");
            flowStatus = taskId != 0L ? FlowStepServiceHelper.getFlowTaskStatus(taskId) : MergeMessage.FLOW_UNDONE.getText();
        } else if (isEc) {
            flowStatus = MergeMessage.FLOW_UNDONE.getText();
        } else if (orgNode.getParent() != null && !"Entity".equals(orgNode.getParent().getNumber())) {
            flowStatus = MergeMessage.FLOW_UNDONE.getText();
        }
        return flowStatus;
    }

    public String getStageFlowName(IDNumberTreeNode orgNode, StageMcStatus stageStatus, boolean isEc) {
        String status;
        String flowStatus = "";
        long flowTaskId = 0L;
        if (stageStatus == null) {
            status = "";
        } else {
            status = isEc ? stageStatus.getEcFlowStatus() : stageStatus.getPcFlowStatus();
            long l = flowTaskId = isEc ? stageStatus.getEcFlowTaskId() : stageStatus.getPcFlowTaskId();
        }
        if ("C".equals(status)) {
            flowStatus = MergeMessage.FLOW_SUBMIT.getText();
        } else if ("B".equals(status)) {
            flowStatus = flowTaskId > 0L ? FlowStepServiceHelper.getFlowTaskStatus(flowTaskId) : MergeMessage.FLOW_UNDONE.getText();
        } else if (isEc) {
            flowStatus = MergeMessage.FLOW_UNDONE.getText();
        } else if (orgNode.getParent() != null && !"Entity".equals(orgNode.getParent().getNumber())) {
            flowStatus = MergeMessage.FLOW_UNDONE.getText();
        }
        return flowStatus;
    }

    private DynamicObjectCollection getOrgTree(FixedItem fixedItem, Long pid, String pageItem, boolean isContainSelf) {
        return this.getOrgTree(fixedItem, pid, pageItem, isContainSelf, true);
    }

    public DynamicObjectCollection getOrgTree(FixedItem fixedItem, Long pid, String pageItem, boolean isContainSelf, boolean dealPerm) {
        DynamicObject orgDyn;
        DynamicObjectCollection orgTree = new DynamicObjectCollection();
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        String yearNum = fixedItem.getFyNum();
        if (isContainSelf && (orgDyn = OrgServiceHelper.getOrg(modelId, pid)) != null) {
            orgTree.add((Object)orgDyn);
        }
        if (!"show_table".equals(pageItem)) {
            orgTree.addAll((Collection)OrgServiceHelper.getOrgChildren(modelId, pid));
        } else {
            orgTree.addAll((Collection)OrgServiceHelper.getAllOrgChildren(modelId, pid));
        }
        if (dealPerm) {
            List<Long> allOrgId = orgTree.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            Set<Long> noPermMembers = PermissionServiceImpl.getInstance(modelId).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", allOrgId);
            List dynList = orgTree.stream().filter(o -> !noPermMembers.contains(o.getLong("id"))).collect(Collectors.toList());
            orgTree = new DynamicObjectCollection();
            orgTree.addAll(dynList);
        }
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, yearNum, periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgTree);
        OrgServiceHelper.dealNoMergeOrgList(orgTree, modelId, scenarioId, yearId, periodId);
        return orgTree;
    }

    public String getSchemeById(Long modelId, Long orgId) {
        if (orgId == null || orgId == 0L) {
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            qf.and("number", "=", (Object)"DefaultScheme");
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id as cslschemeid,number", (QFilter[])qf.toArray());
            return dyn == null ? "0" : dyn.getString("cslschemeid");
        }
        QFilter qf = new QFilter("id", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,cslscheme.id as cslschemeid", (QFilter[])qf.toArray());
        return dyn == null ? "0" : dyn.getString("cslschemeid");
    }

    public String getSchemeNameById(Long orgId) {
        QFilter qf = new QFilter("id", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,cslscheme.name as cslschemename", (QFilter[])qf.toArray());
        return dyn == null ? "" : dyn.getString("cslschemename");
    }

    private Set<String> getNonMerge(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<String> memberNumbers) {
        QFBuilder qFilter = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", memberNumbers).add("ismerge", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orgnumber,orgpnumber,ismerge", (QFilter[])qFilter.toArray());
        return dynColl.stream().map(dyn -> dyn.getString("orgpnumber") + "!" + dyn.getString("orgnumber")).collect(Collectors.toSet());
    }

    public Set<String> getNonMergeOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<String> orgNumbers) {
        DynamicObjectCollection orgs;
        QFBuilder qf;
        if (orgNumbers == null) {
            qf = new QFBuilder("model", "=", (Object)modelId).add("number", "!=", (Object)"Entity").add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()).and("status", "!=", (Object)"A").add("isexchangerate", "=", (Object)"0");
            orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, parent.number, parent.storagetype", (QFilter[])qf.toArray());
            IDNumberTreeNode fyMember = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)yearId);
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam((long)modelId, (long)scenarioId, fyMember.getNumber(), (long)periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgs);
        } else {
            qf = new QFBuilder("model", "=", (Object)modelId).add("number", "in", orgNumbers).and("status", "!=", (Object)"A");
            orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, parent.number, parent.storagetype", (QFilter[])qf.toArray());
        }
        HashSet lableOrgs = new HashSet();
        orgs.forEach(o -> {
            if (!"Entity".equals(o.getString("number")) && StorageTypeEnum.LABEL.getOIndex().equals(o.getString("parent.storagetype"))) {
                lableOrgs.add(o.getString("parent.number") + "!" + o.getString("number"));
            }
        });
        Set<String> nonMergeOrgs = this.getNonMerge(modelId, scenarioId, yearId, periodId, orgNumbers);
        nonMergeOrgs.addAll(lableOrgs);
        return nonMergeOrgs;
    }

    public Set<String> getRealProcessSet(String processNum) {
        HashSet<String> realProcess = new HashSet<String>(10);
        if (processNum == null) {
            processNum = "erpt";
        }
        switch (processNum) {
            case "erpt": {
                realProcess.add("EIRpt");
                realProcess.add("ERAdj");
                realProcess.add("ERpt");
                break;
            }
            case "rpt": {
                realProcess.add("IRpt");
                realProcess.add("RAdj");
                realProcess.add("Rpt");
                break;
            }
            case "arpt": {
                realProcess.add("ADJ");
                realProcess.add("ARPT");
                break;
            }
            case "prpt": {
                realProcess.add("CADJ");
                realProcess.add("PRPT");
                break;
            }
            case "eje": {
                realProcess.add("EJE");
                realProcess.add("EIT");
                realProcess.add("EICA");
                realProcess.add("EOther");
                realProcess.add("EOE");
                realProcess.add("ECF");
                break;
            }
            case "cctotal": {
                realProcess.add("CC");
                realProcess.add("CCADJ");
                realProcess.add("CCTotal");
                break;
            }
        }
        return realProcess;
    }

    public List<String> getOrgProperties() {
        ArrayList<String> properties = new ArrayList<String>(20);
        properties.add("id");
        properties.add("number");
        properties.add("longnumber");
        properties.add("name");
        properties.add("memberid");
        properties.add("level");
        properties.add("isleaf");
        properties.add("currencyname");
        properties.add("currencynumber");
        return properties;
    }

    public List<String> getProperties(Long modelId, Long sceneId, Long yearId, Long periodId, boolean isFromCard) {
        ArrayList<String> properties = new ArrayList<String>(20);
        properties.add("id");
        properties.add("number");
        properties.add("longnumber");
        properties.add("name");
        properties.add("memberid");
        properties.add("level");
        properties.add("isleaf");
        properties.add("currencyname");
        properties.add("currencynumber");
        properties.add("mergedatasource");
        properties.add("mergestatus");
        properties.add("calculatestatus");
        properties.add("pccalculatestatus");
        properties.add("flowstatus");
        properties.add("pcflowstatus");
        properties.add("checkstatus");
        properties.add("archivestatus");
        properties.add("chkstatus");
        properties.add("adjuststatus");
        properties.add("begintime");
        properties.add("endtime");
        properties.add("modifiername");
        properties.add("ecdataid");
        properties.add("pcdataid");
        properties.add("scenename");
        properties.add("isversioned");
        properties.add("ismerge");
        properties.add("flowusername");
        properties.add("flowtime");
        if (isFromCard) {
            return properties;
        }
        Pair<Long, List<Tuple<Long, String, String>>> dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo(modelId, sceneId, yearId, periodId);
        if ((Long)dataLockPlanInfo.p1 > 0L) {
            for (Tuple stageItem : (List)dataLockPlanInfo.p2) {
                properties.add("flowstatusstage" + (String)stageItem.p2);
                properties.add("pcflowstatusstage" + (String)stageItem.p2);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultBox checkOnProcessing(FixedItem ctx) {
        long modelId = ctx.getModelId();
        long scenarioId = ctx.getScenarioId();
        long yearId = ctx.getFyId();
        long periodId = ctx.getPeriodId();
        long orgId = ctx.getOrgId();
        try (DLock lock = DLock.create((String)("MergeControl-" + modelId));){
            try {
                if (lock.tryLock(10000L)) {
                    ResultBox resultBox = MergeProgressHelper.checkOnProcessing(modelId, orgId, scenarioId, yearId, periodId);
                    return resultBox;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return ResultBox.of();
    }

    public Long executeCslInOne(FixedItem fixedItem, MergeCondition condition) {
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long fyId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        long orgId = fixedItem.getOrgId();
        String modelNum = fixedItem.getModelNum();
        McStatus status = MergeStatusHelper.getMcStatus(modelId, scenarioId, fyId, periodId, orgId);
        if (status.getFlow().isNone() || status.getFlow().isNeeded()) {
            ExecuteContext ctx = this.fillExecuteContext(fixedItem, condition);
            DynamicObject mergeProgress = this.saveMergeProgressInfo(fixedItem, ctx.getUserId(), orgId, ctx.isMergeAll());
            long progressId = mergeProgress.getLong("id");
            ctx.setProgressId(progressId);
            ctx.setCslInOne(true);
            ctx.setEntryCtx(true);
            ctx.setEntryOrgId(orgId);
            JVMShutdownHook.monitorProgress(progressId);
            try {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                DynamicObjectCollection orgParents = MergeControlHelper.getOrgParents(modelId, orgNode.getLongNumber(), false);
                Collection parentIds = orgParents.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                MergeStatusHelper.batchUpdateCalcStatus(modelId, scenarioId, fyId, periodId, parentIds);
                DynamicObjectCollection orgChildren = ctx.isMergeAll() ? OrgServiceHelper.getAllOrgChildren(modelId, orgId, true) : OrgServiceHelper.getDirectOrgChildren(modelId, orgId, true);
                EntityVersioningUtil.filterVersionOrgTree((List<DynamicObject>)orgChildren, modelId, fyId, periodId, scenarioId);
                List<Long> childIds = orgChildren.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNum, (Long)scenarioId);
                boolean isVersioned = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
                if (isVersioned) {
                    Set<String> parentVersionOrgs = MergeEntityService.getInstance().getVersionedOrgs(modelId, scenarioId, fyId, periodId, childIds);
                    childIds.removeIf(o -> {
                        IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)modelId, (Long)o);
                        return !parentVersionOrgs.contains(org.getNumber());
                    });
                }
                this.mcService.batchInitMcData(modelId, scenarioId, fyId, periodId, childIds);
            }
            catch (Exception e) {
                logger.error("UpdateParentsStatus error: ", (Throwable)e);
            }
            ThreadPoolService.runInThreadForMerge(() -> {
                if (ConfigServiceHelper.getBoolParam(modelId, "isNewDispatcher")) {
                    new CslService2Dispatcher().dispatchService(ctx);
                } else {
                    new CslServiceDispatcher().dispatchService(ctx);
                }
            });
            return progressId;
        }
        return null;
    }

    public Long execAllMerge(FixedItem fixedItem) {
        MergeCondition condition = this.defaultMergeCondition();
        return this.executeCslInOne(fixedItem, condition);
    }

    public Long execAllMerge(FixedItem fixedItem, MergeCondition condition) {
        if (condition == null) {
            condition = this.defaultMergeCondition();
        }
        return this.executeCslInOne(fixedItem, condition);
    }

    public MergeCondition defaultMergeCondition() {
        MergeCondition condition = new MergeCondition();
        condition.setMergeScope(1);
        condition.setMergeCondition(2);
        condition.setEcRuleCondition(2);
        condition.setPcRuleCondition(2);
        condition.setInterCheckCondition(2);
        condition.setIntrElimCondition(2);
        condition.setCommonPaperElimCondition(2);
        condition.setInvElimCondition(2);
        return condition;
    }

    public ResultBox checkMerge(FixedItem fixedItem, OpItemEnum opEnum) {
        String msg;
        ResultBox result = ResultBox.of();
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long fyId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        long orgId = fixedItem.getOrgId();
        McStatus mcStatus = MergeStatusHelper.getMcStatus(modelId, scenarioId, fyId, periodId, orgId);
        if (mcStatus.getArchive().isArchive()) {
            msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s\u3002", (String)"MergeControlService_13", (String)"fi-bcm-business", (Object[])new Object[0]), opEnum.getName());
            result.add(msg);
        }
        if (mcStatus.getFlow().isSubmitOrApproval()) {
            msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u4e0d\u662f\u201c\u5904\u7406\u4e2d\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s\u3002", (String)"MergeControlService_12", (String)"fi-bcm-business", (Object[])new Object[0]), opEnum.getName());
            result.add(msg);
        }
        result.append(() -> this.checkOnProcessing(fixedItem));
        return result;
    }

    public ResultBox checkCalculate(FixedItem fixedItem, OpItemEnum opEnum) {
        ResultBox result = ResultBox.of();
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long fyId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        Collection orgList = fixedItem.getOrgList();
        if (MergeControlHelper.isQuoteScene(modelId, scenarioId)) {
            orgList = orgList.stream().filter(e -> MergeControlHelper.isVersionedOrg(modelId, scenarioId, fyId, periodId, (Long)e.getId())).collect(Collectors.toList());
        }
        Map<Long, McStatus> mcStatusMap = MergeStatusHelper.batchGetMcStatus(modelId, scenarioId, fyId, periodId, orgList.stream().map(o -> (Long)o.getId()).collect(Collectors.toList()));
        if (OpItemEnum.EXEC_CONVERT == opEnum) {
            boolean hasCvtFlowSuccess = mcStatusMap.values().stream().anyMatch(s -> s.getPcFlow().isSubmitOrApproval());
            if (hasCvtFlowSuccess) {
                String msg = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u6298\u7b97\u5e01\u62a5\u8868\u5408\u5e76\u6d41\u7a0b\u4e0d\u662f\u201c\u5904\u7406\u4e2d\u201d\uff0c\u4e0d\u53ef\u6267\u884c\u201c%s\u201d\u64cd\u4f5c\u3002", (String)"MergeControlService_14", (String)"fi-bcm-business", (Object[])new Object[0]), opEnum.getName());
                result.add(msg);
            }
        } else {
            String msg;
            boolean hasFlowArchive = mcStatusMap.values().stream().anyMatch(s -> s.getArchive().isArchive());
            boolean hasFlowSuccess = mcStatusMap.values().stream().anyMatch(s -> s.getFlow().isSubmitOrApproval());
            if (hasFlowArchive) {
                msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s\u3002", (String)"MergeControlService_13", (String)"fi-bcm-business", (Object[])new Object[0]), opEnum.getName());
                result.add(msg);
            } else {
                String periodNum;
                String yearNum;
                String sceneNum = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId).getNumber();
                boolean existArchiving = LockScopeServiceHelper.isExistArchiving(modelId, sceneNum, yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)fyId).getNumber(), periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber());
                if (existArchiving) {
                    String msg2 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4\u5df2\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s\u3002", (String)"MergeControlService_13", (String)"fi-bcm-business", (Object[])new Object[0]), opEnum.getName());
                    result.add(msg2);
                }
            }
            if (hasFlowSuccess) {
                msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u4e0d\u662f\u201c\u5904\u7406\u4e2d\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s\u3002", (String)"MergeControlService_12", (String)"fi-bcm-business", (Object[])new Object[0]), opEnum.getName());
                result.add(msg);
            }
        }
        return result;
    }

    public void executeCalculate(FixedItem fixedItem, MergeCondition condition) {
        ExecuteContext ctx = this.fillExecuteContext(fixedItem, condition);
        this.fillCtxProgressIds(fixedItem, ctx, MergeTaskTypeEnum.Calculate.getCode());
        new McCalculateDispatcher().dispatchService(ctx);
    }

    private void fillCtxProgressIds(FixedItem fixedItem, ExecuteContext ctx, String taskType) {
        HashMap progressIds = new HashMap(fixedItem.getOrgList().size());
        fixedItem.getOrgList().forEach(org -> {
            DynamicObject dyn = this.saveProgressInfo(fixedItem, (Long)org.getId(), taskType);
            progressIds.put(org.getId(), dyn.getLong("id"));
        });
        ctx.put("progressIds", progressIds);
    }

    public void fillCtxProgressIdByLeafOrg(FixedItem fixedItem, ExecuteContext ctx, String taskType) {
        DynamicObject dyn = this.saveProgressInfo(fixedItem, (Long)ctx.getOrg().getId(), taskType, false);
        ctx.setProgressId(dyn.getLong("id"));
    }

    public void fillCtxProgressIdForMergeSum(FixedItem fixedItem, ExecuteContext ctx, String taskType) {
        DynamicObject dyn = this.saveProgressInfo(fixedItem, (Long)ctx.getOrg().getId(), taskType, true);
        ctx.setProgressId(dyn.getLong("id"));
    }

    public void syncExecuteCalculate(FixedItem fixedItem, MergeCondition condition) {
        ExecuteContext ctx = this.fillExecuteContext(fixedItem, condition);
        new McCalculateDispatcher().doDispatchService(ctx);
    }

    public void executeCalculate(String modelNumber, String orgNumber, String sceneNumber, String yearNumber, String periodNumber) {
        if (StringUtils.isEmpty((String)modelNumber) || StringUtils.isEmpty((String)orgNumber) || StringUtils.isEmpty((String)sceneNumber) || StringUtils.isEmpty((String)yearNumber) || StringUtils.isEmpty((String)periodNumber)) {
            throw new IllegalArgumentException("The parameter cannot be null");
        }
        Long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        if (modelId == 0L) {
            throw new KDBizException("modelNumber is not exist");
        }
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNumber);
        if (orgNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new KDBizException("orgNumber is not exist");
        }
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelNumber, (String)sceneNumber);
        if (sceneNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new KDBizException("sceneNumber is not exist");
        }
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelNumber, (String)yearNumber);
        if (yearNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new KDBizException("yearNumber is not exist");
        }
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNumber);
        if (periodNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new KDBizException("periodNumber is not exist");
        }
        FixedItem fixedItem = FixedItem.newOne(SimpleItem.newOne(modelId, modelNumber), SimpleItem.newOne(sceneNode.getId(), sceneNumber), SimpleItem.newOne(yearNode.getId(), yearNumber), SimpleItem.newOne(periodNode.getId(), periodNumber));
        List<SimpleItem> orgList = Collections.singletonList(SimpleItem.newOne(orgNode.getId(), orgNumber));
        fixedItem.setOrgList(orgList);
        MergeCondition calculateCondition = this.getDefaultCalculateCondition();
        ExecuteContext ctx = this.fillExecuteContext(fixedItem, calculateCondition);
        this.fillCtxProgressIds(fixedItem, ctx, MergeTaskTypeEnum.Calculate.getCode());
        new McCalculateDispatcher().doDispatchService(ctx);
    }

    public MergeCondition getDefaultCalculateCondition() {
        MergeCondition calculateCondition = new MergeCondition();
        calculateCondition.setEcRuleCondition(2);
        calculateCondition.setCheckCondition(1);
        return calculateCondition;
    }

    public void executeConvert(FixedItem fixedItem, MergeCondition condition) {
        ExecuteContext ctx = this.fillExecuteContext(fixedItem, condition);
        this.fillCtxProgressIds(fixedItem, ctx, MergeTaskTypeEnum.Convert.getCode());
        new McConvertDispatcher().dispatchService(ctx);
    }

    public void execContribution(FixedItem fixedItem) {
        ExecuteContext ctx = this.fillExecuteContext(fixedItem, true);
        DynamicObject dyn = this.saveProgressInfo(fixedItem, (Long)ctx.getOrg().getId(), MergeTaskTypeEnum.Contribution.getCode());
        ctx.setProgressId(dyn.getLong("id"));
        new McContributionDispatcher().dispatchService(ctx);
        Long modelId = (Long)ctx.getModel().getId();
        Long orgId = (Long)ctx.getOrg().getId();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String opDescription = orgNode.getNumber() + " " + orgNode.getName() + " " + OpItemEnum.EXEC_CONTRIBUTION.getName() + ResultStatusEnum.SUCCESS.getName();
        OperationLogUtil.writeOperationLog(OpItemEnum.EXEC_CONTRIBUTION.getName(), opDescription, modelId, "bcm_mergecontrollist");
    }

    public DynamicObject saveProgressInfo(FixedItem fixedItem, Long orgId, String taskType) {
        return this.saveProgressInfo(fixedItem, orgId, taskType, true);
    }

    public DynamicObject saveProgressInfo(FixedItem fixedItem, Long orgId, String taskType, boolean containsChild) {
        return this.saveProgressInfo(fixedItem, orgId, taskType, true, true);
    }

    public DynamicObject saveProgressInfo(FixedItem fixedItem, Long orgId, String taskType, boolean containsChild, boolean isMergeAll) {
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        String yearNumber = fixedItem.getFyNum();
        int leafCount = 0;
        int subCount = 0;
        if (containsChild) {
            DynamicObjectCollection orgChildren = isMergeAll ? OrgServiceHelper.getAllOrgChildren(modelId, orgId, true) : OrgServiceHelper.getDirectOrgChildren(modelId, orgId, true);
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, yearNumber, periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgChildren);
            for (DynamicObject org : orgChildren) {
                if (org.getBoolean("isleaf")) {
                    ++leafCount;
                    continue;
                }
                ++subCount;
            }
        } else {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (org != IDNumberTreeNode.NotFoundTreeNode) {
                if (org.isLeaf()) {
                    leafCount = 1;
                } else {
                    subCount = 1;
                }
            }
        }
        if (MergeTaskTypeEnum.CheckUp.getCode().equals(taskType)) {
            QFBuilder filter = new QFBuilder("userid", "=", (Object)RequestContext.get().getCurrUserId());
            filter.add("orgid", "=", (Object)orgId);
            filter.add("fstatus", "=", (Object)ProgressStatusEnum.PROCESSING.getCode());
            filter.add("tasktype", "=", (Object)taskType);
            filter.add("issueid", "=", (Object)modelId);
            filter.add("scenarioid", "=", (Object)scenarioId);
            filter.add("yearid", "=", (Object)yearId);
            filter.add("periodid", "=", (Object)periodId);
            filter.add("orgleafcount", "=", (Object)leafCount);
            filter.add("orgsubcount", "=", (Object)subCount);
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_mergeprogressentity", (QFilter[])filter.toArray(), null, (int)-1);
            List<Long> ids = primaryKeys.stream().map(LongUtil::toLong).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                MergeProgressHelper.updateStatus(ProgressStatusEnum.TERMING.getCode(), ids);
                AbortThreadHelper.setMergerProcessAbortFlag(ids);
            }
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergeprogressentity");
        obj.set("userid", (Object)RequestContext.get().getCurrUserId());
        obj.set("orgid", (Object)orgId);
        obj.set("fstatus", (Object)ProgressStatusEnum.PROCESSING.getCode());
        obj.set("tasktype", (Object)taskType);
        obj.set("issueid", (Object)modelId);
        obj.set("scenarioid", (Object)scenarioId);
        obj.set("yearid", (Object)yearId);
        obj.set("periodid", (Object)periodId);
        obj.set("orgleafcount", (Object)leafCount);
        obj.set("orgsubcount", (Object)subCount);
        obj.set("begintime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        return obj;
    }

    public void batchCheckUpChk(FixedItem fixedItem, boolean containsChild, String autoCalFlag) {
        fixedItem.getOrgList().forEach(org -> {
            SimpleItem orgSI = SimpleItem.newOne(org.getId(), org.getNumber());
            DynamicObject dyn = this.saveProgressInfo(fixedItem, (Long)org.getId(), MergeTaskTypeEnum.CheckUp.getCode(), containsChild);
            this.checkUpChk(fixedItem, orgSI, dyn.getLong("id"), containsChild, autoCalFlag);
        });
    }

    public ResultBox stageOp(FixedItem fixedItem, Map<String, Object> dataMap) {
        String commitMethod;
        McContext mcContext = this.getMcContext(fixedItem);
        mcContext.setDataMap(dataMap);
        String opType = (String)dataMap.get("stageoptype");
        if (dataMap.get("isIgnoreOrgEffect") != null) {
            mcContext.setIgnoreOrgEffect(true);
        }
        FlowOpService flowService = "2".equals(commitMethod = (String)dataMap.get("commitmethod")) ? new FlowOpService(mcContext, opType, Boolean.TRUE) : new FlowOpService(mcContext, opType);
        return flowService.doSubmit();
    }

    public ResultBox archive(FixedItem fixedItem) {
        McContext mcContext = this.getMcContext(fixedItem);
        MergeArchiveExecutor srv = new MergeArchiveExecutor();
        return srv.doSubmit(mcContext);
    }

    public ResultBox cancelArchive(FixedItem fixedItem) {
        McContext mcContext = this.getMcContext(fixedItem);
        MergeCancelArchiveExecutor srv = new MergeCancelArchiveExecutor();
        return srv.doSubmit(mcContext);
    }

    public boolean checkApprPerm(Map<String, DynamicObject> org2Perm, String orgNumber, Long flowstepId) {
        if (org2Perm == null) {
            return true;
        }
        DynamicObject permClass = org2Perm.get(orgNumber);
        if (permClass == null) {
            return true;
        }
        if (permClass.getLong("permclass") == 0L) {
            return false;
        }
        return PermClassEntityHelper.isAuth(RequestContext.get().getCurrUserId(), permClass.getLong("permclass"), String.valueOf(flowstepId));
    }

    public boolean hasStepAuth(long modelId, Long userId, int flowSort, Long orgId) {
        int STEP_BACK = 100;
        int STEP_SUBMIT = 98;
        int STEP_PROCESSING = -1;
        if (flowSort == -1) {
            return true;
        }
        boolean hasData = (Boolean)ThreadCache.get((Object)("auth_info_exists_" + modelId), () -> QueryServiceHelper.exists((String)"bcm_auth_info", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray()));
        if (!hasData) {
            return true;
        }
        Set modelIds = (Set)ThreadCache.get((Object)"getLimitedModelListByUser", MemberPermHelper::getLimitedModelListByUser);
        if (modelIds.contains(modelId)) {
            return true;
        }
        Map permMap = (Map)ThreadCache.get((Object)("getAllPermissionByModel_" + modelId), () -> {
            QFilter range = new QFilter("model", "=", (Object)modelId).and("entityname", "=", (Object)"bcm_entitymembertree");
            String fields = "entityid,permclass.id";
            DynamicObjectCollection permColl = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)fields, (QFilter[])range.toArray());
            return permColl.stream().collect(Collectors.toMap(k -> k.getLong("entityid"), v -> v.getLong("permclass.id"), (dy1, dy2) -> dy1));
        });
        if (permMap.isEmpty()) {
            return true;
        }
        Long permClassId = (Long)permMap.get(orgId);
        if (permClassId == null) {
            return true;
        }
        Map authInfoMap = (Map)ThreadCache.get((Object)("getAuthInfoListByUserGroup_" + modelId), () -> {
            HashSet<Long> userorgroup = new HashSet<Long>(10);
            userorgroup.add(userId);
            Set<Long> groupid = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
            Set<String> grouprelid = PermClassEntityHelper.getRelGroupIds(groupid.stream().map(String::valueOf).collect(Collectors.toSet()));
            userorgroup.addAll(groupid);
            userorgroup.addAll(grouprelid.stream().map(Long::valueOf).collect(Collectors.toSet()));
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            qf.and("users", "in", userorgroup);
            String selectFields = "authclass.id,level1,level2,level3,level4,level5,level6,level7,level8,level9,level10,level11,level12,level13,level14";
            DynamicObjectCollection authInfoList = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qf.toArray());
            return authInfoList.stream().collect(Collectors.groupingBy(o -> o.getLong("authclass.id")));
        });
        List authInfoList = (List)authInfoMap.get(permClassId);
        DynamicObjectCollection flowSteps = (DynamicObjectCollection)ThreadCache.get((Object)("FlowStepApprovalInfo_" + modelId), () -> FlowStepServiceHelper.getFlowSteps(modelId));
        Map flowStepMap = flowSteps.stream().collect(Collectors.toMap(dy -> dy.getString("id"), Function.identity(), (dy1, dy2) -> dy1));
        for (DynamicObject auth : authInfoList) {
            for (int j = 1; j <= 14; ++j) {
                String authLevel = auth.getString("level" + j);
                if (StringUtils.isBlank((String)authLevel) || flowStepMap.get(authLevel) == null) continue;
                DynamicObject stepDyn = (DynamicObject)flowStepMap.get(authLevel);
                int sort = stepDyn.getInt("sort");
                if (sort == 100 && flowSort == 98) {
                    return true;
                }
                if (sort == 100 || flowSort >= sort) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, DynamicObject> getApprPerm(long modelId, Set<String> orgNumbers) {
        if (MemberPermHelper.ifUserHasRootPermByModel(RequestContext.get().getCurrUserId(), String.valueOf(modelId))) {
            return new HashMap<String, DynamicObject>();
        }
        HashMap<String, DynamicObject> org2Perm = new HashMap<String, DynamicObject>(16);
        QFilter filter = new QFilter("number", "in", orgNumbers);
        filter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        filter.and("model", "=", (Object)LongUtil.toLong((Object)modelId));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number", (QFilter[])filter.toArray());
        Map<String, Long> orgNumber2Id = query.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o.getLong("id")));
        QFilter perFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        perFilter.and("entityname", "=", (Object)"bcm_entitymembertree");
        perFilter.and("entityid", "in", orgNumber2Id.values());
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)"entityid, permclass", (QFilter[])perFilter.toArray());
        Map<Long, DynamicObject> orgId2Permclass = dc.stream().collect(Collectors.toMap(o -> o.getLong("entityid"), o -> o));
        for (String orgNumber : orgNumbers) {
            DynamicObject permClass = orgId2Permclass.get(orgNumber2Id.get(orgNumber));
            org2Perm.put(orgNumber, permClass);
        }
        return org2Perm;
    }

    private DynamicObjectCollection getDirectSubOrgChildren(long modelId, long scenarioId, long yearId, long periodId, long parentId) {
        DynamicObjectCollection orgChildren = OrgServiceHelper.getOrgChildren(modelId, parentId);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode fyNumber = MemberReader.findFyMemberById((String)modelNumber, (Long)yearId);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, fyNumber.getNumber(), periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgChildren);
        DynamicObjectCollection noMergeDoc = OrgServiceHelper.getNoMergeOrgList(orgChildren, modelId, scenarioId, yearId, periodId);
        orgChildren.removeAll((Collection)noMergeDoc);
        return orgChildren;
    }

    public String checkSubLevel(long modelId, long scenarioId, long yearId, long periodId, long parentId, int stepSort) {
        boolean isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus");
        if (isOpen) {
            return "";
        }
        DynamicObjectCollection orgChildren = this.getDirectSubOrgChildren(modelId, scenarioId, yearId, periodId, parentId);
        if (CollectionUtils.isEmpty((Collection)orgChildren)) {
            return "";
        }
        Set<Long> orgIds = orgChildren.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, MergeData> mcMap = this.mcService.batchGetMcData(modelId, scenarioId, yearId, periodId, orgIds);
        HashSet<Long> taskIds = new HashSet<Long>(16);
        HashMap<Long, String> orgMap = new HashMap<Long, String>(16);
        ArrayList<String> tipOrgNumberSet = new ArrayList<String>(10);
        for (DynamicObject org : orgChildren) {
            DynamicObject ecData;
            MergeData mergeData = mcMap.get(org.getLong("id"));
            if (mergeData == null || (ecData = mergeData.getEcData()) == null) continue;
            long taskId = ecData.getLong("flowtask");
            orgMap.put(taskId, ecData.getString("orgnumber"));
            if (taskId > 0L) {
                taskIds.add(taskId);
                continue;
            }
            if (taskId != 0L || stepSort <= 0 || mergeData.getMergeStatus().getFlow().isFlowSubmit()) continue;
            tipOrgNumberSet.add(org.getString("number"));
        }
        DynamicObjectCollection taskColl = FlowStepServiceHelper.getFlowTasks(taskIds);
        for (DynamicObject taskRecord : taskColl) {
            if (taskRecord.getInt("flowstep.sort") >= stepSort) continue;
            tipOrgNumberSet.add((String)orgMap.get(taskRecord.getLong("id")));
        }
        if (!tipOrgNumberSet.isEmpty()) {
            return String.join((CharSequence)",", tipOrgNumberSet);
        }
        return "";
    }

    public String checkSubLevelForStage(long modelId, long scenarioId, long yearId, long periodId, long parentId, int stepSort, long stageId) {
        boolean isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus");
        if (isOpen) {
            return "";
        }
        DynamicObjectCollection orgChildren = this.getDirectSubOrgChildren(modelId, scenarioId, yearId, periodId, parentId);
        if (CollectionUtils.isEmpty((Collection)orgChildren)) {
            return "";
        }
        Set<Long> orgIds = orgChildren.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, MergeData> mcMap = this.mcService.batchGetMcData(modelId, scenarioId, yearId, periodId, orgIds);
        HashSet<Long> taskIds = new HashSet<Long>(16);
        HashMap<Long, String> orgMap = new HashMap<Long, String>(16);
        ArrayList<String> tipOrgNumberSet = new ArrayList<String>(10);
        for (DynamicObject org : orgChildren) {
            MergeData mergeData = mcMap.get(org.getLong("id"));
            if (mergeData == null) continue;
            long taskId = 0L;
            Map<Long, DynamicObject> ecStageDataMap = mergeData.getEcStageDataMap();
            DynamicObject ecStageMergeData = ecStageDataMap.get(stageId);
            if (ecStageMergeData != null) {
                taskId = ecStageMergeData.getLong("flowtask");
                orgMap.put(taskId, ecStageMergeData.getString("mergecontrol.orgnumber"));
            }
            if (taskId > 0L) {
                taskIds.add(taskId);
            }
            if (taskId != 0L || stepSort <= 0 || mergeData.getMergeStatus().getFlow().isFlowSubmit()) continue;
            tipOrgNumberSet.add(org.getString("number"));
        }
        DynamicObjectCollection taskColl = FlowStepServiceHelper.getFlowTasks(taskIds);
        for (DynamicObject taskRecord : taskColl) {
            if (taskRecord.getInt("flowstep.sort") >= stepSort) continue;
            tipOrgNumberSet.add((String)orgMap.get(taskRecord.getLong("id")));
        }
        if (!tipOrgNumberSet.isEmpty()) {
            return String.join((CharSequence)",", tipOrgNumberSet);
        }
        return "";
    }

    public String checkSubPcStatus(long modelId, long scenarioId, long yearId, long periodId, long parentId) {
        boolean isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus");
        if (isOpen) {
            return "";
        }
        DynamicObjectCollection orgChildren = this.getDirectSubOrgChildren(modelId, scenarioId, yearId, periodId, parentId);
        if (CollectionUtils.isEmpty((Collection)orgChildren)) {
            return "";
        }
        Set<Long> orgIds = orgChildren.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(modelId, orgIds, scenarioId, yearId, periodId);
        ArrayList<String> tipOrgNumberSet = new ArrayList<String>(10);
        for (DynamicObject orgChild : orgChildren) {
            McStatus mcStatus = mcStatusMap.get(orgChild.getLong("id"));
            if (mcStatus.getPcFlow().isFlowSubmit()) continue;
            tipOrgNumberSet.add(orgChild.getString("number"));
        }
        if (!tipOrgNumberSet.isEmpty()) {
            return String.join((CharSequence)",", tipOrgNumberSet);
        }
        return "";
    }

    public String checkSubPcStatusForStage(long modelId, long scenarioId, long yearId, long periodId, long parentId, long stageId) {
        boolean isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus");
        if (isOpen) {
            return "";
        }
        DynamicObjectCollection orgChildren = this.getDirectSubOrgChildren(modelId, scenarioId, yearId, periodId, parentId);
        if (CollectionUtils.isEmpty((Collection)orgChildren)) {
            return "";
        }
        Set<Long> orgIds = orgChildren.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, MergeData> mcMap = this.mcService.batchGetMcData(modelId, scenarioId, yearId, periodId, orgIds);
        ArrayList<String> tipOrgNumberSet = new ArrayList<String>(10);
        for (DynamicObject orgChild : orgChildren) {
            MergeData mergeData = mcMap.get(orgChild.getLong("id"));
            Map<Long, StageMcStatus> stageMergeStatusMap = mergeData.getStageMergeStatusMap();
            StageMcStatus stageMcStatus = stageMergeStatusMap.getOrDefault(stageId, StageMcStatus.DefaultStageMcStatus);
            if (stageMcStatus.getPcFlow().isFlowSubmit()) continue;
            tipOrgNumberSet.add(orgChild.getString("number"));
        }
        if (!tipOrgNumberSet.isEmpty()) {
            return String.join((CharSequence)",", tipOrgNumberSet);
        }
        return "";
    }

    public Map<Long, Pair<String, String>> getChkCheckResult(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds, String processType) {
        DynamicObjectCollection chkReports;
        IDNumberTreeNode orgNode;
        DynamicObjectCollection orgColl = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, copyfrom", (QFilter[])new QFilter("id", "in", orgIds).toArray());
        Collection baseOrgIds = orgColl.stream().map(o -> o.getLong("copyfrom") == 0L ? o.getLong("id") : o.getLong("copyfrom")).collect(Collectors.toSet());
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId);
        boolean isVersioned = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter sceneFilter = new QFilter("scenario", "=", (Object)scenarioId);
        QFilter yearFilter = new QFilter("year", "=", (Object)yearId);
        QFilter periodFilter = new QFilter("period", "=", (Object)periodId);
        if (isVersioned) {
            long quoteSceneId = (Long)sceneNode.getProperty("scenequote.id");
            Set<String> versionedOrgNums = MergeEntityService.getInstance().getVersionedOrgs(modelId, scenarioId, yearId, periodId, orgIds);
            HashSet<Long> versionedOrgIds = new HashSet<Long>(versionedOrgNums.size());
            HashSet<Long> unVersionedOrgIds = new HashSet<Long>(16);
            for (Long orgId : baseOrgIds) {
                orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                if (orgNode.getId() <= 0L) continue;
                if (versionedOrgNums.contains(orgNode.getNumber())) {
                    versionedOrgIds.add(orgId);
                    continue;
                }
                unVersionedOrgIds.add(orgId);
            }
            QFilter versionedOrgFilter = new QFilter("org", "in", versionedOrgIds);
            QFilter[] versionedFilter = new QFilter[]{modelFilter, sceneFilter, yearFilter, periodFilter, versionedOrgFilter};
            chkReports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id, org, chkresulttype, currency, process, orgparent,chkformula.id", (QFilter[])versionedFilter);
            QFilter sourceSceneFilter = new QFilter("scenario", "=", (Object)quoteSceneId);
            QFilter unVersionedOrgFilter = new QFilter("org", "in", unVersionedOrgIds);
            QFilter[] unVersionedFilter = new QFilter[]{modelFilter, sourceSceneFilter, yearFilter, periodFilter, unVersionedOrgFilter};
            chkReports.addAll(QueryServiceHelper.query((String)"bcm_chkreport", (String)"id, org, chkresulttype, currency, process, orgparent,chkformula.id", (QFilter[])unVersionedFilter));
        } else {
            QFilter orgFilter = new QFilter("org", "in", (Object)baseOrgIds);
            QFilter[] filter = new QFilter[]{modelFilter, sceneFilter, yearFilter, periodFilter, orgFilter};
            chkReports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id, org, chkresulttype, currency, process, orgparent,chkformula.id", (QFilter[])filter);
        }
        Map<Object, Object> orgChkMap = new HashMap(16);
        if (!chkReports.isEmpty()) {
            List chkSettingIds = chkReports.stream().map(report -> report.getLong("chkformula.id")).collect(Collectors.toList());
            DynamicObjectCollection chkSetting = QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,status", (QFilter[])new QFBuilder("id", "in", chkSettingIds).toArray());
            Set enableSetting = chkSetting.stream().filter(setting -> CHKFormulaStatusEnum.enable.getIndex().equals(setting.getString("status"))).map(set -> set.getLong("id")).collect(Collectors.toSet());
            orgChkMap = chkReports.stream().filter(rep -> enableSetting.contains(rep.getLong("chkformula.id"))).collect(Collectors.groupingBy(e -> e.getLong("org")));
        }
        HashMap<Long, Pair<String, String>> orgId2ChkCheckResult = new HashMap<Long, Pair<String, String>>(16);
        Map currencys = MemberReader.getAllNodeFromCache((String)"bcm_currencymembertree", (Object)modelId);
        Map processs = MemberReader.getAllNodeFromCache((String)"bcm_processmembertree", (Object)modelId);
        Map<Long, String> orgId2CurrencyNumber = OrgCurrencyServiceHelper.getOrgsCurrency(new QFilter("id", "in", orgIds).toArray(), yearId, periodId).stream().filter(o -> o.get("currency.number") != null).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("currency.number")));
        for (Long orgId : orgIds) {
            DynamicObject currencyDy;
            List chkList;
            orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            long baseId = orgId;
            if (orgNode.isShare()) {
                baseId = orgNode.getBaseTreeNode().getId();
            }
            if ((chkList = (List)orgChkMap.get(baseId)) == null) continue;
            String orgEC = orgId2CurrencyNumber.get(orgId);
            IDNumberTreeNode parentNode = orgNode.getParent();
            if (orgEC == null || parentNode == null) continue;
            Long parentId = parentNode.getId();
            String parentNumber = parentNode.getNumber();
            String orgPC = orgId2CurrencyNumber.get(parentId);
            if (orgPC == null && !parentNumber.equals("Entity") && (currencyDy = OrgCurrencyServiceHelper.getCurrencyDynById(parentId, yearId, periodId)) != null) {
                orgPC = currencyDy.getString("number");
            }
            String ecResult = "C";
            String pcResult = "C";
            for (DynamicObject report2 : chkList) {
                IDNumberTreeNode process;
                long orgparentId = report2.getLong("orgparent");
                if (orgparentId != 0L && orgparentId != parentId || (process = (IDNumberTreeNode)processs.get(report2.getLong("process"))) == null || process.getId() == -1L) continue;
                String processNumber = process.getNumber();
                IDNumberTreeNode currency = (IDNumberTreeNode)currencys.get(report2.getLong("currency"));
                if (currency == null || currency.getId() == -1L) continue;
                String reportCurrency = currency.getNumber();
                String chkResultType = report2.getString("chkresulttype");
                if (!chkResultType.equals(String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()))) continue;
                if (processType != null) {
                    if (!this.getRealProcessSet(processType).contains(processNumber)) continue;
                    if (processType.equals("erpt")) {
                        ecResult = "U";
                        break;
                    }
                    if (orgPC == null || !orgPC.equals(reportCurrency)) continue;
                    pcResult = "U";
                    break;
                }
                if (ecResult.equals("C") && orgEC.equals(reportCurrency) && this.getRealProcessSet("erpt").contains(processNumber)) {
                    ecResult = "U";
                    continue;
                }
                if (!pcResult.equals("C") || orgPC == null || !orgPC.equals(reportCurrency) || !this.getRealProcessSet("rpt").contains(processNumber)) continue;
                pcResult = "U";
            }
            orgId2ChkCheckResult.put(orgId, (Pair<String, String>)Pair.onePair((Object)ecResult, (Object)pcResult));
        }
        return orgId2ChkCheckResult;
    }

    public List<Tuple<Long, String, String>> getUnCommitOrgs(FixedItem fixedItem, int mergeScope) {
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long fyId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        long orgId = fixedItem.getOrgId();
        String fyNum = fixedItem.getFyNum();
        DynamicObjectCollection children = mergeScope == 1 ? OrgServiceHelper.getAllOrgChildren(modelId, orgId) : OrgServiceHelper.getOrgChildren(modelId, orgId);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, fyNum, periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)children);
        List<Long> orgIds = children.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        ArrayList commitOrgIds = new ArrayList(orgIds.size());
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(modelId, orgIds, scenarioId, fyId, periodId);
        mcStatusMap.forEach((o, m) -> {
            if (m.getFlow().isFlowSubmit()) {
                commitOrgIds.add(o);
            }
        });
        return children.stream().filter(o -> !commitOrgIds.contains(o.getLong("id"))).map(s -> new Tuple((Object)MemberReader.findEntityMemberById((Long)modelId, (Long)s.getLong("id")).getBaseTreeNode().getId(), (Object)s.getString("number"), (Object)s.getString("name"))).collect(Collectors.toList());
    }

    public void checkUpChk(FixedItem fixedItem, SimpleItem org, long progressId, boolean containsChild, String autoCalFlag) {
        this.checkUpChk(fixedItem, org, progressId, containsChild, autoCalFlag, true);
    }

    public void checkUpChk(FixedItem fixedItem, SimpleItem org, long progressId, boolean containsChild, String autoCalFlag, boolean isMergeAll) {
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long periodId = fixedItem.getPeriodId();
        long orgId = (Long)org.getId();
        String yearNum = fixedItem.getFyNum();
        String periodNum = fixedItem.getPeriodNum();
        String orgNumber = org.getNumber();
        HashMap<Long, String> orgMap = new HashMap<Long, String>(16);
        if (!containsChild) {
            orgMap.put(orgId, orgNumber);
        } else {
            DynamicObjectCollection allChildren = isMergeAll ? OrgServiceHelper.getAllOrgChildren(modelId, orgId, true) : OrgServiceHelper.getDirectOrgChildren(modelId, orgId, true);
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, yearNum, periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)allChildren);
            for (DynamicObject dot : allChildren) {
                orgMap.put(dot.getLong("id"), dot.getString("number"));
            }
        }
        CountDownLatch latch = new CountDownLatch(orgMap.size());
        for (Map.Entry entry : orgMap.entrySet()) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)entry.getKey()));
            IDNumberTreeNode parentOrgNode = orgNode.getParent();
            ThreadPoolService.runMergeChkThread(() -> {
                block10: {
                    if (containsChild && progressId != 0L && AbortThreadHelper.isAbortMergerProcess(progressId)) {
                        latch.countDown();
                        return;
                    }
                    try {
                        String pc;
                        if (parentOrgNode == null) break block10;
                        String ec = orgNode.getCurrency();
                        MergeChkCheckContext mergeChkCheckContext = new MergeChkCheckContext(fixedItem.getModel(), SimpleItem.newOne(orgNode.getId(), orgNode.getNumber()), fixedItem.getFy(), fixedItem.getPeriod(), fixedItem.getScenario(), SimpleItem.newOne(parentOrgNode.getId(), parentOrgNode.getNumber()), ec);
                        if (autoCalFlag.equals("0") || autoCalFlag.equals("1")) {
                            logger.info("MergeCheck_EC begin");
                            try {
                                MsServiceHelper.invokeMergeChkService((String)mergeChkCheckContext.toString());
                            }
                            catch (Exception e) {
                                logger.error("MergeCheck_EC error", (Throwable)e);
                            }
                            logger.info("MergeCheck_EC end");
                        }
                        if ((pc = parentOrgNode.getCurrency()) != null && !pc.equals(ec) && (autoCalFlag.equals("0") || autoCalFlag.equals("2"))) {
                            logger.info("MergeCheck_PC begin");
                            mergeChkCheckContext.setCurrencyNum(pc);
                            MsServiceHelper.invokeMergeChkService((String)mergeChkCheckContext.toString());
                            logger.info("MergeCheck_PC end");
                        }
                    }
                    catch (Exception e) {
                        logger.error("MergeCheckErrorInfo:\n", (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
            if (progressId != 0L) {
                ProgressStatusEnum status = AbortThreadHelper.isAbortMergerProcess(progressId) ? ProgressStatusEnum.TERMINATION : ProgressStatusEnum.SUCCESS;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)progressId, (String)"bcm_mergeprogressentity");
                dynamicObject.set("fstatus", (Object)status.getCode());
                dynamicObject.set("endtime", (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                String opDescription = String.format("%1$s %2$s %3$s %4$s %5$s", orgNumber, yearNum, periodNum, MergeTaskTypeEnum.CheckUp.getText(), status.getText());
                OperationLogUtil.writeOperationLog(MergeTaskTypeEnum.CheckUp.getText(), opDescription, modelId, "bcm_mergecontrollist");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            GlobalCacheServiceHelper.invalidateCacheByKey((String)("chkcheckcache_mergeChk-allChkFormulaModel-" + fixedItem.getModelNum()));
        }
    }

    private McContext getMcContext(FixedItem fixedItem) {
        return new McContext(fixedItem.getModel(), fixedItem.getScenario(), fixedItem.getFy(), fixedItem.getPeriod(), fixedItem.getOrgList());
    }

    private ExecuteContext fillExecuteContext(FixedItem fixedItem, boolean isForceExec) {
        ExecuteContext ctx = new ExecuteContext(fixedItem.getModel(), fixedItem.getOrg(), fixedItem.getFy(), fixedItem.getPeriod(), fixedItem.getScenario(), isForceExec);
        ctx.setUserId(RequestContext.get().getCurrUserId());
        Collection<SimpleItem> orgList = fixedItem.getOrgList();
        if (CollectionUtils.isNotEmpty(orgList)) {
            StringBuilder str = new StringBuilder();
            orgList.forEach(t -> str.append((Long)t.getId()).append(",").append(t.getNumber()).append(";"));
            str.deleteCharAt(str.length() - 1);
            ctx.put("orgs", str.toString());
        }
        return ctx;
    }

    private ExecuteContext fillExecuteContext(FixedItem fixedItem, MergeCondition condition) {
        boolean isForceExec = condition != null && condition.getMergeCondition() == 2;
        ExecuteContext ctx = this.fillExecuteContext(fixedItem, isForceExec);
        if (condition != null) {
            ctx.setMergeAll(condition.getMergeScope() == 1);
            ctx.setSkipCheck(condition.getInterCheckCondition() == 1);
            ctx.setSkipPcRule(condition.getPcRuleCondition() == 1);
            ctx.setSkipEcRule(condition.getEcRuleCondition() == 1);
            ctx.setSkipInvElim(condition.getInvElimCondition() == 1);
            ctx.setSkipCommPaperElim(condition.getCommonPaperElimCondition() == 1);
            ctx.setSkipIntrElim(condition.getIntrElimCondition() == 1);
        }
        return ctx;
    }

    public ExecuteContext fillExecuteContextForTask(FixedItem fixedItem, MergeCondition condition) {
        return this.fillExecuteContext(fixedItem, condition);
    }

    private DynamicObject saveMergeProgressInfo(FixedItem fixedItem, long userId, long orgId, boolean isAll) {
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long fyId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        String fyNum = fixedItem.getFyNum();
        DynamicObjectCollection orgChildren = isAll ? OrgServiceHelper.getAllOrgChildren(modelId, orgId, true) : OrgServiceHelper.getDirectOrgChildren(modelId, orgId, true);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, fyNum, periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgChildren);
        int leafCount = 0;
        int subOrgCount = 0;
        ArrayList<Long> subOrgIds = new ArrayList<Long>();
        for (DynamicObject org : orgChildren) {
            if (org.getBoolean("isleaf")) {
                ++leafCount;
                continue;
            }
            ++subOrgCount;
            subOrgIds.add(org.getLong("id"));
        }
        Date now = TimeServiceHelper.now();
        long id = GlobalIdUtil.genGlobalLongId();
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergeprogressentity");
        obj.set("id", (Object)id);
        obj.set("userid", (Object)userId);
        obj.set("orgid", (Object)orgId);
        obj.set("fstatus", (Object)ProgressStatusEnum.PROCESSING.getCode());
        obj.set("tasktype", (Object)MergeTaskTypeEnum.OneKeyMerge.getCode());
        obj.set("issueid", (Object)modelId);
        obj.set("scenarioid", (Object)scenarioId);
        obj.set("yearid", (Object)fyId);
        obj.set("periodid", (Object)periodId);
        obj.set("orgleafcount", (Object)leafCount);
        obj.set("orgsubcount", (Object)subOrgCount);
        obj.set("begintime", (Object)now);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        ProgressCacheHelper.initProcess(id);
        QFilter qcf = new QFilter("model", "=", (Object)modelId);
        qcf.and("scenario", "=", (Object)LongUtil.toLong((Object)scenarioId));
        qcf.and("year", "=", (Object)fyId);
        qcf.and("period", "=", (Object)periodId);
        qcf.and("org", "in", subOrgIds);
        DynamicObjectCollection mergeDataSets = QueryServiceHelper.query((String)"bcm_mergesetentity", (String)"org, mergedatasource", (QFilter[])new QFilter[]{qcf});
        HashMap<Long, String> mdsMap = new HashMap<Long, String>(mergeDataSets.size());
        for (DynamicObject mds : mergeDataSets) {
            mdsMap.put(mds.getLong("org"), mds.getString("mergedatasource"));
        }
        long logId = obj.getLong("id");
        ArrayList<DynamicObject> mergeSetLogs = new ArrayList<DynamicObject>(subOrgIds.size());
        for (Long tempOrgId : subOrgIds) {
            DynamicObject mergeSetLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergedatasetlog");
            mergeSetLog.set("logid", (Object)logId);
            mergeSetLog.set("org", (Object)tempOrgId);
            mergeSetLog.set("modifier", (Object)userId);
            mergeSetLog.set("modifytime", (Object)now);
            String value = (String)mdsMap.get(tempOrgId);
            if (null != value) {
                mergeSetLog.set("mergedatasource", (Object)value);
            } else {
                mergeSetLog.set("mergedatasource", (Object)MergeDataSourceEnum.SIRpt.getIndex());
            }
            mergeSetLogs.add(mergeSetLog);
        }
        SaveServiceHelper.save((DynamicObject[])mergeSetLogs.toArray(new DynamicObject[0]));
        return obj;
    }

    public ResultBox updateCheckStatus(FixedItem fixedItem, boolean isComplete, Boolean includeChildren) {
        McContext mcContext = this.getMcContext(fixedItem);
        HashMap<String, Object> includeMap = new HashMap<String, Object>(2);
        includeMap.put("includeChildren", includeChildren);
        mcContext.setDataMap(includeMap);
        CheckCompleteExecutor srv = isComplete ? new CheckCompleteExecutor() : new CheckCancelCompleteExecutor();
        return srv.doSubmit(mcContext);
    }

    public ResultBox versioned(FixedItem fixedItem, Map<String, Object> resultMap) {
        McContext mcContext = this.getMcContext(fixedItem);
        mcContext.setDataMap(resultMap);
        DataVersionedExecutor srv = new DataVersionedExecutor();
        return srv.doSubmit(mcContext);
    }

    public ResultBox cancelVersioned(FixedItem fixedItem, Map<String, Object> resultMap) {
        McContext mcContext = this.getMcContext(fixedItem);
        mcContext.setDataMap(resultMap);
        DataCancelVersionedExecutor srv = new DataCancelVersionedExecutor();
        return srv.doSubmit(mcContext);
    }

    private boolean isSendMessageByCslExecute(Long modelId) {
        return ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.IS_NOTICE_BY_MERGE.getNumber());
    }

    private String getOrgsCacheKey(Long progressId) {
        return "CslExecuteOrgs_" + progressId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrgCacheByCalc(Long progressId, String orgNumber, Long modelId) {
        block18: {
            if (!this.isSendMessageByCslExecute(modelId)) {
                return;
            }
            String cacheKey = this.getOrgsCacheKey(progressId);
            long millis = 10000L;
            try (DLock lock = DLock.create((String)cacheKey);){
                if (lock.tryLock(millis)) {
                    try {
                        HashSet<String> orgNumbers = AppCacheServiceHelper.get(cacheKey, Set.class);
                        if (null == orgNumbers) {
                            orgNumbers = new HashSet<String>(16);
                        }
                        orgNumbers.add(orgNumber);
                        AppCacheServiceHelper.put(cacheKey, orgNumbers, 1800);
                        break block18;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                logger.info(String.format("\u8fdb\u5ea6[%s]\u4e2d\u7ec4\u7ec7[%s]\u5b58\u5165\u8ba1\u7b97\u6d88\u606f\u901a\u77e5\u7f13\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u8d85\u65f6", progressId, orgNumber));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageByCalc(Long progressId, Long entryOrgId, FixedItem fixedItem) {
        Long modelId = fixedItem.getModelId();
        String cacheKey = this.getOrgsCacheKey(progressId);
        Set orgNumbers = AppCacheServiceHelper.get(cacheKey, Set.class);
        if (CollectionUtils.isEmpty((Collection)orgNumbers) || !this.isSendMessageByCslExecute(modelId)) {
            return;
        }
        try {
            Map<String, Set<Long>> org2users = MemberPermHelper.getHasEntityPermByNumber(fixedItem.getModelId(), orgNumbers.stream().collect(Collectors.toList()));
            List<Long> userList = org2users.values().stream().flatMap(s -> s.stream()).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userList)) {
                return;
            }
            String orgName = MemberReader.findEntityMemberById((Long)modelId, (Long)entryOrgId).getName();
            String scene = MemberReader.findScenaMemberById((Long)modelId, (Long)fixedItem.getScenarioId()).getName();
            String fy = MemberReader.findFyMemberById((Long)modelId, (Long)fixedItem.getFyId()).getName();
            String period = MemberReader.findPeriodMemberById((Long)modelId, (Long)fixedItem.getPeriodId()).getName();
            String username = RequestContext.get().getUserName();
            String title = ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6d88\u606f\u901a\u77e5", (String)"MergeControlService_17", (String)"fi-bcm-business", (Object[])new Object[0]);
            String content = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011\u3010%5$s\u3011\u6267\u884c\u4e86\u667a\u80fd\u5408\u5e76", (String)"MergeControlService_18", (String)"fi-bcm-business", (Object[])new Object[0]), username, scene, fy, period, orgName);
            MessageServiceUtil.sendMessageByNotice(title, content, userList);
        }
        finally {
            AppCacheServiceHelper.remove(cacheKey);
        }
    }

    private void sendMessageByReminder(DynamicObject currentOrg, List<String> orgNumbers, String title) {
        if (CollectionUtils.isEmpty(orgNumbers)) {
            return;
        }
        DynamicObject parent = (DynamicObject)currentOrg.getParent();
        Long modelId = parent.getLong("model.id");
        Map<String, Set<Long>> org2users = MemberPermHelper.getHasEntityPermByNumber(modelId, orgNumbers);
        if (org2users.isEmpty()) {
            return;
        }
        String contentFmt = ResManager.loadKDString((String)"\u8bf7\u6309\u65f6\u63d0\u4ea4\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011", (String)"MergeControlService_19", (String)"fi-bcm-business", (Object[])new Object[0]);
        String modelNumber = parent.getString("model.number");
        String fy = parent.getString("year.name");
        String scene = parent.getString("scenario.name");
        String period = parent.getString("period.name");
        HashMap user2Orgs = Maps.newHashMap();
        for (Map.Entry<String, Set<Long>> entry : org2users.entrySet()) {
            for (Long user : entry.getValue()) {
                user2Orgs.computeIfAbsent(user, e -> Sets.newHashSet()).add(entry.getKey());
            }
        }
        for (Map.Entry<String, Set<Long>> entry : user2Orgs.entrySet()) {
            Long user = (Long)((Object)entry.getKey());
            Set orgNames = entry.getValue().stream().map(e -> MemberReader.findEntityMemberByNum((String)modelNumber, (String)e).getName()).collect(Collectors.toSet());
            String content = String.format(contentFmt, scene, fy, period, String.join((CharSequence)",", orgNames));
            MessageServiceUtil.sendMessageByNotice(title, content, Lists.newArrayList((Object[])new Long[]{user}));
        }
    }

    public void mergeReminder(FixedItem fixedItem, DynamicObject currentOrg) {
        DynamicObjectCollection orgTree = this.getOrgTreeSimple(fixedItem, currentOrg.getLong("id"), false, false, false);
        OrgServiceHelper.delNoMergeOrgListAllChildren(orgTree, fixedItem.getModelId(), fixedItem.getScenarioId(), fixedItem.getFyId(), fixedItem.getPeriodId(), currentOrg.getLong("id"));
        if (CollectionUtils.isEmpty((Collection)orgTree)) {
            return;
        }
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        Set<Long> orgIds = orgTree.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, MergeData> mcDataMap = this.mcService.batchGetMcData(modelId, scenarioId, yearId, periodId, orgIds);
        List<String> orgNumbers = mcDataMap.entrySet().stream().filter(e -> !Objects.equals("C", ((MergeData)e.getValue()).getMergeStatus().getFlow().getStatus())).map(e -> ((MergeData)e.getValue()).getOrgNode().getNumber()).collect(Collectors.toList());
        String title = ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6d41\u7a0b\u50ac\u62a5", (String)"MergeControlService_20", (String)"fi-bcm-business", (Object[])new Object[0]);
        this.sendMessageByReminder(currentOrg, orgNumbers, title);
    }

    public String taskReminder(FixedItem fixedItem, DynamicObject currentOrg) {
        DynamicObjectCollection orgTree = this.getOrgTreeSimple(fixedItem, currentOrg.getLong("id"), false, false, false);
        OrgServiceHelper.delNoMergeOrgListAllChildren(orgTree, fixedItem.getModelId(), fixedItem.getScenarioId(), fixedItem.getFyId(), fixedItem.getPeriodId(), currentOrg.getLong("id"));
        if (CollectionUtils.isEmpty((Collection)orgTree)) {
            return null;
        }
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        List<TaskRecordModel> taskRecordList = UserTaskHelper.getTaskRecordByMerge(modelId, scenarioId, yearId, periodId);
        if (CollectionUtils.isEmpty(taskRecordList)) {
            String resultMsg = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\u5408\u5e76\u4efb\u52a1\u3002", (String)"MergeControlService_22", (String)"fi-bcm-business", (Object[])new Object[0]);
            return resultMsg;
        }
        if (TaskReocrdStatusEnum.COMPLETE == taskRecordList.get(0).getTaskRecordStatus()) {
            String resultMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5408\u5e76\u4efb\u52a1\u201c%s\u201d\u5df2\u5b8c\u6210\u3002", (String)"MergeControlService_23", (String)"fi-bcm-business", (Object[])new Object[0]), taskRecordList.get(0).getTaskTemplateModel().getName());
            return resultMsg;
        }
        Set<Long> orgIds = QueryMemberDetailsHelper.change2BaseMember(orgTree.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        String selectProperties = "id,member";
        DynamicObjectCollection userTaskList = UserTaskHelper.queryUserTaskList(modelId, orgIds, taskRecordList.stream().map(e -> e.getId()).collect(Collectors.toSet()), TaskStatusEnum.PROCESSING, selectProperties);
        if (CollectionUtils.isEmpty((Collection)userTaskList)) {
            String resultMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u201c%s\u201d\u8303\u56f4\u5185\u4e0d\u5b58\u5728\u5408\u5e76\u4efb\u52a1\u3002", (String)"MergeControlService_24", (String)"fi-bcm-business", (Object[])new Object[0]), currentOrg.getString("name"));
            return resultMsg;
        }
        List<String> orgNumbers = userTaskList.stream().map(e -> MemberReader.findEntityMemberById((Long)modelId, (Long)e.getLong("member")).getNumber()).collect(Collectors.toList());
        String title = ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u4efb\u52a1\u50ac\u62a5", (String)"MergeControlService_21", (String)"fi-bcm-business", (Object[])new Object[0]);
        this.sendMessageByReminder(currentOrg, orgNumbers, title);
        return null;
    }

    public DynamicObjectCollection getOrgTreeSimple(FixedItem fixedItem, Long pid, boolean isContainSelf, boolean onlyMergeOrg, boolean isContainName) {
        DynamicObjectCollection orgTree = new DynamicObjectCollection();
        long modelId = fixedItem.getModelId();
        long scenarioId = fixedItem.getScenarioId();
        long yearId = fixedItem.getFyId();
        long periodId = fixedItem.getPeriodId();
        String yearNum = fixedItem.getFyNum();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)pid);
        ArrayList<IDNumberTreeNode> list = new ArrayList<IDNumberTreeNode>(1 + orgNode.getAllChildren().size());
        if (isContainSelf) {
            list.add(orgNode);
        }
        list.addAll(orgNode.getAllChildren());
        DynamicObjectType entityType = this.getOrg(modelId, pid, isContainName).getDynamicObjectType();
        for (IDNumberTreeNode node : list) {
            DynamicObject org = new DynamicObject(entityType);
            org.set("id", (Object)node.getId());
            org.set("number", (Object)node.getNumber());
            org.set("memberid", (Object)node.getId());
            org.set("copyfrom", (Object)node.getCopyfromId());
            if (isContainName) {
                org.set("name", (Object)node.getName());
            }
            orgTree.add((Object)org);
        }
        List<Long> allOrgId = orgTree.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Set<Long> noPermMembers = PermissionServiceImpl.getInstance(modelId).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", allOrgId);
        List dynList = orgTree.stream().filter(o -> !noPermMembers.contains(o.getLong("id"))).collect(Collectors.toList());
        orgTree = new DynamicObjectCollection();
        orgTree.addAll(dynList);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, yearNum, periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgTree);
        if (onlyMergeOrg) {
            OrgServiceHelper.delNoMergeOrgListAll(orgTree, modelId, scenarioId, yearId, periodId);
        } else if (isContainName) {
            OrgServiceHelper.dealNoMergeOrgList(orgTree, modelId, scenarioId, yearId, periodId);
        }
        return orgTree;
    }

    private DynamicObjectCollection getOrg(Long modelId, long orgId, boolean isContainName) {
        QFilter qcs = new QFilter("model", "=", (Object)modelId);
        qcs.and("id", "=", (Object)orgId);
        String ORGSELECT_FIELDS = "id,id as memberid,number,copyfrom";
        if (isContainName) {
            ORGSELECT_FIELDS = ORGSELECT_FIELDS + ",name";
        }
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)ORGSELECT_FIELDS, (QFilter[])new QFilter[]{qcs});
    }
}

