/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.UserUtils;

public class MergeEntityService {
    private static final Log logger = LogFactory.getLog(MergeEntityService.class);

    private MergeEntityService() {
    }

    public static MergeEntityService getInstance() {
        return new MergeEntityService();
    }

    public boolean isQuoteScene(Long modelId, Long scenarioId) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId);
        return Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
    }

    public long getSrcScene(Long modelId, Long scenarioId) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId);
        if (Boolean.TRUE.equals(sceneNode.getProperty("isversioned"))) {
            return (Long)sceneNode.getProperty("scenequote.id");
        }
        return scenarioId;
    }

    public boolean isVersionedOrg(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        Set<String> versionedOrgs = this.getAllVersionedOrgs(modelId, scenarioId, yearId, periodId);
        if (versionedOrgs.isEmpty()) {
            return false;
        }
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        return versionedOrgs.contains(orgNode.getNumber());
    }

    public Set<String> getVersionedOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        Collection<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        return this.queryVersionedOrgs(modelId, scenarioId, yearId, periodId, orgNumbers);
    }

    public Set<String> getAllVersionedOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        return this.queryAllVersionedOrgs(modelId, scenarioId, yearId, periodId);
    }

    private Set<String> queryAllVersionedOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("isversioned", "=", (Object)true);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_mergeentitycontrol", (String)"orgnumber", (QFilter[])qcf.toArray());
        return dyns.stream().map(d -> d.getString("orgnumber")).collect(Collectors.toSet());
    }

    private Set<String> queryVersionedOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<String> orgNumbers) {
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers).and("isversioned", "=", (Object)true);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_mergeentitycontrol", (String)"orgnumber", (QFilter[])qcf.toArray());
        return dyns.stream().map(d -> d.getString("orgnumber")).collect(Collectors.toSet());
    }

    public DynamicObject[] batchLoadMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return new DynamicObject[0];
        }
        Collection<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers);
        return BusinessDataServiceHelper.load((String)"bcm_mergeentitycontrol", (String)"id,orgnumber,isversioned,modifytime", (QFilter[])qcf.toArray());
    }

    public void batchInitMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        Collection<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(orgIds.size());
        List<DynamicObject> dynList = this.batchQueryMcData(modelId, scenarioId, yearId, periodId, orgNumbers);
        Map mcMap = dynList.stream().collect(Collectors.toMap(d -> d.getString("orgnumber"), Function.identity(), (d1, d2) -> d1));
        for (String orgNumber : orgNumbers) {
            DynamicObject dyn = (DynamicObject)mcMap.get(orgNumber);
            if (dyn != null) continue;
            dataList.add(this.buildMcObject(modelId, scenarioId, yearId, periodId, orgNumber));
        }
        if (dataList.isEmpty()) {
            return;
        }
        try {
            SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]));
        }
        catch (Exception ex) {
            logger.error("Batch Init MergeStatus Error: ", (Throwable)ex);
        }
    }

    private List<DynamicObject> batchQueryMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<String> orgNumbers) {
        if (orgNumbers.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers);
        return QueryServiceHelper.query((String)"bcm_mergeentitycontrol", (String)"id,orgnumber,isversioned", (QFilter[])qcf.toArray());
    }

    private DynamicObject buildMcObject(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgNumber) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergeentitycontrol");
        obj.set("model", (Object)modelId);
        obj.set("scenario", (Object)scenarioId);
        obj.set("year", (Object)yearId);
        obj.set("period", (Object)periodId);
        obj.set("orgNumber", (Object)orgNumber);
        obj.set("creator", (Object)UserUtils.getUserId());
        obj.set("createtime", (Object)TimeServiceHelper.now());
        return obj;
    }

    public String packKey(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        return "getAllVersionedOrgs-" + modelId + "_" + scenarioId + "_" + yearId + "_" + periodId;
    }

    public Collection<String> getOrgNumber4Id(Long modelId, Collection<Long> orgIds) {
        HashSet<String> orgNumbers = new HashSet<String>(orgIds.size());
        for (Long orgId : orgIds) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String orgNumber = orgNode.getNumber();
            orgNumbers.add(orgNumber);
        }
        return orgNumbers;
    }
}

