/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeControlStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class MergeStatusHelper {
    private static final MergeStatusService msService = MergeStatusService.getInstance();

    private MergeStatusHelper() {
        throw new IllegalStateException("Illegal Class Constructor");
    }

    public static McStatus getMcStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        return msService.getMergeData(modelId, scenarioId, yearId, periodId, orgId).getMergeStatus();
    }

    public static McStatus getMcStatusByCurrencyNumber(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId, String currencyNumber) {
        return msService.getMergeDataByCurrencyNumber(modelId, scenarioId, yearId, periodId, orgId, currencyNumber).getMergeStatus();
    }

    public static Map<Long, McStatus> batchGetMcStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        return MergeStatusHelper.batchGetMcStatus(modelId, scenarioId, yearId, periodId, orgIds, false, null);
    }

    public static Map<Long, McStatus> batchGetMcStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds, String pcCurrency) {
        return MergeStatusHelper.batchGetMcStatus(modelId, scenarioId, yearId, periodId, orgIds, true, pcCurrency);
    }

    private static Map<Long, McStatus> batchGetMcStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds, boolean isManual, String currencyNumber) {
        Map<Long, MergeData> mcDataMap = msService.batchGetMcData(modelId, scenarioId, yearId, periodId, orgIds, isManual, currencyNumber);
        HashMap<Long, McStatus> mcMap = new HashMap<Long, McStatus>(mcDataMap.size());
        for (Map.Entry<Long, MergeData> entry : mcDataMap.entrySet()) {
            mcMap.put(entry.getKey(), entry.getValue().getMergeStatus());
        }
        return mcMap;
    }

    public static Map<String, McStatus> batchGetMcStatus4Periods(Long modelId, Collection<Long> scenarioIds, Collection<Long> yearIds, Collection<Long> periodIds, Collection<Long> orgIds) {
        Map<String, MergeData> mcDataMap = msService.batchGetMcData4Periods(modelId, scenarioIds, yearIds, periodIds, orgIds);
        HashMap<String, McStatus> mcMap = new HashMap<String, McStatus>(mcDataMap.size());
        for (Map.Entry<String, MergeData> entry : mcDataMap.entrySet()) {
            mcMap.put(entry.getKey(), entry.getValue().getMergeStatus());
        }
        return mcMap;
    }

    public static void updateCalcStatusByCurrencyNum(Long modelId, Long scenarioId, Long fyId, Long periodId, String orgNumber, String currencyNumber) {
        msService.updateCalcStatusByCurrencyNum(modelId, scenarioId, fyId, periodId, orgNumber, currencyNumber);
    }

    public static void batchUpdateCalcStatus(Long modelId, Long scenarioId, Long fyId, Long periodId, Collection<Long> orgIds) {
        msService.batchUpdateMergeStatus(modelId, scenarioId, fyId, periodId, orgIds);
    }

    public static void batchUpdateCalcStatusByCurrencyNum(Long modelId, Long scenarioId, Long fyId, Long periodId, String currencyNum, Collection<String> orgNumbers) {
        msService.batchUpdateCalcStatusByCurrencyNum(modelId, scenarioId, fyId, periodId, currencyNum, orgNumbers);
    }

    public static void updateChkStatusProcessing(Long modelId, Long scenarioId, Long fyId, Long periodId, Long orgId, String currencyNumber) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (orgNode != IDNumberTreeNode.NotFoundTreeNode) {
            MergeStatusService.getInstance().getOrInitMcData(modelId, scenarioId, fyId, periodId, orgId, currencyNumber);
            msService.updateChkStatus(modelId, scenarioId, fyId, periodId, orgNode.getNumber(), currencyNumber, "Z");
        }
    }

    public static void updateChkStatusSuccess(Long modelId, Long scenarioId, Long fyId, Long periodId, Long orgId, String currencyNumber) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (orgNode != IDNumberTreeNode.NotFoundTreeNode) {
            msService.updateChkStatus(modelId, scenarioId, fyId, periodId, orgNode.getNumber(), currencyNumber, "C");
        }
    }

    public static void updateChkStatusFail(Long modelId, Long scenarioId, Long fyId, Long periodId, Long orgId, String currencyNumber) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (orgNode != IDNumberTreeNode.NotFoundTreeNode) {
            msService.updateChkStatus(modelId, scenarioId, fyId, periodId, orgNode.getNumber(), currencyNumber, "U");
        }
    }

    public static void updateChkStatusNeedChk(Long modelId, Long scenarioId, Long fyId, Long periodId, Long orgId, String currencyNumber) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (orgNode != IDNumberTreeNode.NotFoundTreeNode) {
            msService.updateChkStatus(modelId, scenarioId, fyId, periodId, orgNode.getNumber(), currencyNumber, "B");
        }
    }

    public static MergeControlStatus getMergeControlStatus(Long modelId, Long orgId, Long scenarioId, Long yearId, Long periodId, String currencyNumber) {
        List<DynamicObject> stageMergeDataList;
        DynamicObject mergeControlData;
        MergeControlStatus mergeControlStatus = new MergeControlStatus();
        IDNumberTreeNode orgTreeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if ("Entity".equals(orgTreeNode.getNumber()) || IDNumberTreeNode.NotFoundTreeNode == orgTreeNode) {
            return mergeControlStatus.buildDefault();
        }
        MergeData mergeData = msService.getMergeDataByCurrencyNumber(modelId, scenarioId, yearId, periodId, orgId, currencyNumber);
        if (currencyNumber.equals(orgTreeNode.getCurrency())) {
            mergeControlData = mergeData.getEcData();
            stageMergeDataList = mergeData.getEcStageMergeDataList();
        } else {
            mergeControlData = mergeData.getPcData();
            stageMergeDataList = mergeData.getPcStageMergeDataList();
        }
        mergeControlStatus.setArchive(mergeData.getEcData() == null ? "B" : mergeData.getEcData().getString("archivestatus"));
        mergeControlStatus.setAction(mergeControlData == null ? "" : mergeControlData.getString("flowtask.action"));
        mergeControlStatus.setFlowTaskId(mergeControlData == null ? 0L : mergeControlData.getLong("flowtask.id"));
        mergeControlStatus.setOrgMergeStatus(mergeControlData == null ? "B" : mergeControlData.getString("flowstatus"));
        HashMap<String, String> stageMergeNumberMapForNumber = new HashMap<String, String>(16);
        HashMap<Long, String> stageMergeNumberMapForId = new HashMap<Long, String>(16);
        for (DynamicObject record : stageMergeDataList) {
            stageMergeNumberMapForNumber.put(record.getString("lockstage.number"), record.getString("flowstatus"));
            stageMergeNumberMapForId.put(record.getLong("lockstage.id"), record.getString("flowstatus"));
        }
        mergeControlStatus.setStageMergeStatusMapForId(stageMergeNumberMapForId);
        mergeControlStatus.setStageMergeStatusMapForNumber(stageMergeNumberMapForNumber);
        return mergeControlStatus;
    }
}

